/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utils.ProjectPathUtil;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSVendor;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class POSClassFieldsGenerator {
    public static void main(String[] args) throws IOException {
        POSResourcesUtil.generatingDataModel = true;
        StringBuilder builder = new StringBuilder();
        builder.append("package com.namasoft.namapos.postactions;\n\nimport java.util.*;\n\npublic class POSClassFields\n{\n\tprivate static final Map<String, List<String>> FIELDS = new HashMap<>();\n\tprivate static final Map<String, List<String>> REFERENCEFIELDS = new HashMap<>();\n\n\tpublic static List<String> fetchFieldsFor(String entityType)\n\t{\n\t\tif(FIELDS.isEmpty())\n\t\t\tinitFields();\n\t\treturn FIELDS.get(entityType);\n\t}\n\tpublic static List<String> fetchReferenceFieldsFor(String entityType)\n\t{\n\t\tif(REFERENCEFIELDS.isEmpty())\n\t\t\tinitReferenceFields();\n\t\treturn REFERENCEFIELDS.get(entityType);\n\t}\n\n\tprivate static void initFields()\n\t{\n");
        POSClassFieldsGenerator.genFields(builder);
        builder.append("\t}\n");
        builder.append("\tprivate static void initReferenceFields()\n\t{\n");
        POSClassFieldsGenerator.genReferenceFields(builder);
        builder.append("\t}\n}");
        Files.write(new File(ProjectPathUtil.POS_GUI_ROOT, "src/main/java/com/namasoft/namapos/postactions/POSClassFields.java").toPath(), builder.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void genFields(StringBuilder builder) {
        POSClassFieldsGenerator.genFieldsFor(new POSPaymentToRegistery(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSReceiptFromRegistery(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSOrderReservation(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSSalesReplacement(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSSalesReturn(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSStockReceipt(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSStockTakingDetailsDoc(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSStockTransferReq(), builder);
        POSClassFieldsGenerator.genFieldsFor(new PosCancelReservation(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSSalesInvoice(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSShortfallsDoc(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSScrapDoc(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSShiftOpen(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSShiftClose(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSCustomer(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSItem(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSEmployee(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSGenReference(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSInvoiceClassification(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSPaymentMethod(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSCurrency(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSWarehouse(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSRegistery(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSVendor(), builder);
        POSClassFieldsGenerator.genFieldsFor(new POSReturnReason(), builder);
    }

    private static void genFieldsFor(POSMasterFile o, StringBuilder builder) {
        ArrayList<String> fieldList = new ArrayList<String>();
        POSClassFieldsGenerator.collectClassFields(o.getClass(), fieldList);
        fieldList.sort(Comparator.naturalOrder());
        builder.append("\t\tFIELDS.put(\"" + o.calcNamaEntityType() + "\", Arrays.asList(" + fieldList.stream().map(t -> "\"" + t + "\"").collect(Collectors.joining(",")) + "));\n");
    }

    private static void collectClassFields(Class c, List<String> fields) {
        Field[] declaredFields = c.getDeclaredFields();
        fields.addAll(Arrays.stream(declaredFields).map(f -> f.getName()).collect(Collectors.toList()));
        if (c.getSuperclass() == null || c.getSuperclass() == Object.class) {
            return;
        }
        POSClassFieldsGenerator.collectClassFields(c.getSuperclass(), fields);
    }

    private static void genReferenceFields(StringBuilder builder) {
        POSClassFieldsGenerator.genReferenceFields(new POSPaymentToRegistery(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSReceiptFromRegistery(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSOrderReservation(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSSalesReplacement(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSSalesReturn(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSStockReceipt(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSStockTakingDetailsDoc(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSStockTransferReq(), builder);
        POSClassFieldsGenerator.genReferenceFields(new PosCancelReservation(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSSalesInvoice(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSShiftOpen(), builder);
        POSClassFieldsGenerator.genReferenceFields(new POSShiftClose(), builder);
    }

    private static void genReferenceFields(POSMasterFile o, StringBuilder builder) {
        List<String> fieldList = o.fetchReferenceFieldsIDs();
        fieldList.sort(Comparator.naturalOrder());
        builder.append("\t\tREFERENCEFIELDS.put(\"" + o.calcNamaEntityType() + "\", Arrays.asList(" + fieldList.stream().map(t -> "\"" + t + "\"").collect(Collectors.joining(",")) + "));\n");
    }
}

