/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.util.POSScreenSettings;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.GridPane;

public class POSEditTablesFontDialog
extends NamaDialog<ButtonType> {
    public POSEditTablesFontDialog() {
        super("editFontSize");
    }

    public void showDialog() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(8.0);
        gridPane.setVgap(5.0);
        NamaTextField headersFont = new NamaTextField(POSFieldType.Text);
        headersFont.setText("" + POSScreenSettings.getTableHeadersFont());
        NamaTextField cellsFont = new NamaTextField(POSFieldType.Text);
        cellsFont.setText("" + POSScreenSettings.getTableCellsFont());
        NamaTextField textFieldsFont = new NamaTextField(POSFieldType.Text);
        textFieldsFont.setText("" + POSScreenSettings.getTextFieldsFont());
        NamaTextField shortCutsBtnsHeight = new NamaTextField(POSFieldType.Text);
        shortCutsBtnsHeight.setText("" + POSScreenSettings.getShortcutHeight());
        gridPane.add((Node)new NamaLabel("Text fields font"), 0, 0);
        gridPane.add((Node)textFieldsFont, 1, 0);
        gridPane.add((Node)new NamaLabel("Table headers font"), 0, 1);
        gridPane.add((Node)headersFont, 1, 1);
        gridPane.add((Node)new NamaLabel("Table cells font"), 0, 2);
        gridPane.add((Node)cellsFont, 1, 2);
        gridPane.add((Node)new NamaLabel("shortCutsBtnsHeight "), 0, 3);
        gridPane.add((Node)shortCutsBtnsHeight, 1, 3);
        this.content((Node)gridPane);
        this.addOkButton("");
        this.addCancelButton("");
        headersFont.textProperty().addListener((observable, oldValue, newValue) -> this.allowNumbersOnly(headersFont, (String)newValue));
        cellsFont.textProperty().addListener((observable, oldValue, newValue) -> this.allowNumbersOnly(headersFont, (String)newValue));
        textFieldsFont.textProperty().addListener((observable, oldValue, newValue) -> this.allowNumbersOnly(headersFont, (String)newValue));
        shortCutsBtnsHeight.textProperty().addListener((observable, oldValue, newValue) -> this.allowNumbersOnly(headersFont, (String)newValue));
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.updateTableFontProperties(headersFont.getText(), cellsFont.getText(), textFieldsFont.getText(), shortCutsBtnsHeight.getText());
        }
    }

    public void allowNumbersOnly(NamaTextField headersFont, String newValue) {
        if (!newValue.matches("\\d*")) {
            headersFont.setText(newValue.replaceAll("[^\\d]", ""));
        }
    }

    private void updateTableFontProperties(String headerFont, String cellFont, String textFieldsFont, String shortCutsHeight) {
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{headerFont, cellFont, textFieldsFont})) {
            return;
        }
        POSScreenSettings.getProperties().put("tableHeadersFont", headerFont);
        POSScreenSettings.getProperties().put("tableCellsFont", cellFont);
        POSScreenSettings.getProperties().put("textFieldsFont", textFieldsFont);
        POSScreenSettings.getProperties().put("shortcutHeight", (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{shortCutsHeight, "30"}));
        POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
    }
}

