/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.tablecells.NamaTextFieldTableCell;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.details.POSFreeGroupLine;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.TableCellCreatorUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableRow;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Screen;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class POSFreeItemsGroupDialog
extends NamaDialog<ButtonType> {
    private final IHasToolBar hasToolBar;
    private NamaTableView<POSFreeItemsGroupDialogLine> table;
    private final POSFreeItemGroup freeItemGroup;
    private final Map<POSItem, BigDecimal> itemQtyMap = new HashMap<POSItem, BigDecimal>();
    private final BiConsumer<POSItem, BigDecimal> selectAction;
    private final BigDecimal totalQty;
    private NamaLabel info;
    private final String selectionMessage = "Please select {0} item/s";

    public POSFreeItemsGroupDialog(IHasToolBar screen, POSFreeItemGroup freeItemGroup, BigDecimal totalQty, BiConsumer<POSItem, BigDecimal> afterSelectionAction) {
        super("freeItemsGroup");
        this.hasToolBar = screen;
        this.freeItemGroup = freeItemGroup;
        this.selectAction = afterSelectionAction;
        this.totalQty = totalQty;
    }

    public void showDialog() {
        this.table = new NamaTableView();
        this.table.setEditable(true);
        BorderPane box = new BorderPane();
        box.setPadding(new Insets(10.0));
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.getDialogPane().setPrefHeight(primaryScreenBounds.getHeight() - 100.0);
        this.getDialogPane().setPrefWidth(primaryScreenBounds.getWidth() - 100.0);
        this.setResizable(true);
        Class<POSItem> onKlass = POSItem.class;
        POSItem item = (POSItem)ObjectCreatorUtil.creator(onKlass).create();
        TableCellCreatorUtil creatorUtil = new TableCellCreatorUtil(primaryScreenBounds, TableCellCreatorUtil.getDefaultCellWidth(), onKlass);
        List<POSTableColumn> columns = item.createColumnList(creatorUtil);
        columns.forEach(c -> c.setEditable(false));
        columns.add(this.createQtyColIfNeeded(TableCellCreatorUtil.getDefaultCellWidth()));
        columns.forEach(arg_0 -> this.table.getColumns().add(arg_0));
        box.setCenter(this.table);
        this.info = new NamaLabel(POSResourcesUtil.id("Please select {0} item/s", this.totalQty.intValue()));
        this.info.setPadding(new Insets(10.0));
        this.getDialogPane().setHeader((Node)this.info);
        this.content((Node)box);
        this.addOkButton("");
        this.addCancelButton("");
        this.table.setRowFactory(tv -> {
            TableRow<POSFreeItemsGroupDialogLine> row = new TableRow<POSFreeItemsGroupDialogLine>(this){

                protected void updateItem(POSFreeItemsGroupDialogLine item, boolean empty) {
                    if (item != null && NaMaMath.isGreaterThan((BigDecimal)item.getQty(), (BigDecimal)BigDecimal.ZERO)) {
                        this.setStyle("-fx-background-color: #0ca455; -fx-opacity: 1.0;-fx-text-fill: red");
                    }
                    super.updateItem((Object)item, empty);
                }
            };
            row.setOnMouseClicked(arg_0 -> this.lambda$showDialog$1((TableRow)row, arg_0));
            row.setOnKeyPressed(arg_0 -> this.lambda$showDialog$2((TableRow)row, arg_0));
            return row;
        });
        this.table.getColumns().forEach(column -> {
            String propertyId = "freeItemGroupDialog." + column.getId();
            column.widthProperty().addListener((observable, oldValue, newValue) -> {
                if (ObjectChecker.areNotEqual((Object)newValue, (Object)oldValue)) {
                    POSScreenSettings.getProperties().setProperty(propertyId, newValue.toString());
                }
                POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
            });
            String propertyValue = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSScreenSettings.getProperties().getProperty(column.getId()), POSScreenSettings.getProperties().getProperty(propertyId)});
            if (ObjectChecker.isNotEmptyOrNull((Object)propertyValue)) {
                column.setPrefWidth(Double.valueOf(propertyValue).doubleValue());
            } else {
                column.setPrefWidth(this.getDialogPane().getPrefWidth() / (double)this.table.getColumns().size());
            }
        });
        this.table.setItems(FXCollections.observableArrayList(this.createItems()));
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            for (Map.Entry<POSItem, BigDecimal> entry : this.itemQtyMap.entrySet()) {
                if (!ObjectChecker.isNotEmptyOrZero((BigDecimal)entry.getValue())) continue;
                this.selectAction.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    private POSTableColumn<POSFreeItemsGroupDialogLine, BigDecimal> createQtyColIfNeeded(double defaultCellWidth) {
        POSTableColumn<POSFreeItemsGroupDialogLine, BigDecimal> qtyCol = new POSTableColumn<POSFreeItemsGroupDialogLine, BigDecimal>("qty");
        qtyCol.setId("searchDialogQtyCol");
        qtyCol.setCellFactory(param -> {
            NamaTextFieldTableCell cell = new NamaTextFieldTableCell(new StringConverter<BigDecimal>(this){

                public String toString(BigDecimal object) {
                    return ObjectChecker.toStringOrEmpty((Object)object);
                }

                public BigDecimal fromString(String string) {
                    return ObjectChecker.isEmptyOrNull((Object)string) ? null : new BigDecimal(string);
                }
            });
            cell.setOnMouseClicked(Event::consume);
            return cell;
        });
        qtyCol.setCellValueFactory((Callback)new PropertyValueFactory("qty"));
        qtyCol.setOnEditCommit(e -> {
            if (e.getTablePosition() == null) {
                return;
            }
            this.updateQtyFor((POSFreeItemsGroupDialogLine)e.getRowValue(), (BigDecimal)e.getNewValue());
        });
        qtyCol.setPrefWidth(defaultCellWidth);
        return qtyCol;
    }

    private void updateQtyFor(POSFreeItemsGroupDialogLine line, BigDecimal qty) {
        line.setQty(qty);
        qty = ObjectChecker.toZeroIfNull((BigDecimal)qty);
        BigDecimal oldQty = this.itemQtyMap.put(line.item, qty);
        if (ObjectChecker.areEqual((Object)oldQty, (Object)qty)) {
            return;
        }
        BigDecimal takenQty = NaMaMath.totalizeDecimalStream(this.itemQtyMap.values().stream());
        if (NaMaMath.isGreaterThan((BigDecimal)takenQty, (BigDecimal)this.totalQty)) {
            this.info.setStyle("-fx-text-fill: red");
            this.info.setText(POSResourcesUtil.id("You can not take more than {0} item/s. Taken quantity {1}", this.totalQty.intValue(), takenQty));
            this.fetchOkBtn().setDisable(true);
        } else {
            this.info.setStyle("-fx-text-fill: black");
            this.info.setText(POSResourcesUtil.id("Please select {0} item/s", this.totalQty.subtract(takenQty).intValue()));
            this.fetchOkBtn().setDisable(false);
        }
        this.table.refresh();
    }

    private List<POSFreeItemsGroupDialogLine> createItems() {
        List items = this.freeItemGroup.getDetails().stream().map(POSFreeGroupLine::getItem).collect(Collectors.toList());
        ArrayList<POSFreeItemsGroupDialogLine> lines = new ArrayList<POSFreeItemsGroupDialogLine>();
        for (POSItem item : items) {
            lines.add(new POSFreeItemsGroupDialogLine(this, item));
        }
        return lines;
    }

    private /* synthetic */ void lambda$showDialog$2(TableRow row, KeyEvent e) {
        if (e.getCode().equals((Object)KeyCode.ENTER) && this.table.getSelectionModel().getSelectedItem() != null) {
            this.updateQtyFor((POSFreeItemsGroupDialogLine)row.getItem(), ObjectChecker.toZeroIfNull((BigDecimal)((POSFreeItemsGroupDialogLine)row.getItem()).getQty()).add(BigDecimal.ONE));
        }
    }

    private /* synthetic */ void lambda$showDialog$1(TableRow row, MouseEvent t) {
        if (t.getClickCount() == 2 && !row.isEmpty()) {
            this.updateQtyFor((POSFreeItemsGroupDialogLine)row.getItem(), ObjectChecker.toZeroIfNull((BigDecimal)((POSFreeItemsGroupDialogLine)row.getItem()).getQty()).add(BigDecimal.ONE));
        }
    }

    public class POSFreeItemsGroupDialogLine {
        POSItem item;
        String code;
        String name1;
        String name2;
        String racksCodes;
        BigDecimal qty;

        public POSFreeItemsGroupDialogLine(POSFreeItemsGroupDialog this$0, POSItem item) {
            this.item = item;
            this.code = item.getCode();
            this.name1 = item.getName1();
            this.name2 = item.getName2();
            this.racksCodes = item.getRacksCodes();
        }

        public POSItem getItem() {
            return this.item;
        }

        public String getCode() {
            return this.code;
        }

        public String getName1() {
            return this.name1;
        }

        public String getName2() {
            return this.name2;
        }

        public String getRacksCodes() {
            return this.racksCodes;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setItem(POSItem item) {
            this.item = item;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setName1(String name1) {
            this.name1 = name1;
        }

        public void setName2(String name2) {
            this.name2 = name2;
        }

        public void setRacksCodes(String racksCodes) {
            this.racksCodes = racksCodes;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }
    }
}

