/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.MultiKeyHash;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.valueobjects.POSItemSalesFreeItem;
import com.namasoft.pos.util.POSSalesPriceUtil;
import java.util.HashMap;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class POSFreeItemsOnInvoiceOfferDialog
extends NamaDialog<ButtonType> {
    public POSFreeItemsOnInvoiceOfferDialog() {
        super("Free items on invoice offer");
    }

    public void showDailog(ActionEvent e, Dialog payDialog, AbsPOSSales salesDoc, HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd, boolean ignoreOtherOffers, AbsPosSalesScreen screen) {
        payDialog.hide();
        VBox vBox = new VBox(15.0);
        HBox box = new HBox(10.0);
        NamaLabel offerLabel = new NamaLabel("There is a free item offer ");
        vBox.getChildren().addAll((Object[])new Node[]{offerLabel, box});
        NamaLabel label = new NamaLabel("Don't show offer again");
        CheckBox doNotShowAgain = new CheckBox();
        box.getChildren().addAll((Object[])new Node[]{label, doNotShowAgain});
        this.content((Node)vBox);
        this.addOkButton("");
        this.addCancelButton("");
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            if (doNotShowAgain.isSelected() && screen != null) {
                screen.setShowFreeItemsOnInvoiceOfferDialogAgain(false);
            }
            salesDoc.addInvoiceFreeItems(POSResourcesUtil.fetchMainRegister(), toAdd, screen);
            if (ignoreOtherOffers) {
                POSSalesPriceUtil.cancelOtherOffers(salesDoc.fetchDetails(), salesDoc, screen);
            }
        } else {
            if (doNotShowAgain.isSelected() && screen != null) {
                screen.setShowFreeItemsOnInvoiceOfferDialogAgain(false);
            }
            this.hide();
            e.consume();
        }
    }
}

