/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSResult;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class POSInternalMsgScreen
implements IHasToolBar {
    private NamaSearchBox toEmp1;
    private NamaSearchBox toEmp2;
    private NamaSearchBox toEmp3;
    private NamaSearchBox toEmp4;
    private NamaSearchBox toEmp5;
    private TextArea msgBody = new TextArea();
    private NamaBorderPane pane;
    private POSInternalMessage internalMessage;
    private static Stage stage;
    private static PosScene scene;
    protected POSIdleMonitor idleMonitor;
    private BorderPaneCreator borderPaneCreator;
    private HashMap<String, IPOSFieldInfo> map = new HashMap();

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    public POSInternalMsgScreen() {
        PosEntryPoint.lastScreen = this;
    }

    @Override
    public void defineControllers() {
        this.toEmp1 = new NamaSearchBox(POSEmployee.class, this, "emp1", stage);
        this.toEmp2 = new NamaSearchBox(POSEmployee.class, this, "emp2", stage);
        this.toEmp3 = new NamaSearchBox(POSEmployee.class, this, "emp3", stage);
        this.toEmp4 = new NamaSearchBox(POSEmployee.class, this, "emp4", stage);
        this.toEmp5 = new NamaSearchBox(POSEmployee.class, this, "emp5", stage);
    }

    public BorderPane draw(Stage primStage) {
        try {
            stage = primStage;
            this.internalMessage = new POSInternalMessage(this);
            if (this.borderPaneCreator == null) {
                this.borderPaneCreator = new BorderPaneCreator();
            }
            this.pane = this.borderPaneCreator.createBorderPane(this);
            scene = new PosScene((Parent)this.pane, stage.getWidth(), stage.getHeight(), this, stage);
            PosScene.monitorIdleness(this);
            stage.setScene((Scene)scene);
            scene.setNodeOrientation(POSResourcesUtil.getOrientation());
            this.pane.autosize();
            stage.setOnCloseRequest(e -> PosScene.onCloseRequestEvent(event -> PosScene.terminateAction(this, stage, event), e));
            return this.pane;
        }
        catch (Exception es) {
            es.printStackTrace();
            return null;
        }
    }

    @Override
    public Node fetchPaneCenter() {
        GridPane container = new GridPane();
        container.setId("internal-msg-content-pane");
        container.setPrefWidth(stage.getWidth());
        container.setPrefHeight(stage.getHeight() - 100.0);
        ColumnConstraints constraints1 = new ColumnConstraints();
        constraints1.setPercentWidth(10.0);
        ColumnConstraints constraints2 = new ColumnConstraints();
        constraints2.setPercentWidth(40.0);
        ColumnConstraints constraints3 = new ColumnConstraints();
        constraints3.setPercentWidth(10.0);
        ColumnConstraints constraints4 = new ColumnConstraints();
        constraints4.setPercentWidth(40.0);
        container.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{constraints1, constraints2, constraints3, constraints4});
        NamaLabel emp1Label = new NamaLabel("To Employee 1");
        NamaLabel emp2Label = new NamaLabel("To Employee 2");
        NamaLabel emp3Label = new NamaLabel("To Employee 3");
        NamaLabel emp4Label = new NamaLabel("To Employee 4");
        NamaLabel emp5Label = new NamaLabel("To Employee 5");
        NamaLabel msgLabel = new NamaLabel("Message Body");
        container.add((Node)emp1Label, 0, 0);
        container.add((Node)this.toEmp1, 1, 0);
        container.add((Node)emp2Label, 2, 0);
        container.add((Node)this.toEmp2, 3, 0);
        container.add((Node)emp3Label, 0, 2);
        container.add((Node)this.toEmp3, 1, 2);
        container.add((Node)emp4Label, 2, 2);
        container.add((Node)this.toEmp4, 3, 2);
        container.add((Node)emp5Label, 0, 4);
        container.add((Node)this.toEmp5, 1, 4);
        container.add((Node)msgLabel, 0, 6);
        container.add((Node)this.msgBody, 1, 6);
        GridPane.setColumnSpan((Node)this.msgBody, (Integer)5);
        NamaButton send = new NamaButton("send");
        send.getStyleClass().add((Object)"apply-button");
        send.setPrefWidth(150.0);
        send.setPrefHeight(50.0);
        container.add((Node)send, 2, 8);
        NamaButton cancel = new NamaButton("cancel");
        cancel.setPrefWidth(150.0);
        cancel.setPrefHeight(50.0);
        send.setOnAction(e -> {
            POSResult result = new POSResult();
            this.validateMessage(result);
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, stage);
            } else {
                this.internalMessage.setCode(POSCodeGenerator.generateInvoiceCode(POSDocumentType.Msg));
                this.internalMessage.setToEmp1(POSPersister.findByID(POSEmployee.class, this.toEmp1.getIdBox().getText()));
                this.internalMessage.setToEmp2(POSPersister.findByID(POSEmployee.class, this.toEmp2.getIdBox().getText()));
                this.internalMessage.setToEmp3(POSPersister.findByID(POSEmployee.class, this.toEmp3.getIdBox().getText()));
                this.internalMessage.setToEmp4(POSPersister.findByID(POSEmployee.class, this.toEmp4.getIdBox().getText()));
                this.internalMessage.setToEmp5(POSPersister.findByID(POSEmployee.class, this.toEmp5.getIdBox().getText()));
                this.internalMessage.setMessageBody(this.msgBody.getText());
                this.internalMessage.setValueDate(new Date());
                if (PosScene.noConnection()) {
                    result.failure("No Connection !! Message will sent later automatically", new Object[0]);
                    POSErrorAndInfoMessagesUtil.showError(result, stage);
                } else if (this.saveOrUpdateByUser(this.internalMessage, stage)) {
                    POSDataWriterUtil.writePOSInternalMsg(POSResourcesUtil.fetchMainRegister(), Arrays.asList(this.internalMessage));
                    PosScene.drawSalesScreen(stage);
                }
            }
        });
        cancel.setOnAction(e -> PosScene.drawSalesScreen(stage));
        container.add((Node)cancel, 3, 8);
        container.setAlignment(Pos.TOP_CENTER);
        POSSettingsUtil.addStyleSheetFor("css/allfiles.css", (Parent)container);
        return container;
    }

    private void validateMessage(POSResult result) {
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{this.toEmp1.getCodeBox().getText(), this.toEmp2.getCodeBox().getText(), this.toEmp3.getCodeBox().getText(), this.toEmp4.getCodeBox().getText(), this.toEmp5.getCodeBox().getText()})) {
            result.failure("Please choose employee at least", new Object[0]);
        }
        this.checkValidEmpCode(this.toEmp1, result);
        this.checkValidEmpCode(this.toEmp2, result);
        this.checkValidEmpCode(this.toEmp3, result);
        this.checkValidEmpCode(this.toEmp4, result);
        this.checkValidEmpCode(this.toEmp5, result);
        if (ObjectChecker.isEmptyOrNull((Object)this.msgBody.getText())) {
            result.failure("Please write message body", new Object[0]);
        }
    }

    private void checkValidEmpCode(NamaSearchBox employee, POSResult result) {
        POSEmployee emp;
        if (ObjectChecker.isNotEmptyOrNull((Object)employee.getCodeBox().getText()) && ObjectChecker.isEmptyOrNull((Object)(emp = POSPersister.findByID(POSEmployee.class, employee.getIdBox().getText())))) {
            result.failure(POSResourcesUtil.id("Please enter valid employee", new Object[0]), new Object[0]);
        }
    }

    @Override
    public PosScene fetchScene() {
        return scene;
    }

    @Override
    public Stage fetchStage() {
        return stage;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    @Override
    public String screenTitle() {
        return "POSInternalMessage";
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return this.idleMonitor;
    }

    @Override
    public String fetchScreenEntityType() {
        return "NamaPOSInternalMessage";
    }

    @Override
    public void doPostSaveAction() {
    }

    @Override
    public void escapeAction() {
        PosScene.drawSalesScreen(stage);
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.borderPaneCreator;
    }

    public POSMasterFile document() {
        return this.internalMessage;
    }

    @Override
    public POSDocumentType documentType() {
        return POSDocumentType.Msg;
    }
}

