/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSActionType;
import com.namasoft.pos.util.LoginUtil;
import com.namasoft.pos.util.POSResult;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.PasswordField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.StageStyle;

public class POSLockDialog
extends NamaDialog<ButtonType> {
    private Button loginBtn;
    private NamaTextField username;
    private PasswordField password;

    public POSLockDialog(IHasToolBar hasToolBar, String headerText) {
        block2: {
            super("");
            try {
                this.getDialogPane().setId("lock-dialog");
                this.initStyle(StageStyle.TRANSPARENT);
                this.setOkAction(event -> this.tryUnLock(hasToolBar));
                this.error(headerText);
                this.addOkButton("login");
                GridPane grid = new GridPane();
                grid.setId("lock-dialog-content");
                this.username = new NamaTextField(POSFieldType.Text);
                this.username.setPromptText(POSResourcesUtil.id("Username", new Object[0]));
                this.password = new PasswordField();
                this.password.setPromptText(POSResourcesUtil.id("Password", new Object[0]));
                grid.add((Node)this.username, 0, 0);
                grid.add((Node)this.password, 0, 1);
                this.content((Node)grid);
                Platform.runLater(() -> this.username.requestFocus());
                this.username.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                    if (ObjectChecker.isAnyEqualToFirst((Object)event.getCode(), (Object[])new KeyCode[]{KeyCode.ENTER, KeyCode.TAB})) {
                        Platform.runLater(() -> this.password.requestFocus());
                    }
                });
                this.password.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                    if (ObjectChecker.areEqual((Object)event.getCode(), (Object)KeyCode.TAB)) {
                        Platform.runLater(() -> this.requestFocus());
                    }
                    if (ObjectChecker.areEqual((Object)event.getCode(), (Object)KeyCode.ENTER)) {
                        Platform.runLater(() -> this.tryUnLock(hasToolBar));
                    }
                });
                this.loginBtn = new Button();
                this.loginBtn.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.tryUnLock(hasToolBar));
                this.getDialogPane().setOnKeyPressed(event -> {
                    if (ObjectChecker.isFalse((Boolean)event.getCode().equals((Object)KeyCode.ESCAPE))) {
                        return;
                    }
                    this.close();
                    Platform.runLater(() -> new POSLockDialog(hasToolBar));
                });
                POSPersister.saveOrUpdate(POSActionHistory.create(null, POSActionType.Locked));
                Platform.runLater(() -> {
                    Optional result = this.showAndWait();
                    if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonType.APPLY.getButtonData())) {
                        this.tryUnLock(hasToolBar);
                    }
                });
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
                if (hasToolBar == null || hasToolBar.fetchPane() == null) break block2;
                hasToolBar.fetchPane().setEffect(null);
            }
        }
        POSSettingsUtil.addStyleSheetFor("css/salesscreen.css", (Parent)this.getDialogPane());
    }

    public POSLockDialog(IHasToolBar hasToolBar) {
        this(hasToolBar, "");
    }

    public void tryUnLock(IHasToolBar hasToolBar) {
        boolean authenticateUser;
        POSResult result = new POSResult();
        POSUser user = LoginUtil.authenticateUser(this.username.getText(), this.password.getText(), result);
        boolean bl = authenticateUser = ObjectChecker.isNotEmptyOrNull((Object)user);
        if (authenticateUser) {
            POSSettingsInfo posSettingsInfo = POSSettingsInfo.fetchConfiguration();
            posSettingsInfo.setCurrentUser(user);
            POSPersister.saveOrUpdate(POSActionHistory.create(null, POSActionType.Unlocked));
            this.close();
        } else {
            this.close();
            Platform.runLater(() -> {
                String errMsg = POSResourcesUtil.id("Wrong user name or password", new Object[0]);
                if (result.isFailed().booleanValue()) {
                    errMsg = result.getMessageByLanguage();
                }
                new POSLockDialog(hasToolBar, errMsg);
            });
        }
    }
}

