/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSLabeledLabel;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import java.io.Serializable;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class POSNewCustomHeader<Doc extends AbsPOSSales, Screen extends POSNewSalesScreen>
extends NamaVBox {
    private final POSLabeledLabel totalQtyLabel = new POSLabeledLabel("totalQty", "0.0");
    private final POSLabeledLabel distinctItemsCountLabel = new POSLabeledLabel("distinctItemsCount", "0.0");
    private final POSLabeledLabel totalLabel = new POSLabeledLabel("total", "0.0");
    private final SimpleDoubleProperty totalProperty = new SimpleDoubleProperty();
    private final String InvoiceCustomHeaderStyleClass = "colorful-mode-custom-header-for-sales-invoice";

    public POSNewCustomHeader(Screen hasToolBar) {
        this.getStyleClass().add((Object)"custom-header");
        this.addInvoiceCustomHeaderStyleClass();
        if (ObjectChecker.isNotEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings().getTotalsPaneColor())) {
            this.setStyle(this.getStyle() + ";-fx-background-color: " + POSUISettingsUtil.getPosUISettings().getTotalsPaneColor() + ";");
        }
        AbsPOSSales document = (AbsPOSSales)((AbsPosSalesScreen)hasToolBar).document();
        ((AbsPosSalesScreen)hasToolBar).fetchScreenTable().getItems().addListener(e -> {
            this.totalQtyLabel.setValue(document.fetchQuantity((AbsPosSalesScreen)hasToolBar));
            this.distinctItemsCountLabel.setValue(document.calcDistinctItemsCount((AbsPosSalesScreen<?>)hasToolBar));
        });
        this.totalProperty.bind((ObservableValue)((AbsPosSalesScreen)hasToolBar).getSalesDoc().totalProperty);
        this.totalProperty.addListener(l -> {
            Double value = this.totalProperty.getValue();
            this.totalLabel.setValue(ObjectChecker.getFirstNotEmptyObj((Object[])new Serializable[]{value, "0.0"}));
            hasToolBar.fireOnFieldChangedEvent("netPrice", value);
        });
        NamaHBox.setHgrow((Node)this.totalQtyLabel, (Priority)Priority.ALWAYS);
        NamaHBox.setHgrow((Node)this.distinctItemsCountLabel, (Priority)Priority.ALWAYS);
        NamaHBox.setHgrow((Node)this.totalLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.totalQtyLabel, this.distinctItemsCountLabel, this.totalLabel});
        for (Node child : this.getChildren()) {
            if (!ObjectChecker.isNotEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings().getTotalsPaneFontColor()) || !(child instanceof POSLabeledLabel)) continue;
            POSLabeledLabel labeledFiled = (POSLabeledLabel)child;
            labeledFiled.style(";-fx-text-fill:" + POSUISettingsUtil.getPosUISettings().getTotalsPaneFontColor() + "; ");
        }
    }

    public void bindTotalProperty(SimpleDoubleProperty totalProperty) {
        this.totalProperty.unbind();
        this.totalProperty.bind((ObservableValue)totalProperty);
    }

    public void addInvoiceCustomHeaderStyleClass() {
        this.getStyleClass().add((Object)"colorful-mode-custom-header-for-sales-invoice");
    }

    public void removeInvoiceCustomHeaderStyleClass() {
        this.getStyleClass().remove((Object)"colorful-mode-custom-header-for-sales-invoice");
    }
}

