/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.CashDenominationsBox;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSLabeledFileChooser;
import com.namasoft.namacontrols.POSLabeledSearchBox;
import com.namasoft.namacontrols.POSLabeledTextArea;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.GridPaneDrawer;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.IPOSShiftScreen;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSShiftInventoryScreen;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSShiftTakenElementsPerShiftLine;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSShiftInventoryService;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class POSNewShiftsScreen<T extends Control>
implements IHasToolBar,
IPOSShiftScreen {
    private Stage stage;
    private PosScene scene;
    private final BorderPaneCreator borderPaneCreator = new BorderPaneCreator();
    private NamaBorderPane pane;
    protected POSIdleMonitor idleMonitor;
    private AbsPOSShiftInventory shiftOrInventory;
    private POSLabeledTextField code;
    private POSLabeledTextField shiftDate;
    private POSLabeledTextField shiftTime;
    private POSLabeledSearchBox registery;
    private POSLabeledTextArea remarks;
    private boolean isShift;
    private ObservableList<AbsPOSInventoryLine> totals;
    private NamaButton cancelBtn;
    protected NamaButton okBtn;
    int BottomHeight = 40;
    private NamaButton analyzeCash;
    private NamaLabel currentShiftCashAmount = new NamaLabel();
    private NamaLabel oldShiftsCashAmount = new NamaLabel();
    private NamaTableView<AbsPOSInventoryLine> detailsTable;
    private NamaTableView<AbsPOSShiftTakenElementsPerShiftLine> takenElementsPerShiftTable;
    private HashMap<String, IPOSFieldInfo> map = new HashMap();
    protected POSLabeledTextField totalAccountant;
    protected POSLabeledTextField totalActual;
    protected POSLabeledTextField totalDiff;
    protected POSLabeledFileChooser attach1;
    protected POSLabeledFileChooser attach2;
    private CashDenominationsBox denominationsBox;
    private Map<String, Consumer<BigDecimal>> denominationChangeListenersMap = new HashMap<String, Consumer<BigDecimal>>();
    private boolean createNewShift = true;

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    @Override
    public Node fetchPaneCenter() {
        boolean isShiftClose;
        this.createShiftDoc(this.isShift);
        NamaVBox container = new NamaVBox();
        container.setId("shift-screen-root");
        container.getChildren().add((Object)this.addPOSShiftHeader());
        boolean bl = isShiftClose = this.isShift() && ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift());
        if (isShiftClose) {
            this.denominationsBox = new CashDenominationsBox(this.stage, this, this.denominationChangeListenersMap);
            container.getChildren().add((Object)this.denominationsBox);
        }
        container.getChildren().add(this.addPOSShiftDetailsTable());
        if (ObjectChecker.isNotEmptyOrNull(this.shiftOrInventory.fetchTakenElements())) {
            container.getChildren().addAll((Object[])new Node[]{this.addTakenElementsPerShiftGrid()});
        }
        container.getChildren().add((Object)this.addBottomGrid(isShiftClose));
        return container;
    }

    private GridPane addPOSShiftHeader() {
        GridPaneDrawer gridPaneDrawer = new GridPaneDrawer(this.shiftOrInventory);
        gridPaneDrawer.setGridColsPerRow(6);
        gridPaneDrawer.addGridColConstrains(12.0, 25.0, 15.0, 25.0, 15.0, 25.0);
        gridPaneDrawer.addField((Region)this.code);
        gridPaneDrawer.addField((Region)this.registery);
        gridPaneDrawer.addField((Region)this.shiftDate);
        gridPaneDrawer.addField((Region)this.shiftTime);
        gridPaneDrawer.addField((Region)this.attach1);
        gridPaneDrawer.addField((Region)this.attach2);
        gridPaneDrawer.addField((Region)this.remarks);
        gridPaneDrawer.addField((Region)this.totalActual);
        if (ObjectChecker.isTrue((Boolean)POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant).isSucceeded())) {
            gridPaneDrawer.addField((Region)this.totalAccountant);
            gridPaneDrawer.addField((Region)this.totalDiff);
        }
        GridPane topGrid = gridPaneDrawer.getPane();
        topGrid.setId("shift-header-fields");
        this.updateHeaderFields();
        return topGrid;
    }

    private NamaTableView<AbsPOSInventoryLine> addPOSShiftDetailsTable() {
        POSTableColumn methodCol = new POSTableColumn("paymentWay");
        methodCol.setCellValueFactory((Callback)new PropertyValueFactory("paymentWay"));
        POSTableColumn currencyCol = new POSTableColumn("currency");
        currencyCol.setCellValueFactory((Callback)new PropertyValueFactory("currency"));
        POSTableColumn accountantCol = new POSTableColumn("accountantRemaining");
        accountantCol.setCellValueFactory((Callback)new PropertyValueFactory("accountantRemaining"));
        accountantCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        accountantCol.setEditable(false);
        POSTableColumn actualCol = new POSTableColumn("actualRemaining");
        actualCol.setEditable(true);
        actualCol.setCellValueFactory((Callback)new PropertyValueFactory("actualRemaining"));
        actualCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        actualCol.setOnEditCommit(val -> {
            AbsPOSInventoryLine shiftLine = (AbsPOSInventoryLine)val.getRowValue();
            if (ObjectChecker.isEmptyOrNull((Object)val.getNewValue())) {
                shiftLine.setActualRemaining(BigDecimal.ZERO);
            } else {
                shiftLine.setActualRemaining((BigDecimal)val.getNewValue());
            }
            shiftLine.setDifference(shiftLine.getActualRemaining().subtract(shiftLine.getAccountantRemaining()));
            this.updateSumFields();
            Platform.runLater(() -> this.detailsTable.refresh());
        });
        POSTableColumn diffCol = new POSTableColumn("difference");
        diffCol.setCellValueFactory((Callback)new PropertyValueFactory("difference"));
        diffCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        diffCol.setEditable(false);
        POSTableColumn narrationCol = new POSTableColumn("narration");
        narrationCol.setCellValueFactory((Callback)new PropertyValueFactory("narration"));
        narrationCol.setCellFactory(POSTableCell.defaultCellFactory());
        narrationCol.setEditable(true);
        narrationCol.setOnEditCommit(v -> {
            AbsPOSInventoryLine line = (AbsPOSInventoryLine)v.getRowValue();
            line.setNarration((String)v.getNewValue());
        });
        POSTableColumn narration2Col = new POSTableColumn("narration2");
        narration2Col.setCellValueFactory((Callback)new PropertyValueFactory("narration2"));
        narration2Col.setCellFactory(POSTableCell.defaultCellFactory());
        narration2Col.setEditable(true);
        narration2Col.setOnEditCommit(v -> {
            AbsPOSInventoryLine line = (AbsPOSInventoryLine)v.getRowValue();
            line.setNarration2((String)v.getNewValue());
        });
        this.detailsTable = new NamaTableView();
        this.detailsTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS);
        this.detailsTable.setEditable(true);
        this.detailsTable.getColumns().addAll((Object[])new TableColumn[]{methodCol, currencyCol, actualCol, narrationCol, narration2Col});
        Boolean canViewAccountant = POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant).isSucceeded();
        if (ObjectChecker.isTrue((Boolean)canViewAccountant)) {
            this.detailsTable.getColumns().add(2, accountantCol);
            this.detailsTable.getColumns().add(4, diffCol);
        }
        this.updateDetails();
        return this.detailsTable;
    }

    public void updateHeaderFields() {
        this.code.setValue(this.shiftOrInventory.getCode());
        this.registery.setValue(this.shiftOrInventory.getRegistery());
        this.shiftDate.setValue(ObjectChecker.toStringOrEmpty((Object)POSShiftInventoryService.dateFormat.format(this.shiftOrInventory.getShiftDate().toInstant().atZone(ZoneId.systemDefault()))));
        this.shiftTime.setValue(ObjectChecker.toStringOrEmpty((Object)this.shiftOrInventory.getShiftTime()));
        this.remarks.setValue(this.shiftOrInventory.getRemarks());
        this.attach1.setValue(this.shiftOrInventory.getAttach1FilePath());
        this.attach2.setValue(this.shiftOrInventory.getAttach2FilePath());
    }

    private NamaTableView addTakenElementsPerShiftGrid() {
        POSTableColumn elementCol = new POSTableColumn("element");
        elementCol.setCellValueFactory((Callback)new PropertyValueFactory("element"));
        elementCol.setCellFactory(c -> {
            POSTableCell cell = new POSTableCell(new StringConverter(this){

                public String toString(Object object) {
                    if (object instanceof POSEntityRefData) {
                        POSEntityRefData ref = (POSEntityRefData)object;
                        return ref.nameByLanguage();
                    }
                    return "";
                }

                public Object fromString(String string) {
                    return null;
                }
            });
            return cell;
        });
        POSTableColumn descriptionCol = new POSTableColumn("description");
        descriptionCol.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        POSTableColumn qtyCol = new POSTableColumn("qty");
        qtyCol.setCellValueFactory((Callback)new PropertyValueFactory("qtyValue"));
        qtyCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        qtyCol.setOnEditCommit(val -> {
            AbsPOSShiftTakenElementsPerShiftLine line = (AbsPOSShiftTakenElementsPerShiftLine)val.getRowValue();
            line.setQtyValue((BigDecimal)val.getNewValue());
        });
        POSTableColumn remarks = new POSTableColumn("remarks");
        remarks.setCellValueFactory((Callback)new PropertyValueFactory("remarks"));
        remarks.setCellFactory(POSTableCell.defaultCellFactory());
        remarks.setOnEditCommit(val -> {
            AbsPOSShiftTakenElementsPerShiftLine line = (AbsPOSShiftTakenElementsPerShiftLine)val.getRowValue();
            line.setRemarks((String)val.getNewValue());
        });
        this.takenElementsPerShiftTable = new NamaTableView();
        this.takenElementsPerShiftTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS);
        this.takenElementsPerShiftTable.setEditable(true);
        this.takenElementsPerShiftTable.getColumns().addAll((Object[])new TableColumn[]{elementCol, descriptionCol, qtyCol, remarks});
        this.updateTakenElementsPerShiftGrid();
        return this.takenElementsPerShiftTable;
    }

    private void updateTakenElementsPerShiftGrid() {
        if (this.takenElementsPerShiftTable == null) {
            return;
        }
        this.takenElementsPerShiftTable.getItems().clear();
        this.takenElementsPerShiftTable.getItems().addAll(this.shiftOrInventory.fetchTakenElements());
    }

    private Pane addBottomGrid(boolean isShiftClose) {
        NamaHBox btnsBox = new NamaHBox(new Node[]{this.okBtn, this.cancelBtn});
        btnsBox.setId("shift-screen-buttons-pane");
        POSResult userCanViewAccountant = POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant);
        if (!userCanViewAccountant.isFailed().booleanValue() && isShiftClose) {
            btnsBox.getChildren().addAll((Object[])new Node[]{this.analyzeCash});
        }
        btnsBox.setPadding(new Insets(10.0));
        btnsBox.setAlignment(Pos.CENTER);
        btnsBox.setPrefHeight(this.BottomHeight);
        btnsBox.setPrefWidth(this.stage.getWidth());
        return btnsBox;
    }

    private void updateDetails() {
        if (ObjectChecker.isEmptyOrNull(this.totals)) {
            this.totals = FXCollections.observableArrayList(POSPaymentMethodsUtil.calcShiftTotals(POSResourcesUtil.fetchMainRegister(), this.shiftOrInventory.createLine().getClass(), t -> {
                BigDecimal tDecimal = ObjectChecker.isEmptyOrNull((Object)t) ? BigDecimal.ZERO : new BigDecimal((String)t);
                this.currentShiftCashAmount.setText(String.valueOf(NaMaMath.round((BigDecimal)tDecimal, (Integer)POSMoneyUtils.displayDecimalPlaces)));
            }));
        }
        this.updateSumFields();
        this.totals.stream().forEach(l -> this.addDenominationChangeListener((AbsPOSInventoryLine)l));
        this.detailsTable.getItems().clear();
        this.detailsTable.getItems().addAll(this.totals);
    }

    private void addDenominationChangeListener(AbsPOSInventoryLine l) {
        this.denominationChangeListenersMap.put(l.getPaymentWay(), v -> {
            l.setActualRemaining((BigDecimal)v);
            this.detailsTable.refresh();
        });
    }

    public void updateSumFields() {
        this.totalActual.setValue(this.totals.stream().map(AbsPOSInventoryLine::getActualRemaining).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        this.totalAccountant.setValue(this.totals.stream().map(AbsPOSInventoryLine::getAccountantRemaining).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        this.totalDiff.setValue(this.totals.stream().map(AbsPOSInventoryLine::getDifference).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
    }

    @Override
    public void fireOpenOldDocAction(POSMasterFile item, Event event) {
        AbsPOSShiftInventory selectedItem = (AbsPOSShiftInventory)item;
        if (ObjectChecker.isEmptyOrNull((Object)selectedItem)) {
            return;
        }
        this.createNewShift = false;
        this.shiftOrInventory = selectedItem;
        this.totals = FXCollections.observableArrayList(selectedItem.fetchDetails());
        this.draw(this.stage, this.isShift);
    }

    @Override
    public void defineControllers() {
        this.code = new POSLabeledTextField("code", null, POSFieldType.Text);
        this.code.getField().setEditable(false);
        this.okBtn = new NamaButton("Ok");
        this.okBtn.setId("btn");
        this.okBtn.getStyleClass().add((Object)"apply-button");
        this.cancelBtn = new NamaButton("cancel");
        this.cancelBtn.setId("btn");
        this.analyzeCash = new NamaButton("Analyze Cash Amount");
        this.analyzeCash.setId("btn");
        this.analyzeCash.setOnAction(event -> POSShiftInventoryScreen.cashAnalysisAction(this));
        this.cancelBtn.setOnAction(event -> PosScene.drawSalesScreen(this.stage));
        this.okBtn.setOnAction(event -> {
            if (this.shiftOrInventory.getComitBefore().booleanValue()) {
                return;
            }
            POSShiftInventoryScreen.okAction(this, false, this.stage);
        });
        this.shiftDate = new POSLabeledTextField("shiftDate", this, POSFieldType.Text);
        this.shiftDate.getField().setDisable(true);
        this.shiftTime = new POSLabeledTextField("shiftTime", null, POSFieldType.Text);
        this.shiftTime.getField().setDisable(true);
        this.registery = new POSLabeledSearchBox("registery", POSRegistery.class, this);
        this.registery.getField().setDisable(true);
        this.attach1 = new POSLabeledFileChooser("Attachment1", p -> this.shiftOrInventory.setAttach1FilePath((String)p), this.stage);
        this.attach2 = new POSLabeledFileChooser("Attachment2", p -> this.shiftOrInventory.setAttach2FilePath((String)p), this.stage);
        this.attach1.getField().reset();
        this.attach2.getField().reset();
        this.remarks = new POSLabeledTextArea("remarks");
        this.remarks.setAlone(true);
        this.totalAccountant = new POSLabeledTextField("totalAcc", this);
        this.totalAccountant.getField().setEditable(false);
        this.totalActual = new POSLabeledTextField("totalActual", this);
        this.totalActual.getField().setEditable(false);
        this.totalDiff = new POSLabeledTextField("totalDiff", this);
        this.totalDiff.getField().setEditable(false);
    }

    @Override
    public void draw(Stage primStage, boolean shift) {
        try {
            this.isShift = shift;
            this.stage = primStage;
            this.pane = this.borderPaneCreator.createBorderPane(this);
            if (this.scene == null) {
                this.scene = new PosScene((Parent)this.pane, this.stage.getWidth(), this.stage.getHeight(), this, this.stage);
                POSSettingsUtil.addStyleSheetFor("css/allfiles.css", (Parent)this.pane);
                POSSettingsUtil.updateScreenColor((Parent)this.pane, this.documentType());
            } else {
                this.scene.setRoot((Parent)this.pane);
            }
            this.scene.setOnKeyPressed(e -> {
                if (ObjectChecker.areEqual((Object)e.getCode(), (Object)KeyCode.F2)) {
                    POSShiftInventoryScreen.okAction(this, true, this.stage);
                }
            });
            PosScene.monitorIdleness(this);
            this.stage.setScene((Scene)this.scene);
            this.scene.setNodeOrientation(POSResourcesUtil.getOrientation());
            this.pane.setPrefHeight(this.calcStageHeight());
            this.pane.setPrefWidth(this.stage.getWidth());
            this.pane.autosize();
            this.stage.setOnCloseRequest(e -> PosScene.onCloseRequestEvent(event -> PosScene.terminateAction(this, this.stage, event), e));
        }
        catch (Exception es) {
            NaMaLogger.error((Throwable)es);
        }
    }

    private double calcStageHeight() {
        return this.stage.getHeight() - 50.0;
    }

    private void createShiftDoc(boolean shift) {
        this.shiftOrInventory = null;
        this.shiftOrInventory = POSShiftInventoryService.createShiftDoc(POSResourcesUtil.fetchMainRegister(), shift, this.getCode(), this);
    }

    @Override
    public String screenTitle() {
        if (this.isShift) {
            POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift();
            if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
                return "openShift";
            }
            return "closeShift";
        }
        return "cashCount";
    }

    @Override
    public PosScene fetchScene() {
        return this.scene;
    }

    @Override
    public Stage fetchStage() {
        return this.stage;
    }

    @Override
    public boolean isShift() {
        return !(this.shiftOrInventory instanceof POSInventory);
    }

    @Override
    public AbsPOSShiftInventory getShiftOrInventory() {
        return this.shiftOrInventory;
    }

    @Override
    public String getCode() {
        if (this.shiftOrInventory != null && ObjectChecker.isNotEmptyOrNull((Object)this.shiftOrInventory.getCode())) {
            return this.shiftOrInventory.getCode();
        }
        return this.isShift() ? POSCodeGenerator.generateShiftCode() : POSCodeGenerator.generateInventoryCode();
    }

    @Override
    public TextArea getRemarksField() {
        return this.remarks.getField();
    }

    @Override
    public NamaSearchBox getRegisteryCodeTextField() {
        return this.registery.getField();
    }

    @Override
    public NamaLabel getCurrentShiftCashAmount() {
        return this.currentShiftCashAmount;
    }

    @Override
    public NamaLabel getOldShiftsCashAmount() {
        return this.oldShiftsCashAmount;
    }

    @Override
    public List<AbsPOSInventoryLine> calcLines() {
        for (int i = 0; i < this.totals.size(); ++i) {
            AbsPOSInventoryLine shiftLine = (AbsPOSInventoryLine)this.totals.get(i);
            BigDecimal actualRemaining = ObjectChecker.toZeroIfNull((BigDecimal)shiftLine.getActualRemaining());
            BigDecimal accountantRemaining = ObjectChecker.toZeroIfNull((BigDecimal)shiftLine.getAccountantRemaining());
            shiftLine.setActualRemaining(actualRemaining);
            shiftLine.setAccountantRemaining(accountantRemaining);
            shiftLine.setDifference(actualRemaining.subtract(accountantRemaining));
        }
        return this.totals;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return this.idleMonitor;
    }

    public POSMasterFile document() {
        return this.shiftOrInventory;
    }

    @Override
    public <T extends POSMasterFile> void afterCachedScreenReDraw() {
        if (this.createNewShift) {
            this.totals = null;
        }
        if (this.createNewShift) {
            this.createShiftDoc(this.isShift);
        }
        this.updateDetails();
        this.updateTakenElementsPerShiftGrid();
        this.resetCashDenominationsBox();
        ((IPOSToolBar)this.borderPaneCreator.getToolBar()).updateInformation(null);
        this.updateHeaderFields();
        this.createNewShift = true;
    }

    private void resetCashDenominationsBox() {
        if (this.denominationsBox != null) {
            this.denominationsBox.clear();
        }
    }

    @Override
    public POSDocumentType documentType() {
        if (this.isShift()) {
            if (ObjectChecker.isEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift())) {
                return POSDocumentType.ShiftOpen;
            }
            return POSDocumentType.ShiftClose;
        }
        return POSDocumentType.CashCount;
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.borderPaneCreator;
    }
}

