/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.concurrent.Task;

public class POSOldDocsUtility {
    private static final int DELETE_COUNT = 100;
    private static List<? extends Class> posDocsClasses = Arrays.asList(POSPaymentToRegistery.class, POSReceiptFromRegistery.class, POSOrderReservation.class, POSSalesReplacement.class, POSSalesReturn.class, POSStockReceipt.class, POSStockTakingDetailsDoc.class, POSStockTransferReq.class, PosCancelReservation.class, POSSalesInvoice.class, POSShiftOpen.class, POSShiftClose.class);

    public static Task fetchDeletionTask(final String condition, final HashMap<String, Object> params) {
        Task task = new Task(){

            protected Object call() throws Exception {
                for (Class clazz : posDocsClasses) {
                    if (this.isCancelled()) break;
                    Number count = POSPersister.count(clazz, condition, params);
                    this.deleteOperation(clazz, count);
                    this.updateProgress(0L, 1L);
                }
                this.updateProgress(1L, 1L);
                this.updateTitle(POSResourcesUtil.id("deletingProcessFinished", new Object[0]));
                return null;
            }

            private void deleteOperation(Class posDocsClass, Number count) {
                for (int i = count.intValue(); i > 0; i -= 100) {
                    this.updateTitle(POSResourcesUtil.id("deletingDocsOf", new Object[0]) + " " + POSResourcesUtil.id(posDocsClass.getSimpleName(), new Object[0]) + "\n " + POSResourcesUtil.id("totalDocs", new Object[0]) + ": " + count.intValue() + "\n" + POSResourcesUtil.id("deletedDocs", new Object[0]) + ": " + (count.intValue() - i));
                    if (this.isCancelled()) break;
                    List<?> objects = POSPersister.selectTop(posDocsClass, condition, 100, " DESC", (Map<String, Object>)params, false, "");
                    if (ObjectChecker.isEmptyOrNull(objects)) break;
                    POSPersister.deleteAll(objects);
                    int countOfRemainingDocs = ObjectChecker.toZeroIfNegative((Integer)(i - 100));
                    this.updateProgress(count.doubleValue() - (double)countOfRemainingDocs, count.doubleValue());
                }
            }
        };
        return task;
    }
}

