/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.POSCreditNoteAndCouponUtil;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class POSReceiptCouponsDialog {
    private NamaDialog<ButtonType> dialog = new NamaDialog("genCouponsWithReceiptValue");
    private TextField numOfCoupons;
    private CheckBox usedOnce;
    private DatePicker fromDate;
    private DatePicker toDate;
    private Boolean failed = false;

    public POSReceiptCouponsDialog() {
        GridPane grid = new GridPane();
        grid.setVgap(10.0);
        grid.setHgap(5.0);
        this.numOfCoupons = new TextField();
        this.usedOnce = new CheckBox();
        this.fromDate = new DatePicker();
        this.toDate = new DatePicker();
        grid.add((Node)new NamaLabel("numOfGenCoupons"), 0, 0);
        grid.add((Node)this.numOfCoupons, 1, 0);
        grid.add((Node)new NamaLabel("fromDate"), 0, 1);
        grid.add((Node)this.fromDate, 1, 1);
        grid.add((Node)new NamaLabel("toDate"), 2, 1);
        grid.add((Node)this.toDate, 3, 1);
        grid.add((Node)new NamaLabel("usedOnce"), 0, 2);
        grid.add((Node)this.usedOnce, 1, 2);
        this.dialog.content((Node)grid);
        this.dialog.addOkButton("");
        this.dialog.addCancelButton("");
    }

    public void showDialog(POSPaymentReciptScreen view) {
        this.failed = false;
        Optional result = this.dialog.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.validateAndGenCoupons(view, this.dialog, this.numOfCoupons, this.fromDate, this.toDate, this.usedOnce);
        }
    }

    private void validateAndGenCoupons(POSPaymentReciptScreen view, NamaDialog dialog, TextField numOfCoupons, DatePicker fromDatePicker, DatePicker toDatePicker, CheckBox usedOnce) {
        Date fromDate = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)fromDatePicker.getValue())) {
            fromDate = Date.valueOf((LocalDate)fromDatePicker.getValue());
        }
        Date toDate = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)toDatePicker.getValue())) {
            toDate = Date.valueOf((LocalDate)toDatePicker.getValue());
        }
        Integer couponsCount = 0;
        if (ObjectChecker.isNotEmptyOrNull((Object)numOfCoupons.getText())) {
            couponsCount = ObjectChecker.tryParseInt((String)numOfCoupons.getText());
        }
        if (ObjectChecker.isEmptyOrZero((Integer)couponsCount) || couponsCount < 0) {
            this.failed = true;
            dialog.error("Not complete data");
            this.showDialog(view);
        }
        if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{fromDate, toDate}) && fromDate.compareTo(toDate) > 0) {
            this.failed = true;
            dialog.error("From date must be before to date");
            this.showDialog(view);
        }
        if (!this.failed.booleanValue()) {
            dialog.hide();
            AbsPOSPayReceipt doc = view.getPayReceipt();
            BigDecimal value = NaMaMath.divide((BigDecimal)doc.getValue(), (BigDecimal)new BigDecimal(couponsCount), (Integer)doc.getCurrency().getFractionDecimalPlaces());
            for (int i = 0; i < couponsCount; ++i) {
                UUID customerId = doc.getSubsidiaryID();
                POSCustomer customer = POSPersister.findByID(POSCustomer.class, customerId);
                POSResult result = new POSResult();
                POSCreditNoteAndCouponUtil.genAndPrintCouponFromSalesOffer(POSResourcesUtil.fetchMainRegister(), view, customer, fromDate, toDate, value, usedOnce.isSelected(), null, view.document());
                if (!result.isFailed().booleanValue()) continue;
                POSErrorAndInfoMessagesUtil.showError(result, view.fetchStage());
            }
        }
    }
}

