/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.criteria.AllowedValue;
import com.namasoft.common.flatobjects.FieldTypesUtils;
import com.namasoft.common.layout.list.QuestionField;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.layout.metadata.ReportQuestionFieldMetadata;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.TimePeriodUtilsNormal;
import com.namasoft.namacontrols.NamaCheckBox;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTextArea;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.util.POSDataReaderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;

public class POSReportsScreen<POSControl extends Region>
implements IHasToolBar {
    private IHasToolBar owner;
    private Dialog reportsDialog;

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.owner.fetchFieldsMap();
    }

    public POSReportsScreen(IHasToolBar owner, Dialog reportsDialog) {
        this.owner = owner;
        PosEntryPoint.lastScreen = this;
        this.reportsDialog = reportsDialog;
    }

    @Override
    public PosScene fetchScene() {
        return this.owner.fetchScene();
    }

    @Override
    public Stage fetchStage() {
        return this.owner.fetchStage();
    }

    @Override
    public void fireSelectItemAction(Class<?> onKlass, TableView<POSMasterFile> table, POSMasterFile selectedItem) {
        POSReportDefinition report = (POSReportDefinition)selectedItem;
        ReportMetadata metadata = report.fetchMetadata();
        List<QuestionField> questionFields = metadata.getQuestionFields().stream().filter(q -> ObjectChecker.isEmptyOrNull((Object)q.getHidden()) || ObjectChecker.isFalse((Boolean)q.getHidden())).collect(Collectors.toList());
        if (ObjectChecker.areEqual((Object)report.getReportType(), (Object)"UserReport") && ObjectChecker.isEmptyOrNull(questionFields)) {
            report.viewPrintDialog(POSResourcesUtil.fetchMainRegister(), new HashMap<String, Object>(), true, (Callback<Void>)Callback.NULL, true);
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        List<POSControl> controls = this.constructControls(questionFields);
        if (this.showParametersGrid(controls, parameters, report, metadata, this.reportsDialog)) {
            report.addQuestionFieldMetadataParams(parameters, controls, metadata);
            report.viewPrintDialog(POSResourcesUtil.fetchMainRegister(), parameters, true, (Callback<Void>)Callback.NULL, true);
        }
    }

    public List<POSControl> constructControls(List<QuestionField> questionFields) {
        ArrayList<NamaDatePicker> controls = new ArrayList<NamaDatePicker>();
        try {
            for (QuestionField questionField : questionFields) {
                String id = questionField.getId();
                POSField control = null;
                FieldType fieldType = questionField.getFieldType();
                switch (fieldType) {
                    case Text: 
                    case Decimal: 
                    case Integer: 
                    case Long: {
                        control = new NamaTextField(POSFieldType.valueOf(fieldType.name()), null, null);
                        break;
                    }
                    case Date: {
                        control = new NamaDatePicker();
                        break;
                    }
                    case Boolean: {
                        control = new NamaCheckBox(id);
                        break;
                    }
                    case BigText: {
                        control = new NamaTextArea(null, null);
                        break;
                    }
                    case Enum: {
                        control = new NamaComboBox(CollectionsUtility.convert((Collection)questionField.getAllowedValues(), AllowedValue::getValue), null, null);
                        break;
                    }
                    case Reference: {
                        IHasToolBar tempScreen = new IHasToolBar(){

                            @Override
                            public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
                                return POSReportsScreen.this.owner.fetchFieldsMap();
                            }

                            @Override
                            public PosScene fetchScene() {
                                return POSReportsScreen.this.fetchScene();
                            }

                            @Override
                            public Stage fetchStage() {
                                return POSReportsScreen.this.fetchStage();
                            }
                        };
                        Class<?> klass = POSDataReaderUtil.constructNamaWithPOSTypesMap().get(questionField.getMetaData().getReferencedEntityType());
                        if (klass == null) {
                            klass = Class.forName("com.namasoft.pos.domain.entities." + questionField.getMetaData().getReferencedEntityType());
                        }
                        control = new NamaSearchBox(klass, tempScreen, "", this.fetchStage());
                        ((NamaSearchBox)control).setUsedInReport(true);
                    }
                }
                control.setId(id);
                ((POSField)control).setTitle(this.calcQuestionTitle(questionField));
                controls.add((NamaDatePicker)control);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return controls;
    }

    private String calcQuestionTitle(QuestionField questionField) {
        if (ObjectChecker.isEmptyOrNull((Object)questionField.getTitle())) {
            return POSResourcesUtil.id(null, questionField.getId());
        }
        return POSResourcesUtil.translate(questionField.getTitle());
    }

    private boolean showParametersGrid(List<POSControl> controls, HashMap<String, Object> parameters, POSReportDefinition report, ReportMetadata metadata, Dialog reportsDialog) {
        NamaDialog dialog = new NamaDialog(report.nameByLanguage());
        dialog.fromDialog(reportsDialog);
        GridPane grid = new GridPane();
        for (int i = 0; i < controls.size(); ++i) {
            Region region = (Region)controls.get(i);
            ((POSField)region).updateValueFromQuestionField(FieldTypesUtils.parseString((String)this.getDefaultValue(metadata, region), (FieldType)FieldType.valueOf((String)((POSField)region).fetchFieldType().name()), TimePeriodUtilsNormal::addTimePeriodToDate));
            grid.add((Node)new NamaLabel(((POSField)region).getTitle()), 0, i);
            grid.add((Node)region, 1, i);
        }
        dialog.content((Node)grid);
        dialog.addOkButton("");
        dialog.addCancelButton("");
        Optional result = dialog.showAndWait();
        if (result != null && result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonType.APPLY.getButtonData())) {
            for (Region control : controls) {
                report.addParameter(parameters, ((POSField)control).fetchValue(), control.getId(), metadata);
            }
        } else {
            dialog.hide();
            return false;
        }
        return true;
    }

    private String getDefaultValue(ReportMetadata metadata, POSControl region) {
        ReportQuestionFieldMetadata question = (ReportQuestionFieldMetadata)HasIDUtil.find((String)region.getId(), (List)metadata.getMetadata());
        if (question != null) {
            return question.getDefaultValue();
        }
        return null;
    }
}

