/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.IBaseEntityDTO;
import com.namasoft.common.Pair;
import com.namasoft.common.constants.ApplicationVersion;
import com.namasoft.common.constants.DBTranslationResp;
import com.namasoft.common.constants.Language;
import com.namasoft.common.constants.NamaAppVersionDTO;
import com.namasoft.common.constants.OutputFormat;
import com.namasoft.common.flatobjects.DateFieldUtils;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.urlutils.ReportQuestions;
import com.namasoft.common.utilities.MultiKeyHash;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.SimpleEntry;
import com.namasoft.common.utils.NaMaLayersConnector;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.common.utils.translation.AggregatedMessageTranslator;
import com.namasoft.common.utils.translation.MessageTranslator;
import com.namasoft.common.utils.translation.MessageTranslatorFromDB;
import com.namasoft.common.utils.translation.MessageTranslatorFromFile;
import com.namasoft.common.utils.translation.TranslationUtil;
import com.namasoft.contracts.common.dtos.config.DTOGlobalConfig;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ItemFinder;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.modules.namapos.contracts.common.DTOFieldAllowedValuesReq;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.modules.namapos.contracts.valueobjects.DTOPOSConditionGroup;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOSupplyChainConfigurations;
import com.namasoft.pos.application.CachedFavouritesObject;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSCachedObject;
import com.namasoft.pos.application.IPOSHasDateAndTime;
import com.namasoft.pos.application.IPosValuesUpdater;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSTranslationOverriderUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosShortcutsUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.details.POSExchangeRateLine;
import com.namasoft.pos.domain.details.POSFavouriteLine;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSDepreciationReason;
import com.namasoft.pos.domain.entities.POSError;
import com.namasoft.pos.domain.entities.POSExtraFilter;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSPaymentMethodsSettings;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDefaultsTemplate;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import com.namasoft.pos.domain.entities.PosTableEntry;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.PosFieldAllowedValues;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPricesCachingUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.POSXMLSerializer;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.specialserialization.FlatObjectUtilies;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.SimpleXMLMarshaller;
import jakarta.xml.bind.UnmarshalException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class POSResourcesUtil {
    public static final int DATABASE_VERSION = 46;
    public static Boolean disablePrinting = false;
    private static NodeOrientation orientation = POSResourcesUtil.initOrientation();
    public static POSSettingsInfo currentSetting;
    public static POSIdleMonitor lastIdleMonitor;
    public static Node idleMonitorNode;
    public static List<POSReportDefinition> reportDefintions;
    public static Boolean addTrayIcon;
    public static Boolean showIds;
    private static POSRegistery posRegistery;
    public static PosDefaultsTemplate defaultsTemplate;
    public static List<POSPaymentMethod> methods;
    public static List<POSHall> halls;
    public static List<POSTable> tables;
    public static List<POSCurrency> currencies;
    public static List<PosFieldAllowedValues> fieldAllowedValues;
    public static HashMap<String, IPosValuesUpdater> valuesUpdaterHashMap;
    private static HashMap<Pair<List<UUID>, Boolean>, CachedFavouritesObject> cachedFavourites;
    private static List<POSDepreciationReason> cachedDepreciationReasons;
    public static final Thread.UncaughtExceptionHandler uncaughtExceptionsHandler;
    public static HashMap<POSDocumentType, AbsPOSSales> lastScreensDocs;
    private static HashMap<MultiKeyHash, PosItemAdditionalItems> additionalItemsMap;
    public static List<POSPaymentMethod> pgwMethods;
    public static IHasToolBar currentScreen;
    public static List<POSFavouriteLine> favouriteItems;
    private static Map<String, Optional<POSRegistery>> registeryCache;
    private static POSExtraFilter extraFilters;
    private static POSPaymentMethodsSettings paymentMethodsSettings;
    private static final Map<Class, String> entityTypeByClass;
    private static Map<String, Integer> posShiftCodeLength;
    public static boolean generatingDataModel;
    private static DTOGlobalConfig dtoGlobalConfig;
    private static DTOPOSConfiguration dtoPosConfiguration;
    private static DTOSupplyChainConfigurations dtoSupplyChainConfiguration;
    private static Optional<DTOTaxPlan> configTaxPlan;
    private static ConcurrentHashMap<UUID, Optional<UUID>> itemsTaxPlans;
    private static final DateTimeFormatter _yyyymmdd;

    public static void checkIfIncompatibleVersionWithNama(Throwable e) {
        if (e instanceof UnmarshalException || e.getCause() instanceof UnmarshalException) {
            POSResourcesUtil.errorAndWait(POSResourcesUtil.id("Nama version is not compatible with POS version", new Object[0]));
        }
    }

    public static void errorAndWaitThenExit(String errorMessage) {
        POSResourcesUtil.errorAndWait(errorMessage, true);
    }

    public static void errorAndWait(String errorMessage) {
        POSResourcesUtil.errorAndWait(errorMessage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void errorAndWait(String errorMessage, boolean exit) {
        Object lock = new Object();
        Pair errorShown = new Pair((Object)false, (Object)false);
        Runnable showError = () -> {
            errorShown.setX((Object)true);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setHeaderText("Error");
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setContentText(errorMessage);
            alert.showAndWait();
        };
        if (Platform.isFxApplicationThread()) {
            showError.run();
            if (exit) {
                PosShortcutsUtil.terminateAll();
            }
            return;
        }
        Platform.runLater(() -> {
            Object object = lock;
            synchronized (object) {
                showError.run();
            }
        });
        try {
            Thread.sleep(2000L);
            Object object = lock;
            synchronized (object) {
                System.out.println();
            }
        }
        catch (InterruptedException e1) {
            NaMaLogger.error((Throwable)e1);
        }
        if (exit) {
            PosShortcutsUtil.terminateAll();
        }
    }

    public static void loadTranslations() {
        if (NaMaLayersConnector.getInstance() == null) {
            NaMaLayersConnector.setInstance((NaMaLayersConnector)new NaMaLayersConnector(){

                public String toHijri(Date date) {
                    return null;
                }

                public List runSQLQuery(String query, Object ... parameters) {
                    return null;
                }

                public void registerClosable(Closeable closeable) {
                }

                public Long nextMessageSequence() {
                    return null;
                }

                public boolean isModuleLoaded(String moduleName) {
                    return false;
                }

                public BigDecimal getVacation1RemainderBalance(Object empCodeOrId) {
                    return null;
                }

                public BigDecimal getVacationRemainderBalance(Object empCodeOrId, Object vacationTypeIdOrCode, Object atDate) {
                    return null;
                }

                public BigDecimal getVacation2RemainderBalance(Object empCodeOrId) {
                    return null;
                }

                public BigDecimal getVacation3RemainderBalance(Object empCodeOrId) {
                    return null;
                }

                public InputStream getFile(Object id) throws Exception {
                    return null;
                }

                public List<MessageTranslator> getDBTranslators() {
                    List<DBTranslationResp> dbTranslations;
                    ArrayList<MessageTranslator> translators = new ArrayList<MessageTranslator>();
                    if (ObjectChecker.isNotEmptyOrNull((Object)POSPersister.getFactory()) && ObjectChecker.isNotEmptyOrNull(dbTranslations = POSTranslationOverriderUtil.calcDbTranslations())) {
                        for (DBTranslationResp dbTranslation : dbTranslations) {
                            if (ObjectChecker.isEmptyOrNull((Object)dbTranslation.getOrder())) {
                                dbTranslation.setOrder(Long.valueOf(0L));
                            }
                            translators.add((MessageTranslator)new MessageTranslatorFromDB(dbTranslation.getArabic(), dbTranslation.getEnglish(), dbTranslation.getReplacements(), (long)(ObjectChecker.toZeroIfNull((BigDecimal)new BigDecimal(dbTranslation.getOrder())).intValue() + 100)));
                        }
                    }
                    return translators;
                }

                public SimpleEntry<EntityReferenceData, ReportMetadata> findReportMetadataById(String id) {
                    return null;
                }

                public SimpleEntry<EntityReferenceData, ReportMetadata> findReportMetadataByCode(String code) {
                    return null;
                }

                public boolean canDisplay(Object o) {
                    return false;
                }

                public String audit(Object entityType, Object id, Object versionNumber, Object actionType, Language language, OutputFormat outputFormat) {
                    return null;
                }

                public EntityReferenceData findItemByCode(String code) {
                    return ItemFinder.findItemByCode((String)code);
                }

                public Object getValueFromModuleConfig(String moduleId, String fieldId) {
                    return null;
                }

                public <T extends IBaseEntityDTO> T fetchReference(EntityReferenceData ref) {
                    return null;
                }

                public boolean usingFrench() {
                    return false;
                }

                public EntityReferenceData refByCode(String entityType, String code) {
                    return EntityReferenceData.code((String)entityType, (String)code);
                }

                public EntityReferenceData refById(String entityType, String id) {
                    return EntityReferenceData.id((String)entityType, (String)id);
                }

                public EntityReferenceData findByIdOrCode(String entityType, Object id) {
                    return EntityReferenceData.code((String)entityType, (String)ObjectChecker.toStringOrNull((Object)ReportQuestions.preProcessValue((Object)id)));
                }
            });
        }
        AggregatedMessageTranslator.addTranslators(Arrays.asList(MessageTranslatorFromFile.fromClassPathFiles((String)"pos-ar.properties", (String)"pos-en.properties", (long)0L)));
    }

    public static POSRegistery fetchRegisterIgnoringInActiveAndPreventUsage(UUID registerId) {
        if (ObjectChecker.isEmptyOrNull((Object)registerId)) {
            return null;
        }
        return POSResourcesUtil.fetchRegister(ObjectChecker.toStringOrEmpty((Object)registerId));
    }

    public static void clearRegisteryCache() {
        registeryCache.clear();
    }

    public static POSRegistery fetchRegister(String registerId) {
        return POSResourcesUtil.fetchRegister(registerId, true);
    }

    public static POSRegistery fetchRegister(String registerId, boolean checkInactiveAndPreventUsage) {
        if (ObjectChecker.isEmptyOrNull((Object)registerId)) {
            return null;
        }
        Optional<POSRegistery> registerHolder = registeryCache.get(registerId);
        if (registerHolder != null) {
            return registerHolder.get();
        }
        POSRegistery register = POSPersister.findByID(POSRegistery.class, registerId);
        if (register != null && checkInactiveAndPreventUsage && ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{register.getInActive(), register.getPreventUsage()})) {
            register = null;
        }
        registeryCache.put(registerId, Optional.of(register));
        return register;
    }

    public static POSRegistery fetchMainRegister() {
        return POSResourcesUtil.fetchRegister(false);
    }

    public static UUID fetchRegisterId() {
        POSRegistery register = POSResourcesUtil.fetchRegister(false);
        if (register == null) {
            return null;
        }
        return register.getId();
    }

    public static POSExtraFilter fetchExtraFilters() {
        EntityReferenceData filter = (EntityReferenceData)ObjectChecker.getFirstNotNullObj((Object[])new EntityReferenceData[]{POSResourcesUtil.fetchMainRegister().getExtraFilters() == null ? null : POSResourcesUtil.fetchMainRegister().getExtraFilters().toEntityReferenceData(), POSResourcesUtil.fetchPOSConfig().getExtraFilters()});
        if (filter == null) {
            return null;
        }
        if (extraFilters == null || ObjectChecker.areNotEqual((Object)filter, (Object)extraFilters.toEntityReferenceData())) {
            extraFilters = POSPersister.findByID(POSExtraFilter.class, filter.getId());
        }
        return extraFilters;
    }

    public static void resetExtraFilters() {
        extraFilters = null;
    }

    public static POSPaymentMethodsSettings fetchPaymentMethodsSettings() {
        UUID payMethodsSettings = (UUID)ObjectChecker.getFirstNotNullObj((Object[])new UUID[]{POSResourcesUtil.fetchMainRegister().getPaymentMethodsSettings(), POSResourcesUtil.fetchPOSConfig().getPaymentMethodsSettings() == null ? null : UUID.fromString(POSResourcesUtil.fetchPOSConfig().getPaymentMethodsSettings().getId())});
        if (payMethodsSettings == null) {
            return null;
        }
        if (paymentMethodsSettings == null || ObjectChecker.areNotEqual((Object)payMethodsSettings, (Object)paymentMethodsSettings)) {
            paymentMethodsSettings = POSPersister.findByID(POSPaymentMethodsSettings.class, payMethodsSettings);
        }
        return paymentMethodsSettings;
    }

    public static void resetPaymentMethodsSettings() {
        paymentMethodsSettings = null;
    }

    public static boolean fileMatched(POSMasterFile pos, EntityReferenceData nama) {
        if (ObjectChecker.isEmptyOrNull((Object)nama)) {
            return true;
        }
        if (pos == null) {
            return false;
        }
        return ObjectChecker.areEqual((Object)pos.getId(), (Object)UUID.fromString(nama.getId()));
    }

    public static PosDefaultsTemplate fetchTemplate() {
        return POSResourcesUtil.fetchTemplate(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchRegisterId()));
    }

    public static PosDefaultsTemplate fetchTemplate(String registerId) {
        if (defaultsTemplate != null) {
            return defaultsTemplate;
        }
        if (POSResourcesUtil.fetchRegister(registerId).getDefaultsTemplate() == null) {
            defaultsTemplate = null;
            return null;
        }
        defaultsTemplate = POSPersister.findByID(PosDefaultsTemplate.class, POSResourcesUtil.fetchRegister(registerId).getDefaultsTemplate().getId());
        return defaultsTemplate;
    }

    public static POSRegistery fetchRegister(boolean forceReFetch) {
        if (posRegistery != null && ObjectChecker.isFalseOrNull((Boolean)forceReFetch)) {
            return posRegistery;
        }
        String code = POSGeneralSettings.getRegisterCode();
        posRegistery = (POSRegistery)POSPersister.findByCode(POSRegistery.class, code);
        return posRegistery;
    }

    private static NodeOrientation initOrientation() {
        if (POSGeneralSettings.getDefaultLang() == Language.Arabic) {
            return NodeOrientation.RIGHT_TO_LEFT;
        }
        return NodeOrientation.LEFT_TO_RIGHT;
    }

    public static String id(Class klass, String key) {
        String entityType = POSResourcesUtil.calcEntityType(klass);
        if (ObjectChecker.isEmptyOrNull((Object)entityType)) {
            return POSResourcesUtil.id(key, new Object[0]);
        }
        return POSResourcesUtil.id(entityType + "." + key, new Object[0]);
    }

    public static String calcEntityType(Class klass) {
        if (klass == null || !POSMasterFile.class.isAssignableFrom(klass)) {
            return null;
        }
        String fromCache = entityTypeByClass.get(klass);
        if (fromCache != null) {
            return fromCache;
        }
        String entityType = POSResourcesUtil.calcEntityTypeFromClass(klass);
        entityTypeByClass.put(klass, ObjectChecker.toStringOrEmpty((Object)entityType));
        return entityTypeByClass.get(klass);
    }

    private static String calcEntityTypeFromClass(Class klass) {
        try {
            POSMasterFile file = (POSMasterFile)ObjectCreatorUtil.creator((Class)klass).create();
            return file.calcNamaEntityType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String id(String key, Object ... arguments) {
        return POSResourcesUtil.idByDefLang(POSGeneralSettings.getDefaultLang(), key, arguments);
    }

    public static String idToArabic(String key, Object ... arguments) {
        return POSResourcesUtil.idByDefLang(Language.Arabic, key, arguments);
    }

    public static String idToEnglish(String key, Object ... arguments) {
        return POSResourcesUtil.idByDefLang(Language.English, key, arguments);
    }

    public static String idByDefLang(Language language, String key, Object ... arguments) {
        if (showIds.booleanValue()) {
            return key;
        }
        return TranslationUtil.translate((Language)language, (String)key, (Object[])arguments);
    }

    public static NodeOrientation getOrientation() {
        return orientation;
    }

    public static void setOrientation(NodeOrientation orientation) {
        POSResourcesUtil.orientation = orientation;
    }

    public static Language getCurrentLang() {
        return POSGeneralSettings.getDefaultLang();
    }

    public static boolean isArabic() {
        return POSResourcesUtil.getCurrentLang() == Language.Arabic;
    }

    public static List<Pair<String, String>> fetchPOSGenRefsTypes() {
        List<String> refTypes = POSResourcesUtil.fetchPosGenRef();
        return refTypes.stream().map(t -> new Pair(t, (Object)POSResourcesUtil.id(t, new Object[0]))).collect(Collectors.toList());
    }

    public static List<String> fetchPosGenRef() {
        return POSPersister.searchFor("SELECT distinct type FROM " + POSGenReference.class.getSimpleName());
    }

    public static boolean getUseItemsImage() {
        if (!POSGeneralSettings.getUseImages()) {
            return false;
        }
        if (currentSetting == null) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDonotUseItemsImage());
    }

    public static int isTheSameVersionAsServer() {
        if (PosScene.connectionIsDown()) {
            return 0;
        }
        try {
            CoreWS coreWS = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
            GetResult result = coreWS.fetchServerVersion(new ServiceRequest());
            return ((NamaAppVersionDTO)result.getData()).compareTo(ApplicationVersion.toAppVersionDTO());
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return 0;
        }
    }

    public static String calcAppVersion() {
        return POSResourcesUtil.pad(2025, 4) + "." + POSResourcesUtil.pad(12, 2) + "." + POSResourcesUtil.pad(15, 2) + "-" + POSResourcesUtil.pad(18, 2) + "." + POSResourcesUtil.pad(21, 2);
    }

    private static String pad(int i, int len) {
        return ServerStringUtils.leftPad((Integer)i, (Integer)len);
    }

    public static void genMemoryAndThreadDump() throws IOException {
        ThreadInfo[] threadInfos;
        String fileName = "pos-thread-dump-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".txt";
        PrintWriter writer = new PrintWriter(fileName, "utf-8");
        String NL = System.getProperty("line.separator");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        writer.append("Used Memory: " + memoryMXBean.getHeapMemoryUsage().getUsed() / 0x100000L + "MB From: " + memoryMXBean.getHeapMemoryUsage().getMax() / 0x100000L + "MB");
        writer.append(NL + NL);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            writer.append('\"');
            writer.append(threadInfo.getThreadName());
            writer.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            writer.append(NL + "   java.lang.threadState : " + String.valueOf((Object)state));
            for (StackTraceElement ele : stackTraceElements = threadInfo.getStackTrace()) {
                writer.append(NL + "   at " + String.valueOf(ele));
            }
            writer.append(NL + " " + NL);
        }
        writer.close();
        Runtime.getRuntime().exec("explorer /select,\"" + new File(fileName).getAbsoluteFile().getPath() + "\"");
    }

    public static POSShiftOpen fetchLastOpenShift() {
        return POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister());
    }

    public static POSShiftOpen fetchLastOpenShift(POSRegistery register) {
        List<?> maxCode;
        if (posShiftCodeLength.get(register.getCode()) == null) {
            posShiftCodeLength.put(register.getCode(), POSCodeGenerator.generateShiftCode(register).length());
        }
        if (ObjectChecker.isEmptyOrNull(maxCode = POSPersister.searchFor("SELECT MAX(code) FROM POSShiftOpen where LENGTH(code)  = :length and registery= :registery", POSPersister.params("length", posShiftCodeLength.get(register.getCode()), "registery", register)))) {
            return null;
        }
        POSShiftOpen open = (POSShiftOpen)POSPersister.findByCode(POSShiftOpen.class, (String)maxCode.get(0));
        if (ObjectChecker.isEmptyOrNull((Object)open)) {
            return null;
        }
        POSShiftClose shiftClose = (POSShiftClose)POSPersister.findByCode(POSShiftClose.class, open.getCode());
        if (ObjectChecker.isNotEmptyOrNull((Object)shiftClose)) {
            return null;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)open) && ObjectChecker.isEmptyOrNull((Object)open.getPosUser())) {
            open.setPosUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
            POSPersister.saveOrUpdateWithActionHistory(open, null);
        }
        return open;
    }

    public static POSShiftClose fetchLastCloseShift() {
        return POSResourcesUtil.fetchLastCloseShift(POSResourcesUtil.fetchMainRegister());
    }

    public static POSShiftClose fetchLastCloseShift(POSRegistery register) {
        List<?> maxCode = POSPersister.searchFor("SELECT MAX(code) FROM POSShiftClose WHERE registery= :registery", POSPersister.params("registery", register));
        if (ObjectChecker.isEmptyOrNull(maxCode)) {
            return null;
        }
        return (POSShiftClose)POSPersister.findByCode(POSShiftClose.class, (String)maxCode.get(0));
    }

    public static POSGenericDims fetchRegisterDims() {
        return POSResourcesUtil.fetchRegisterDims(POSResourcesUtil.fetchMainRegister());
    }

    public static POSGenericDims fetchRegisterDims(POSRegistery register) {
        return register.getGenericDims().cloneData();
    }

    public static DTOGlobalConfig fetchGlobalConfig() {
        if (dtoGlobalConfig == null && (dtoGlobalConfig = POSXMLSerializer.instance().xmlToObject(currentSetting.getGlobalConfigXML(), DTOGlobalConfig.class)) != null) {
            dtoGlobalConfig.loadOtherCurrencyDetails();
        }
        if (dtoGlobalConfig == null || dtoGlobalConfig.getInfo() == null) {
            PosEntryPoint.loadConfigurations(true);
            return POSResourcesUtil.fetchGlobalConfig();
        }
        return dtoGlobalConfig;
    }

    public static DTOPOSConfiguration fetchPOSConfig() {
        if (dtoPosConfiguration == null && currentSetting != null) {
            dtoPosConfiguration = POSXMLSerializer.instance().xmlToObject(currentSetting.getPosConfigXML(), DTOPOSConfiguration.class);
            POSResourcesUtil.updateConnectionAndReceiveTimeout();
        }
        return dtoPosConfiguration == null ? new DTOPOSConfiguration() : dtoPosConfiguration;
    }

    private static void updateConnectionAndReceiveTimeout() {
        Integer receiveTimeout;
        Integer connectionTimeout = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{POSGeneralSettings.getConnectionTimeout(), dtoPosConfiguration.getConnectionTimeout()});
        if (ObjectChecker.isNotEmptyOrZero((Integer)connectionTimeout) && ObjectChecker.areNotEqual((Object)connectionTimeout, (Object)ServiceUtility.getConnectionTimeout())) {
            ServiceUtility.setConnectionTimeout((long)connectionTimeout.intValue());
        }
        if (ObjectChecker.isNotEmptyOrZero((Integer)(receiveTimeout = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{POSGeneralSettings.getReceiveTimeout(), dtoPosConfiguration.getReceiveTimeout()}))) && ObjectChecker.areNotEqual((Object)receiveTimeout, (Object)ServiceUtility.getReceiveTimeout())) {
            ServiceUtility.setReceiveTimeout((long)receiveTimeout.intValue());
        }
    }

    public static DTOTaxPlan fetchPosConfigDtoTaxPlan() {
        if (configTaxPlan != null) {
            return configTaxPlan.orElse(null);
        }
        POSTaxPlan posConfigTaxPlan = (POSTaxPlan)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getTaxPlan());
        if (posConfigTaxPlan == null) {
            configTaxPlan = Optional.empty();
            return null;
        }
        configTaxPlan = Optional.ofNullable(posConfigTaxPlan.fetchFullDTO());
        return configTaxPlan.orElse(null);
    }

    public static void clearPosConfigTaxPlan() {
        configTaxPlan = null;
    }

    public static DTOTaxPlan fetchItemDtoTaxPlanFrom(POSItem item) {
        if (item == null) {
            return null;
        }
        if (itemsTaxPlans.containsKey(item.getId())) {
            return POSTaxPlan.fetchFullDTOById(itemsTaxPlans.get(item.getId()).orElse(null));
        }
        POSTaxPlan taxPlan = item.getTaxPlan();
        if (taxPlan == null) {
            itemsTaxPlans.put(item.getId(), Optional.empty());
            return null;
        }
        itemsTaxPlans.put(item.getId(), Optional.ofNullable(taxPlan.getId()));
        return taxPlan.fetchFullDTO();
    }

    public static Integer fetchNumberOfTimesForResending() {
        Integer numberOfTimesForResending = POSResourcesUtil.fetchPOSConfig().getNumForResendingFailures();
        if (ObjectChecker.isNegativeOrZero((Integer)numberOfTimesForResending)) {
            numberOfTimesForResending = 25;
        }
        return numberOfTimesForResending;
    }

    public static DTOSupplyChainConfigurations fetchSupplyChainConfig() {
        if (dtoSupplyChainConfiguration == null) {
            dtoSupplyChainConfiguration = POSXMLSerializer.instance().xmlToObject(currentSetting.getScConfigXML(), DTOSupplyChainConfigurations.class);
        }
        return dtoSupplyChainConfiguration == null ? new DTOSupplyChainConfigurations() : dtoSupplyChainConfiguration;
    }

    public static Boolean fillSalesManInDetails() {
        return POSResourcesUtil.fetchSupplyChainConfig().getSalesManInDetails() != false && POSResourcesUtil.fetchSupplyChainConfig().getSalesManFromHeaderIfDetEmpty() != false;
    }

    public static Integer safeGetValue(Integer field) {
        if (ObjectChecker.isEmptyOrZero((Integer)field)) {
            return 0;
        }
        return field;
    }

    public static String safeGetValue(String field) {
        if (ObjectChecker.isEmptyOrNull((Object)field)) {
            return "";
        }
        return field;
    }

    public static BigDecimal safeGetValue(BigDecimal field) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)field)) {
            return BigDecimal.ZERO;
        }
        return field;
    }

    public static Integer couponCodeLength() {
        Integer discountCouponCodeLength = POSResourcesUtil.fetchPOSConfig().getDiscountCouponCodeLength();
        if (ObjectChecker.isEmptyOrZero((Integer)discountCouponCodeLength)) {
            return 12;
        }
        return discountCouponCodeLength;
    }

    public static DTOPOSConditionGroup fetchConfigConditionGroup() {
        DTOPOSConditionGroup conditionGroup = POSResourcesUtil.fetchPOSConfig().getConditionGroup();
        if (conditionGroup != null) {
            return conditionGroup;
        }
        return new DTOPOSConditionGroup();
    }

    public static void updateGlobalConfig(FlatObject globalFlatObj) {
        dtoGlobalConfig = (DTOGlobalConfig)FlatObjectUtilies.toRealObject((FlatObject)globalFlatObj);
        dtoGlobalConfig.getInfo().setAddRemarksPageTo(new ArrayList());
        dtoGlobalConfig.getInfo().setEmailSettings(new ArrayList());
        dtoGlobalConfig.getInfo().setSmsSettings(new ArrayList());
        dtoGlobalConfig.getInfo().setEmailReceiverSettings(new ArrayList());
        dtoGlobalConfig.getInfo().setAddDetailedRemarksPageTo(new ArrayList());
        dtoGlobalConfig.getInfo().setAddMeetingRemarksPageTo(new ArrayList());
        dtoGlobalConfig.getInfo().setAddContactsPageTo(new ArrayList());
        dtoGlobalConfig.getInfo().setDoNotReplicate(new ArrayList());
        dtoGlobalConfig.getInfo().setAddDMSDocsTo(new ArrayList());
        dtoGlobalConfig.getInfo().setAddSubsidiaryBalanceTo(new ArrayList());
        dtoGlobalConfig.getInfo().setHijriFields(new ArrayList());
        dtoGlobalConfig.getInfo().setEntitiesReviseLevels(new ArrayList());
        dtoGlobalConfig.getInfo().setEntityImages(new ArrayList());
        dtoGlobalConfig.getInfo().setIgnoreRecordCapabilitiesIn(new ArrayList());
        dtoGlobalConfig.getInfo().setIgnoreClosedPeriodsIn(new ArrayList());
        dtoGlobalConfig.getInfo().setUseColorsIn(new ArrayList());
        dtoGlobalConfig.getInfo().setMailServerSettings(null);
        dtoGlobalConfig.getInfo().setDocConverterSettings(null);
        dtoGlobalConfig.getInfo().setItemCodingFormula(null);
        dtoGlobalConfig.getInfo().setExcelExportConfig(null);
        dtoGlobalConfig.getInfo().setHijriFormat(null);
        dtoGlobalConfig.getInfo().setTrackDebtAgesOn(null);
        dtoGlobalConfig.getInfo().setUseLogoForPublic(null);
        dtoGlobalConfig.getInfo().setFontInfo(null);
        currentSetting.setGlobalConfigXML(SimpleXMLMarshaller.getInstance().marshal((Object)dtoGlobalConfig));
        Integer globalInfoPercentScale = dtoGlobalConfig.getInfo().getPercentageFractionalDecimalPlaces();
        if (ObjectChecker.isNotEmptyOrZero((Integer)globalInfoPercentScale) && ObjectChecker.areNotEqual((Object)POSMoneyUtils.getPercentageScale(), (Object)globalInfoPercentScale)) {
            POSMoneyUtils.percentageScale = globalInfoPercentScale;
        }
        POSPersister.saveOrUpdate(currentSetting);
    }

    public static void updatePOSConfig(FlatObject posFlatObj) {
        dtoPosConfiguration = (DTOPOSConfiguration)FlatObjectUtilies.toRealObject((FlatObject)posFlatObj, (String)DTOPOSConfiguration.class.getName());
        dtoPosConfiguration.setSendConfigLines(new ArrayList());
        dtoPosConfiguration.setSalesTerms(new ArrayList());
        dtoPosConfiguration.setReturnTerms(new ArrayList());
        dtoPosConfiguration.setPaymentTerms(new ArrayList());
        currentSetting.setPosConfigXML(SimpleXMLMarshaller.getInstance().marshal((Object)dtoPosConfiguration));
        POSPersister.saveOrUpdate(currentSetting);
        POSResourcesUtil.cacheRegisterConfigFields();
        POSPricesCachingUtil.clearCache();
        cachedFavourites.clear();
        POSGeneralSettings.setProperty((String)"useDomainServerForRelease", (String)("" + ObjectChecker.isTrue((Boolean)dtoPosConfiguration.getUseDomainServerForRelease())));
        POSResourcesUtil.resetExtraFilters();
        POSResourcesUtil.resetPaymentMethodsSettings();
        POSResourcesUtil.clearPosConfigTaxPlan();
        PosSalesUtil.evictChargeItemsAndDeliveryCostCache();
        POSResourcesUtil.updateConnectionAndReceiveTimeout();
    }

    private static void updateConfigFavouriteItems() {
        favouriteItems.clear();
        favouriteItems.addAll(POSDataReaderUtil.readFavouriteItems(POSResourcesUtil.fetchMainRegister()));
    }

    public static void updateSupplyChainConfig(FlatObject scFlatObj) {
        dtoSupplyChainConfiguration = (DTOSupplyChainConfigurations)FlatObjectUtilies.toRealObject((FlatObject)scFlatObj);
        dtoSupplyChainConfiguration.setMFactors(new ArrayList());
        dtoSupplyChainConfiguration.setAddQtyToItemDimensionsSuggestionInTypes(new ArrayList());
        dtoSupplyChainConfiguration.setAddQtyTrackingFieldsTo(new ArrayList());
        dtoSupplyChainConfiguration.setAddQtyTrackingFieldsTo2(new ArrayList());
        dtoSupplyChainConfiguration.setScGridConfigLines(new ArrayList());
        dtoSupplyChainConfiguration.setCostSchedule(new ArrayList());
        dtoSupplyChainConfiguration.setDimensionsBySuffix(new ArrayList());
        dtoSupplyChainConfiguration.setAddDeleteOnSaveFieldTo(new ArrayList());
        dtoSupplyChainConfiguration.setAddGrossWeightAndNetWeightFieldsTo(new ArrayList());
        dtoSupplyChainConfiguration.setCostSources(new ArrayList());
        dtoSupplyChainConfiguration.setOverdraftCostSources(new ArrayList());
        dtoSupplyChainConfiguration.setDimensionsWithAllowedOverdraft(new ArrayList());
        dtoSupplyChainConfiguration.setBranchConfigurations(null);
        dtoSupplyChainConfiguration.setSectorConfigurations(null);
        dtoSupplyChainConfiguration.setAnalysisSetConfigurations(null);
        dtoSupplyChainConfiguration.setDepartmentConfigurations(null);
        dtoSupplyChainConfiguration.setDefaultConfigurations(null);
        dtoSupplyChainConfiguration.setLot(null);
        dtoSupplyChainConfiguration.setRevision(null);
        dtoSupplyChainConfiguration.setSizeAndColor(null);
        dtoSupplyChainConfiguration.setMeasures(null);
        dtoSupplyChainConfiguration.setSerial(null);
        dtoSupplyChainConfiguration.setUnitConfig(null);
        dtoSupplyChainConfiguration.setItemField1Query(null);
        dtoSupplyChainConfiguration.setItemField2Query(null);
        dtoSupplyChainConfiguration.setItemField3Query(null);
        dtoSupplyChainConfiguration.setItemField4Query(null);
        dtoSupplyChainConfiguration.setItemField5Query(null);
        currentSetting.setScConfigXML(SimpleXMLMarshaller.getInstance().marshal((Object)dtoSupplyChainConfiguration));
        POSPersister.saveOrUpdate(currentSetting);
    }

    public static POSWarehouse fetchRegisterWarehouse() {
        return POSResourcesUtil.fetchRegisterWarehouse(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchRegisterId()));
    }

    public static POSWarehouse fetchRegisterWarehouse(String registerId) {
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        if (register == null) {
            return null;
        }
        return register.getWarehouse();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static String name(String arabic, String english) {
        return POSResourcesUtil.getCurrentLang() == Language.Arabic ? (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{arabic, english}) : (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{english, arabic});
    }

    public static String translate(NaMaText title) {
        if (ObjectChecker.isEmptyOrNull((Object)title)) {
            return "";
        }
        if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{title.getArabicText(), title.getEnglishText()})) {
            return POSResourcesUtil.name(title.getArabicText(), title.getEnglishText());
        }
        return POSResourcesUtil.id(null, title.getResourceId());
    }

    public static POSInvoiceClassification calcInvoiceClassification(POSRegistery posRegistery) {
        POSInvoiceClassification invClassifition = null;
        invClassifition = ObjectChecker.isNotEmptyOrNull((Object)posRegistery) ? posRegistery.getInvoiceClassification() : POSMasterFile.findPOSRef(POSInvoiceClassification.class, POSResourcesUtil.fetchPOSConfig().getInvoiceClassification());
        return invClassifition;
    }

    public static BigDecimal getCurrencyRate(POSCurrency currency, Date onDate) {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (posRegistery == null || currency == null) {
            return new BigDecimal(1);
        }
        POSDimInfo dimInfo = posRegistery.getGenericDims().getLegalEntity();
        if (dimInfo == null || ObjectChecker.isEmptyOrNull((Object)dimInfo.getId())) {
            return new BigDecimal(1);
        }
        POSLegalEntity legalEntity = POSPersister.findByID(POSLegalEntity.class, dimInfo.getId());
        if (legalEntity == null || ObjectChecker.isEmptyOrNull((Object)legalEntity.getLedgerId())) {
            return new BigDecimal(1);
        }
        return POSResourcesUtil.calcRateFor(legalEntity.getLedgerId(), currency, onDate);
    }

    private static BigDecimal calcRateFor(UUID ledgerId, POSCurrency currency, Date onDate) {
        if (ObjectChecker.isNotEmptyOrNull((Object)onDate)) {
            HashMap<String, Object> params = POSPersister.params("ledger", ledgerId, "curr", currency, "onDate", onDate);
            List<?> exchangeRateLines = POSPersister.listAll(POSExchangeRateLine.class, " where ledgerId = :ledger and currency = :curr and startDate <= :onDate and endDate >= :onDate", params, "");
            exchangeRateLines.sort(Comparator.comparing(POSExchangeRateLine::typePriority));
            if (ObjectChecker.isEmptyOrNull(exchangeRateLines)) {
                return BigDecimal.ONE;
            }
            return ((POSExchangeRateLine)exchangeRateLines.get(0)).getBuy();
        }
        return BigDecimal.ONE;
    }

    public static boolean noDataToSend() {
        return ObjectChecker.areAllEmptyOrZero((BigDecimal[])new BigDecimal[]{POSDataWriterUtil.countDocsToSend(POSSalesInvoice.class), POSDataWriterUtil.countDocsToSend(POSSalesReturn.class), POSDataWriterUtil.countDocsToSend(POSSalesReplacement.class), POSDataWriterUtil.countDocsToSend(POSStockTransferReq.class), POSDataWriterUtil.countDocsToSend(POSPaymentToRegistery.class), POSDataWriterUtil.countDocsToSend(POSReceiptFromRegistery.class), POSDataWriterUtil.countDocsToSend(POSShiftOpen.class), POSDataWriterUtil.countDocsToSend(POSShiftClose.class), POSDataWriterUtil.countDocsToSend(POSCustomer.class), POSDataWriterUtil.countDocsToSend(POSCreditNote.class), POSDataWriterUtil.countDocsToSend(POSError.class), POSDataWriterUtil.countDocsToSend(POSInventory.class), POSDataWriterUtil.countDocsToSend(POSInternalMessage.class), POSDataWriterUtil.countDocsToSend(POSOrderReservation.class), POSDataWriterUtil.countDocsToSend(POSStockReceipt.class), POSDataWriterUtil.countDocsToSend(POSScrapDoc.class), POSDataWriterUtil.countDocsToSend(POSShortfallsDoc.class)});
    }

    public static void changeLanguage(IHasToolBar hasToolBar) {
        if (POSResourcesUtil.isArabic()) {
            POSResourcesUtil.systemToEnglish(hasToolBar);
        } else {
            POSResourcesUtil.systemToArabic(hasToolBar);
        }
        ServiceLoginProvider.setLanguage((Language)POSResourcesUtil.getCurrentLang());
    }

    public static void systemToEnglish(IHasToolBar hasToolBar) {
        POSGeneralSettings.setProperty((String)"defaultlang", (String)Language.English.toString());
        POSResourcesUtil.setOrientation(NodeOrientation.LEFT_TO_RIGHT);
        hasToolBar.fetchPaneCreator().refreshPaneCenter(hasToolBar);
    }

    public static void systemToArabic(IHasToolBar hasToolBar) {
        POSGeneralSettings.setProperty((String)"defaultlang", (String)Language.Arabic.toString());
        POSResourcesUtil.setOrientation(NodeOrientation.RIGHT_TO_LEFT);
        hasToolBar.fetchPaneCreator().refreshPaneCenter(hasToolBar);
    }

    public static void deleteOldImg(UUID id) {
        try {
            File folder = new File(POSGeneralSettings.getImagesFolderPath());
            if (!folder.exists()) {
                return;
            }
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile() || !listOfFiles[i].getName().startsWith(String.valueOf(id))) continue;
                listOfFiles[i].delete();
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static void cacheRegisterConfigFields() {
        POSResourcesUtil.updateConfigFavouriteItems();
        POSUISettingsUtil.cacheUISettings();
    }

    public static List<POSLiteMasterFile> getCachedFavourites(Pair<List<UUID>, Boolean> ids) {
        CachedFavouritesObject cachedFavouritesObject = cachedFavourites.get(ids);
        if (cachedFavouritesObject == null) {
            return null;
        }
        POSResourcesUtil.updatePosCachedObjDate(cachedFavouritesObject);
        return cachedFavouritesObject.getFiles();
    }

    public static void updatePosCachedObjDate(IPOSCachedObject cachedObject) {
        cachedObject.setLastUsageDate(new Date());
    }

    public static void addCachedFavourites(Pair<List<UUID>, Boolean> ids, List<POSLiteMasterFile> posMasterFiles, Boolean hasNoChildren) {
        CachedFavouritesObject cachedFavouritesObject = cachedFavourites.get(ids);
        if (cachedFavouritesObject == null) {
            cachedFavouritesObject = new CachedFavouritesObject();
            cachedFavourites.put(ids, cachedFavouritesObject);
        }
        if (posMasterFiles != null) {
            cachedFavouritesObject.setFiles(posMasterFiles);
        }
        if (hasNoChildren != null) {
            cachedFavouritesObject.setHasChildren(hasNoChildren);
        }
        POSResourcesUtil.clearSomeCachedObjectsIfNeeded();
    }

    public static <T extends IPOSCachedObject> void clearSomeCachedObjectsIfNeeded() {
        int i;
        String maxCacheSizeProp = POSGeneralSettings.getProperty((String)"maxCacheSize");
        String cacheClearCountProp = POSGeneralSettings.getProperty((String)"cacheClearCount");
        if (ObjectChecker.isEmptyOrNull((Object)maxCacheSizeProp)) {
            return;
        }
        Integer maxCacheSize = ObjectChecker.tryParseInt((String)maxCacheSizeProp);
        if (ObjectChecker.isEmptyOrZero((Integer)maxCacheSize) || maxCacheSize < 0) {
            return;
        }
        Integer cacheClearCount = ObjectChecker.tryParseInt((String)cacheClearCountProp);
        if (ObjectChecker.isEmptyOrZero((Integer)cacheClearCount) || cacheClearCount > maxCacheSize) {
            cacheClearCount = maxCacheSize / 4;
        }
        if (cachedFavourites.size() > maxCacheSize) {
            ArrayList<Pair<List<UUID>, Boolean>> favKeys = new ArrayList<Pair<List<UUID>, Boolean>>(cachedFavourites.keySet());
            for (i = favKeys.size() - 1; i >= maxCacheSize - cacheClearCount; --i) {
                cachedFavourites.remove(favKeys.get(i));
            }
        }
        if (POSPricesCachingUtil.priceEntries.size() > maxCacheSize) {
            ArrayList<String> pricesKeys = new ArrayList<String>(POSPricesCachingUtil.priceEntries.keySet());
            for (i = pricesKeys.size() - 1; i >= maxCacheSize - cacheClearCount; --i) {
                POSPricesCachingUtil.priceEntries.remove(pricesKeys.get(i));
            }
        }
    }

    private static int favouritesAndPricesCacheCount() {
        return ObjectChecker.toZeroIfNull((Integer)cachedFavourites.size()) + ObjectChecker.toZeroIfNull((Integer)POSPricesCachingUtil.priceEntries.size());
    }

    public static Boolean getCachedFavouritesWithChildren(Pair<List<UUID>, Boolean> ids) {
        CachedFavouritesObject cachedFavouritesObject = cachedFavourites.get(ids);
        if (cachedFavouritesObject == null) {
            return null;
        }
        POSResourcesUtil.updatePosCachedObjDate(cachedFavouritesObject);
        return cachedFavouritesObject.getHasChildren();
    }

    public static void clearCachedFavourites() {
        cachedFavourites.clear();
    }

    public static void clearAdditionalItemsMap() {
        additionalItemsMap = null;
    }

    private static void fillAdditionalItemsMap() {
        if (additionalItemsMap != null) {
            return;
        }
        additionalItemsMap = new HashMap();
        List<PosItemAdditionalItems> additionalItems = POSPersister.listAll(PosItemAdditionalItems.class);
        if (ObjectChecker.isEmptyOrNull(additionalItems)) {
            return;
        }
        for (PosItemAdditionalItems addItems : additionalItems) {
            addItems.getAdditionalItems1().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems2().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems3().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems4().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems5().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems6().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems7().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems8().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems9().forEach(l -> l.setAddItems(null));
            addItems.getAdditionalItems10().forEach(l -> l.setAddItems(null));
            additionalItemsMap.put(MultiKeyHash.of((Object[])new Object[]{addItems.getBasicItemID(), addItems.getBasicItemType()}), addItems);
        }
    }

    public static PosItemAdditionalItems fetchAdditionalItemsForItem(POSItem item) {
        POSResourcesUtil.fillAdditionalItemsMap();
        return (PosItemAdditionalItems)ObjectChecker.getFirstNotNullObj((Object[])new PosItemAdditionalItems[]{additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.getId(), item.calcNamaEntityType()})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchSectionId(), "ItemSection"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass1Id(), "ItemClass1"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass2Id(), "ItemClass2"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass3Id(), "ItemClass3"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass4Id(), "ItemClass4"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass5Id(), "ItemClass5"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass6Id(), "ItemClass6"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass7Id(), "ItemClass7"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass8Id(), "ItemClass8"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass9Id(), "ItemClass9"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{item.fetchClass10Id(), "ItemClass10"})), additionalItemsMap.get(MultiKeyHash.of((Object[])new Object[]{null, null}))});
    }

    public static List<POSDepreciationReason> fetchDepreciationReasons() {
        if (ObjectChecker.isEmptyOrNull(cachedDepreciationReasons)) {
            cachedDepreciationReasons = POSPersister.listAll(POSDepreciationReason.class);
        }
        return cachedDepreciationReasons;
    }

    public static void clearDepreciationReasons() {
        cachedDepreciationReasons = null;
    }

    public static void updateDocDateAndTime(IPOSHasDateAndTime doc) {
        Date valueDate = doc.fetchDate();
        Date valueTime = doc.fetchTime();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)POSResourcesUtil.fetchPOSConfig().getLastShiftClosingHour()) && valueTime.getHours() < POSResourcesUtil.fetchPOSConfig().getLastShiftClosingHour().intValue()) {
            valueDate.setDate(valueDate.getDate() - 1);
            valueTime.setHours(23);
            valueTime.setMinutes(59);
        }
        doc.updateDate(valueDate);
        doc.updateTime(valueTime);
    }

    public static Image loadImageFromResources(String s) {
        return POSResourcesUtil.loadImageFromResources(s, 0.0, 0.0, false, false);
    }

    public static Image loadImageFromResources(String s, double requestedWidth, double requestedHeight, boolean preserveRatio, boolean smooth) {
        Image image;
        block8: {
            InputStream stream = POSResourcesUtil.class.getClassLoader().getResourceAsStream(s);
            try {
                image = new Image(stream, requestedWidth, requestedHeight, preserveRatio, smooth);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return image;
    }

    public static void cacheFieldsAllowedValues() {
        List<PosFieldAllowedValues> list = POSPersister.listAll(PosFieldAllowedValues.class);
        fieldAllowedValues = list.stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getAllowedValues())).collect(Collectors.toList());
    }

    public static String readFieldsAllowedValues(String forType, String fieldId) {
        PosFieldAllowedValues cachedAllowedValues = fieldAllowedValues.stream().filter(f -> f.matches(forType, fieldId)).findFirst().orElse(null);
        if (cachedAllowedValues != null) {
            return cachedAllowedValues.getAllowedValues();
        }
        DTOFieldAllowedValuesReq req = new DTOFieldAllowedValuesReq();
        req.setEntityType(forType);
        req.setFieldId(fieldId);
        GetResult<String> result = POSWSClient.instance.readFieldAllowedValues((SendRequest<DTOFieldAllowedValuesReq>)new SendRequest((Object)req));
        String allowedValuesRes = (String)result.getData();
        PosFieldAllowedValues allowedValues = new PosFieldAllowedValues();
        allowedValues.setEntityType(forType);
        allowedValues.setFieldId(fieldId);
        allowedValues.setAllowedValues(allowedValuesRes);
        POSPersister.saveOrUpdate(allowedValues);
        fieldAllowedValues.add(allowedValues);
        return allowedValuesRes;
    }

    public static PosTableEntry fetchTableBusyEntry(POSTable table) {
        List<?> entriesForTable = POSPersister.listAll(PosTableEntry.class, " where posTable=:table", POSPersister.params("table", table), "");
        PosTableEntry busyEntry = entriesForTable.stream().filter(PosTableEntry::getBusyTable).findFirst().orElse(null);
        return busyEntry;
    }

    public static PosTableEntry fetchTableReservedEntry(POSTable table, Date fromTime, Date toTime) {
        List<PosTableEntry> entriesForTable = POSPersister.listAll(PosTableEntry.class, " where posTable=:table", POSPersister.params("table", table), "");
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{fromTime, toTime})) {
            return entriesForTable.stream().filter(e -> POSResourcesUtil.reservedNow(e)).findFirst().orElse(null);
        }
        return POSResourcesUtil.reservedFromTimeToTime(fromTime, toTime, entriesForTable);
    }

    private static PosTableEntry reservedFromTimeToTime(Date fromTime, Date toTime, List<PosTableEntry> entriesForTable) {
        for (PosTableEntry entry : entriesForTable) {
            Date entryToTime;
            Date entryFromTime = entry.getReservationFrom();
            boolean isReserved = LocalDateUtils.areDatesOverLapping((Date)fromTime, (Date)toTime, (Date)entryFromTime, (Date)(entryToTime = entry.getReservationTo())) || DateFieldUtils.isDateBetweenIgnoringNull((Date)toTime, (Date)entryFromTime, (Date)entryToTime);
            if (!isReserved) continue;
            return entry;
        }
        return null;
    }

    private static boolean reservedNow(PosTableEntry e) {
        Date reservationTo;
        Date reservationFrom = e.getReservationFrom();
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{reservationFrom, reservationTo = e.getReservationTo()})) {
            return false;
        }
        LocalDateTime reservationFromDateTime = LocalDateUtils.dateToLocalDateTime((Date)reservationFrom);
        LocalDateTime reservationToDateTime = LocalDateUtils.dateToLocalDateTime((Date)reservationTo);
        LocalDateTime now = LocalDateTime.now();
        boolean fromBeforeOrEqualsNow = reservationFromDateTime.isBefore(now) || reservationFromDateTime.equals(now);
        boolean toAfterOrEqualsNow = reservationToDateTime.isAfter(now) || reservationToDateTime.equals(now);
        return fromBeforeOrEqualsNow && toAfterOrEqualsNow;
    }

    public static void removeItemFromTaxPlanCache(UUID id) {
        itemsTaxPlans.remove(id);
    }

    public static Stage fetchCurrentScreenStage() {
        if (currentScreen == null) {
            return null;
        }
        return currentScreen.fetchStage();
    }

    public static void alignLabels(Node ... nodes) {
        for (Node node : nodes) {
            GridPane.setHalignment((Node)node, (HPos)(POSResourcesUtil.isArabic() ? HPos.RIGHT : HPos.LEFT));
        }
    }

    public static boolean checkIfNewHSErrFilesExist() {
        File directory = new File("");
        File[] files = directory.listFiles();
        long yesterday = System.currentTimeMillis() - 0x6DDD000L;
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().startsWith("hs_err_pid") || file.lastModified() <= yesterday) continue;
                NaMaLogger.info((Object)("Found file: " + file.getName()));
                return true;
            }
        }
        return false;
    }

    static {
        showIds = false;
        methods = new ArrayList<POSPaymentMethod>();
        halls = new ArrayList<POSHall>();
        tables = new ArrayList<POSTable>();
        currencies = new ArrayList<POSCurrency>();
        fieldAllowedValues = new ArrayList<PosFieldAllowedValues>();
        valuesUpdaterHashMap = new HashMap();
        cachedFavourites = new HashMap();
        cachedDepreciationReasons = new ArrayList<POSDepreciationReason>();
        uncaughtExceptionsHandler = (t, e) -> {
            POSResourcesUtil.checkIfIncompatibleVersionWithNama(e);
            NaMaLogger.error((Throwable)e);
        };
        lastScreensDocs = new HashMap();
        additionalItemsMap = null;
        pgwMethods = new ArrayList<POSPaymentMethod>();
        favouriteItems = new ArrayList<POSFavouriteLine>();
        registeryCache = new HashMap<String, Optional<POSRegistery>>();
        extraFilters = null;
        paymentMethodsSettings = null;
        entityTypeByClass = new ConcurrentHashMap<Class, String>();
        posShiftCodeLength = new HashMap<String, Integer>();
        dtoGlobalConfig = null;
        configTaxPlan = null;
        itemsTaxPlans = new ConcurrentHashMap();
        _yyyymmdd = DateTimeFormatter.ofPattern("yyyyMMdd");
    }
}

