/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Matcher;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.CashDenominationsBox;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosFileChooser;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFieldInfo;
import com.namasoft.pos.application.IPOSShiftScreen;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSNewShiftsScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosEntryPoint;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.POSIdleMonitor;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSShiftInventoryService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class POSShiftInventoryScreen
implements IHasToolBar,
IPOSShiftScreen {
    public static final int COLUMNS_COUNT = 6;
    private NamaText dateLabel;
    private NamaTextField dateTextField;
    private NamaText registeryLabel;
    private NamaSearchBox registeryCodeTextField;
    private NamaText shiftCode;
    private NamaLabel codeLabel;
    private NamaText time;
    private NamaTextField timeTextField;
    private TableView<AbsPOSInventoryLine> table = new TableView();
    private static Stage stage;
    private static PosScene scene;
    private ObservableList<AbsPOSInventoryLine> list = FXCollections.observableArrayList();
    private NamaButton noBtn;
    protected NamaButton okBtn;
    private AbsPOSShiftInventory shiftOrInventory;
    private boolean shift;
    private NamaBorderPane pane;
    private NamaTextField remarksField;
    private NamaLabel remarksLabel;
    protected POSIdleMonitor idleMonitor;
    private NamaButton analyzeCash;
    private NamaLabel currentShiftCashAmount = new NamaLabel();
    private NamaLabel oldShiftsCashAmount = new NamaLabel();
    private final BorderPaneCreator borderPaneCreator = new BorderPaneCreator();
    private HashMap<String, IPOSFieldInfo> map = new HashMap();
    protected NamaLabel attach1Label;
    protected NamaLabel attach2Label;
    protected PosFileChooser attach1;
    protected PosFileChooser attach2;
    protected NamaLabel totalAccountantLabel;
    protected NamaLabel totalActualLabel;
    protected NamaLabel totalDiffLabel;
    protected NamaTextField totalAccountant;
    protected NamaTextField totalActual;
    protected NamaTextField totalDiff;
    private CashDenominationsBox denominationsBox;
    private Map<String, Consumer<BigDecimal>> denominationChangeListenersMap;

    @Override
    public NamaLabel getCurrentShiftCashAmount() {
        return this.currentShiftCashAmount;
    }

    @Override
    public NamaLabel getOldShiftsCashAmount() {
        return this.oldShiftsCashAmount;
    }

    public POSShiftInventoryScreen() {
        PosEntryPoint.lastScreen = this;
    }

    private void defineFields() {
        POSShiftOpen lastShift;
        this.map.put("registery", new IPOSFieldInfo(){

            @Override
            public void update(AbsPOSSales posSales) {
            }

            @Override
            public String namaField() {
                return "registery";
            }

            @Override
            public String posFieldValue() {
                POSRegistery register = POSPersister.findByID(POSRegistery.class, POSShiftInventoryScreen.this.registeryCodeTextField.getIdBox().getText());
                if (ObjectChecker.isNotEmptyOrNull((Object)register)) {
                    return register.getId().toString();
                }
                return "";
            }
        });
        this.remarksField = new NamaTextField(POSFieldType.Text, this, "remarks");
        this.dateLabel = new NamaText("EditingDate", new Object[0]);
        this.registeryLabel = new NamaText("MachineCode", new Object[0]);
        this.remarksLabel = new NamaLabel("remarks");
        POSRegistery registery = POSResourcesUtil.fetchMainRegister();
        this.registeryCodeTextField = new NamaSearchBox(POSRegistery.class, this, "registery", stage);
        this.registeryCodeTextField.getCodeBox().setEditable(false);
        this.registeryCodeTextField.getNameBox().setEditable(false);
        this.shiftCode = new NamaText("code", new Object[0]);
        this.codeLabel = new NamaLabel();
        this.codeLabel.setDisable(true);
        this.okBtn = new NamaButton("Ok");
        this.okBtn.setId("btn");
        this.noBtn = new NamaButton("No");
        this.noBtn.setId("btn");
        this.analyzeCash = new NamaButton("Analyze Cash Amount");
        this.analyzeCash.setId("btn");
        this.analyzeCash.setOnAction(event -> POSShiftInventoryScreen.cashAnalysisAction(this));
        this.attach1Label = new NamaLabel("Attachment1");
        this.attach2Label = new NamaLabel("Attachment2");
        this.attach1 = new PosFileChooser(stage, p -> this.shiftOrInventory.setAttach1FilePath((String)p));
        this.attach2 = new PosFileChooser(stage, p -> this.shiftOrInventory.setAttach2FilePath((String)p));
        this.attach1.reset();
        this.attach2.reset();
        this.totalAccountantLabel = new NamaLabel("totalAcc");
        this.totalActualLabel = new NamaLabel("totalActual");
        this.totalDiffLabel = new NamaLabel("totalDiff");
        this.totalAccountant = new NamaTextField();
        this.totalAccountant.setEditable(false);
        this.totalDiff = new NamaTextField();
        this.totalDiff.setEditable(false);
        this.totalActual = new NamaTextField();
        this.totalActual.setEditable(false);
        this.dateTextField = new NamaTextField(POSFieldType.Date, this, "valueDate");
        this.dateTextField.setEditable(false);
        this.time = this.isShift() ? (ObjectChecker.isEmptyOrNull((Object)(lastShift = POSResourcesUtil.fetchLastOpenShift(registery))) ? new NamaText("openShiftTime", new Object[0]) : new NamaText("closeShiftTime", new Object[0])) : new NamaText("CashCountTime", new Object[0]);
        this.timeTextField = new NamaTextField(POSFieldType.Time, null, null);
        this.timeTextField.setEditable(false);
        this.updateDetails();
        this.noBtn.setOnAction(event -> PosScene.drawSalesScreen(stage));
        this.okBtn.setOnAction(event -> POSShiftInventoryScreen.okAction(this, false, stage));
        stage.setOnCloseRequest(e -> PosScene.onCloseRequestEvent(event -> PosScene.terminateAction(this, stage, event), e));
    }

    private void updateDetails() {
        POSRegistery registery = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isNotEmptyOrNull((Object)registery)) {
            this.registeryCodeTextField.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)registery.getId()));
            this.registeryCodeTextField.getCodeBox().setText(registery.getCode());
            this.registeryCodeTextField.getNameBox().setText(registery.nameByLanguage());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String[] dataAndTime = dateFormat.format(date).split(" ");
        this.dateTextField.setText(dataAndTime[0]);
        this.timeTextField.setText(dataAndTime[1]);
        if (this.shift) {
            this.shiftOrInventory = POSResourcesUtil.fetchLastOpenShift(registery);
            if (ObjectChecker.isNotEmptyOrNull((Object)this.shiftOrInventory) && ObjectChecker.isNotEmptyOrNull((Object)this.shiftOrInventory.getCode())) {
                this.codeLabel.setText(this.shiftOrInventory.getCode());
                if (ObjectChecker.isNotEmptyOrNull((Object)this.shiftOrInventory.getRegistery())) {
                    this.registeryCodeTextField.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)this.shiftOrInventory.getRegistery().getId()));
                    this.registeryCodeTextField.getCodeBox().setText(this.shiftOrInventory.getRegistery().getCode());
                    this.registeryCodeTextField.getNameBox().setText(this.shiftOrInventory.getRegistery().nameByLanguage());
                }
                Date shiftDate = new Date();
                this.dateTextField.setText(shiftDate.toString().substring(0, 10));
                this.shiftOrInventory = new POSShiftClose();
            } else {
                this.codeLabel.setText(POSCodeGenerator.generateShiftCode());
                this.shiftOrInventory = new POSShiftOpen();
            }
        } else {
            this.codeLabel.setText(POSCodeGenerator.generateInventoryCode());
            this.shiftOrInventory = new POSInventory(this.codeLabel.getText(), new Date(this.dateTextField.getText()), this.timeTextField.getText(), this.registeryCodeTextField.getCodeBox().getText());
        }
        this.shiftOrInventory.setView(this);
        ObservableList totals = FXCollections.observableArrayList(POSPaymentMethodsUtil.calcShiftTotals(POSResourcesUtil.fetchMainRegister(), this.shiftOrInventory.createLine().getClass(), t -> this.currentShiftCashAmount.setText((String)t)));
        ArrayList<AbsPOSInventoryLine> firstList = new ArrayList<AbsPOSInventoryLine>((Collection<AbsPOSInventoryLine>)this.list);
        ArrayList secondList = new ArrayList(totals);
        ArrayList intersection = new ArrayList();
        CollectionsUtility.compareTwoLists(firstList, secondList, (Matcher)new Matcher<AbsPOSInventoryLine>(this){

            public boolean match(AbsPOSInventoryLine obj1, AbsPOSInventoryLine obj2) {
                return ObjectChecker.areEqual((Object)obj1.getPaymentMethodId(), (Object)obj2.getPaymentMethodId()) && ObjectChecker.areEqual((Object)obj1.getCurrencyId(), (Object)obj2.getCurrencyId()) && ObjectChecker.areEqual((Object)obj1.getAccountantRemaining(), (Object)obj2.getAccountantRemaining());
            }
        }, intersection, new ArrayList(), new ArrayList());
        if (ObjectChecker.areNotEqual((Object)totals.size(), (Object)intersection.size())) {
            this.list.clear();
            this.list.addAll((Collection)totals);
            this.shiftOrInventory.updateDetails((List<AbsPOSInventoryLine>)totals);
            if (this.shiftOrInventory instanceof POSShiftClose) {
                this.updateDenominationsBoxIfNeeded();
            }
        }
    }

    private void updateDenominationsBoxIfNeeded() {
        if (this.denominationsBox == null) {
            return;
        }
        this.table = this.creatCurrentStateTable();
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            AbsPOSInventoryLine line = (AbsPOSInventoryLine)this.table.getItems().get(i);
            this.denominationChangeListenersMap.put(line.getPaymentMethodName(), v -> this.applyAccountantEffect(line, (BigDecimal)v));
        }
        this.denominationsBox.setDenominationChangeListenersMap(this.denominationChangeListenersMap);
    }

    @Override
    public void afterCachedScreenReDraw() {
        this.updateDetails();
        if (this.denominationsBox != null) {
            this.denominationsBox.clear();
        }
        this.remarksField.clear();
        ((IPOSToolBar)this.borderPaneCreator.getToolBar()).updateInformation(null);
    }

    public static void cashAnalysisAction(IPOSShiftScreen shiftScreen) {
        NamaDialog dialog = new NamaDialog("Analyze Cash Amount");
        GridPane gridPane = new GridPane();
        gridPane.setVgap(7.0);
        gridPane.setHgap(30.0);
        gridPane.add((Node)new NamaLabel("currentShiftCashAmount"), 0, 0);
        gridPane.add((Node)shiftScreen.getCurrentShiftCashAmount(), 1, 0);
        gridPane.add((Node)new NamaLabel("oldShiftsCashAmount"), 0, 1);
        gridPane.add((Node)shiftScreen.getOldShiftsCashAmount(), 1, 1);
        BigDecimal currentCash = BigDecimal.ZERO;
        try {
            currentCash = NaMaMath.round((BigDecimal)new BigDecimal(shiftScreen.getCurrentShiftCashAmount().getText()), (Integer)POSMoneyUtils.displayDecimalPlaces);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        shiftScreen.getOldShiftsCashAmount().setText(POSShiftInventoryScreen.calcOldShiftsCash(currentCash, shiftScreen));
        dialog.content((Node)gridPane);
        dialog.addOkButton("");
        dialog.addCancelButton("");
        dialog.showAndWait();
    }

    private static String calcOldShiftsCash(BigDecimal currentShiftCash, IPOSShiftScreen shiftScreen) {
        for (AbsPOSInventoryLine l : shiftScreen.calcLines()) {
            if (!ObjectChecker.areEqual((Object)ServerStringUtils.toUUIDStr((Object)l.getPaymentMethodId()), (Object)ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchMainRegister().fetchCashMethodId()))) continue;
            BigDecimal total = NaMaMath.round((BigDecimal)l.getAccountantRemaining().subtract(currentShiftCash), (Integer)POSMoneyUtils.displayDecimalPlaces);
            return String.valueOf(NaMaMath.probableZero((BigDecimal)total) ? BigDecimal.ZERO : total);
        }
        return "";
    }

    @Override
    public List<AbsPOSInventoryLine> calcLines() {
        return this.table.getItems();
    }

    @Override
    public String getCode() {
        return this.codeLabel.getText();
    }

    @Override
    public NamaSearchBox getRegisteryCodeTextField() {
        return this.registeryCodeTextField;
    }

    @Override
    public TextArea getRemarksField() {
        return null;
    }

    public static <T extends IPOSShiftScreen & IHasToolBar> void okAction(T screen, boolean byShortcut, Stage stage) {
        if (byShortcut && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getPreventSavingShiftByShortcut())) {
            return;
        }
        List<AbsPOSInventoryLine> shiftLines = screen.calcLines();
        shiftLines.set(0, shiftLines.get(0));
        POSShiftInventoryService.POSCreateShiftRequest request = new POSShiftInventoryService.POSCreateShiftRequest(screen);
        POSResult result = new POSResult();
        POSShiftInventoryService.saveShift(request, result);
        if (result.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(result, stage);
        } else {
            POSShiftInventoryScreen.printFormAndDrawSales(screen.getShiftOrInventory(), screen.isShiftClosing(), stage);
        }
    }

    private static void printFormAndDrawSales(AbsPOSShiftInventory shiftOrInventory, boolean isShiftClose, Stage stage) {
        if (isShiftClose && POSSecurityUtil.userCan(POSSecurityCapability.CanPrintShiftClosing).isFailed().booleanValue()) {
            PosScene.drawSalesScreen(stage);
        } else {
            POSReportDefinition.printForm(POSResourcesUtil.fetchMainRegister(), shiftOrInventory, (Callback<Void>)((Callback)c -> Platform.runLater(() -> PosScene.drawSalesScreen(stage))));
        }
    }

    @Override
    public void draw(Stage primStage, boolean shift) {
        try {
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getStartWithNewShiftUI())) {
                new POSNewShiftsScreen().draw(primStage, shift);
                return;
            }
            stage = primStage;
            this.setShift(shift);
            this.pane = this.borderPaneCreator.createBorderPane(this);
            scene = new PosScene((Parent)this.pane, stage.getWidth(), stage.getHeight(), this, stage);
            scene.setOnKeyPressed(e -> {
                if (ObjectChecker.areEqual((Object)e.getCode(), (Object)KeyCode.F2)) {
                    POSShiftInventoryScreen.okAction(this, true, stage);
                }
            });
            PosScene.monitorIdleness(this);
            stage.setScene((Scene)scene);
            scene.setNodeOrientation(POSResourcesUtil.getOrientation());
            this.pane.autosize();
        }
        catch (Exception es) {
            NaMaLogger.error((Throwable)es);
        }
    }

    private NamaVBox createShiftScreen(Stage primaryStage) {
        stage = primaryStage;
        this.defineFields();
        NamaVBox allScreenLayout = new NamaVBox(10);
        NamaVBox firstSid = new NamaVBox(10);
        NamaVBox secondSide = new NamaVBox();
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.Arabic)) {
            secondSide.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        }
        NamaVBox thirdSide = new NamaVBox();
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        this.drawFieldsUsingColumnsAndRows(grid);
        Platform.runLater(() -> this.codeLabel.requestFocus());
        NamaHBox box = new NamaHBox(30);
        NamaButton openDocBtn = new NamaButton();
        openDocBtn.setTooltip(new POSTooltip("showDocument"));
        openDocBtn.setSVGIcon("select.svg");
        openDocBtn.setOnAction(e -> {
            if (POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanOpenOldInvoice).isFailed().booleanValue()) {
                return;
            }
            NamaSearchBox openDocSearch = new NamaSearchBox(this.shiftOrInventory.getClass(), (IHasToolBar)this, "", stage, true, true);
            openDocSearch.getSearchBtn().fire();
        });
        box.getChildren().addAll((Object[])new Node[]{openDocBtn, this.okBtn, this.noBtn});
        box.setAlignment(Pos.CENTER);
        HBox remarksHBox = new HBox();
        remarksHBox.setPadding(new Insets(0.0, 105.0, 0.0, 105.0));
        this.remarksField.setPrefWidth(stage.getWidth() / 1.2);
        remarksHBox.getChildren().addAll((Object[])new Node[]{this.remarksLabel, this.remarksField});
        firstSid.getChildren().addAll((Object[])new Node[]{grid, remarksHBox});
        firstSid.setAlignment(Pos.CENTER);
        secondSide.setAlignment(Pos.CENTER);
        thirdSide.getChildren().addAll((Object[])new Node[]{box});
        thirdSide.setAlignment(Pos.BOTTOM_CENTER);
        allScreenLayout.setPrefHeight(primaryStage.getHeight() - 160.0);
        allScreenLayout.setPrefWidth(primaryStage.getWidth());
        allScreenLayout.getChildren().add((Object)firstSid);
        this.table = this.creatCurrentStateTable();
        if (this.shiftOrInventory instanceof POSShiftClose) {
            this.denominationChangeListenersMap = new HashMap<String, Consumer<BigDecimal>>();
            for (int i = 0; i < this.table.getItems().size(); ++i) {
                AbsPOSInventoryLine line = (AbsPOSInventoryLine)this.table.getItems().get(i);
                this.denominationChangeListenersMap.put(line.getPaymentMethodName(), v -> this.applyAccountantEffect(line, (BigDecimal)v));
            }
            this.denominationsBox = new CashDenominationsBox(stage, this, this.denominationChangeListenersMap);
            allScreenLayout.getChildren().add((Object)this.denominationsBox);
        }
        allScreenLayout.getChildren().addAll((Object[])new Node[]{secondSide, thirdSide});
        this.addClickEventRecursivley((Node)allScreenLayout);
        secondSide.getChildren().add(this.table);
        POSSettingsUtil.setFonts(20.0, this.getClass().getClassLoader(), new Node[]{this.okBtn, this.noBtn});
        return allScreenLayout;
    }

    private void addClickEventRecursivley(Node node) {
        node.setOnMouseClicked(event -> this.table.getItems().set(0, (Object)((AbsPOSInventoryLine)this.table.getItems().get(0))));
        if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                this.addClickEventRecursivley(child);
            }
        }
    }

    public TableView<AbsPOSInventoryLine> creatCurrentStateTable() {
        if (ObjectChecker.isEmptyOrNull(this.list)) {
            this.list.add((Object)this.shiftOrInventory.createLine());
        }
        this.table = new TableView();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.table = new TableView();
        this.table.setPrefWidth(primaryScreenBounds.getWidth());
        this.table.setPrefHeight(primaryScreenBounds.getHeight() / 2.0);
        POSTableColumn paymentWayCol = new POSTableColumn("paymentWay");
        paymentWayCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("paymentWay"));
        paymentWayCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        paymentWayCol.setCellFactory(POSTableCell.defaultCellFactory());
        paymentWayCol.setEditable(false);
        POSTableColumn currencyCol = new POSTableColumn("currency");
        currencyCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("currency"));
        currencyCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        currencyCol.setCellFactory(POSTableCell.defaultCellFactory());
        POSTableColumn actualRemainingCol = new POSTableColumn("actualRemaining");
        actualRemainingCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        actualRemainingCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("actualRemaining"));
        actualRemainingCol.setEditable(true);
        actualRemainingCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        actualRemainingCol.setOnEditCommit(t -> this.applyAccountantEffect((TableColumn.CellEditEvent<AbsPOSInventoryLine, BigDecimal>)t));
        POSTableColumn accountantRemainingCol = new POSTableColumn(" accountantRemaining");
        accountantRemainingCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        accountantRemainingCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        accountantRemainingCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("accountantRemaining"));
        accountantRemainingCol.setEditable(false);
        POSTableColumn diffCol = new POSTableColumn(" difference");
        diffCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        diffCol.setCellFactory(POSTableCell.stringBigDecimalConverter());
        diffCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("difference"));
        diffCol.setEditable(false);
        this.table.getColumns().addAll((Object[])new TableColumn[]{paymentWayCol, currencyCol});
        POSResult userCanViewAccountant = POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant);
        if (!userCanViewAccountant.isFailed().booleanValue()) {
            this.table.getColumns().addAll((Object[])new TableColumn[]{accountantRemainingCol});
        }
        this.table.getColumns().addAll((Object[])new TableColumn[]{actualRemainingCol});
        if (!userCanViewAccountant.isFailed().booleanValue()) {
            this.table.getColumns().add(diffCol);
        }
        POSTableColumn narrationCol = new POSTableColumn(" narration");
        narrationCol.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        narrationCol.setEditable(true);
        narrationCol.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("narration"));
        narrationCol.setCellFactory(POSTableCell.defaultCellFactory());
        narrationCol.setOnEditCommit(e -> {
            int row = e.getTablePosition().getRow();
            ((AbsPOSInventoryLine)e.getTableView().getItems().get(row)).setNarration((String)e.getNewValue());
        });
        POSTableColumn narration2Col = new POSTableColumn(" narration2");
        narration2Col.setPrefWidth(primaryScreenBounds.getWidth() / 6.0);
        narration2Col.setEditable(true);
        narration2Col.setCellValueFactory((javafx.util.Callback)new PropertyValueFactory("narration2"));
        narration2Col.setCellFactory(POSTableCell.defaultCellFactory());
        narration2Col.setOnEditCommit(e -> {
            int row = e.getTablePosition().getRow();
            ((AbsPOSInventoryLine)e.getTableView().getItems().get(row)).setNarration2((String)e.getNewValue());
        });
        this.table.getColumns().addAll((Object[])new TableColumn[]{narrationCol, narration2Col});
        this.table.setItems(this.list);
        this.updateSumFields();
        this.table.setEditable(true);
        this.table.setId("mytable");
        int nonDebitLineIndex = IntStream.range(0, this.list.size()).filter(i -> ObjectChecker.isFalseOrNull((Boolean)((AbsPOSInventoryLine)this.list.get(i)).isDebit())).findFirst().orElse(0);
        this.table.getSelectionModel().select(nonDebitLineIndex);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        return this.table;
    }

    private void applyAccountantEffect(TableColumn.CellEditEvent<AbsPOSInventoryLine, BigDecimal> t) {
        try {
            TablePosition tablePosition = t.getTablePosition();
            if (ObjectChecker.isEmptyOrNull((Object)tablePosition)) {
                return;
            }
            this.applyAccountantEffect((AbsPOSInventoryLine)this.table.getItems().get(tablePosition.getRow()), (BigDecimal)t.getNewValue());
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private void applyAccountantEffect(AbsPOSInventoryLine selectedItem, BigDecimal newValue) {
        if (ObjectChecker.isEmptyOrNull((Object)selectedItem)) {
            return;
        }
        selectedItem.setActualRemaining(newValue);
        for (int i = this.table.getItems().size() - 1; i >= 0; --i) {
            AbsPOSInventoryLine line = (AbsPOSInventoryLine)this.table.getItems().get(i);
            this.updateLineValues(line.getActualRemaining(), line);
            AbsPOSInventoryLine shiftLine = this.shiftOrInventory.fetchDetails().get(i);
            shiftLine.setActualRemaining(line.getActualRemaining());
            shiftLine.setDifference(shiftLine.getActualRemaining().subtract(shiftLine.getAccountantRemaining()));
        }
        this.updateSumFields();
        this.table.refresh();
    }

    private void updateSumFields() {
        this.totalActual.setText(this.table.getItems().stream().map(AbsPOSInventoryLine::getActualRemaining).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        this.totalAccountant.setText(this.table.getItems().stream().map(AbsPOSInventoryLine::getAccountantRemaining).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
        this.totalDiff.setText(this.table.getItems().stream().map(AbsPOSInventoryLine::getDifference).map(ObjectChecker::toZeroIfNull).reduce(BigDecimal.ZERO, BigDecimal::add).toString());
    }

    private void updateLineValues(BigDecimal newValue, AbsPOSInventoryLine selectedItem) {
        if (ObjectChecker.isEmptyOrZero((BigDecimal)selectedItem.getAccountantRemaining())) {
            selectedItem.setAccountantRemaining(BigDecimal.ZERO);
        }
        if (ObjectChecker.isEmptyOrZero((BigDecimal)selectedItem.getActualRemaining())) {
            selectedItem.setActualRemaining(BigDecimal.ZERO);
        }
        selectedItem.setDifference(newValue.subtract(selectedItem.getAccountantRemaining()));
        this.shiftOrInventory.updateDetails((List<AbsPOSInventoryLine>)FXCollections.observableArrayList((Collection)this.table.getItems()));
    }

    public void refreshTable() {
        this.table.getItems().clear();
        this.table.setItems(FXCollections.observableArrayList(this.shiftOrInventory.fetchDetails()));
    }

    private void drawFieldsUsingColumnsAndRows(GridPane grid) {
        int rowIndex = 1;
        grid.add((Node)this.shiftCode, 10, rowIndex);
        grid.add((Node)this.codeLabel, 12, rowIndex);
        grid.add((Node)this.registeryLabel, 14, rowIndex);
        grid.add((Node)this.registeryCodeTextField, 16, rowIndex);
        grid.add((Node)this.dateLabel, 10, ++rowIndex);
        grid.add((Node)this.dateTextField, 12, rowIndex);
        grid.add((Node)this.time, 14, rowIndex);
        grid.add((Node)this.timeTextField, 16, rowIndex);
        grid.add((Node)this.attach1Label, 10, ++rowIndex);
        grid.add((Node)this.attach1, 12, rowIndex);
        grid.add((Node)this.attach2Label, 14, rowIndex);
        grid.add((Node)this.attach2, 16, rowIndex);
        POSResult userCanViewAccountant = POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant);
        if (this.isShift() && !userCanViewAccountant.isFailed().booleanValue() && ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister()))) {
            grid.add((Node)this.analyzeCash, 18, rowIndex);
        }
        grid.add((Node)this.totalActualLabel, 10, ++rowIndex);
        grid.add((Node)this.totalActual, 12, rowIndex);
        if (ObjectChecker.isTrue((Boolean)POSSecurityUtil.userCan(POSSecurityCapability.CanViewAccountant).isSucceeded())) {
            grid.add((Node)this.totalAccountantLabel, 14, rowIndex);
            grid.add((Node)this.totalAccountant, 16, rowIndex);
            grid.add((Node)this.totalDiffLabel, 18, rowIndex);
            grid.add((Node)this.totalDiff, 20, rowIndex);
        }
    }

    @Override
    public Node fetchPaneCenter() {
        return this.createShiftScreen(stage);
    }

    @Override
    public PosScene fetchScene() {
        return scene;
    }

    @Override
    public boolean isShift() {
        return this.shift;
    }

    public void setShift(boolean shift) {
        this.shift = shift;
    }

    @Override
    public AbsPOSShiftInventory getShiftOrInventory() {
        return this.shiftOrInventory;
    }

    public void setShiftOrInventory(AbsPOSShiftInventory shiftOrInventory) {
        this.shiftOrInventory = shiftOrInventory;
    }

    @Override
    public Stage fetchStage() {
        return stage;
    }

    @Override
    public NamaBorderPane fetchPane() {
        return this.pane;
    }

    public TableView<AbsPOSInventoryLine> getTable() {
        return this.table;
    }

    public void setTable(TableView<AbsPOSInventoryLine> table) {
        this.table = table;
    }

    @Override
    public String screenTitle() {
        if (this.shift) {
            POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister());
            if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
                return "openShift";
            }
            return "closeShift";
        }
        return "cashCount";
    }

    public NamaButton getNoBtn() {
        return this.noBtn;
    }

    public void setNoBtn(NamaButton noBtn) {
        this.noBtn = noBtn;
    }

    public NamaButton getOkBtn() {
        return this.okBtn;
    }

    public void setOkBtn(NamaButton okBtn) {
        this.okBtn = okBtn;
    }

    @Override
    public POSIdleMonitor fetchMonitor() {
        return this.idleMonitor;
    }

    @Override
    public String fetchScreenEntityType() {
        if (this.shift) {
            POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister());
            if (ObjectChecker.isEmptyOrNull((Object)lastShift)) {
                return "POSShiftOpening";
            }
            return "POSShiftClosing";
        }
        return "POSCashDrawer";
    }

    @Override
    public void doPostSaveAction() {
        PosScene.drawSalesScreen(stage);
    }

    @Override
    public TableView fetchScreenTable() {
        return this.table;
    }

    @Override
    public void escapeAction() {
        this.getNoBtn().fire();
    }

    @Override
    public void terminateAction(Stage stage, Event e) {
        if (this.getTable().getItems().size() > 0) {
            PosScene.continueOrCancelCheck(stage, e, this);
        }
    }

    @Override
    public HashMap<String, IPOSFieldInfo> fetchFieldsMap() {
        return this.map;
    }

    @Override
    public void fireOpenOldDocAction(POSMasterFile item, Event event) {
        AbsPOSShiftInventory selectedItem = (AbsPOSShiftInventory)item;
        if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem)) {
            this.shiftOrInventory = selectedItem;
            this.codeLabel.setText(selectedItem.getCode());
            this.dateTextField.setText(selectedItem.getShiftDate().toString());
            this.timeTextField.setText(selectedItem.getTime());
            this.registeryCodeTextField.getCodeBox().setText(selectedItem.getRegistery().getCode());
            this.registeryCodeTextField.getIdBox().setText(selectedItem.getRegistery().getId().toString());
            this.remarksField.setText(selectedItem.getRemarks());
            this.table.setItems(FXCollections.observableArrayList(selectedItem.fetchDetails()));
            this.updateSumFields();
            if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getAttach1FilePath())) {
                this.attach1.getFileNameField().setText(StringUtils.substringAfterLast((String)selectedItem.getAttach1FilePath(), (String)"_#_"));
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)selectedItem.getAttach2FilePath())) {
                this.attach2.getFileNameField().setText(StringUtils.substringAfterLast((String)selectedItem.getAttach2FilePath(), (String)"_#_"));
            }
        }
    }

    @Override
    public BorderPaneCreator fetchPaneCreator() {
        return this.borderPaneCreator;
    }

    public POSMasterFile document() {
        return this.shiftOrInventory;
    }

    @Override
    public POSDocumentType documentType() {
        if (this.isShift()) {
            if (ObjectChecker.isEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister()))) {
                return POSDocumentType.ShiftOpen;
            }
            return POSDocumentType.ShiftClose;
        }
        return POSDocumentType.CashCount;
    }
}

