/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.PosUISettings;
import com.namasoft.pos.domain.PosUISettingsOptions;
import com.namasoft.pos.domain.details.AbsPOSFieldLine;
import com.namasoft.pos.domain.details.POSOrderReservationGridLine;
import com.namasoft.pos.domain.details.POSOrderReservationMainLine;
import com.namasoft.pos.domain.details.POSRegisterGridLine;
import com.namasoft.pos.domain.details.POSRegisterMainLine;
import com.namasoft.pos.domain.details.POSReplacementGridLine;
import com.namasoft.pos.domain.details.POSReplacementMainLine;
import com.namasoft.pos.domain.details.POSReturnGridLine;
import com.namasoft.pos.domain.details.POSReturnMainLine;
import com.namasoft.pos.domain.details.POSTakingGridLine;
import com.namasoft.pos.domain.details.POSTakingMainLine;
import com.namasoft.pos.domain.details.POSTransferGridLine;
import com.namasoft.pos.domain.details.POSTransferMainLine;
import com.namasoft.pos.domain.details.POSUISettingsSearchDialogueConfigLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.valueobjects.PosUiBasicInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.stage.Screen;

public class POSUISettingsUtil {
    public static PosUISettings posUISettings;
    private static HashMap<POSDocumentType, PosUiBasicInfo> basicUIInfoForTypes;
    private static HashMap<POSDocumentType, List<String>> mainLinesForTypes;
    private static HashMap<POSDocumentType, List<String>> otherLinesForTypes;
    private static HashMap<POSDocumentType, List<? extends AbsPOSFieldLine>> gridLinesForTypes;

    public static PosUISettings getPosUISettings() {
        return posUISettings;
    }

    public static PosUISettingsOptions getPosUISettingsOptions() {
        return posUISettings.getUiSettingsOptions();
    }

    public static void cacheUISettings() {
        posUISettings = POSUISettingsUtil.fetchUISettings();
        POSUISettingsUtil.reset();
    }

    private static PosUISettings fetchUISettings() {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        if (posRegistery == null) {
            return null;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)posRegistery.getUiSettings())) {
            return POSPersister.findByID(PosUISettings.class, posRegistery.getUiSettings().getId());
        }
        EntityReferenceData uiSettings = POSResourcesUtil.fetchPOSConfig().getUiSettings();
        if (ObjectChecker.isNotEmptyOrNull((Object)uiSettings)) {
            return POSMasterFile.findPOSRef(PosUISettings.class, uiSettings);
        }
        return POSUISettingsUtil.createDefaultUISettings();
    }

    private static void reset() {
        basicUIInfoForTypes = new HashMap();
        mainLinesForTypes = new HashMap();
        otherLinesForTypes = new HashMap();
        gridLinesForTypes = new HashMap();
    }

    private static <T extends AbsPOSFieldLine> PosUISettings createDefaultUISettings() {
        PosUISettings posUISettings = new PosUISettings();
        PosUiBasicInfo basicInfo = new PosUiBasicInfo();
        basicInfo.setColsCountPerRow(2);
        basicInfo.setDoNotAddFavouritesPart(false);
        basicInfo.setFavouritePaneWidthPercent(new BigDecimal(25));
        posUISettings.setInvoiceBasicInfo(basicInfo);
        posUISettings.setReturnBasicInfo(basicInfo);
        posUISettings.setReplacementBasicInfo(basicInfo);
        posUISettings.setTransferBasicInfo(basicInfo);
        posUISettings.setShortfallsDocBasicInfo(basicInfo);
        posUISettings.setScrapDocBasicInfo(basicInfo);
        posUISettings.setTakingBasicInfo(basicInfo);
        posUISettings.setOrderReservationBasicInfo(basicInfo);
        ArrayList<POSRegisterMainLine> mainPageFields = new ArrayList<POSRegisterMainLine>();
        mainPageFields.addAll(Arrays.asList(new POSRegisterMainLine("Code"), new POSRegisterMainLine("Customer"), new POSRegisterMainLine("Currency"), new POSRegisterMainLine("SalesMan"), new POSRegisterMainLine("Warehouse"), new POSRegisterMainLine("TotalPrice"), new POSRegisterMainLine("ItemCode")));
        posUISettings.setMainPageFields(mainPageFields);
        posUISettings.setReturnMainFields(CollectionsUtility.convert(mainPageFields, object -> new POSReturnMainLine(object.getField())));
        posUISettings.setReplacementMainFields(CollectionsUtility.convert(mainPageFields, object -> new POSReplacementMainLine(object.getField())));
        posUISettings.setTransferMainFields(CollectionsUtility.convert(mainPageFields, object -> new POSTransferMainLine(object.getField())));
        posUISettings.setTakingMainFields(CollectionsUtility.convert(mainPageFields, object -> new POSTakingMainLine(object.getField())));
        posUISettings.setOrderReservationMainFields(CollectionsUtility.convert(mainPageFields, object -> new POSOrderReservationMainLine(object.getField())));
        ArrayList<POSRegisterGridLine> gridFields = new ArrayList<POSRegisterGridLine>();
        gridFields.addAll(Arrays.asList(new POSRegisterGridLine("LineNumber"), new POSRegisterGridLine("Select"), new POSRegisterGridLine("ItemCode"), new POSRegisterGridLine("Item"), new POSRegisterGridLine("Quantity"), new POSRegisterGridLine("UOM"), new POSRegisterGridLine("FreeItem"), new POSRegisterGridLine("UnitPrice"), new POSRegisterGridLine("TotalPrice"), new POSRegisterGridLine("NetPrice")));
        posUISettings.setSalesGridFields(gridFields);
        posUISettings.setReturnGridFields(CollectionsUtility.convert(gridFields, object -> new POSReturnGridLine(object.getField())));
        posUISettings.setReplacementGridFields(CollectionsUtility.convert(gridFields, object -> new POSReplacementGridLine(object.getField())));
        posUISettings.setTransferGridFields(CollectionsUtility.convert(gridFields, object -> new POSTransferGridLine(object.getField())));
        posUISettings.setTakingGridFields(CollectionsUtility.convert(gridFields, object -> new POSTakingGridLine(object.getField())));
        posUISettings.setOrderReservationGridFields(CollectionsUtility.convert(gridFields, object -> new POSOrderReservationGridLine(object.getField())));
        return posUISettings;
    }

    public static PosUiBasicInfo basicUIInfoForTypes(POSDocumentType documentType) {
        if (ObjectChecker.isEmptyOrNull((Object)posUISettings)) {
            return new PosUiBasicInfo();
        }
        if (ObjectChecker.isNotEmptyOrNull(basicUIInfoForTypes)) {
            return (PosUiBasicInfo)ObjectChecker.getFirstNotNullObj((Object[])new PosUiBasicInfo[]{basicUIInfoForTypes.get((Object)documentType), basicUIInfoForTypes.get((Object)POSDocumentType.Invoice)});
        }
        basicUIInfoForTypes.put(POSDocumentType.Invoice, POSUISettingsUtil.getPosUISettings().getInvoiceBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.Return, POSUISettingsUtil.getPosUISettings().getReturnBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.Replacement, POSUISettingsUtil.getPosUISettings().getReplacementBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.StockTransferReq, POSUISettingsUtil.getPosUISettings().getTransferBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.StockTakingDetails, POSUISettingsUtil.getPosUISettings().getTakingBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.POSOrderReservation, POSUISettingsUtil.getPosUISettings().getOrderReservationBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.POSCancelReservation, POSUISettingsUtil.getPosUISettings().getCanelReservationBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.POSStockReceipt, POSUISettingsUtil.getPosUISettings().getStockReceiptBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.ShortfallsDoc, POSUISettingsUtil.getPosUISettings().getShortfallsDocBasicInfo());
        basicUIInfoForTypes.put(POSDocumentType.ScrapDoc, POSUISettingsUtil.getPosUISettings().getScrapDocBasicInfo());
        return (PosUiBasicInfo)ObjectChecker.getFirstNotNullObj((Object[])new PosUiBasicInfo[]{basicUIInfoForTypes.get((Object)documentType), basicUIInfoForTypes.get((Object)POSDocumentType.Invoice), PosUiBasicInfo.empty()});
    }

    public static double favoritesWidthPercent(IHasToolBar hasToolBar) {
        PosUiBasicInfo posUiBasicInfo = POSUISettingsUtil.basicUIInfoForTypes(hasToolBar.documentType());
        BigDecimal favouritePaneWidthPercent = posUiBasicInfo.getFavouritePaneWidthPercent();
        return ObjectChecker.getFirstNotEmptyOrZero((BigDecimal[])new BigDecimal[]{favouritePaneWidthPercent, BigDecimal.valueOf(30L)}).intValue();
    }

    public static List<String> mainLinesForTypes(POSDocumentType documentType) {
        if (ObjectChecker.isNotEmptyOrNull(mainLinesForTypes)) {
            return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{mainLinesForTypes.get((Object)documentType), mainLinesForTypes.get((Object)POSDocumentType.Invoice)});
        }
        mainLinesForTypes.put(POSDocumentType.Invoice, POSUISettingsUtil.getPosUISettings().getMainPageFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.POSOrderReservation, POSUISettingsUtil.getPosUISettings().getMainPageFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.Return, POSUISettingsUtil.getPosUISettings().getReturnMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.Replacement, POSUISettingsUtil.getPosUISettings().getReplacementMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.StockTransferReq, POSUISettingsUtil.getPosUISettings().getTransferMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.StockTakingDetails, POSUISettingsUtil.getPosUISettings().getTakingMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.POSOrderReservation, POSUISettingsUtil.getPosUISettings().getOrderReservationMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.POSCancelReservation, POSUISettingsUtil.getPosUISettings().getCancelReservationMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.POSStockReceipt, POSUISettingsUtil.getPosUISettings().getStockReceiptMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.ShortfallsDoc, POSUISettingsUtil.getPosUISettings().getShortfallsDocMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        mainLinesForTypes.put(POSDocumentType.ScrapDoc, POSUISettingsUtil.getPosUISettings().getScrapDocMainFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{mainLinesForTypes.get((Object)documentType), mainLinesForTypes.get((Object)POSDocumentType.Invoice)});
    }

    public static List<String> otherLinesForTypes(POSDocumentType documentType) {
        if (ObjectChecker.isNotEmptyOrNull(otherLinesForTypes)) {
            return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{otherLinesForTypes.get((Object)documentType), otherLinesForTypes.get((Object)POSDocumentType.Invoice)});
        }
        otherLinesForTypes.put(POSDocumentType.Invoice, POSUISettingsUtil.getPosUISettings().getOtherPageFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.POSOrderReservation, POSUISettingsUtil.getPosUISettings().getOrderReservationOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.Return, POSUISettingsUtil.getPosUISettings().getReturnOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.Replacement, POSUISettingsUtil.getPosUISettings().getReplacementOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.StockTransferReq, POSUISettingsUtil.getPosUISettings().getTransferOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.StockTakingDetails, POSUISettingsUtil.getPosUISettings().getTakingOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.POSCancelReservation, POSUISettingsUtil.getPosUISettings().getCancelReservationOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.POSStockReceipt, POSUISettingsUtil.getPosUISettings().getStockReceiptOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.ShortfallsDoc, POSUISettingsUtil.getPosUISettings().getShortfallsDocOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        otherLinesForTypes.put(POSDocumentType.ScrapDoc, POSUISettingsUtil.getPosUISettings().getScrapDocOtherFields().stream().map(l -> l.getField()).collect(Collectors.toList()));
        return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{otherLinesForTypes.get((Object)documentType), otherLinesForTypes.get((Object)POSDocumentType.Invoice)});
    }

    public static List<? extends AbsPOSFieldLine> gridLinesForTypes(POSDocumentType documentType) {
        if (ObjectChecker.isNotEmptyOrNull(gridLinesForTypes)) {
            return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{gridLinesForTypes.get((Object)documentType), gridLinesForTypes.get((Object)POSDocumentType.Invoice)});
        }
        gridLinesForTypes.put(POSDocumentType.Invoice, POSUISettingsUtil.getPosUISettings().getSalesGridFields());
        gridLinesForTypes.put(POSDocumentType.POSOrderReservation, POSUISettingsUtil.getPosUISettings().getOrderReservationGridFields());
        gridLinesForTypes.put(POSDocumentType.Return, POSUISettingsUtil.getPosUISettings().getReturnGridFields());
        gridLinesForTypes.put(POSDocumentType.Replacement, POSUISettingsUtil.getPosUISettings().getReplacementGridFields());
        gridLinesForTypes.put(POSDocumentType.StockTransferReq, POSUISettingsUtil.getPosUISettings().getTransferGridFields());
        gridLinesForTypes.put(POSDocumentType.StockTakingDetails, POSUISettingsUtil.getPosUISettings().getTakingGridFields());
        gridLinesForTypes.put(POSDocumentType.POSCancelReservation, POSUISettingsUtil.getPosUISettings().getCancelReservationGridFields());
        gridLinesForTypes.put(POSDocumentType.POSStockReceipt, POSUISettingsUtil.getPosUISettings().getStockReceiptGridFields());
        gridLinesForTypes.put(POSDocumentType.ShortfallsDoc, POSUISettingsUtil.getPosUISettings().getShortfallsDocGridFields());
        gridLinesForTypes.put(POSDocumentType.ScrapDoc, POSUISettingsUtil.getPosUISettings().getScrapDocGridFields());
        return (List)ObjectChecker.getFirstNotNullObj((Object[])new List[]{gridLinesForTypes.get((Object)documentType), gridLinesForTypes.get((Object)POSDocumentType.Invoice)});
    }

    public static double favoritesWidth(IHasToolBar hasToolBar) {
        return POSUISettingsUtil.favoritesWidthPercent(hasToolBar) * POSNewSalesScreen.screenWidth() / 100.0;
    }

    public static boolean addSalesLineDecQty() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettings().getDoNotAddSalesLineDecQtyBtn());
    }

    public static boolean addSalesLineIncQty() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettings().getDoNotAddSalesLineIncQtyBtn());
    }

    public static boolean addSalesLineDuplQty() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettings().getDoNotAddSalesLineDuplBtn());
    }

    public static boolean addSalesLineRemoveQty() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettings().getDoNotAddSalesLineRemovelBtn());
    }

    public static boolean addSalesLineDepreciate() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return ObjectChecker.isFalseOrNull((Boolean)POSUISettingsUtil.getPosUISettings().getDoNotAddSalesLineDepreciateBtn());
    }

    public static boolean doNoAddSalesLineButtons() {
        if (ObjectChecker.isEmptyOrNull((Object)POSUISettingsUtil.getPosUISettings())) {
            return false;
        }
        return !POSUISettingsUtil.addSalesLineDecQty() && !POSUISettingsUtil.addSalesLineDuplQty() && !POSUISettingsUtil.addSalesLineIncQty() && !POSUISettingsUtil.addSalesLineRemoveQty() && !POSUISettingsUtil.addSalesLineDepreciate();
    }

    public static String fetchSortTypeFor(String namaEntityType) {
        POSUISettingsSearchDialogueConfigLine searchDialogueConfigLine = (POSUISettingsSearchDialogueConfigLine)CollectionsUtility.getFirstMatching(POSUISettingsUtil.getPosUISettings().getSearchDialogueConfigLines(), l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType));
        if (searchDialogueConfigLine == null) {
            return null;
        }
        return searchDialogueConfigLine.getSearchDialogSortType();
    }

    public static String fetchOrderByFieldFor(String namaEntityType) {
        POSUISettingsSearchDialogueConfigLine searchDialogueConfigLine = (POSUISettingsSearchDialogueConfigLine)CollectionsUtility.getFirstMatching(POSUISettingsUtil.getPosUISettings().getSearchDialogueConfigLines(), l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType));
        if (searchDialogueConfigLine == null) {
            return null;
        }
        return searchDialogueConfigLine.getSearchDialogOrderByField();
    }

    public static Integer fetchRecordsCountPerPageFor(String namaEntityType) {
        POSUISettingsSearchDialogueConfigLine searchDialogueConfigLine = (POSUISettingsSearchDialogueConfigLine)CollectionsUtility.getFirstMatching(POSUISettingsUtil.getPosUISettings().getSearchDialogueConfigLines(), l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType));
        if (searchDialogueConfigLine == null) {
            return null;
        }
        return searchDialogueConfigLine.getSearchDialogRecordsCountPerPage();
    }

    public static String fetchViewModificationMode(String namaEntityType) {
        POSUISettingsSearchDialogueConfigLine searchDialogueConfigLine = (POSUISettingsSearchDialogueConfigLine)CollectionsUtility.getFirstMatching(POSUISettingsUtil.getPosUISettings().getSearchDialogueConfigLines(), l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType));
        if (searchDialogueConfigLine == null) {
            return null;
        }
        return searchDialogueConfigLine.getSearchDialogColumnsMode();
    }

    public static List<String> fetchCustomerDisplayWindowHeaderFieldsForType(String namaEntityType) {
        return POSUISettingsUtil.getPosUISettings().getCustomerDisplayWindowHeaderFields().stream().filter(l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType)).map(AbsPOSFieldLine::getField).collect(Collectors.toList());
    }

    public static List<String> fetchCustomerDisplayWindowFooterFieldsForType(String namaEntityType) {
        return POSUISettingsUtil.getPosUISettings().getCustomerDisplayWindowFooterFields().stream().filter(l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType)).map(AbsPOSFieldLine::getField).collect(Collectors.toList());
    }

    public static List<String> fetchCustomerDisplayWindowTableColumnsForType(String namaEntityType) {
        return POSUISettingsUtil.getPosUISettings().getCustomerDisplayWindowTableColumns().stream().filter(l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)namaEntityType)).map(AbsPOSFieldLine::getField).collect(Collectors.toList());
    }

    public static double calcWidthFromSize(String widthSize) {
        double screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
        if (ObjectChecker.isEmptyOrNull((Object)widthSize)) {
            return 0.0;
        }
        switch (widthSize.toLowerCase()) {
            case "tiny": {
                return screenWidth * 0.025;
            }
            case "verysmall": {
                return screenWidth * 0.05;
            }
            case "small": {
                return screenWidth * 0.075;
            }
            case "medium": {
                return screenWidth * 0.1;
            }
            case "large": {
                return screenWidth * 0.125;
            }
            case "xlarge": {
                return screenWidth * 0.15;
            }
            case "xxlarge": {
                return screenWidth * 0.175;
            }
        }
        return screenWidth * 0.05;
    }

    static {
        basicUIInfoForTypes = new HashMap();
        mainLinesForTypes = new HashMap();
        otherLinesForTypes = new HashMap();
        gridLinesForTypes = new HashMap();
    }
}

