/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.util.plugnplay.POSPlugNPlayUtils;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;

public class POSUtilsDialog
extends NamaDialog<ButtonType> {
    private POSLabeledTextField utilNameField;
    private POSLabeledTextField utilParametersField;

    public POSUtilsDialog(IHasToolBar hasToolBar) {
        super("Utils");
        this.utilNameField = new POSLabeledTextField("utilName", hasToolBar, POSFieldType.Text);
        this.utilParametersField = new POSLabeledTextField("utilParameters", hasToolBar, POSFieldType.Text);
        NamaHBox content = new NamaHBox(new Node[]{this.utilNameField, this.utilParametersField});
        this.content((Node)content);
        this.addOkButton("");
        this.addCancelButton("");
    }

    public void showDialog() {
        this.utilNameField.getField().requestFocus();
        Optional buttonType = this.showAndWait();
        if (buttonType.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)buttonType.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            String result = POSPlugNPlayUtils.runUtil(ObjectChecker.toStringOrEmpty((Object)this.utilNameField.getValue()), ObjectChecker.toStringOrEmpty((Object)this.utilParametersField.getValue()));
            if (ObjectChecker.areEqual((Object)result, (Object)"Done")) {
                POSErrorAndInfoMessagesUtil.showInfo(result, (Stage)this.getOwner());
            } else {
                POSErrorAndInfoMessagesUtil.showError(result, (Stage)this.getOwner());
            }
        }
    }
}

