/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.MultiKeyHash;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.enums.YesNo;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSFreeItemsOnInvoiceOfferDialog;
import com.namasoft.pos.application.POSOfferOnItemsCountDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSOfferOnItemsCountLine;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.domain.valueobjects.POSItemSalesFreeItem;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceReq;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceRes;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceResDetail;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqType;
import com.namasoft.pos.util.POSConfigurationUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.PosSalesUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.scene.control.Dialog;

public class PaymentDialogHelper {
    public static boolean serviceItemMustBeReCalculated(AbsPOSSales salesDoc, AbsPosSalesScreen view, boolean forceReCalc) {
        AbsPOSSalesLine line = salesDoc.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)AbsPOSSales.fetchServiceItem())).findFirst().orElse(null);
        boolean shouldAddServiceItem = POSConfigurationUtil.shouldAddServiceItemAutomaticallyInInv();
        POSResult posResult = new POSResult();
        posResult.failure("Service charge recalculated", new Object[0]);
        if (line != null && (forceReCalc || ObjectChecker.areNotEqual((Object)line.getUnitPrice(), (Object)salesDoc.calculateServiceChargeValue()))) {
            salesDoc.fetchDetails().remove(line);
            PaymentDialogHelper.addServiceItem(salesDoc, view, posResult);
            return true;
        }
        if (line == null && shouldAddServiceItem) {
            PaymentDialogHelper.addServiceItem(salesDoc, view, posResult);
            return true;
        }
        return false;
    }

    private static void addServiceItem(AbsPOSSales salesDoc, AbsPosSalesScreen view, POSResult posResult) {
        POSErrorAndInfoMessagesUtil.showInfo(posResult, view.fetchStage());
        PosSalesUtil.addServiceItemToInvoice(view, salesDoc, posResult);
        salesDoc.refreshViewAfterAddLine(salesDoc.fetchDetails().get(salesDoc.fetchDetails().size() - 1).getItem().getId().toString(), view, null);
    }

    public static boolean minChargeItemMustBeReCalculated(AbsPOSSales salesDoc, AbsPosSalesScreen screen, POSResult result) {
        boolean isReservation = ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{salesDoc instanceof POSOrderReservation, salesDoc instanceof PosCancelReservation});
        if (isReservation && ObjectChecker.areNotEqual((Object)POSResourcesUtil.fetchPOSConfig().getEnableMinChargeInPOSReservationDoc(), (Object)YesNo.Yes)) {
            return false;
        }
        AbsPOSSalesLine line = salesDoc.fetchDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getItem(), (Object)AbsPOSSales.fetchMinChargeItem())).findFirst().orElse(null);
        BigDecimal minChargeVal = salesDoc.calculateMinChargeVal();
        boolean isNegativeOrZeroVal = ObjectChecker.isNegativeOrZero((BigDecimal)minChargeVal);
        if (line != null && !isNegativeOrZeroVal && ObjectChecker.areNotEqual((Object)line.getUnitPrice(), (Object)minChargeVal)) {
            PaymentDialogHelper.showMinChargeInfoMassage(screen);
            salesDoc.fetchDetails().remove(line);
            salesDoc.addMinChargeItemToInvoice(screen, result);
            return true;
        }
        if (line == null && !isNegativeOrZeroVal) {
            PaymentDialogHelper.showMinChargeInfoMassage(screen);
            salesDoc.addMinChargeItemToInvoice(screen, result);
            return true;
        }
        if (line != null && isNegativeOrZeroVal) {
            PaymentDialogHelper.showMinChargeInfoMassage(screen);
            salesDoc.removeMinChargeItem(screen);
            return true;
        }
        return false;
    }

    private static void showMinChargeInfoMassage(AbsPosSalesScreen screen) {
        if (screen == null) {
            return;
        }
        POSResult posResult = new POSResult();
        posResult.failure(POSResourcesUtil.id("Minimum charge recalculated", new Object[0]), new Object[0]);
        POSErrorAndInfoMessagesUtil.showInfo(posResult, screen.fetchStage());
    }

    public static boolean checkAndShowFreeItemsOnInvoiceDialog(Dialog dialog, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchSupplyChainConfig().getActivateFreeItemsOnInvoiceOffers())) {
            return false;
        }
        if (view != null && !view.getShowFreeItemsOnInvoiceOfferDialogAgain().booleanValue()) {
            return false;
        }
        POSInvoiceClassification invClassifition = (POSInvoiceClassification)ObjectChecker.getFirstNotNullObj((Object[])new POSInvoiceClassification[]{salesDoc.getPosInvoiceClassification(), POSResourcesUtil.calcInvoiceClassification(POSResourcesUtil.fetchMainRegister())});
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSItemSalesPriceReq itemPriceReq = POSSalesPriceUtil.createSalesPriceRequestHeader(new ArrayList<BigDecimal>(), new Date(), invClassifition, POSSalesPriceReqType.All, currentUser, salesDoc.fetchDetails(), ObjectChecker.toStringOrEmpty((Object)salesDoc.getDiscountPercent()), salesDoc.getTotalPrice(), ObjectChecker.toStringOrEmpty((Object)salesDoc.getTotalPrice()), salesDoc);
        POSItemSalesPriceRes priceResult = new POSItemSalesPriceRes();
        priceResult.setQty(BigDecimal.valueOf(-1L));
        priceResult.setDetails(new ArrayList<POSItemSalesPriceResDetail>());
        POSItemSalesPriceRes itemSalesPriceRes = POSSalesPriceUtil.calculateInvoiceFreeItems(itemPriceReq, priceResult);
        List<POSItemSalesFreeItem> freeItems = itemSalesPriceRes.getDetails().get(0).getFreeItems();
        if (ObjectChecker.isEmptyOrNull(freeItems) && salesDoc.fetchDetails().stream().anyMatch(l -> ObjectChecker.isTrue((Boolean)l.getFromFreeItemsOnInvoiceOffer()))) {
            PaymentDialogHelper.removeOldFreeItemsOnInvoiceOfferLines(salesDoc, view);
        } else if (ObjectChecker.isNotEmptyOrNull(freeItems)) {
            HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd = salesDoc.constructItemsMapFromExistAndNew(freeItems, view);
            if (PaymentDialogHelper.offerLinesMustBeRecalculated(toAdd)) {
                PaymentDialogHelper.removeOldFreeItemsOnInvoiceOfferLines(salesDoc, view);
                toAdd = salesDoc.constructItemsMapFromExistAndNew(freeItems, view);
            }
            if (ObjectChecker.isNotEmptyOrNull(toAdd)) {
                POSFreeItemsOnInvoiceOfferDialog onInvoiceOfferDialog = new POSFreeItemsOnInvoiceOfferDialog();
                onInvoiceOfferDialog.showDailog(new ActionEvent(), dialog, salesDoc, toAdd, itemSalesPriceRes.getIgnoreOtherOffers(), view);
                return true;
            }
        }
        return false;
    }

    private static void removeOldFreeItemsOnInvoiceOfferLines(AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        for (int i = salesDoc.fetchDetails().size() - 1; i >= 0; --i) {
            AbsPOSSalesLine line = salesDoc.fetchDetails().get(i);
            if (!ObjectChecker.isTrue((Boolean)line.getFromFreeItemsOnInvoiceOffer())) continue;
            salesDoc.removeLineAndShowMsg(line, view);
        }
    }

    private static boolean offerLinesMustBeRecalculated(HashMap<MultiKeyHash, POSItemSalesFreeItem> toAdd) {
        for (Map.Entry<MultiKeyHash, POSItemSalesFreeItem> entry : toAdd.entrySet()) {
            if (!ObjectChecker.isNegative((BigDecimal)entry.getValue().getQty().getValue())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Dialog> boolean checkAndShowOfferDialog(T dialog, AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        if (!view.getShowOfferDialogAgain().booleanValue()) {
            return false;
        }
        List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> linesOfItemToGetFree = salesDoc.fetchOfferOnItemsCount();
        if (PaymentDialogHelper.newOfferLinesDifferFromOld(linesOfItemToGetFree, (List<AbsPOSSalesLine>)view.getSalesTable().getItems())) {
            boolean hasOldOfferLines = PaymentDialogHelper.removeOldOfferLines(salesDoc, view);
            if (ObjectChecker.isEmptyOrNull(linesOfItemToGetFree) && hasOldOfferLines) {
                POSResult posResult = new POSResult();
                posResult.failure(POSResourcesUtil.id("Offer line has been removed", new Object[0]), new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, view.fetchStage());
                view.updateFieldsEvent(Arrays.asList("details"), salesDoc);
                return true;
            }
            List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> offersForDialog = linesOfItemToGetFree.stream().filter(o -> ((POSOfferOnItemsCountLine)o.getX()).getSalesOffer() != null).toList();
            if (ObjectChecker.isNotEmptyOrNull(offersForDialog)) {
                POSOfferOnItemsCountDialog offerOnItemsDialog = new POSOfferOnItemsCountDialog();
                offerOnItemsDialog.showDialog(new ActionEvent(), dialog, salesDoc, offersForDialog, view);
                return true;
            }
        }
        return false;
    }

    private static <T extends AbsPOSSalesLine> boolean newOfferLinesDifferFromOld(List<Pair<POSOfferOnItemsCountLine, AbsPOSSalesLine>> linesOfItemToGetFree, List<AbsPOSSalesLine> salesLines) {
        ArrayList<AbsPOSSalesLine> offerLines = new ArrayList<AbsPOSSalesLine>();
        linesOfItemToGetFree.forEach(pair -> offerLines.add((AbsPOSSalesLine)pair.getY()));
        for (AbsPOSSalesLine salesLine : salesLines) {
            List filteredList;
            if (ObjectChecker.isFalseOrNull((Boolean)salesLine.getFreeFromItemsCountOffer()) || salesLine.getFreeItemGroup() != null || (filteredList = CollectionsUtility.filter(offerLines, offerLine -> offerLine.getItem() != null && ObjectChecker.areEqual((Object)offerLine.getItem().getCode(), (Object)salesLine.getItem().getCode()) && ObjectChecker.areEqual((Object)offerLine.getQty().getValue(), (Object)PaymentDialogHelper.findQtyOfLinesWithItemOrGroup(salesLines, offerLine.getItem(), offerLine.getFreeItemGroup())))).size() != 0) continue;
            return true;
        }
        return PaymentDialogHelper.newOfferLinesDifferFromOldIfFromFreeItemGroup(salesLines, offerLines);
    }

    private static boolean newOfferLinesDifferFromOldIfFromFreeItemGroup(List<AbsPOSSalesLine> salesLines, List<AbsPOSSalesLine> offerLines) {
        Map freeItemGroupMap = CollectionsUtility.mapList(offerLines, AbsPOSSalesLine::getFreeItemGroup);
        for (Map.Entry entry : freeItemGroupMap.entrySet()) {
            boolean sameOfferLines = ObjectChecker.areEqual((Object)CollectionsUtility.totalize((List)((List)entry.getValue()), l -> l.getQty().getValue()), (Object)PaymentDialogHelper.findQtyOfLinesWithItemOrGroup(salesLines, null, (POSFreeItemGroup)entry.getKey()));
            if (sameOfferLines) continue;
            return true;
        }
        return false;
    }

    private static BigDecimal findQtyOfLinesWithItemOrGroup(List<AbsPOSSalesLine> salesLines, POSItem item, POSFreeItemGroup freeItemGroup) {
        BigDecimal qty = BigDecimal.ZERO;
        for (AbsPOSSalesLine line : salesLines) {
            POSFreeItemGroup lineFreeItemGroup;
            if (line.getInvoiceOfferId() == null || ((lineFreeItemGroup = POSPersister.findByID(POSFreeItemGroup.class, line.getFreeItemGroup().getId())) == null || !ObjectChecker.areEqual((Object)lineFreeItemGroup, (Object)freeItemGroup)) && (item == null || !ObjectChecker.areEqual((Object)line.getItem(), (Object)item))) continue;
            qty = qty.add(line.getQty().getValue());
        }
        return qty;
    }

    private static boolean removeOldOfferLines(AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        boolean hasOldOfferLines = false;
        for (int i = salesDoc.fetchDetails().size() - 1; i >= 0; --i) {
            AbsPOSSalesLine line = salesDoc.fetchDetails().get(i);
            if (line.getInvoiceOfferId() == null) continue;
            hasOldOfferLines = true;
            salesDoc.fetchDetails().remove(line);
            view.getSalesTable().getItems().remove((Object)line);
        }
        return hasOldOfferLines;
    }

    public static boolean isRemainingValid(BigDecimal value, BigDecimal paid, POSDocumentType docType) {
        BigDecimal approximationDiscountValue = POSResourcesUtil.fetchGlobalConfig().getInfo().getApproximationDiscountValue();
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)approximationDiscountValue)) {
            BigDecimal allowedApproximation;
            BigDecimal remainder = value.remainder(BigDecimal.ONE);
            BigDecimal remaining = value.subtract(paid);
            if (remaining.compareTo(allowedApproximation = remainder.remainder(approximationDiscountValue, MathContext.DECIMAL128)) <= 0) {
                return true;
            }
        }
        return ObjectChecker.areEqual((Object)((Object)POSDocumentType.POSOrderReservation), (Object)((Object)docType)) ? true : paid.compareTo(value) >= 0;
    }
}

