/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.NamaPosAdditionalItemsType;
import com.namasoft.namacontrols.NamaContextMenu;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.tablecells.POSSalesTableFields;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosAdditionalItemBtn;
import com.namasoft.pos.application.PosAdditionalItemsGroupPane;
import com.namasoft.pos.application.PosItemBasicProperty;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPosAdditionalItems;
import com.namasoft.pos.domain.details.PosAdditionalItemsLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;

public class PosAdditionalItemsDialog
extends NamaDialog<ButtonType> {
    private PosItemAdditionalItems additionalItems;
    private AbsPosSalesScreen screen;
    private List<PosAdditionalItemsGroupPane> groups;
    private int lineNumber;
    private POSItem posItem;

    public PosAdditionalItemsDialog(PosItemAdditionalItems items, AbsPosSalesScreen salesScreen, int lineNumber, POSItem item) {
        super(POSResourcesUtil.id("AdditionalItems", new Object[0]) + " - " + item.nameByLanguage());
        this.additionalItems = items;
        this.screen = salesScreen;
        this.lineNumber = lineNumber;
        this.posItem = item;
        int rowIndex = 1;
        double dialogWidth = this.screen.fetchStage().getWidth() / 2.0;
        ScrollPane scrollPane = new ScrollPane();
        GridPane pane = new GridPane();
        this.groups = PosAdditionalItemsDialog.createGroups(this.additionalItems, this.posItem);
        for (PosAdditionalItemsGroupPane g : this.groups) {
            if (!ObjectChecker.isNotEmptyOrNull(g.getButtons())) continue;
            g.setPrefWidth(dialogWidth - 10.0);
            pane.add((Node)g, 0, rowIndex++);
        }
        scrollPane.setFitToWidth(true);
        scrollPane.setContent((Node)pane);
        this.content((Node)scrollPane);
    }

    public static List<PosAdditionalItemsGroupPane> createGroups(PosItemAdditionalItems additionalItems, POSItem posItem) {
        PosAdditionalItemsGroupPane group;
        ArrayList<Pair> groupsOrder = new ArrayList<Pair>();
        ArrayList<Integer> positionsUsedInItemProperties = new ArrayList<Integer>();
        if (additionalItems.getShowItemRevisions().booleanValue()) {
            group = new PosAdditionalItemsGroupPane(posItem, null, false, additionalItems.getMakeItemRevisionsRequired(), posItem.nameByLanguage() + " : " + additionalItems.getRevisionsTitleInPos(), PosItemBasicProperty.Revision, additionalItems.getItemRevisionsDisplayMethod(), ObjectChecker.toZeroIfNull((Integer)additionalItems.getAdditionalItemsCountPerPage()), true, true);
            groupsOrder.add(new Pair((Object)additionalItems.getItemRevisionsOrder(), (Object)group));
            positionsUsedInItemProperties.add(additionalItems.getItemRevisionsOrder());
        }
        if (additionalItems.getShowItemColors().booleanValue()) {
            group = new PosAdditionalItemsGroupPane(posItem, null, false, additionalItems.getMakeItemColorsRequired(), posItem.nameByLanguage() + " : " + additionalItems.getColorsTitleInPos(), PosItemBasicProperty.Color, additionalItems.getItemColorsDisplayMethod(), ObjectChecker.toZeroIfNull((Integer)additionalItems.getAdditionalItemsCountPerPage()), true, true);
            groupsOrder.add(new Pair((Object)additionalItems.getItemColorsOrder(), (Object)group));
            positionsUsedInItemProperties.add(additionalItems.getItemColorsOrder());
        }
        if (additionalItems.getShowItemSizes().booleanValue()) {
            group = new PosAdditionalItemsGroupPane(posItem, null, false, additionalItems.getMakeItemSizesRequired(), posItem.nameByLanguage() + " : " + additionalItems.getSizesTitleInPos(), PosItemBasicProperty.Size, additionalItems.getItemSizesDisplayMethod(), ObjectChecker.toZeroIfNull((Integer)additionalItems.getAdditionalItemsCountPerPage()), true, true);
            groupsOrder.add(new Pair((Object)additionalItems.getItemSizesOrder(), (Object)group));
            positionsUsedInItemProperties.add(additionalItems.getItemSizesOrder());
        }
        ArrayList<PosAdditionalItemsGroupPane> groups = new ArrayList<PosAdditionalItemsGroupPane>();
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems1(), NamaPosAdditionalItemsType.AdditionalItems1, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems2(), NamaPosAdditionalItemsType.AdditionalItems2, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems3(), NamaPosAdditionalItemsType.AdditionalItems3, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems4(), NamaPosAdditionalItemsType.AdditionalItems4, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems5(), NamaPosAdditionalItemsType.AdditionalItems5, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems6(), NamaPosAdditionalItemsType.AdditionalItems6, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems7(), NamaPosAdditionalItemsType.AdditionalItems7, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems8(), NamaPosAdditionalItemsType.AdditionalItems8, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems9(), NamaPosAdditionalItemsType.AdditionalItems9, additionalItems, groups, posItem);
        PosAdditionalItemsDialog.addItemsGroup(additionalItems.getAdditionalItems10(), NamaPosAdditionalItemsType.AdditionalItems10, additionalItems, groups, posItem);
        int position = 1;
        while (ObjectChecker.isNotEmptyOrNull(groups)) {
            if (!positionsUsedInItemProperties.contains(position)) {
                groupsOrder.add(new Pair((Object)position, (Object)((PosAdditionalItemsGroupPane)((Object)groups.remove(0)))));
            }
            ++position;
        }
        groupsOrder.sort(Comparator.comparing(Pair::getX));
        return groupsOrder.stream().map(Pair::getY).collect(Collectors.toList());
    }

    public void showDialog() {
        this.getDialogPane().setPrefHeight(this.screen.fetchStage().getHeight() / 1.5);
        this.setResizable(true);
        this.addOkButton("");
        this.addCancelButton("");
        this.dialogHandler();
    }

    private void dialogHandler() {
        this.setOkAction(e -> {
            StringBuilder errors = new StringBuilder();
            if (this.isAnyRequiredEmpty(this.groups, this.posItem, errors)) {
                this.error(errors.toString());
            } else {
                this.addSelectedToDoc(this.groups);
            }
        });
        this.showAndWait();
    }

    private boolean isAnyRequiredEmpty(List<PosAdditionalItemsGroupPane> groups, POSItem basicItem, StringBuilder errors) {
        boolean hasErrors = false;
        for (PosAdditionalItemsGroupPane group : groups) {
            if (ObjectChecker.isNotEmptyOrNull(group.getSubGroups())) {
                hasErrors = this.isAnyRequiredEmpty(group.getSubGroups(), group.getBasicItem(), errors);
            }
            if (!group.isRequired() || !ObjectChecker.isEmptyOrNull(group.getSelectedButtons())) continue;
            String message = basicItem.nameByLanguage() + " : " + group.getText() + " \u0645\u0637\u0644\u0648\u0628\u0629 ";
            if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.isArabic())) {
                message = basicItem.nameByLanguage() + " : " + group.getText() + " required";
            }
            errors.append(message);
            errors.append("\n");
            hasErrors = true;
        }
        return hasErrors;
    }

    public static void addItemsGroup(List<? extends AbsPosAdditionalItems> items, NamaPosAdditionalItemsType type, PosItemAdditionalItems additionalItems, List<PosAdditionalItemsGroupPane> groups, POSItem item) {
        if (ObjectChecker.isEmptyOrNull((Object)additionalItems)) {
            return;
        }
        PosAdditionalItemsLine line = additionalItems.getAdditionalItemsSettings().stream().filter(l -> ObjectChecker.areEqual((Object)l.getAdditionalItemsType(), (Object)type)).findFirst().orElse(new PosAdditionalItemsLine());
        PosAdditionalItemsGroupPane group = new PosAdditionalItemsGroupPane(item, items, line, ObjectChecker.toZeroIfNull((Integer)additionalItems.getAdditionalItemsCountPerPage()));
        groups.add(group);
    }

    private void addSelectedToDoc(List<PosAdditionalItemsGroupPane> groups) {
        AbsPOSSales salesDoc = this.screen.getSalesDoc();
        for (PosAdditionalItemsGroupPane group : groups) {
            this.addDetailsToDoc(salesDoc, group);
        }
    }

    private void addDetailsToDoc(AbsPOSSales salesDoc, PosAdditionalItemsGroupPane group) {
        List<PosAdditionalItemBtn> selectedButtons = group.getSelectedButtons();
        if (ObjectChecker.isEmptyOrNull(selectedButtons)) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)((Object)group.getGroupForProperty()))) {
            selectedButtons.forEach(b -> {
                POSItem item = b.getItem();
                int lineIndex = salesDoc.fetchDetails().size();
                POSResult result = new POSResult();
                salesDoc.addSalesLine(POSResourcesUtil.fetchMainRegister(), item.getCode(), lineIndex, BigDecimal.ONE, true, this.screen, true, b.getPosUnit(), result);
                if (result.isSucceeded().booleanValue()) {
                    this.lineNumber = lineIndex;
                    List<PosAdditionalItemsGroupPane> subGroups = group.getSubGroups().stream().filter(g -> ObjectChecker.areEqual((Object)g.getBasicItem().getId(), (Object)item.getId())).collect(Collectors.toList());
                    if (ObjectChecker.isNotEmptyOrNull(subGroups)) {
                        this.addSelectedToDoc(subGroups);
                    }
                } else {
                    POSErrorAndInfoMessagesUtil.showError(result, this.screen.fetchStage());
                }
            });
        } else {
            AbsPOSSalesLine line = salesDoc.fetchDetails().get(this.lineNumber);
            Map.Entry pair = (Map.Entry)selectedButtons.get(0).getUserData();
            if (ObjectChecker.areEqual((Object)((Object)group.getGroupForProperty()), (Object)((Object)PosItemBasicProperty.Revision))) {
                line.getItemDimensions().setRevisionId((String)pair.getKey());
            } else if (ObjectChecker.isAnyEqualToFirst((Object)((Object)group.getGroupForProperty()), (Object[])new PosItemBasicProperty[]{PosItemBasicProperty.Size, PosItemBasicProperty.Color})) {
                NamaContextMenu.fillColorOrSizeCols(ObjectChecker.isAnyEqualToFirst((Object)((Object)group.getGroupForProperty()), (Object[])new PosItemBasicProperty[]{PosItemBasicProperty.Size}) ? POSSalesTableFields.Size_Col : POSSalesTableFields.Color_Col, line.getItemDimensions(), pair);
            }
            salesDoc.calcUnitPriceAndFreeLines(POSResourcesUtil.fetchMainRegister(), line, false, this.screen);
        }
    }
}

