/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.KeyPadButton;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import java.awt.AWTException;
import java.awt.Robot;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class PosKeyPad {
    private KeyPadButton btn1 = new KeyPadButton("1");
    private KeyPadButton btn2 = new KeyPadButton("2");
    private KeyPadButton btn3 = new KeyPadButton("3");
    private KeyPadButton btn4 = new KeyPadButton("4");
    private KeyPadButton btn5 = new KeyPadButton("5");
    private KeyPadButton btn6 = new KeyPadButton("6");
    private KeyPadButton btn7 = new KeyPadButton("7");
    private KeyPadButton btn8 = new KeyPadButton("8");
    private KeyPadButton btn9 = new KeyPadButton("9");
    private KeyPadButton zeroBtn = new KeyPadButton("0");
    private KeyPadButton dotBtn = new KeyPadButton(". ");
    private KeyPadButton clearBtn = new KeyPadButton("C");
    private KeyPadButton btn025 = new KeyPadButton(".25");
    private KeyPadButton btn05 = new KeyPadButton(".5");
    private KeyPadButton btn075 = new KeyPadButton(".75");
    private Stage stage;

    PosKeyPad(Stage stage) {
        this.stage = stage;
    }

    public Node drawItemCodeKeys() {
        HBox line1 = new HBox(new Node[]{this.btn1, this.btn2, this.btn3});
        line1.getStyleClass().add((Object)"numbers-pad-line");
        HBox line2 = new HBox(new Node[]{this.btn4, this.btn5, this.btn6});
        line2.getStyleClass().add((Object)"numbers-pad-line");
        HBox line3 = new HBox(new Node[]{this.btn7, this.btn8, this.btn9});
        line3.getStyleClass().add((Object)"numbers-pad-line");
        HBox line4 = new HBox(new Node[]{this.zeroBtn, this.dotBtn, this.clearBtn});
        line4.getStyleClass().add((Object)"numbers-pad-line");
        HBox line5 = new HBox(new Node[]{this.btn025, this.btn05, this.btn075});
        line5.getStyleClass().add((Object)"numbers-pad-line");
        NamaVBox keyPadBox = new NamaVBox(new Node[]{line1, line2, line3, line4, line5});
        keyPadBox.getStyleClass().add((Object)"numbers-pad");
        NamaVBox.setVgrow((Node)keyPadBox, (Priority)Priority.ALWAYS);
        this.constructActions(this.btn1, this.btn2, this.btn3, this.btn4, this.btn5, this.btn6, this.btn7, this.btn8, this.btn9, this.dotBtn, this.zeroBtn, this.clearBtn, this.btn025, this.btn05, this.btn075);
        return keyPadBox;
    }

    private void constructActions(Button ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i].setOnAction(this.keyPadEventHandler(48 + i + 1));
            if (i == 9) {
                args[i].setOnAction(this.keyPadEventHandler(46));
            }
            if (i == 10) {
                args[i].setOnAction(this.keyPadEventHandler(48));
            }
            if (i == 11) {
                args[11].setOnAction(this.keyPadEventHandler(8));
            }
            if (i == 12) {
                args[12].setOnAction(e -> this.keyEventEvents(48, 46, 50, 53));
            }
            if (i == 13) {
                args[13].setOnAction(e -> this.keyEventEvents(48, 46, 53));
            }
            if (i != 14) continue;
            args[14].setOnAction(e -> this.keyEventEvents(48, 46, 55, 53));
        }
    }

    private EventHandler<ActionEvent> keyPadEventHandler(int key) {
        return e -> this.keyEventEvent(key);
    }

    private void keyEventEvents(int ... keys) {
        for (int key : keys) {
            this.keyEventEvent(key);
        }
    }

    private void keyEventEvent(int key) {
        try {
            Node focusedNode = (Node)this.stage.getScene().focusOwnerProperty().get();
            Robot r = new Robot();
            if (ObjectChecker.isEmptyOrNull((Object)focusedNode) || !(focusedNode instanceof TextField)) {
                Platform.runLater(() -> {
                    if (POSResourcesUtil.currentScreen instanceof AbsPosSalesScreen) {
                        ((AbsPosSalesScreen)POSResourcesUtil.currentScreen).getFavouritesContainerBuilder().requestFocus();
                    }
                    r.keyPress(key);
                    r.keyRelease(key);
                });
                return;
            }
            r.keyPress(key);
            r.keyRelease(key);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }
}

