/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSubsidiaryBox;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import java.util.Arrays;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;

public class PosLineReferenceEditDialog
extends NamaDialog<ButtonType> {
    private AbsPOSSalesLine line;
    private String refId;
    private AbsPosSalesScreen screen;
    private POSSubsidiaryBox posSubsidiaryBox;

    public PosLineReferenceEditDialog(AbsPosSalesScreen screen, AbsPOSSalesLine line, String refId) {
        super("editReference");
        this.line = line;
        this.refId = refId;
        this.screen = screen;
    }

    public void showDialog() {
        double dialogWidth = this.screen.fetchStage().getWidth() / 4.0;
        this.getDialogPane().setPrefWidth(dialogWidth);
        this.setResizable(true);
        this.posSubsidiaryBox = new POSSubsidiaryBox(this.screen);
        this.posSubsidiaryBox.setLineRef(true);
        String allowedValues = POSResourcesUtil.readFieldsAllowedValues(this.screen.getSalesDoc().calcNamaEntityType(), "details." + this.refId);
        if (ObjectChecker.isNotEmptyOrNull((Object)allowedValues)) {
            String[] values = allowedValues.split(",");
            this.posSubsidiaryBox.setAllowedValues(Arrays.asList(values));
        }
        NamaHBox box = new NamaHBox(10);
        box.getChildren().add((Object)new NamaLabel(POSResourcesUtil.id(this.screen.fetchDocumentClass(), "details." + this.refId)));
        box.getChildren().add((Object)this.posSubsidiaryBox);
        this.content((Node)box);
        this.addOkButton("");
        this.addCancelButton("");
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.setRefInDoc();
        }
    }

    private void setRefInDoc() {
        POSMasterFile value = this.posSubsidiaryBox.getReference();
        if (ObjectChecker.isEmptyOrNull((Object)value)) {
            PosLineReferenceEditDialog.clearRefById(this.refId, this.line, this.screen);
        } else {
            this.updateRefById(this.refId, value);
        }
    }

    private void updateRefById(String refId, Object value) {
        if (ObjectChecker.areEqual((Object)refId, (Object)"ref1")) {
            this.line.setRef1Id(((POSMasterFile)value).getId());
            this.line.setRef1Code(((POSMasterFile)value).getCode());
            this.line.setRef1Type((String)this.posSubsidiaryBox.getTypeCombo().getValue());
            this.line.setRef1NamaType(((POSMasterFile)value).calcNamaEntityType());
        }
        this.screen.getSalesTable().getItems().clear();
        this.screen.getSalesTable().getItems().addAll(this.screen.salesDoc.fetchDetails());
    }

    public static void clearRefById(Object refId, AbsPOSSalesLine line, AbsPosSalesScreen screen) {
        if (ObjectChecker.areEqual((Object)refId, (Object)"ref1")) {
            line.setRef1Id(null);
            line.setRef1Code(null);
            line.setRef1Type(null);
        }
        screen.getSalesTable().getItems().clear();
        screen.getSalesTable().getItems().addAll(screen.salesDoc.fetchDetails());
    }
}

