/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSInternalMsgScreen;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSNewShiftsScreen;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSShiftInventoryScreen;
import com.namasoft.pos.application.PosEntryPoint;
import java.util.HashMap;
import java.util.function.Function;

public class PosScreenCacheUtil {
    private static HashMap<POSDocumentType, IHasToolBar> cachedScreens = new HashMap();
    private static HashMap<POSDocumentType, Function<Void, IHasToolBar>> newScreens = new HashMap();

    private static Function<Void, IHasToolBar> newScreenOfType(POSDocumentType type) {
        if (ObjectChecker.isNotEmptyOrNull(newScreens)) {
            return newScreens.get((Object)type);
        }
        newScreens.put(POSDocumentType.Invoice, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.POSOrderReservation, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.POSCancelReservation, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.StockTransferReq, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.StockTakingDetails, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.ShortfallsDoc, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.ScrapDoc, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.Return, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.Replacement, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.POSStockReceipt, r -> new POSNewSalesScreen());
        newScreens.put(POSDocumentType.Payment, r -> new POSPaymentReciptScreen());
        newScreens.put(POSDocumentType.Receipt, r -> new POSPaymentReciptScreen());
        newScreens.put(POSDocumentType.entryPoint, r -> new PosEntryPoint());
        newScreens.put(POSDocumentType.ShiftOpen, r -> new POSNewShiftsScreen());
        newScreens.put(POSDocumentType.ShiftClose, r -> new POSNewShiftsScreen());
        newScreens.put(POSDocumentType.CashCount, r -> ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getStartWithNewShiftUI()) ? new POSNewShiftsScreen() : new POSShiftInventoryScreen());
        newScreens.put(POSDocumentType.Msg, r -> new POSInternalMsgScreen());
        return newScreens.get((Object)type);
    }

    public static void addScreenIfNeeded(IHasToolBar hasToolBar) {
        if (ObjectChecker.isEmptyOrNull((Object)cachedScreens.get((Object)hasToolBar.documentType()))) {
            cachedScreens.put(hasToolBar.documentType(), hasToolBar);
        }
    }

    public static IHasToolBar fetchCachedScreen(POSDocumentType type) {
        IHasToolBar screen = cachedScreens.get((Object)type);
        if (screen == null) {
            screen = PosScreenCacheUtil.newScreenOfType(type).apply(null);
        }
        return screen;
    }

    public static void clear() {
        cachedScreens.clear();
    }

    public static void clearExceptLoginScreen() {
        cachedScreens.entrySet().removeIf(e -> ObjectChecker.areNotEqual(e.getKey(), (Object)((Object)POSDocumentType.entryPoint)));
    }
}

