/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class PosThreadDumper {
    public static void main(String[] args) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader("PID"));
            String pid = reader.readLine();
            if (ObjectChecker.isNotEmptyOrNull((Object)pid)) {
                pid = pid.trim();
                System.out.println("Starting creating thread dump for process with id " + pid);
                String threadFileName = "threadDump-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".txt";
                File threadFile = new File(threadFileName);
                String jstackPath = "jstack.exe";
                if (ObjectChecker.isNotEmptyOrNull((Object)System.getProperty("jdk-path"))) {
                    jstackPath = new File(System.getProperty("jdk-path"), "/bin/jstack.exe").getAbsolutePath();
                }
                Process exec = new ProcessBuilder(jstackPath, "-l", pid).redirectOutput(threadFile).redirectError(threadFile).start();
                exec.waitFor();
                Desktop.getDesktop().open(threadFile);
            }
            reader.close();
        }
        catch (IOException ex) {
            String errorText = "Could not find jstack application, please make sure that jdk/bin folder is in your path.\nMost probably it will be something like C:\\Program Files\\Java\\jdk.VERSIONS_HERE\\bin.\n\nThread dumper not working with JRE, you need to install JDK";
            System.out.println(errorText);
            JOptionPane.showMessageDialog(null, errorText, "", 2);
            ex.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("cannot generate Or open thread dump file");
            e.printStackTrace();
        }
    }
}

