/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.DTONamaRewardInfo;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSLabeledPasswordField;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSRewardPointsUtil;
import java.math.BigDecimal;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class RewardPointsDialog
extends NamaDialog<ButtonType> {
    private POSLabeledTextField remainingRewardPointsField = new POSLabeledTextField("remainingRewardPoints", null);
    private POSLabeledTextField remainingRewardAmountField = new POSLabeledTextField("remainingRewardAmount", null);
    private POSLabeledTextField redeemAmountField;
    private Button requestOTPBtn;
    private Callback<Event> requestOTPCallback;
    private Callback<Event> onShowingCallback;
    private POSLabeledPasswordField otpField;
    private NamaButton redeemBtn;

    public RewardPointsDialog() {
        super("redeemAmount");
        this.remainingRewardPointsField.getField().setEditable(false);
        this.remainingRewardAmountField.getField().setEditable(false);
        this.redeemAmountField = new POSLabeledTextField("redeemAmount", null);
        this.requestOTPBtn = new NamaButton("requestOTP");
        this.requestOTPBtn.setOnAction(e -> {
            if (this.requestOTPCallback != null) {
                this.requestOTPCallback.done((Object)e);
            }
        });
        this.otpField = new POSLabeledPasswordField("\tOTP", null);
        this.redeemBtn = new NamaButton("redeem");
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(8.0);
        gridPane.add((Node)this.remainingRewardPointsField.getLabel(), 0, 0);
        gridPane.add((Node)this.remainingRewardPointsField.getField(), 1, 0);
        gridPane.add((Node)this.remainingRewardAmountField.getLabel(), 2, 0);
        gridPane.add((Node)this.remainingRewardAmountField.getField(), 3, 0);
        gridPane.add((Node)this.redeemAmountField.getLabel(), 0, 1);
        gridPane.add((Node)this.redeemAmountField.getField(), 1, 1);
        gridPane.add((Node)this.requestOTPBtn, 3, 1);
        gridPane.add((Node)this.otpField.getLabel(), 0, 2);
        gridPane.add((Node)this.otpField.getField(), 1, 2);
        gridPane.add((Node)this.redeemBtn, 3, 2);
        this.content((Node)gridPane);
        this.addCancelButton("");
        EventHandler SuperOnShowing = RewardPointsDialog.super.getOnShowing();
        this.setOnShowing(e -> {
            SuperOnShowing.handle(e);
            if (this.onShowingCallback != null) {
                this.onShowingCallback.done((Object)e);
            }
        });
    }

    public void showDialog(AbsPOSSales doc, NamaTextField processNumberField, PaymentInfo info, POSResult result) {
        this.clear();
        if (this.requestOTPBtn.isVisible()) {
            this.redeemBtn.setDisable(true);
            this.otpField.disable(true);
        }
        this.onShowingCallback = e -> {
            DTONamaRewardInfo rewardInfo = POSRewardPointsUtil.calculateRemainingRewardInfo(doc.getCustomer(), result);
            if (result.isFailed().booleanValue() || rewardInfo == null) {
                Platform.runLater(() -> this.hide());
                return;
            }
            this.remainingRewardPointsField.getField().setText(ObjectChecker.toStringOrEmpty((Object)rewardInfo.getRemainingRewardPoints()));
            this.remainingRewardAmountField.getField().setText(ObjectChecker.toStringOrEmpty((Object)rewardInfo.getRemainingRewardAmount()));
        };
        this.requestOTPCallback = e -> {
            BigDecimal redeemAmount;
            POSResult posResult = new POSResult();
            try {
                redeemAmount = new BigDecimal(ObjectChecker.toStringOrEmpty((Object)this.redeemAmountField.getValue()));
            }
            catch (Exception exception) {
                redeemAmount = BigDecimal.ZERO;
            }
            POSRewardPointsUtil.requestOTP(doc, redeemAmount, posResult);
            if (posResult.isFailed().booleanValue()) {
                this.error(posResult.getMessageByLanguage());
                return;
            }
            this.redeemBtn.setDisable(false);
            this.otpField.disable(false);
        };
        this.redeemBtn.setOnAction(event -> {
            POSResult posResult = new POSResult();
            BigDecimal redeemAmount = new BigDecimal(String.valueOf(this.redeemAmountField.getValue()));
            if (ObjectChecker.isNegative((BigDecimal)redeemAmount) || NaMaMath.isGreaterThan((BigDecimal)redeemAmount, (BigDecimal)new BigDecimal(String.valueOf(this.remainingRewardAmountField.getValue())))) {
                posResult.failure("Please enter valid amount", new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, (Stage)this.getOwner());
                return;
            }
            if (NaMaMath.isGreaterThan((BigDecimal)redeemAmount, (BigDecimal)doc.calcDocumentNet())) {
                posResult.failure("Amount to redeem should be less or equal to invoice total", new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, (Stage)this.getOwner());
                return;
            }
            String couponCode = POSRewardPointsUtil.redeem(doc, redeemAmount, this.otpField.getField().getText(), this.requestOTPBtn.isVisible(), posResult);
            if (posResult.isFailed().booleanValue()) {
                this.error(posResult.getMessageByLanguage());
                return;
            }
            processNumberField.setText(couponCode);
            info.setFromRedeem(true);
            this.close();
        });
        this.showAndWait();
    }

    public void clear() {
        this.remainingRewardPointsField.clear();
        this.remainingRewardAmountField.clear();
        this.redeemAmountField.clear();
        this.otpField.clear();
    }
}

