/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;

public class TableUtils {
    public static void installCopyPasteHandler(TableView<?> table) {
        table.setOnKeyPressed((EventHandler)new TableKeyEventHandler());
    }

    public static <T, C> void applyMultipleCellSelection(TableView<T> table, TableColumn<T, C> ... cells) {
        DragSelectionCellFactory cellFactory = new DragSelectionCellFactory();
        for (TableColumn<T, C> cell : cells) {
            cell.setCellFactory(cellFactory);
        }
        table.getSelectionModel().setCellSelectionEnabled(true);
        table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    public static void copyTableSelectionToClipboard(TableView<?> table) {
        StringBuilder clipboardString = new StringBuilder();
        ObservableList positionList = table.getSelectionModel().getSelectedCells();
        int prevRow = -1;
        for (TablePosition position : positionList) {
            int row = position.getRow();
            int col = position.getColumn();
            col = TableUtils.subtractPreviousNestedCols(col, table);
            Object cell = ((TableColumn)table.getColumns().get(col)).getCellData(row);
            if (cell == null) {
                cell = "";
            }
            if (prevRow == row) {
                clipboardString.append(' ');
            } else if (row != 0) {
                clipboardString.append('\n');
            }
            String text = cell.toString();
            clipboardString.append(text);
            prevRow = row;
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    private static int subtractPreviousNestedCols(int col, TableView<?> table) {
        for (int i = 0; i < table.getColumns().size(); ++i) {
            if (i >= col) {
                return col;
            }
            int nestedColSize = ((TableColumn)table.getColumns().get(i)).getColumns().size();
            if (nestedColSize <= 1) continue;
            col = col - nestedColSize + 1;
        }
        return col;
    }

    public static void copyTextSelectionToClipboard(TextInputControl textInputControl) {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(textInputControl.getText());
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public static void copyAllCellsToClipboard(TableView tableView) {
        StringBuilder clipboardString = new StringBuilder();
        ObservableList columns = tableView.getColumns();
        for (Object row : tableView.getItems()) {
            for (TableColumn column : columns) {
                clipboardString.append(column.getCellObservableValue(row).getValue()).append(' ');
            }
            clipboardString.delete(clipboardString.length() - 2, clipboardString.length());
            clipboardString.append('\n');
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public static class TableKeyEventHandler
    implements EventHandler<KeyEvent> {
        KeyCodeCombination copyKeyCodeCompination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});

        public void handle(KeyEvent keyEvent) {
            if (this.copyKeyCodeCompination.match(keyEvent) && keyEvent.getSource() instanceof TableView) {
                TableUtils.copyTableSelectionToClipboard((TableView)keyEvent.getSource());
                keyEvent.consume();
            }
        }
    }

    public static class DragSelectionCellFactory<T, C>
    implements Callback<TableColumn<T, C>, TableCell<T, C>> {
        public TableCell<T, C> call(TableColumn<T, C> col) {
            return new DragSelectionCell();
        }
    }

    public static class DragSelectionCell<T, C>
    extends TableCell<T, C> {
        public DragSelectionCell() {
            this.setOnDragDetected(event -> {
                this.startFullDrag();
                this.getTableColumn().getTableView().getSelectionModel().select(this.getIndex(), this.getTableColumn());
            });
            this.setOnMouseDragEntered(event -> this.getTableColumn().getTableView().getSelectionModel().select(this.getIndex(), this.getTableColumn()));
        }

        public void updateItem(C item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
            } else {
                this.setText(ObjectChecker.toStringOrEmpty(item));
            }
        }
    }
}

