/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaTimeField;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.NamaObservable;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTableInfoLine;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.PosTableEntry;
import com.namasoft.pos.util.POSResult;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class TablesInquirmentDialog
extends NamaDialog<ButtonType> {
    private AbsPosSalesScreen screen;
    private NamaTableView<POSTableInfoLine> table = new NamaTableView();
    private GridPane grid = new GridPane();
    private NamaDatePicker date = new NamaDatePicker();
    private NamaTimeField fromTimeField = new NamaTimeField();
    private NamaTimeField toTimeField = new NamaTimeField();
    private DateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public TablesInquirmentDialog(AbsPosSalesScreen hasToolBar) {
        super("tablesInquirment");
        this.screen = hasToolBar;
        double width = hasToolBar.fetchStage().getWidth() / 1.5;
        this.setWidth(width);
        this.setHeight(hasToolBar.fetchStage().getHeight() / 2.0);
        POSTableColumn tableColumn = new POSTableColumn("posTable");
        double colWidth = (width - 50.0) / 6.0;
        tableColumn.setPrefWidth(colWidth);
        tableColumn.setCellValueFactory(p -> new NamaObservable<NamaLabel>(new NamaLabel(((POSTableInfoLine)p.getValue()).getPosTable().getCode() + " - " + ((POSTableInfoLine)p.getValue()).getPosTable().nameByLanguage())));
        POSTableColumn busyDetails = new POSTableColumn("busyDetails");
        busyDetails.setPrefWidth(colWidth * 2.0);
        busyDetails.setCellValueFactory((Callback)new PropertyValueFactory("busyDetails"));
        POSTableColumn reservationDetails = new POSTableColumn("reservationDetails");
        reservationDetails.setPrefWidth(colWidth * 3.0);
        reservationDetails.setCellValueFactory((Callback)new PropertyValueFactory("reservationDetails"));
        this.table.getColumns().addAll((Object[])new TableColumn[]{tableColumn, busyDetails, reservationDetails});
        this.table.setFixedCellSize(40.0);
        HBox hBox = new HBox(5.0);
        NamaLabel dateLabel = new NamaLabel("onDate");
        NamaLabel fromTimeLabel = new NamaLabel("fromTime");
        NamaLabel toTimeLabel = new NamaLabel("toTime");
        Button btn = new Button(POSResourcesUtil.id("tablesInquirment", new Object[0]));
        hBox.getChildren().addAll((Object[])new Node[]{dateLabel, this.date, fromTimeLabel, this.fromTimeField, toTimeLabel, this.toTimeField, btn});
        this.grid.add((Node)hBox, 0, 0);
        this.grid.add(this.table, 0, 1);
        btn.setOnAction(event -> this.inquireForTables());
    }

    public void inquireForTables() {
        ArrayList<POSTableInfoLine> items = new ArrayList<POSTableInfoLine>();
        try {
            Date onDate = (Date)this.date.fetchValue();
            Date fromTime = this.fromTimeField.fetchValue();
            Date toTime = this.toTimeField.fetchValue();
            if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{onDate, fromTime, toTime})) {
                POSResult posResult = new POSResult();
                posResult.failure(POSResourcesUtil.id("please enter date, from time and to time", new Object[0]), new Object[0]);
                POSErrorAndInfoMessagesUtil.showError(posResult, this.screen.fetchStage());
                return;
            }
            HashMap<String, Object> params = POSPersister.params(new Object[0]);
            String query = " WHERE busyTable = :busy or (( reservationFrom > :from OR  reservationFrom = :from) AND (reservationTo < :to OR reservationTo = :to))";
            params.put("from", LocalDateUtils.localDateTimeToDateTime((LocalDateTime)LocalDateUtils.dateToLocalDate((Date)onDate).atTime(LocalDateUtils.dateToLocalTime((Date)fromTime))));
            params.put("to", LocalDateUtils.localDateTimeToDateTime((LocalDateTime)LocalDateUtils.dateToLocalDate((Date)onDate).atTime(LocalDateUtils.dateToLocalTime((Date)toTime))));
            params.put("busy", true);
            List<PosTableEntry> entriesForTable = POSPersister.listAll(PosTableEntry.class, query, params, "");
            if (ObjectChecker.isNotEmptyOrNull(entriesForTable)) {
                for (PosTableEntry e : entriesForTable) {
                    POSTableInfoLine line = items.stream().filter(i -> ObjectChecker.areEqual((Object)i.getPosTable(), (Object)e.getPosTable())).findFirst().orElse(null);
                    if (line == null) {
                        line = new POSTableInfoLine();
                        items.add(line);
                    }
                    line.setPosTable(e.getPosTable());
                    if (e.getBusyTable().booleanValue()) {
                        line.setBusyDetails(line.getBusyDetails() + e.getDocumentCode() + "\n");
                        continue;
                    }
                    if (!ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{e.getReservationFrom(), e.getReservationTo()})) continue;
                    line.setReservationDetails(line.getReservationDetails() + e.getDocumentCode() + " - from: " + this.format.format(e.getReservationFrom()) + " to: " + this.format.format(e.getReservationTo()) + "\n");
                }
            }
            this.table.setItems(FXCollections.observableList(items));
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public void display() {
        this.deleteEndedReservationEntries();
        this.setResizable(true);
        this.getDialogPane().setCenterShape(true);
        this.content((Node)this.grid);
        this.addCancelButton("");
        Optional result = this.showAndWait();
        if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.CANCEL_CLOSE) {
            this.close();
        }
    }

    private void deleteEndedReservationEntries() {
        Date currentDate = new Date();
        List<?> entriesForTable = POSPersister.listAll(PosTableEntry.class, " where reservationTo < :date", POSPersister.params("date", currentDate), "");
        if (ObjectChecker.isEmptyOrNull(entriesForTable)) {
            return;
        }
        entriesForTable.stream().map(POSPersister::delete);
    }
}

