/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.customerwindow;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.customerwindow.CustomerDisplayWindowHeaderBox;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class CustomerDisplayWindowFooterBox
extends NamaHBox {
    public CustomerDisplayWindowFooterBox(AbsPosSalesScreen mainScreen, double windowWidth) {
        this.setId("customer-window-footer");
        InputStream logo = POSResourcesUtil.fetchMainRegister().fetchLogo();
        if (ObjectChecker.isNotEmptyOrNull((Object)logo)) {
            Number logoWidth = (Number)ObjectChecker.getFirstNotEmptyObj((Object[])new Double[]{POSUISettingsUtil.getPosUISettingsOptions().getCustomerDisplayWindowLogoWidth(), windowWidth / 3.0});
            Image img = new Image(logo, logoWidth.doubleValue(), 0.0, true, true);
            ImageView imageView = new ImageView(img);
            imageView.setStyle("-fx-background-color: transparent;-fx-pref-width: " + logoWidth.doubleValue() + "; ");
            this.getChildren().add((Object)imageView);
        }
        GridPane footerFields = new GridPane();
        footerFields.setId("customer-window-footer-fields-grid");
        NamaHBox.setHgrow((Node)footerFields, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(10.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(40.0);
        footerFields.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        List<POSLabeledTextField> fields = this.buildFooterFields(mainScreen);
        int row = 0;
        int col = 0;
        for (int i = 0; i < fields.size(); ++i) {
            footerFields.add((Node)fields.get(i).getLabel(), col, row);
            footerFields.add((Node)fields.get(i).getField(), col + 1, row++);
            if (row % 3 != 0) continue;
            ++col;
        }
        this.getChildren().add((Object)footerFields);
    }

    private List<POSLabeledTextField> buildFooterFields(AbsPosSalesScreen mainScreen) {
        ArrayList<POSLabeledTextField> headerFields = new ArrayList<POSLabeledTextField>();
        for (String field : POSUISettingsUtil.fetchCustomerDisplayWindowFooterFieldsForType(mainScreen.calcEntityType())) {
            POSLabeledTextField label = new POSLabeledTextField(field, mainScreen);
            label.getField().setEditable(false);
            label.getChildren().forEach(n -> n.setStyle(""));
            headerFields.add(label);
            CustomerDisplayWindowHeaderBox.addOnFieldChangeListener(field, mainScreen, label);
        }
        return headerFields;
    }
}

