/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.customerwindow;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSLabeledTextField;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCustomer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class CustomerDisplayWindowHeaderBox
extends NamaVBox {
    private NamaLabel title;
    private NamaLabel date;
    private NamaLabel time;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm a");

    public CustomerDisplayWindowHeaderBox(AbsPosSalesScreen mainScreen) {
        this.setId("customer-window-header");
        this.title = new NamaLabel(POSResourcesUtil.fetchMainRegister().nameByLanguage());
        this.title.setId("customer-window-header-title");
        this.date = new NamaLabel(DATE_FORMAT.format(LocalDate.now()));
        this.time = new NamaLabel(TIME_FORMAT.format(LocalTime.now()));
        NamaHBox registerBox = new NamaHBox(new Node[]{this.title});
        registerBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)registerBox, (Priority)Priority.ALWAYS);
        NamaVBox dateTimeBox = new NamaVBox(new Node[]{this.date, this.time});
        StackPane basicInfoBox = new StackPane(new Node[]{registerBox, dateTimeBox});
        StackPane.setAlignment((Node)dateTimeBox, (Pos)Pos.CENTER_RIGHT);
        GridPane customerInfoBox = new GridPane();
        customerInfoBox.setId("customer-window-header-info-grid");
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(10.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(40.0);
        ColumnConstraints col3 = new ColumnConstraints();
        col3.setPercentWidth(10.0);
        ColumnConstraints col4 = new ColumnConstraints();
        col4.setPercentWidth(40.0);
        customerInfoBox.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3, col4});
        List<POSLabeledTextField> headerFields = this.buildHeaderFields(mainScreen);
        int col = 0;
        int row = 0;
        int i = -1;
        while ((double)row < Math.ceil((double)headerFields.size() / 2.0)) {
            customerInfoBox.add((Node)headerFields.get(++i).getLabel(), col++, row);
            customerInfoBox.add((Node)headerFields.get(i).getField(), col++, row);
            if (headerFields.size() > i + 1) {
                customerInfoBox.add((Node)headerFields.get(++i).getLabel(), col++, row);
                customerInfoBox.add((Node)headerFields.get(i).getField(), col, row);
                col = 0;
            }
            ++row;
        }
        this.getChildren().addAll((Object[])new Node[]{basicInfoBox, customerInfoBox});
    }

    private List<POSLabeledTextField> buildHeaderFields(AbsPosSalesScreen mainScreen) {
        ArrayList<POSLabeledTextField> headerFields = new ArrayList<POSLabeledTextField>();
        for (String field : POSUISettingsUtil.fetchCustomerDisplayWindowHeaderFieldsForType(mainScreen.calcEntityType())) {
            POSLabeledTextField label = new POSLabeledTextField(field, mainScreen);
            label.getField().setEditable(false);
            headerFields.add(label);
            CustomerDisplayWindowHeaderBox.addOnFieldChangeListener(field, mainScreen, label);
        }
        return headerFields;
    }

    public static void addOnFieldChangeListener(String field, AbsPosSalesScreen mainScreen, POSLabeledTextField label) {
        mainScreen.addOnFieldChangedListener(CustomerDisplayWindowHeaderBox.calcMainFieldId(field), CustomerDisplayWindowHeaderBox.calcOnFieldChangedHandlerForField(field, label));
    }

    private static String calcMainFieldId(String field) {
        if (ObjectChecker.isAnyEqualToFirst((Object)field, (Object[])new String[]{"customerCode", "rewardPoints", "phoneNumber"})) {
            return "customer";
        }
        return field;
    }

    private static Consumer<Object> calcOnFieldChangedHandlerForField(String field, POSLabeledTextField label) {
        return v -> {
            try {
                if (v instanceof POSCustomer) {
                    POSCustomer customer = (POSCustomer)v;
                    if (ObjectChecker.areEqual((Object)field, (Object)"customerCode")) {
                        label.setValue(customer.getCode());
                    } else if (ObjectChecker.areEqual((Object)field, (Object)"rewardPoints")) {
                        label.setValue(customer.fetchRemainingRewardPointsInfo(null).getRemainingRewardPoints());
                    } else if (ObjectChecker.areEqual((Object)field, (Object)"phoneNumber")) {
                        label.setValue(customer.getPhoneNumber());
                    } else {
                        label.setValue(customer.nameByLanguage());
                    }
                } else if (v instanceof POSMasterFile) {
                    POSMasterFile file = (POSMasterFile)v;
                    label.setValue(file.nameByLanguage());
                } else {
                    label.setValue(v);
                }
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        };
    }
}

