/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.customerwindow;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.POSScreenSettings;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class CustomerDisplayWindowTableView
extends NamaTableView<AbsPOSSalesLine> {
    public CustomerDisplayWindowTableView(AbsPosSalesScreen mainScreen, Double windowWidth) {
        this.setEditable(false);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        List<String> fields = POSUISettingsUtil.fetchCustomerDisplayWindowTableColumnsForType(mainScreen.calcEntityType());
        if (ObjectChecker.isEmptyOrNull(fields)) {
            return;
        }
        for (String field : fields) {
            POSTableColumn salesTableCol = (POSTableColumn)mainScreen.idsWithCols(field);
            if (salesTableCol == null) continue;
            new TableColumn(field);
            POSTableColumn col = new POSTableColumn(salesTableCol.getLabelId());
            col.setCellFactory(salesTableCol.getCellFactory());
            col.setCellValueFactory(salesTableCol.getCellValueFactory());
            col.setPrefWidth(salesTableCol.getPrefWidth());
            this.getColumns().add(col);
            this.addListenerToCol(mainScreen, field, col, windowWidth / (double)fields.size());
        }
        this.setItems(mainScreen.getSalesTable().getItems());
    }

    private void addListenerToCol(AbsPosSalesScreen mainScreen, String field, POSTableColumn col, double colWidth) {
        String propertyId = "customer_window." + mainScreen.documentType().name() + "." + field;
        col.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (ObjectChecker.areNotEqual((Object)newValue, (Object)oldValue)) {
                POSScreenSettings.getProperties().setProperty(propertyId, newValue.toString());
            }
            POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
        });
        String propertyValue = POSScreenSettings.getProperties().getProperty(propertyId);
        if (ObjectChecker.isNotEmptyOrNull((Object)propertyValue)) {
            col.setPrefWidth(Double.valueOf(propertyValue));
        } else {
            col.setPrefWidth(colWidth);
        }
    }
}

