/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.favouriteitems;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSCompositeFavouriteBtn;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.pos.application.POSUISettingsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class FavouriteItemListPane
extends NamaVBox {
    private TilePane levelBtnsPane;
    private ListView<String> listView;

    public FavouriteItemListPane() {
        this.setId("favourite-item-list-pane");
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.levelBtnsPane = new TilePane();
        this.levelBtnsPane.setId("favourite-items-level-btns-pane");
        this.levelBtnsPane.managedProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.levelBtnsPane.getChildren()));
        this.levelBtnsPane.visibleProperty().bind((ObservableValue)this.levelBtnsPane.managedProperty());
        this.listView = new ListView();
        this.listView.setId("favourite-items-list-view");
        VBox.setVgrow(this.listView, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.listView, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.levelBtnsPane, this.listView});
    }

    public void update(List<? extends POSFavouriteBtn> favouriteButtons) {
        this.levelBtnsPane.getChildren().clear();
        this.levelBtnsPane.getChildren().addAll(favouriteButtons.stream().filter(b -> b instanceof POSCompositeFavouriteBtn).toList());
        this.listView.getItems().clear();
        final Integer favouritesCountPerLine = POSUISettingsUtil.getPosUISettingsOptions().fetchFavouriteItemsCountPerLine();
        final List<POSFavouriteBtn> favouriteItemsButtons = favouriteButtons.stream().filter(b -> ObjectChecker.isFalse((Boolean)(b instanceof POSCompositeFavouriteBtn))).toList();
        int tilesCount = favouriteButtons.size() / favouritesCountPerLine;
        if (favouriteButtons.size() % favouritesCountPerLine != 0) {
            ++tilesCount;
        }
        List list = favouriteItemsButtons.stream().map(Object::toString).collect(Collectors.toList());
        this.listView.getItems().addAll(list.subList(0, (Integer)ObjectChecker.getMinValue((Comparable[])new Integer[]{tilesCount, list.size()})));
        this.listView.setCellFactory(cellData -> new ListCell(){

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                } else {
                    this.setText("");
                    this.setGraphic((Node)FavouriteItemListPane.this.createListViewTile(favouriteItemsButtons, this.getIndex(), favouritesCountPerLine));
                }
            }
        });
    }

    private TilePane createListViewTile(List<? extends POSFavouriteBtn> favouriteButtons, int tileIndex, Integer favouritesCountPerLine) {
        if (tileIndex < 0) {
            return null;
        }
        int startFrom = tileIndex * favouritesCountPerLine;
        if (startFrom >= favouriteButtons.size()) {
            return null;
        }
        TilePane tile = (TilePane)CollectionsUtility.removeFirstOrCreateNewCreator(new ArrayList(), () -> new TilePane(3.0, 3.0)).create();
        tile.setId("favourite-items-list-view-tile");
        tile.getChildren().clear();
        for (int index = startFrom; index < startFrom + favouritesCountPerLine && index < favouriteButtons.size(); ++index) {
            POSFavouriteBtn favouriteBtn = favouriteButtons.get(index);
            tile.getChildren().add((Object)favouriteBtn);
        }
        return tile;
    }
}

