/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.favouriteitems;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSCompositeFavouriteBtn;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.namacontrols.POSNormalFavouriteBtn;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSFixedFavouriteItemsPane;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.application.favouriteitems.FavouriteItemListPane;
import com.namasoft.pos.application.favouriteitems.NamaBreadCrumbBarButton;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.details.POSFavouriteLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.valueobjects.POSFavouriteBtnLevel;
import com.namasoft.pos.util.POSImgUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.BreadCrumbBar;

public class FavouritesContainerBuilder {
    private NamaVBox favContainer;
    private int currentLevel = 0;
    private FavouriteItemListPane favouriteItemListPane;
    private HashMap<UUID, Integer> recordIdsWithLevels;
    private POSLiteMasterFile rootRecord;
    private BreadCrumbBar<POSLiteMasterFile> sampleBreadCrumbBar;
    private NamaTextField filter;
    private NamaTextField qty;
    private List<TreeItem<POSLiteMasterFile>> breadCrumbItems;
    private List<? extends POSFavouriteBtn> currentFavouriteBtns;

    public NamaTextField getQty() {
        return this.qty;
    }

    public NamaVBox createFavouriteBox(AbsPosSalesScreen screen) {
        this.favContainer = new NamaVBox();
        this.favContainer.setId("favourite-items-container");
        NamaVBox.setVgrow((Node)this.favContainer, (Priority)Priority.ALWAYS);
        this.favouriteItemListPane = new FavouriteItemListPane();
        NamaHBox mainContent = new NamaHBox(new Node[]{new POSFixedFavouriteItemsPane(screen), this.favouriteItemListPane});
        VBox.setVgrow((Node)mainContent, (Priority)Priority.ALWAYS);
        this.favContainer.getChildren().addAll((Object[])new Node[]{this.createHeaderBox(screen), mainContent});
        List<POSFavouriteBtn> favouriteButtons = FavouritesContainerBuilder.createFavouriteButtons(screen);
        this.addFavouritesPane(favouriteButtons, null);
        POSSettingsUtil.addStyleSheetFor("css/favouriteitems.css", (Parent)this.favContainer);
        return this.favContainer;
    }

    private NamaVBox createHeaderBox(AbsPosSalesScreen screen) {
        this.createBreadCrumbsBar(screen);
        NamaHBox favouriteItemsFilterPane = new NamaHBox();
        favouriteItemsFilterPane.setId("favourite-items-filter-pane");
        this.filter = new NamaTextField(POSFieldType.Text);
        this.filter.setId("favourite-items-filter");
        this.filter.setPromptText(POSResourcesUtil.id("searchFor", new Object[0]));
        this.filter.textProperty().addListener((observable, oldValue, newValue) -> this.filterButtonsBy((String)newValue));
        this.filter.setLeft((Node)POSImgUtil.createSVGImageView("searchInT.svg"));
        NamaHBox.setHgrow((Node)this.filter, (Priority)Priority.ALWAYS);
        this.qty = new NamaTextField();
        this.qty.setId("favourite-items-qty");
        this.qty.setPromptText(POSResourcesUtil.id("quantity", new Object[0]));
        favouriteItemsFilterPane.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.filter.setPrefWidth(newValue.doubleValue() * 0.7);
            this.qty.setPrefWidth(newValue.doubleValue() * 0.3);
        });
        favouriteItemsFilterPane.getChildren().addAll((Object[])new Node[]{this.filter, this.qty});
        NamaVBox headerBox = new NamaVBox(new Node[]{this.sampleBreadCrumbBar, favouriteItemsFilterPane});
        headerBox.setId("favourite-items-header");
        headerBox.getChildren().forEach(c -> {
            NamaHBox.setHgrow((Node)c, (Priority)Priority.ALWAYS);
            NamaVBox.setVgrow((Node)c, (Priority)Priority.ALWAYS);
        });
        return headerBox;
    }

    private void filterButtonsBy(String textToFilterBy) {
        String textToSearch = ObjectChecker.toStringOrEmpty((Object)textToFilterBy).trim();
        List favouriteBtns = this.currentFavouriteBtns.stream().filter(b -> b.getCurrentRecord().getCode().toLowerCase().contains(textToSearch) || b.getCurrentRecord().getName1().toLowerCase().contains(textToSearch) || b.getCurrentRecord().getName2().toLowerCase().contains(textToSearch)).collect(Collectors.toList());
        this.addFavouritesPane(favouriteBtns, null, false, false);
    }

    private void createBreadCrumbsBar(AbsPosSalesScreen screen) {
        this.sampleBreadCrumbBar = new BreadCrumbBar();
        this.recordIdsWithLevels = new HashMap();
        this.breadCrumbItems = new ArrayList<TreeItem<POSLiteMasterFile>>();
        this.rootRecord = new POSLiteMasterFile(POSUUIDUtil.genUUID(), POSResourcesUtil.idToArabic("mainPage", new Object[0]), POSResourcesUtil.idToEnglish("mainPage", new Object[0]));
        this.recordIdsWithLevels.put(this.rootRecord.getId(), this.currentLevel);
        TreeItem rootItem = new TreeItem((Object)this.rootRecord);
        this.breadCrumbItems.add((TreeItem<POSLiteMasterFile>)rootItem);
        this.sampleBreadCrumbBar.setSelectedCrumb((TreeItem<POSLiteMasterFile>)rootItem);
        this.sampleBreadCrumbBar.setCrumbFactory((Callback<TreeItem<POSLiteMasterFile>, Button>)((Callback)param -> new NamaBreadCrumbBarButton(((POSLiteMasterFile)param.getValue()).getName1(), ((POSLiteMasterFile)param.getValue()).getName2())));
        this.sampleBreadCrumbBar.setOnCrumbAction((EventHandler<BreadCrumbBar.BreadCrumbActionEvent<POSLiteMasterFile>>)((EventHandler)bae -> {
            Integer level;
            POSLiteMasterFile value = (POSLiteMasterFile)bae.getSelectedCrumb().getValue();
            List<POSFavouriteBtn> favouriteButtons = FavouritesContainerBuilder.backBreadCrumbsLevel(value, screen, this.currentLevel, this.breadCrumbItems, this.filter, this.qty, arg_0 -> this.lambda$createBreadCrumbsBar$5(level = this.recordIdsWithLevels.get(value.getId()), arg_0), level);
            if (favouriteButtons != null) {
                this.addFavouritesPane(favouriteButtons, null);
            }
        }));
    }

    public void resetBreadCrumbsBar() {
        TreeItem rootItem = new TreeItem((Object)this.rootRecord);
        this.breadCrumbItems.clear();
        this.breadCrumbItems.add((TreeItem<POSLiteMasterFile>)rootItem);
    }

    public void addToBreadCrumbs(POSLiteMasterFile record, boolean addToBreadCrumbs) {
        if (record == null) {
            return;
        }
        this.filter.clear();
        if (!addToBreadCrumbs) {
            return;
        }
        TreeItem newItem = new TreeItem((Object)record);
        this.addBreadItemToTree(newItem, this.breadCrumbItems.get(0));
        this.sampleBreadCrumbBar.setSelectedCrumb((TreeItem<POSLiteMasterFile>)newItem);
        this.recordIdsWithLevels.put(record.getId(), this.currentLevel);
    }

    public void addBreadItemToTree(TreeItem newItem, TreeItem startFrom) {
        if (ObjectChecker.isEmptyOrNull((Object)startFrom.getChildren())) {
            startFrom.getChildren().add((Object)newItem);
            return;
        }
        this.addBreadItemToTree(newItem, (TreeItem)startFrom.getChildren().get(0));
    }

    public static void removeBreadItemToTree(Integer currentLevel, Integer levelToGoTo, TreeItem node) {
        if (currentLevel == levelToGoTo) {
            node.getChildren().clear();
            return;
        }
        FavouritesContainerBuilder.removeBreadItemToTree(currentLevel + 1, levelToGoTo, (TreeItem)node.getChildren().get(0));
    }

    public void addFavouritesPane(List<? extends POSFavouriteBtn> favouriteButtons, POSLiteMasterFile record) {
        this.addFavouritesPane(favouriteButtons, record, true, true);
    }

    public void addFavouritesPane(List<? extends POSFavouriteBtn> favouriteButtons, POSLiteMasterFile record, boolean setBtnsToCurrent, boolean addToBreadCrumb) {
        if (setBtnsToCurrent) {
            this.currentFavouriteBtns = favouriteButtons;
        }
        this.favouriteItemListPane.update(favouriteButtons);
        if (record != null && addToBreadCrumb) {
            ++this.currentLevel;
        }
        this.addToBreadCrumbs(record, addToBreadCrumb);
    }

    public static List<POSFavouriteBtn> createFavouriteButtons(AbsPosSalesScreen screen) {
        ArrayList<POSFavouriteBtn> favouriteBtns = new ArrayList<POSFavouriteBtn>();
        if (ObjectChecker.isNotEmptyOrNull(POSResourcesUtil.favouriteItems)) {
            for (POSFavouriteLine favouriteItem : POSResourcesUtil.favouriteItems) {
                POSFavouriteBtn favouriteBtn;
                if (ObjectChecker.isNotEmptyOrNull((Object)favouriteItem.getItem())) {
                    favouriteBtn = new POSNormalFavouriteBtn(new POSLiteMasterFile<POSItem>(favouriteItem.getItem()), screen);
                    favouriteBtns.add(favouriteBtn);
                }
                if (!ObjectChecker.isNotEmptyOrNull((Object)favouriteItem.getFavouritesLevel1Id())) continue;
                favouriteBtn = new POSCompositeFavouriteBtn(favouriteItem, screen, POSFavouriteBtnLevel.Level1, null, null);
                favouriteBtns.add(favouriteBtn);
            }
        }
        return favouriteBtns;
    }

    public static List<POSFavouriteBtn> backBreadCrumbsLevel(POSLiteMasterFile file, AbsPosSalesScreen screen, int currentLevel, List<TreeItem<POSLiteMasterFile>> breadCrumbItems, NamaTextField filter, NamaTextField qty, Consumer consumer, int level) {
        if (currentLevel == level) {
            return null;
        }
        if (consumer != null) {
            consumer.accept(null);
        }
        if (breadCrumbItems != null) {
            if (level == 0) {
                breadCrumbItems.get(0).getChildren().clear();
            } else {
                FavouritesContainerBuilder.removeBreadItemToTree(0, level, breadCrumbItems.get(0));
            }
        }
        if (filter != null) {
            filter.clear();
        }
        if (qty != null) {
            qty.clear();
        }
        if (file.getBtn() == null) {
            return FavouritesContainerBuilder.createFavouriteButtons(screen);
        }
        return file.getBtn().fireAddItemsAction(screen);
    }

    public void requestFocus() {
        this.filter.requestFocus();
    }

    private /* synthetic */ void lambda$createBreadCrumbsBar$5(Integer level, Object r) {
        this.currentLevel = level;
    }
}

