/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.favouriteitems;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.pos.application.POSResourcesUtil;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;

public class NamaBreadCrumbBarButton
extends NamaButton {
    private final ObjectProperty<Boolean> first = new SimpleObjectProperty((Object)this, "first");
    private String arabicText;
    private String englishText;

    public NamaBreadCrumbBarButton(String arabicText, String englishText) {
        super(arabicText);
        this.first.set((Object)false);
        this.updateShape();
        this.arabicText = arabicText;
        this.englishText = englishText;
        this.refreshContent();
    }

    private void updateShape() {
        this.setShape((Shape)this.createButtonShape());
    }

    public double getArrowWidth() {
        return 5.0;
    }

    private Path createButtonShape() {
        Path path = new Path();
        MoveTo e1 = new MoveTo(0.0, 0.0);
        path.getElements().add((Object)e1);
        HLineTo e2 = new HLineTo();
        e2.xProperty().bind((ObservableValue)this.widthProperty().subtract(5.0));
        path.getElements().add((Object)e2);
        LineTo e3 = new LineTo();
        e3.xProperty().bind((ObservableValue)e2.xProperty().add(5.0));
        e3.setY(10.0);
        path.getElements().add((Object)e3);
        LineTo e4 = new LineTo();
        e4.xProperty().bind((ObservableValue)e2.xProperty());
        e4.setY(20.0);
        path.getElements().add((Object)e4);
        HLineTo e5 = new HLineTo(0.0);
        path.getElements().add((Object)e5);
        if (!this.getStyleClass().contains((Object)"first")) {
            LineTo e6 = new LineTo(5.0, 10.0);
            path.getElements().add((Object)e6);
        } else {
            ArcTo arcTo = new ArcTo();
            arcTo.setSweepFlag(true);
            arcTo.setX(0.0);
            arcTo.setY(0.0);
            arcTo.setRadiusX(15.0);
            arcTo.setRadiusY(15.0);
            path.getElements().add((Object)arcTo);
        }
        ClosePath e7 = new ClosePath();
        path.getElements().add((Object)e7);
        path.setFill((Paint)Color.BLACK);
        return path;
    }

    @Override
    public void refreshContent() {
        String text = this.arabicText;
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.getCurrentLang(), (Object)Language.English)) {
            text = this.englishText;
        }
        this.setText(text);
    }
}

