/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.priceChecker;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemCode;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSMediaUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;

public class POSPriceChecker {
    private static Label productName;
    private static Label productPrice;
    private static Label productCode;
    private static ImageView productImage;
    private static Label prompt;
    private static Stage stage;
    private static List<Image> images;
    private static int currentIndex;

    public static void draw(Stage primaryStage, BorderPaneCreator iHasToolBar) {
        POSPriceChecker.loadImagesFromFolder();
        stage = primaryStage;
        BorderPane root = new BorderPane();
        root.setStyle("-fx-background-color: #f5f5f5;");
        root.setLeft((Node)POSPriceChecker.createLeftSide());
        root.setCenter((Node)POSPriceChecker.createRightSide(iHasToolBar));
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.setFullScreen(true);
        primaryStage.show();
    }

    private static void loadImagesFromFolder() {
        InputStream logoStream = POSResourcesUtil.fetchMainRegister().fetchLogo();
        Image logo = new Image(logoStream, Screen.getPrimary().getVisualBounds().getWidth() / 2.0, Screen.getPrimary().getVisualBounds().getHeight(), false, true);
        images.add(logo);
        String folderPath = POSGeneralSettings.getPromotionalImagesFolderPath();
        File folder = new File(folderPath);
        if (ObjectChecker.isAnyFalseOrNull((Boolean[])new Boolean[]{folder.exists(), folder.isDirectory()})) {
            return;
        }
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !POSPriceChecker.isImageFile(file)) continue;
            images.add(new Image(file.toURI().toString(), Screen.getPrimary().getVisualBounds().getWidth() / 2.0, Screen.getPrimary().getVisualBounds().getHeight(), false, true));
        }
    }

    private static boolean isImageFile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif");
    }

    private static Pane createLeftSide() {
        NamaVBox header = new NamaVBox();
        header.setPadding(new Insets(15.0, 10.0, 0.0, 10.0));
        header.setStyle("-fx-background-color: #2c3e50;-fx-border-width: 1");
        ImageView imageView = new ImageView();
        imageView.setPreserveRatio(true);
        if (!images.isEmpty()) {
            imageView.setImage(images.get(0));
        }
        if (images.size() > 1) {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)3.0), e -> {
                currentIndex = (currentIndex + 1) % images.size();
                imageView.setImage(images.get(currentIndex));
            }, new KeyValue[0])});
            timeline.setCycleCount(-1);
            timeline.play();
        }
        header.getChildren().addAll((Object[])new Node[]{imageView});
        return header;
    }

    private static Pane createRightSide(BorderPaneCreator hasToolBar) {
        NamaVBox productBox = new NamaVBox(20);
        productBox.setPadding(new Insets(30.0));
        productBox.setAlignment(Pos.TOP_CENTER);
        productImage = new ImageView();
        productImage.setPreserveRatio(true);
        prompt = new NamaLabel(POSResourcesUtil.id("Please Scan Or Enter Barcode", new Object[0]));
        prompt.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)28.0));
        prompt.setTextFill((Paint)Color.DARKRED);
        productName = new NamaLabel();
        productName.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)28.0));
        productName.setTextFill((Paint)Color.DARKRED);
        productPrice = new NamaLabel();
        productPrice.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)36.0));
        productPrice.setTextFill((Paint)Color.DARKGREEN);
        productCode = new NamaLabel();
        productCode.setFont(Font.font((String)"Arial", (double)40.0));
        productBox.getChildren().addAll((Object[])new Node[]{POSPriceChecker.createItemSearchField(hasToolBar), prompt, productImage, productCode, productName, productPrice});
        return productBox;
    }

    private static NamaHBox createItemSearchField(BorderPaneCreator hasToolBar) {
        NamaHBox bottomPanel = new NamaHBox(20);
        bottomPanel.setPadding(new Insets(20.0));
        bottomPanel.setStyle("-fx-background-color: #ecf0f1;");
        bottomPanel.setAlignment(Pos.CENTER);
        TextField itemBarcodeField = new TextField();
        itemBarcodeField.setPromptText(POSResourcesUtil.id("Scan or enter barcode...", new Object[0]));
        itemBarcodeField.setFont(Font.font((String)"Arial", (double)18.0));
        itemBarcodeField.setPrefWidth(300.0);
        itemBarcodeField.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)itemBarcodeField, (Priority)Priority.ALWAYS);
        itemBarcodeField.setOnKeyReleased(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            String text = itemBarcodeField.getText();
            POSPriceChecker.clear(itemBarcodeField);
            POSPriceChecker.checkPrice(text);
            itemBarcodeField.clear();
            itemBarcodeField.setPromptText(POSResourcesUtil.id("Please Scan Or Enter Barcode", new Object[0]));
        });
        NamaButton toPOS = new NamaButton("POS");
        toPOS.setOnAction(e -> hasToolBar.exitToLoginScreen(stage));
        bottomPanel.getChildren().addAll((Object[])new Node[]{itemBarcodeField});
        return bottomPanel;
    }

    private static void clear(TextField barcodeField) {
        barcodeField.clear();
        prompt.setText("");
        productImage.setImage(null);
        productName.setText("");
        productCode.setText("");
        productPrice.setText("");
    }

    private static void checkPrice(String barcode) {
        Image image;
        POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, barcode);
        if (ObjectChecker.isEmptyOrNull((Object)posItemCode)) {
            POSMediaUtil.playItemNotFoundSound();
            prompt.setText(POSResourcesUtil.id("Not Found", new Object[0]));
            prompt.setTextFill((Paint)Color.RED);
            return;
        }
        POSItem item = posItemCode.fetchItem();
        if (item.isHasImage().booleanValue() && (image = POSTotalsShowPanel.fetchItemImageIntoView_(item.getId().toString(), item.calcNamaEntityType(), 200, item.getCode(), img -> {})) != null) {
            productImage.setImage(image);
        }
        productName.setText(item.nameByLanguage());
        productCode.setText(barcode);
        productPrice.setText(ObjectChecker.toStringOrEmpty((Object)posItemCode.getCurrentPrice()) + " - " + POSResourcesUtil.fetchMainRegister().fetchCurrency().nameByLanguage());
    }

    static {
        images = new ArrayList<Image>();
        currentIndex = 0;
    }
}

