/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.toolbar.IPOSToolBar;
import com.namasoft.pos.application.toolbar.POSSalesScreenButtonsBox;
import com.namasoft.pos.application.toolbar.POSTitleBar;
import com.namasoft.pos.application.toolbar.POSToolbarFavouriteDocsBox;
import com.namasoft.pos.application.toolbar.POSToolbarHomePane;
import com.namasoft.pos.domain.POSMasterFile;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;

public class POSNewToolBar<T extends POSMasterFile>
extends ToolBar
implements IPOSToolBar {
    private NamaVBox toolBarRoot;
    private POSTitleBar titleBar;
    private NamaHBox toolBarHeader;
    private ScrollPane toolBarContent;
    private NamaButton homeBtn;
    private NamaButton commonCommandsBtn;
    private NamaButton favouriteDocsBtn;
    private POSToolbarHomePane homeBox;
    private POSSalesScreenButtonsBox commonCommandsBox;
    private POSToolbarFavouriteDocsBox favouriteDocsBox;
    private IHasToolBar hasToolBar;

    public POSNewToolBar(IHasToolBar hasToolBar) {
        this.setId("new-tool-bar");
        this.hasToolBar = hasToolBar;
        this.toolBarRoot = new NamaVBox();
        this.toolBarRoot.setId("tool-bar-root");
        NamaHBox.setHgrow((Node)this.toolBarRoot, (Priority)Priority.ALWAYS);
        this.titleBar = new POSTitleBar(hasToolBar);
        this.toolBarHeader = new NamaHBox();
        this.toolBarHeader.getStyleClass().add((Object)"tool-bar-header");
        if (ObjectChecker.isAnyEqualToFirst((Object)((Object)hasToolBar.documentType()), (Object[])new POSDocumentType[]{POSDocumentType.Return, POSDocumentType.Replacement})) {
            this.toolBarHeader.getStyleClass().add((Object)"return-replacement-tool-bar-header");
        }
        this.toolBarContent = new ScrollPane();
        this.toolBarContent.getStyleClass().add((Object)"tool-bar-content");
        this.toolBarContent.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.toolBarContent.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.toolBarContent.setPrefViewportWidth(this.toolBarRoot.getPrefWidth());
        this.toolBarContent.setFitToWidth(true);
        this.toolBarContent.setFitToHeight(true);
        this.constructToolBarHeader();
        this.constructToolBarContent();
        this.setNodeOrientation(POSResourcesUtil.getOrientation());
        this.toolBarRoot.getChildren().addAll((Object[])new Node[]{this.titleBar, this.toolBarHeader, new Separator(), this.toolBarContent});
        this.getItems().addAll((Object[])new Node[]{this.toolBarRoot});
        POSSettingsUtil.addStyleSheetFor("css/toolbar.css", (Parent)this);
    }

    private void constructToolBarHeader() {
        this.homeBtn = new NamaButton("home");
        this.homeBtn.getStyleClass().add((Object)"active-button");
        this.homeBtn.setOnAction(e -> this.updateToolBar((Node)this.homeBox, this.homeBtn));
        this.commonCommandsBtn = new NamaButton("shortCuts");
        this.commonCommandsBtn.setOnAction(e -> this.updateToolBar((Node)this.commonCommandsBox, this.commonCommandsBtn));
        this.favouriteDocsBtn = new NamaButton("favouriteDocuments");
        this.favouriteDocsBtn.setOnAction(e -> this.updateToolBar((Node)this.favouriteDocsBox, this.favouriteDocsBtn));
        this.toolBarHeader.getChildren().clear();
        this.toolBarHeader.getChildren().addAll((Object[])new Node[]{this.homeBtn, this.commonCommandsBtn, this.favouriteDocsBtn});
    }

    private void updateToolBar(Node node, Button button) {
        this.homeBtn.getStyleClass().remove((Object)"active-button");
        this.commonCommandsBtn.getStyleClass().remove((Object)"active-button");
        this.favouriteDocsBtn.getStyleClass().remove((Object)"active-button");
        if (ObjectChecker.areEqual((Object)this.toolBarContent.getContent(), (Object)node) && this.toolBarContent.isVisible()) {
            this.toolBarContent.setVisible(false);
            return;
        }
        this.toolBarContent.setContent(node);
        this.toolBarContent.setVisible(true);
        button.getStyleClass().add((Object)"active-button");
    }

    private void constructToolBarContent() {
        this.toolBarContent.managedProperty().bind((ObservableValue)this.toolBarContent.visibleProperty());
        this.homeBox = new POSToolbarHomePane(this.hasToolBar);
        this.commonCommandsBox = new POSSalesScreenButtonsBox();
        this.commonCommandsBox.createButtonsBox(this.hasToolBar);
        this.favouriteDocsBox = new POSToolbarFavouriteDocsBox(this.hasToolBar);
        this.toolBarContent.setContent((Node)this.homeBox);
    }

    @Override
    public void refreshLangBox(boolean toLoginScreen) {
    }

    @Override
    public <T extends POSMasterFile> void updateInformation(T doc) {
        this.titleBar.refresh();
        this.refreshToolBarContent();
    }

    private void refreshToolBarContent() {
        this.homeBox.refresh();
        this.favouriteDocsBox.refresh();
    }

    @Override
    public void resetElapsedTimeFromLastConnection() {
        this.titleBar.resetElapsedTimeFromLastConnection();
    }

    public void updateNotificationCount() {
        this.titleBar.updateNotificationCount();
    }
}

