/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.StopwatchController;
import com.namasoft.pos.application.BorderPaneCreator;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSNotificationsDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSDataWriterUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.Duration;

public class POSTitleBar
extends NamaHBox {
    private NamaLabel currentUserLabel = new NamaLabel();
    private StopwatchController elapsedTimeFromLastConnection = new StopwatchController();
    private NamaLabel dateTimeLabel = new NamaLabel();
    private NamaLabel shiftCodeLabel = new NamaLabel();
    private NamaLabel titleLabel;
    private NamaButton notificationBtn;
    private NamaLabel notificationCountLabel;

    public POSTitleBar(IHasToolBar hasToolBar) {
        this.setId("title-bar");
        NamaHBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.createUserAndDateBox());
        this.getChildren().add((Object)this.createTitleLabel(hasToolBar));
        this.getChildren().add((Object)this.createNotificationIcon());
        this.getChildren().add((Object)BorderPaneCreator.createMenuIcon(hasToolBar));
    }

    private Pane createUserAndDateBox() {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (currentUser != null) {
            this.currentUserLabel.setText(currentUser.nameByLanguage());
        }
        this.elapsedTimeFromLastConnection.start();
        this.dateTimeLabel.setText(new SimpleDateFormat("MM/dd/yyyy , hh:mm a").format(new Date()));
        this.dateTimeLabel.setId("date-time-label");
        NamaHBox container = new NamaHBox(new Node[]{this.currentUserLabel, this.elapsedTimeFromLastConnection});
        container.setSpacing(5.0);
        NamaVBox userAndDateBox = new NamaVBox(new Node[]{container, this.dateTimeLabel, this.shiftCodeLabel});
        userAndDateBox.setId("user-and-date-box");
        return userAndDateBox;
    }

    private Label createTitleLabel(IHasToolBar hasToolBar) {
        this.titleLabel = new NamaLabel(hasToolBar.screenTitle());
        this.titleLabel.setId("title-label");
        NamaHBox.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        POSTooltip tooltip = new POSTooltip(POSResourcesUtil.calcAppVersion());
        this.titleLabel.setOnMouseEntered(e -> {
            tooltip.show((Node)this.titleLabel, e.getScreenX(), e.getScreenY());
            KeyFrame hideTooltip = new KeyFrame(Duration.seconds((double)4.0), l -> tooltip.hide(), new KeyValue[0]);
            Timeline timeline = new Timeline(new KeyFrame[]{hideTooltip});
            Platform.runLater(() -> ((Timeline)timeline).play());
        });
        return this.titleLabel;
    }

    public void refresh() {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        if (currentUser != null) {
            this.currentUserLabel.setText(currentUser.nameByLanguage());
        }
        this.dateTimeLabel.setText(new SimpleDateFormat("MM/dd/yyyy , hh:mm a").format(new Date()));
        this.shiftCodeLabel.setText(POSResourcesUtil.id("shiftCode", new Object[0]) + ": " + (POSResourcesUtil.fetchLastOpenShift() == null ? POSResourcesUtil.id("notFound", new Object[0]) : POSResourcesUtil.fetchLastOpenShift().getCode()));
        this.updateNotificationCount();
    }

    public void resetElapsedTimeFromLastConnection() {
        this.elapsedTimeFromLastConnection.reset();
    }

    private NamaButton createNotificationIcon() {
        this.notificationBtn = new NamaButton();
        this.notificationBtn.setId("notification-button");
        this.notificationBtn.setTooltip(new POSTooltip("notifications"));
        this.notificationBtn.setOnAction(e -> {
            POSNotificationsDialog dialog = new POSNotificationsDialog(POSResourcesUtil.fetchCurrentScreenStage());
            dialog.setOnCloseRequest(event -> this.updateNotificationCount());
            dialog.showDialog();
        });
        Path bellBody = new Path();
        bellBody.getStyleClass().add((Object)"notification-path");
        bellBody.getElements().addAll((Object[])new PathElement[]{new MoveTo(16.0, 10.0), new LineTo(14.0, 10.0), new LineTo(12.0, 12.0), new LineTo(12.0, 18.0), new LineTo(10.0, 20.0), new LineTo(10.0, 22.0), new LineTo(22.0, 22.0), new LineTo(22.0, 20.0), new LineTo(20.0, 18.0), new LineTo(20.0, 12.0), new LineTo(18.0, 10.0), new LineTo(16.0, 10.0), new ClosePath()});
        Circle clapper = new Circle(16.0, 24.0, 1.5);
        clapper.getStyleClass().add((Object)"notification-path");
        Group iconGroup = new Group(new Node[]{bellBody, clapper});
        this.notificationCountLabel = new NamaLabel();
        this.notificationCountLabel.setId("notification-count-badge");
        this.notificationCountLabel.setVisible(false);
        this.notificationCountLabel.setManaged(false);
        Platform.runLater(this::updateNotificationCount);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{iconGroup, this.notificationCountLabel});
        StackPane.setAlignment((Node)this.notificationCountLabel, (Pos)Pos.TOP_RIGHT);
        this.notificationBtn.setGraphic((Node)stackPane);
        return this.notificationBtn;
    }

    public void updateNotificationCount() {
        int count = POSDataWriterUtil.notifications.size();
        if (count > 0) {
            this.notificationCountLabel.setText(String.valueOf(count > 99 ? "99+" : Integer.valueOf(count)));
            if (!this.notificationCountLabel.isVisible()) {
                this.notificationCountLabel.setVisible(true);
            }
            if (!this.notificationCountLabel.isManaged()) {
                this.notificationCountLabel.setManaged(true);
            }
        } else {
            if (this.notificationCountLabel.isVisible()) {
                this.notificationCountLabel.setVisible(false);
            }
            if (this.notificationCountLabel.isManaged()) {
                this.notificationCountLabel.setManaged(false);
            }
        }
    }
}

