/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application.toolbar;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.KeyPadButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSInvoiceType;
import com.namasoft.pos.application.POSLockDialog;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.util.CashDrawerUtil;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.upgrader.Platform;
import java.io.File;
import java.io.IOException;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Priority;

public class POSToolbarHomePane
extends NamaHBox {
    private KeyPadButton lockBtn;
    private KeyPadButton listHeldInvoices;
    private KeyPadButton calculatorBtn;
    private KeyPadButton keyBoardBtn;
    private KeyPadButton cashDrawerBtn;
    private KeyPadButton discBtn;
    private KeyPadButton holdBtn;
    private KeyPadButton numbersPad;
    private KeyPadButton payInvoiceBtn;
    private KeyPadButton saveBtn;
    private KeyPadButton switchFavoriteAndHeaderViewBtn;

    public POSToolbarHomePane(IHasToolBar hasToolBar) {
        POSNewSalesScreen salesScreen;
        this.setId("tool-bar-home-pane");
        NamaHBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        Class<?> klass = ((AbsPosSalesScreen)hasToolBar).fetchDocumentClass();
        this.switchFavoriteAndHeaderViewBtn = new KeyPadButton("");
        this.switchFavoriteAndHeaderViewBtn.getStyleClass().add((Object)"switch-favorite-and-header-view-btn");
        if (ObjectChecker.isAnyEqualToFirst((Object)((Object)hasToolBar.documentType()), (Object[])new POSDocumentType[]{POSDocumentType.Return, POSDocumentType.Replacement})) {
            this.switchFavoriteAndHeaderViewBtn.getStyleClass().add((Object)"return-replacement-switch-favorite-and-header-view-btn");
        }
        this.switchFavoriteAndHeaderViewBtn.setTooltip(new POSTooltip("invoiceData"));
        this.updateBtnImgOrText("invoice-data.svg", this.switchFavoriteAndHeaderViewBtn);
        if (hasToolBar instanceof POSNewSalesScreen && ObjectChecker.isFalseOrNull((Boolean)(salesScreen = (POSNewSalesScreen)hasToolBar).doNotAddFavourites())) {
            ((POSTooltip)this.switchFavoriteAndHeaderViewBtn.getTooltip()).setOriginalText("favouriteItems");
            this.updateBtnImgOrText("favouriteItems.svg", this.switchFavoriteAndHeaderViewBtn);
            this.switchFavoriteAndHeaderViewBtn.setOnAction(arg0 -> {
                String fieldId = salesScreen.switchFavoriteAndHeaderView();
                ((POSTooltip)this.switchFavoriteAndHeaderViewBtn.getTooltip()).setOriginalText(fieldId);
                if (ObjectChecker.areEqual((Object)fieldId, (Object)"invoiceData")) {
                    this.updateBtnImgOrText("invoice-data.svg", this.switchFavoriteAndHeaderViewBtn);
                } else {
                    this.updateBtnImgOrText("favouriteItems.svg", this.switchFavoriteAndHeaderViewBtn);
                }
            });
        }
        this.getChildren().add((Object)this.switchFavoriteAndHeaderViewBtn);
        if (((AbsPosSalesScreen)hasToolBar).stockTransferOrTaking() || ((AbsPosSalesScreen)hasToolBar).reservationWithoutPayment() || ((AbsPosSalesScreen)hasToolBar).isStockReceipt() || ((AbsPosSalesScreen)hasToolBar).isShortfallsOrScrap()) {
            this.saveBtn = ((AbsPosSalesScreen)hasToolBar).createStockTransferReqSaveBtn();
            this.saveBtn.setTooltip(new POSTooltip("save"));
            this.updateBtnImgOrText("save.svg", this.saveBtn);
            this.getChildren().add((Object)this.saveBtn);
        } else if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchMainRegister().getCallCenterMode())) {
            this.payInvoiceBtn = new KeyPadButton("");
            this.payInvoiceBtn.setTooltip(new POSTooltip(POSResourcesUtil.id("payment", new Object[0]) + " - F5"));
            this.payInvoiceBtn.setOnAction(e -> PosScene.invPayAction(hasToolBar, true));
            this.updateBtnImgOrText("pay.svg", this.payInvoiceBtn);
            this.getChildren().add((Object)this.payInvoiceBtn);
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanUseCalculator).isSucceeded().booleanValue()) {
            this.calculatorBtn = new KeyPadButton("");
            this.calculatorBtn.setTooltip(new POSTooltip("calculator"));
            this.updateBtnImgOrText("calculator.svg", this.calculatorBtn);
            this.calculatorBtn.setOnAction(event -> {
                try {
                    Runtime.getRuntime().exec("calc");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.getChildren().add((Object)this.calculatorBtn);
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanUseKeyBoard).isSucceeded().booleanValue()) {
            this.keyBoardBtn = new KeyPadButton("");
            this.keyBoardBtn.setTooltip(new POSTooltip("keyBoard"));
            this.updateBtnImgOrText("keyboard.svg", this.keyBoardBtn);
            this.keyBoardBtn.setOnAction(event -> {
                try {
                    Runtime.getRuntime().exec("cmd /c C:\\Windows\\System32\\osk.exe");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.getChildren().add((Object)this.keyBoardBtn);
        }
        this.discBtn = new KeyPadButton("");
        this.discBtn.setTooltip(new POSTooltip(POSResourcesUtil.id(klass, "Discount") + " - F10"));
        this.updateBtnImgOrText("discount.svg", this.discBtn);
        this.discBtn.setOnAction(event -> ((AbsPosSalesScreen)hasToolBar).discountAction());
        this.lockBtn = new KeyPadButton("");
        this.lockBtn.setTooltip(new POSTooltip(POSResourcesUtil.id(klass, "lock") + " - F11"));
        this.updateBtnImgOrText("lock.svg", this.lockBtn);
        this.lockBtn.setOnAction(arg0 -> new POSLockDialog(hasToolBar));
        this.getChildren().addAll((Object[])new Node[]{this.discBtn, this.lockBtn});
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanHoldInvoice).isSucceeded().booleanValue()) {
            this.holdBtn = new KeyPadButton("");
            this.holdBtn.setTooltip(new POSTooltip(POSResourcesUtil.id(klass, "Hold") + " - F6"));
            this.updateBtnImgOrText("hold.svg", this.holdBtn);
            this.holdBtn.setOnAction(event -> ((AbsPosSalesScreen)hasToolBar).holdInvoice());
            this.getChildren().add((Object)this.holdBtn);
        }
        this.listHeldInvoices = new KeyPadButton("");
        this.listHeldInvoices.setTooltip(new POSTooltip("listHoldInvoices"));
        this.updateBtnImgOrText("listHeldInvoice.svg", this.listHeldInvoices);
        this.listHeldInvoices.setOnAction(e -> ((AbsPosSalesScreen)hasToolBar).showListOfFeaturedInvoices(POSInvoiceType.Hold));
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanOpenCashDrawer).isSucceeded().booleanValue()) {
            this.cashDrawerBtn = new KeyPadButton("");
            this.cashDrawerBtn.setTooltip(new POSTooltip("openCloseLocker"));
            this.updateBtnImgOrText("cashDrawer.svg", this.cashDrawerBtn);
            this.cashDrawerBtn.setOnAction(e -> CashDrawerUtil.openDrawer());
            this.getChildren().add((Object)this.cashDrawerBtn);
        }
        this.numbersPad = new KeyPadButton("");
        this.numbersPad.setTooltip(new POSTooltip("numbersPad"));
        this.updateBtnImgOrText("numbers-pad.svg", this.numbersPad);
        this.numbersPad.setOnAction(arg0 -> ((AbsPosSalesScreen)hasToolBar).changeNumbersPadVisibility());
        this.getChildren().addAll((Object[])new Node[]{this.listHeldInvoices, this.numbersPad});
        if (Platform.isInDebugMode()) {
            Button reloadCSS = new Button("Reload CSS");
            reloadCSS.setOnAction(event -> {
                this.getStylesheets().clear();
                this.getStylesheets().add((Object)new File("src/main/resources/application.css").getAbsolutePath());
            });
            this.getChildren().add((Object)reloadCSS);
        }
    }

    public void updateBtnImgOrText(String img, KeyPadButton btn) {
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getShortcutImgBtnsToTextBtns()) || ObjectChecker.isEmptyOrNull((Object)img)) {
            btn.setOriginalText(btn.getTooltip().getText());
            POSSettingsUtil.setFonts(POSScreenSettings.getTextFieldsFont(), ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{btn});
            return;
        }
        btn.setOriginalText("");
        btn.setSVGIcon(img);
        btn.setId("has-icon");
    }

    public void refresh() {
        this.refresh(POSResourcesUtil.id("lock", new Object[0]) + " - F11", this.lockBtn);
        this.refresh("listHoldInvoices", this.listHeldInvoices);
        this.refresh("calculator", this.calculatorBtn);
        this.refresh("keyBoard", this.keyBoardBtn);
        this.refresh("openCloseLocker", this.cashDrawerBtn);
        this.refresh(POSResourcesUtil.id("Discount", new Object[0]) + " - F10", this.discBtn);
        this.refresh(POSResourcesUtil.id("Hold", new Object[0]) + " - F6", this.holdBtn);
        this.refresh("numbersPad", this.numbersPad);
        this.refresh(POSResourcesUtil.id("payment", new Object[0]) + " - F5", this.payInvoiceBtn);
        this.refresh(this.switchFavoriteAndHeaderViewBtn.getOriginalText(), this.switchFavoriteAndHeaderViewBtn);
        this.refresh("save", this.saveBtn);
    }

    private void refresh(String text, Button btn) {
        if (btn == null) {
            return;
        }
        btn.getTooltip().setText(POSResourcesUtil.id(text, new Object[0]));
        if (ObjectChecker.isNotEmptyOrNull((Object)btn.getText())) {
            btn.setText(POSResourcesUtil.id(text, new Object[0]));
        }
    }
}

