/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.POSInvoiceTableLine;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSTable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.UUID;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class MobileDTOInvTableLine
implements Serializable {
    private UUID tableId;
    private String tableCode;
    private String tableName1;
    private String tableName2;

    public static MobileDTOInvTableLine fromNormalLine(POSInvoiceTableLine salesInvoiceLine) {
        MobileDTOInvTableLine line = new MobileDTOInvTableLine();
        POSTable posTable = salesInvoiceLine.getPosTable();
        line.setTableId(posTable.getId());
        line.setTableCode(posTable.getCode());
        line.setTableName1(posTable.getName1());
        line.setTableName2(posTable.getName2());
        return line;
    }

    public String getTableCode() {
        return this.tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getTableName1() {
        return this.tableName1;
    }

    public void setTableName1(String tableName1) {
        this.tableName1 = tableName1;
    }

    public String getTableName2() {
        return this.tableName2;
    }

    public void setTableName2(String tableName2) {
        this.tableName2 = tableName2;
    }

    public UUID getTableId() {
        return this.tableId;
    }

    public void setTableId(UUID tableId) {
        this.tableId = tableId;
    }

    public POSInvoiceTableLine toActualInvTableLine(POSSalesInvoice salesInvoice) {
        POSInvoiceTableLine invoiceLine = new POSInvoiceTableLine();
        invoiceLine.assignIds();
        invoiceLine.setPosTable(POSPersister.findByID(POSTable.class, this.getTableId()));
        invoiceLine.setInvoice(salesInvoice);
        return invoiceLine;
    }
}

