/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.namasoft.common.flatobjects.GenericValue;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTONamaRewardInfo;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceMoney;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.namapos.contracts.common.GeneratedDTOPOSConfiguration;
import com.namasoft.modules.namapos.enums.POSSalesHeaderField;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.namapos.enums.POSSpecDimsDisplayType;
import com.namasoft.modules.namapos.enums.PosSalesGridField;
import com.namasoft.namacontrols.NamaPOSSearchDialog;
import com.namasoft.namacontrols.POSCompositeFavouriteBtn;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.namacontrols.POSHallButton;
import com.namasoft.namacontrols.POSHallsTablesButton;
import com.namasoft.namacontrols.POSNormalFavouriteBtn;
import com.namasoft.namacontrols.POSTableButton;
import com.namasoft.pos.PGW.NearPay;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSTotalsShowPanel;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.application.PosAdditionalItemsDialog;
import com.namasoft.pos.application.PosAdditionalItemsGroupPane;
import com.namasoft.pos.application.PosPrepFormPrintTime;
import com.namasoft.pos.application.favouriteitems.FavouritesContainerBuilder;
import com.namasoft.pos.controllers.MobileCompositePOSFavouriteBtn;
import com.namasoft.pos.controllers.MobileDTOAbsPOSShiftLine;
import com.namasoft.pos.controllers.MobileDTOExtraCodeDetailsLine;
import com.namasoft.pos.controllers.MobileDTOFieldsInfoLine;
import com.namasoft.pos.controllers.MobileDTOInvoice;
import com.namasoft.pos.controllers.MobileDTOPOSShift;
import com.namasoft.pos.controllers.MobileDTOPOSUser;
import com.namasoft.pos.controllers.MobileDTOPaymentInfo;
import com.namasoft.pos.controllers.MobileDTOPaymentMethod;
import com.namasoft.pos.controllers.MobileDTOPaymentScreen;
import com.namasoft.pos.controllers.MobileDTOSearchResult;
import com.namasoft.pos.controllers.MobilePOSLiteMasterFile;
import com.namasoft.pos.controllers.MobilePOSMasterFileBaseDTO;
import com.namasoft.pos.controllers.MobilePOSNormalFavouriteBtn;
import com.namasoft.pos.controllers.MobilePOSResult;
import com.namasoft.pos.controllers.MobilePOSTableBtn;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.PosMobileUISettings;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.details.POSFieldFormatLine;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSCustomerCategory;
import com.namasoft.pos.domain.entities.POSCustomerClass;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSGenericReferenceOverrider;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemCode;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import com.namasoft.pos.orm.POSEntityMediator;
import com.namasoft.pos.util.LoginUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSInvoicesService;
import com.namasoft.pos.util.POSPaymentMethodsUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSRewardPointsUtil;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSShiftInventoryService;
import com.namasoft.pos.util.PayRequest;
import com.namasoft.pos.util.PosSalesUtil;
import com.namasoft.pos.util.ValidateDocRequest;
import jakarta.annotation.PostConstruct;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MobileInvoicesController {
    public static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private Map<String, Function<POSMobileActionRequest, POSResult>> actions = new HashMap<String, Function<POSMobileActionRequest, POSResult>>();
    private static Map<String, HashMap<String, Object>> uiConfiguration = new HashMap<String, HashMap<String, Object>>();
    private static final Object lock = new Object();
    private static List<MobileDTOExtraCodeDetailsLine> extraCodeLines = null;

    public static Date parseDate(String value) {
        LocalDate ld = LocalDate.parse(value, DATE_FORMAT);
        return Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date parseTime(String value) {
        LocalTime lt = LocalTime.parse(value, TIME_FORMAT);
        return Date.from(lt.atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.systemDefault()).toInstant());
    }

    @PostConstruct
    public void init() {
        this.actions = new HashMap<String, Function<POSMobileActionRequest, POSResult>>();
        this.actions.put("itemData", this::itemDataAction);
        this.actions.put("lineQty", this::lineQtyAction);
        this.actions.put("lineUnitPrice", this::lineUnitPriceAction);
        this.actions.put("lineDisc1Percent", this::lineDisc1PAction);
        this.actions.put("lineDisc2Percent", this::lineDisc2PAction);
        this.actions.put("lineDisc1Value", this::lineDisc1VAction);
        this.actions.put("lineDisc2Value", this::lineDisc2VAction);
        this.actions.put("lineTax1Percent", this::lineTax1PAction);
        this.actions.put("lineTax1Value", this::lineTax1VAction);
        this.actions.put("lineTax2Percent", this::lineTax2PAction);
        this.actions.put("lineTax2Value", this::lineTax2VAction);
        this.actions.put("uomCode", this::uomCode);
        this.actions.put("freeItem", this::freeItem);
        this.actions.put("warehouseIssue", this::warehouseIssueAction);
        this.actions.put("updateCustomer", this::updateCustomer);
        this.actions.put("updateInvoiceClassification", this::updateInvoiceClassification);
    }

    private POSResult freeItem(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        Boolean free = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? false : Boolean.valueOf(request.body.get("val").toString());
        request.salesInvoice.fetchDetails().get(lineNumber).setFreeLine(free);
        request.salesInvoice.updateTotals(null);
        return new POSResult();
    }

    private POSResult uomCode(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        request.salesInvoice.calcUnitPriceAndFreeLines(request.register, request.salesInvoice.fetchDetails().get(lineNumber), false, null);
        return new POSResult();
    }

    private POSResult itemDataAction(POSMobileActionRequest request) {
        String itemCode = (String)request.body.get("val");
        int lineNumber = (Integer)request.body.get("lineNumber");
        String unitId = (String)request.body.get("unitId");
        POSSalesInvoice salesInvoice = request.salesInvoice;
        BigDecimal qty = request.body.get("qty") == null ? BigDecimal.ZERO : BigDecimal.valueOf((Double)request.body.get("qty"));
        POSResult result = salesInvoice.itemCodeEvent(request.register, itemCode, lineNumber, null, null, qty, unitId);
        if (result.isSucceeded().booleanValue() && salesInvoice.fetchDetails().size() > lineNumber) {
            AbsPOSSalesLine addedLine = salesInvoice.fetchDetails().get(lineNumber);
            if (addedLine == null) {
                return result;
            }
            String base64Image = this.fetchItemImageAsBase64(addedLine.getItem().getId().toString(), itemCode);
            addedLine.setItemImageAsBase64(base64Image);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchItemImageAsBase64(String itemId, String itemCode) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            File imageFile = POSTotalsShowPanel.fetchCachedItemImageFile(itemId, itemCode, 250);
            if (imageFile == null) {
                String string = null;
                return string;
            }
            ImageIO.write((RenderedImage)ImageIO.read(imageFile), "png", outputStream);
            byte[] imageBytes = outputStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
        catch (IIOException e) {
            POSTotalsShowPanel.fetchImageFromServer(null, "", itemId, "InvItem", itemCode, 250);
            return this.fetchItemImageAsBase64(itemId, itemCode);
        }
        catch (Exception e) {
            NaMaLogger.error((Object)("Error fetching item image as base64 for item: " + itemId), (Throwable)e);
            return null;
        }
    }

    private POSResult lineQtyAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal qty = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPosSalesScreen.lineQtyEvent(request.register, qty, line, request.salesInvoice, null);
        return new POSResult();
    }

    private POSResult lineUnitPriceAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal unitPrice = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPosSalesScreen.lineUnitPriceEvent(request.register, unitPrice.toString(), line, request.salesInvoice, null);
        return new POSResult();
    }

    private POSResult lineDisc1PAction(POSMobileActionRequest request) {
        return this.lineDiscPercentAction(request, DiscountLocation.Discount1);
    }

    private POSResult lineDisc2PAction(POSMobileActionRequest request) {
        return this.lineDiscPercentAction(request, DiscountLocation.Discount2);
    }

    private POSResult lineDiscPercentAction(POSMobileActionRequest request, DiscountLocation location) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal discPercent = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPosSalesScreen.discPercentEvent(request.register, location, discPercent, line, null, request.salesInvoice, null);
        return new POSResult();
    }

    private POSResult lineDisc1VAction(POSMobileActionRequest request) {
        return this.lineDiscValueAction(request, DiscountLocation.Discount1);
    }

    private POSResult lineDisc2VAction(POSMobileActionRequest request) {
        return this.lineDiscValueAction(request, DiscountLocation.Discount2);
    }

    private POSResult lineDiscValueAction(POSMobileActionRequest request, DiscountLocation location) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal discVal = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPosSalesScreen.discValEvent(request.register, location, discVal, line, null, request.salesInvoice, null);
        return new POSResult();
    }

    private POSResult lineTax1PAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal val = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPOSSalesLine posSalesLine = line;
        AbsPosSalesScreen.lineTaxEvent(request.register, val, posSalesLine, request.salesInvoice, null, _value -> {
            posSalesLine.getTax1().setPercentage((BigDecimal)_value);
            posSalesLine.getTax1().setValue(null);
            return null;
        }, null);
        return new POSResult();
    }

    private POSResult lineTax1VAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal val = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPOSSalesLine posSalesLine = line;
        AbsPosSalesScreen.lineTaxEvent(request.register, val, posSalesLine, request.salesInvoice, null, _value -> {
            posSalesLine.getTax1().setValue((BigDecimal)_value);
            posSalesLine.getTax1().setPercentage(null);
            return null;
        }, null);
        return new POSResult();
    }

    private POSResult lineTax2PAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal val = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPOSSalesLine posSalesLine = line;
        AbsPosSalesScreen.lineTaxEvent(request.register, val, posSalesLine, request.salesInvoice, null, _value -> {
            posSalesLine.getTax2().setPercentage((BigDecimal)_value);
            posSalesLine.getTax2().setValue(null);
            return null;
        }, null);
        return new POSResult();
    }

    private POSResult lineTax2VAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        BigDecimal val = ObjectChecker.isEmptyOrNull((Object)request.body.get("val")) ? BigDecimal.ZERO : new BigDecimal(request.body.get("val").toString());
        AbsPOSSalesLine line = null;
        if (request.salesInvoice.fetchDetails().size() != 0) {
            line = request.salesInvoice.fetchDetails().get(lineNumber);
        }
        AbsPOSSalesLine posSalesLine = line;
        AbsPosSalesScreen.lineTaxEvent(request.register, val, posSalesLine, request.salesInvoice, null, _value -> {
            posSalesLine.getTax1().setValue((BigDecimal)_value);
            posSalesLine.getTax1().setPercentage(null);
            return null;
        }, null);
        return new POSResult();
    }

    private POSResult warehouseIssueAction(POSMobileActionRequest request) {
        int lineNumber = (Integer)request.body.get("lineNumber");
        request.salesInvoice.fetchDetails().get(lineNumber).updateWarehouseIssueMethod(request.register, ObjectChecker.toStringOrEmpty((Object)request.body.get("val")), null);
        request.salesInvoice.updateTotals(null);
        return new POSResult();
    }

    private POSResult updateCustomer(POSMobileActionRequest request) {
        if (request.salesInvoice.getCustomer() != null) {
            request.salesInvoice.updateCustomer(request.salesInvoice.getCustomer());
        }
        POSSalesPriceUtil.updateDocPriceFun(request.register, GeneratedDTOPOSConfiguration::getDoNotUpdatePriceWithCustomer, null).apply(request.salesInvoice);
        return new POSResult();
    }

    private POSResult updateInvoiceClassification(POSMobileActionRequest request) {
        POSSalesPriceUtil.updateDocPriceFun(request.register, GeneratedDTOPOSConfiguration::getDoNotUpdatePriceWithInvClass, null).apply(request.salesInvoice);
        return new POSResult();
    }

    public static void resetMobileUIConfiguration() {
        uiConfiguration = new HashMap<String, HashMap<String, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"registers/{id}/fetchInvoiceFieldsAndTemplate"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchInvoiceFieldsAndTemplate(@PathVariable(value="id") String registerId) {
        POSResult result = new POSResult();
        if (uiConfiguration.get(registerId) == null) {
            Object object = lock;
            synchronized (object) {
                HashMap<String, Object> configMetaData = new HashMap<String, Object>();
                uiConfiguration.put(registerId, configMetaData);
                POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
                if (register == null) {
                    return null;
                }
                PosMobileUISettings mobileUISettings = (PosMobileUISettings)ObjectChecker.getFirstNotNullObj((Object[])new PosMobileUISettings[]{register.getMobileUISettings(), (PosMobileUISettings)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getMobileUISettings())});
                if (ObjectChecker.isNotEmptyOrNull((Object)mobileUISettings)) {
                    mobileUISettings = POSPersister.findByID(PosMobileUISettings.class, mobileUISettings.getId());
                    List headerLines = mobileUISettings.getMobileMainFields().stream().map(MobileDTOFieldsInfoLine::fromHeaderLine).collect(Collectors.toList());
                    if (POSSecurityUtil.userCan(POSSecurityCapability.CanMakeDocDisc).isFailed().booleanValue()) {
                        headerLines.removeIf(l -> ObjectChecker.areEqual((Object)l.getField(), (Object)POSSalesHeaderField.Discount.name()));
                    }
                    configMetaData.put("invoiceHeaderFields", headerLines);
                    List<MobileDTOFieldsInfoLine> gridLines = mobileUISettings.getMobileGridFields().stream().map(MobileDTOFieldsInfoLine::fromGridLine).collect(Collectors.toList());
                    this.addUOMColsIfNeeded(gridLines);
                    configMetaData.put("invoiceGridFields", gridLines);
                    configMetaData.put("doNotAddPayButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddPayButton()));
                    configMetaData.put("doNotAddSaveButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddSaveButton()));
                    configMetaData.put("doNotAddSendButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddSendButton()));
                    configMetaData.put("doNotAddAddItemButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddAddItemButton()));
                    configMetaData.put("doNotAddEditItemButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddEditItemButton()));
                    configMetaData.put("doNotAddDeleteItemButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddDeleteItemButton()));
                    configMetaData.put("doNotAddFavouriteItemsButton", ObjectChecker.isTrue((Boolean)mobileUISettings.getDoNotAddFavouriteItemsButton()));
                }
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchTemplate(registerId))) {
            uiConfiguration.get(registerId).put("defaultsTemplate", NamaJSON.toString(POSResourcesUtil.fetchTemplate(registerId)));
        }
        return new MobilePOSResult().fromNormalResultToJson(result, uiConfiguration.get(registerId));
    }

    private void addUOMColsIfNeeded(List<MobileDTOFieldsInfoLine> gridLines) {
        MobileDTOFieldsInfoLine uomLine = gridLines.stream().filter(l -> ObjectChecker.areEqual((Object)l.getField(), (Object)PosSalesGridField.UOM.toString())).findFirst().orElse(null);
        if (uomLine != null) {
            String uomDisplayType = POSResourcesUtil.fetchPOSConfig().getUomDisplayType();
            if (ObjectChecker.areEqual((Object)uomDisplayType, (Object)POSSpecDimsDisplayType.ShowCodeOnly.toString())) {
                uomLine.setField("UOMCode");
                return;
            }
            if (ObjectChecker.areEqual((Object)uomDisplayType, (Object)POSSpecDimsDisplayType.ShowBoth)) {
                MobileDTOFieldsInfoLine newLine = new MobileDTOFieldsInfoLine();
                newLine.setField("UOMCode");
                gridLines.add(newLine);
                return;
            }
        }
    }

    @PostMapping(value={"/fetchProperties"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchProperties(@RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        String property = (String)body.get("property");
        String itemCode = (String)body.get("itemCode");
        Map<String, String> props = ObjectChecker.isAnyEqualToFirst((Object)property, (Object[])new String[]{"Size", "Color"}) ? POSItem.fetchSizesAndColors_(itemCode, ObjectChecker.areEqual((Object)property, (Object)"Size")) : POSItem.fetchRevisions(itemCode);
        return new MobilePOSResult().fromNormalResultToJson(result, props);
    }

    @PostMapping(value={"/checkPaid"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String checkPaid(@RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        List listOfIds = (List)body.get("listOfIds");
        for (String id : listOfIds) {
            List<?> invoice = POSPersister.selectTop(POSSalesInvoice.class, " where id = :invId", 1, POSPersister.params("invId", ServerStringUtils.strToUUID((String)id)));
            if (ObjectChecker.isEmptyOrNull(invoice)) {
                resultMap.put(id, false);
                continue;
            }
            POSSalesInvoice salesInvoice = (POSSalesInvoice)invoice.get(0);
            resultMap.put(id, ObjectChecker.areEqual((Object)salesInvoice.getNetPrice(), (Object)salesInvoice.getTotalPaid()));
        }
        return new MobilePOSResult().fromNormalResultToJson(result, resultMap);
    }

    @RequestMapping(value={"registers/{code}/availability"})
    public boolean checkRegisterAvailabilityForMobileApp(@PathVariable(name="code") String registerCode) {
        POSRegistery register = (POSRegistery)POSPersister.findByCode(POSRegistery.class, registerCode);
        if (register == null) {
            return false;
        }
        return register.getAvailableInMobileApp();
    }

    @RequestMapping(value={"registers/{code}"})
    public String fetchRegister(@PathVariable(name="code") String registerCode) {
        POSRegistery register = (POSRegistery)POSPersister.findByCode(POSRegistery.class, registerCode);
        if (register == null) {
            return null;
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), new MobilePOSMasterFileBaseDTO<POSRegistery>(register));
    }

    @RequestMapping(value={"registers/{id}/actions/generate-document-code"})
    public String fetchCode(@PathVariable(value="id") String registerId) {
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        if (register == null) {
            return null;
        }
        return POSCodeGenerator.calcDraftCode(POSSalesInvoice.class, POSCodeGenerator.generateInvoiceCode(POSDocumentType.Invoice, register));
    }

    @RequestMapping(value={"registers/{id}/login"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public MobileDTOPOSUser login(@PathVariable(value="id") String registerId, @RequestBody Map<String, String> requestBody) {
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        POSUser posUser = LoginUtil.authenticateUser(requestBody.get("username"), requestBody.get("password"), register, new POSResult());
        if (posUser == null) {
            return null;
        }
        POSCodeGenerator.fillLastDocsCodesInServerMap(register);
        return new MobileDTOPOSUser(posUser);
    }

    @PostMapping(value={"registers/{id}/fetchLogo"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchLogo(@PathVariable(value="id") String registerId) {
        byte[] bytes = null;
        try {
            POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
            if (register == null) {
                return null;
            }
            bytes = register.fetchLogo().readAllBytes();
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    @PostMapping(value={"registers/{id}/invoices/"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchInvoices(@PathVariable(value="id") String registerId, @RequestParam(defaultValue="0", name="page") int page, @RequestParam(defaultValue="20", name="recordsPerPage") int recordsPerPage, @RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        List<Object> invoices = new ArrayList();
        boolean held = ObjectChecker.isTrue((Boolean)((Boolean)body.get("held")));
        boolean customerId = ObjectChecker.isNotEmptyOrNull((Object)body.get("customerId"));
        if (ObjectChecker.areAllTrue((Boolean[])new Boolean[]{held, customerId})) {
            POSCustomer customer = POSPersister.findByID(POSCustomer.class, UUID.fromString(body.get("customerId").toString()));
            invoices.add(POSInvoicesService.fetchHeldInvoiceForCustomer(POSResourcesUtil.fetchRegister(registerId), customer, result));
        } else {
            invoices = MobileInvoicesController.listInvoices(registerId, page, recordsPerPage, body, held, customerId);
        }
        ArrayList<MobileDTOInvoice> invoicesDtos = new ArrayList<MobileDTOInvoice>();
        for (POSSalesInvoice pOSSalesInvoice : invoices) {
            invoicesDtos.add(new MobileDTOInvoice().fromNormalInvoice(pOSSalesInvoice));
        }
        return new MobilePOSResult().fromNormalResultToJson(result, invoicesDtos);
    }

    private static List<POSSalesInvoice> listInvoices(String registerId, int page, int recordsPerPage, Map<String, Object> body, boolean held, boolean customerId) {
        Object cond = "where 1=1 AND  registerId =:registerId and (preventUsage is null or preventUsage = false)  and hold =:held and (paymentDelayed is null or paymentDelayed = false)";
        HashMap<String, Object> params = POSPersister.params("registerId", UUID.fromString(registerId));
        params.put("held", held);
        if (ObjectChecker.isNotEmptyOrNull((Object)body.get("userId"))) {
            cond = (String)cond + "  and currentUser =:user";
            params.put("user", POSPersister.findByID(POSUser.class, UUID.fromString(body.get("userId").toString())));
        }
        if (customerId) {
            cond = (String)cond + " and customer=:customer";
            params.put("customer", POSPersister.findByID(POSCustomer.class, UUID.fromString(body.get("customerId").toString())));
        }
        DTOPageData dtoPageData = new DTOPageData(page, recordsPerPage);
        if (page == -1) {
            dtoPageData = DTOPageData.lastRecord();
        }
        List<POSSalesInvoice> invoices = POSPersister.selectTop(POSSalesInvoice.class, (String)cond, 15, "DESC", params, false, dtoPageData, null, "valueDate");
        return invoices;
    }

    @PostMapping(value={"registers/{id}/sendInvoice"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String sendInvoice(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        String userId = ObjectChecker.toStringOrEmpty((Object)body.get("userId"));
        List invoices = (List)body.get("sales");
        for (String invoiceJson : invoices) {
            POSSalesInvoice salesInvoice = this.saveInvoice(registerId, invoiceJson, userId, result);
            if (result.isSucceeded().booleanValue()) {
                AbsPosSalesScreen.printPrepFormsIfNeeded(POSResourcesUtil.fetchRegister(registerId), PosPrepFormPrintTime.WithHold, salesInvoice);
                continue;
            }
            if (!result.isFailed().booleanValue()) continue;
            result.failure("Save Failed", new Object[0]);
        }
        return new MobilePOSResult().fromNormalResultToJson(result, new MobileDTOInvoice());
    }

    private POSSalesInvoice saveInvoice(String registerId, String invoiceJson, String userId, POSResult result) {
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        POSSalesInvoice salesInvoice = this.posInvoiceFromJson(invoiceJson);
        POSUser user = POSPersister.findUser(ObjectChecker.toStringOrEmpty((Object)userId));
        if (ObjectChecker.isEmptyOrNull((Object)salesInvoice.getSalesMan()) && user != null) {
            salesInvoice.setSalesMan(POSPersister.findByID(POSEmployee.class, user.getEmpId()));
        }
        salesInvoice.updateRegisterFields(register, null);
        salesInvoice.setHold(true);
        try {
            salesInvoice.setHoldTime(Date.from(LocalDateTime.parse(DATE_FORMAT.format(salesInvoice.getValueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate()) + " " + TIME_FORMAT.format(salesInvoice.getValueTime().toInstant().atZone(ZoneId.systemDefault()).toLocalTime()), DATE_TIME_FORMAT).atZone(ZoneId.systemDefault()).toInstant()));
        }
        catch (Exception e) {
            result.failure("Can not parse hold time", new Object[0]);
            NaMaLogger.error((Throwable)e);
        }
        POSEntityMediator.updateSalesDocData(true, null, null, salesInvoice, user, null, null);
        POSShiftOpen fetchLastShift = POSResourcesUtil.fetchLastOpenShift(register);
        if (ObjectChecker.isEmptyOrNull((Object)fetchLastShift)) {
            result.failure("Open Shift firstly", new Object[0]);
        } else {
            salesInvoice.updateShiftData(register);
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getCustomerRequiredInPOS()) && salesInvoice.getCustomer() == null) {
            result.failure("Customer or subsidiary required", new Object[0]);
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getSalesManIsRequired()) && salesInvoice.getSalesMan() == null) {
            result.failure("Salesman is required", new Object[0]);
        }
        if (result.isFailed().booleanValue()) {
            return salesInvoice;
        }
        POSPersister.saveOrUpdateWithActionHistory(salesInvoice).addToAccumulateResult(result);
        return salesInvoice;
    }

    @PostMapping(value={"registers/{id}/discountAction"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String discountAction(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        String discountPercent = (String)body.get("discountPercent");
        String discountValue = (String)body.get("discountValue");
        String sales = (String)body.get("salesDoc");
        POSSalesInvoice salesDoc = this.posInvoiceFromJson(sales);
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        salesDoc.updateRegisterFields(register, null);
        if (salesDoc.getInvoiceMoney() == null) {
            salesDoc.setInvoiceMoney(new DTOInvoiceMoney());
        }
        salesDoc.getInvoiceMoney().resetAccumualtingValues();
        salesDoc.updateLineAndTotalMoney(null, true);
        salesDoc.setDiscountValue(BigDecimal.valueOf(Double.parseDouble(discountValue)));
        salesDoc.setDiscountPercent(BigDecimal.valueOf(Double.parseDouble(discountPercent)));
        salesDoc.updateLineAndTotalMoney(null, true);
        MobileDTOInvoice response = new MobileDTOInvoice().fromNormalInvoice(salesDoc);
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), response);
    }

    @PostMapping(value={"registers/{id}/doLineAction"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String doLineAction(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        String action = (String)body.get("action");
        String sales = (String)body.get("sales");
        POSSalesInvoice salesInvoice = this.posInvoiceFromJson(sales);
        salesInvoice.updateRegisterFields(POSResourcesUtil.fetchRegister(registerId), null);
        POSResult result = this.actions.get(action).apply(new POSMobileActionRequest(this, body, salesInvoice, POSResourcesUtil.fetchRegister(registerId)));
        MobileDTOInvoice response = new MobileDTOInvoice().fromNormalInvoice(salesInvoice);
        return new MobilePOSResult().fromNormalResultToJson(result, response);
    }

    private POSSalesInvoice posInvoiceFromJson(String sales) {
        try {
            MobileDTOInvoice dtoInvoice = NamaJSON.read(sales, MobileDTOInvoice.class);
            return dtoInvoice.toActualInvoice();
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    @PostMapping(value={"registers/{id}/fetchRefData"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchRefData(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        String refCode;
        POSResult result = new POSResult();
        String refClass = (String)body.get("refClass");
        String code = refCode = (String)body.get("refCode");
        boolean isItemRef = ObjectChecker.areEqual((Object)refClass, (Object)POSItem.class.getSimpleName());
        if (isItemRef) {
            code = AbsPOSSales.parseBarcode(refCode, new ArrayList<GenericValue>());
        }
        POSMasterFile masterFile = null;
        masterFile = this.fetchFile(masterFile, refClass, code, result);
        if (isItemRef && masterFile != null) {
            masterFile.setCode(refCode);
        }
        if (masterFile != null && masterFile.sendAllInfoToMobile()) {
            return new MobilePOSResult().fromNormalResultToJson(result, masterFile);
        }
        return new MobilePOSResult().fromNormalResultToJson(result, masterFile == null ? null : masterFile.toEntityReferenceData());
    }

    private POSMasterFile fetchFile(POSMasterFile masterFile, String refClass, String code, POSResult result) {
        try {
            masterFile = POSPersister.findByCode(Class.forName("com.namasoft.pos.domain.entities." + refClass), code);
            if (masterFile != null) {
                return masterFile;
            }
            if (ObjectChecker.areEqual((Object)POSItem.class.getSimpleName(), (Object)refClass)) {
                POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, code);
                if (posItemCode != null) {
                    masterFile = POSPersister.findByID(POSItem.class, posItemCode.getItemId());
                }
            } else if (ObjectChecker.areEqual((Object)POSCustomer.class.getSimpleName(), (Object)refClass)) {
                masterFile = (POSMasterFile)CollectionsUtility.getFirst(POSPersister.selectTop(POSCustomer.class, "WHERE " + POSCustomer.filteringCondition("", " = ", "value"), 1, POSPersister.params("value", code)));
            }
            if (masterFile == null) {
                result.setFailed(true);
                result.setEnMessage("Not Exist Reference");
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            result.setFailed(true);
            result.setEnMessage(e.getMessage());
        }
        return masterFile;
    }

    @GetMapping(value={"customerExtraCodesDetails"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchCustomerExtraCodesDetails() {
        HashMap<String, List<MobileDTOExtraCodeDetailsLine>> response = new HashMap<String, List<MobileDTOExtraCodeDetailsLine>>();
        if (extraCodeLines == null) {
            this.updateExtraCodeLines();
        }
        response.put("extraCodes", extraCodeLines);
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), response);
    }

    public static void resetExtraCodeLines() {
        extraCodeLines = null;
    }

    private void updateExtraCodeLines() {
        List<POSGenericReferenceOverrider> overriders = POSPersister.listAll(POSGenericReferenceOverrider.class);
        if (ObjectChecker.isEmptyOrNull(overriders)) {
            return;
        }
        List extraCodes = overriders.stream().flatMap(o -> o.getExtraCodes().stream()).map(POSExtraCodeLine::getFieldID).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(extraCodes)) {
            return;
        }
        List formatLines = overriders.stream().flatMap(o -> o.getFieldFormats().stream()).filter(l -> extraCodes.contains(l.getFieldID())).collect(Collectors.toList());
        if (extraCodeLines == null) {
            extraCodeLines = new ArrayList<MobileDTOExtraCodeDetailsLine>();
        }
        for (POSFieldFormatLine formatLine : formatLines) {
            extraCodeLines.add(new MobileDTOExtraCodeDetailsLine(formatLine));
        }
    }

    @PostMapping(value={"registers/{id}/bulkDelete"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String bulkDelete(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        if (POSResourcesUtil.fetchRegister(registerId) == null) {
            return null;
        }
        POSResult result = new POSResult();
        String sales = (String)body.get("sales");
        POSSalesInvoice salesInvoice = this.posInvoiceFromJson(sales);
        MobileDTOInvoice response = null;
        try {
            String indicesStr = (String)body.get("indices");
            List indices = NamaJSON.read(indicesStr, List.class);
            List<? extends AbsPOSSalesLine> items = salesInvoice.fetchDetails();
            for (int i = 0; i < items.size(); ++i) {
                if (!indices.contains(i)) continue;
                items.get(i).setSelected(true);
            }
            AbsPosSalesScreen.bulkDelete(POSResourcesUtil.fetchRegister(registerId), items, null, salesInvoice);
            response = new MobileDTOInvoice().fromNormalInvoice(salesInvoice);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            result.setFailed(true);
            result.setEnMessage(e.getMessage());
        }
        return new MobilePOSResult().fromNormalResultToJson(result, response);
    }

    @PostMapping(value={"/fetchHallTables"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchHallTables(@RequestBody Map<String, Object> body) {
        ArrayList buttons = new ArrayList();
        try {
            HashMap hallData = (HashMap)body.get("hall");
            POSHall hall = NamaJSON.read(NamaJSON.toString(hallData), POSHall.class);
            List<POSTableButton> posTableButtons = POSHallButton.fetchHallTables(hall, null);
            posTableButtons.stream().forEach(t -> buttons.add(new MobilePOSTableBtn((POSHallsTablesButton)t)));
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), buttons);
    }

    @PostMapping(value={"/fetchTables"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchTables(@RequestBody Map<String, Object> body) {
        List<POSHall> halls = POSResourcesUtil.halls;
        List<POSTable> tables = POSResourcesUtil.tables;
        ArrayList buttons = new ArrayList();
        halls.stream().forEach(h -> buttons.add(new MobilePOSTableBtn(new POSHallButton((POSHall)h, null))));
        tables.stream().forEach(t -> buttons.add(new MobilePOSTableBtn(new POSTableButton((POSTable)t, null))));
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), buttons);
    }

    @PostMapping(value={"/fetchFavourites"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchFavourites(@RequestBody Map<String, Object> body) {
        List<POSFavouriteBtn> favouriteButtons = FavouritesContainerBuilder.createFavouriteButtons(null);
        ArrayList mobilePOSFavouriteBtns = new ArrayList();
        favouriteButtons.stream().forEach(posFavouriteBtn -> {
            if (posFavouriteBtn instanceof POSNormalFavouriteBtn) {
                mobilePOSFavouriteBtns.add(new MobilePOSNormalFavouriteBtn((POSNormalFavouriteBtn)posFavouriteBtn));
            } else {
                mobilePOSFavouriteBtns.add(new MobileCompositePOSFavouriteBtn((POSCompositeFavouriteBtn)posFavouriteBtn));
            }
        });
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), mobilePOSFavouriteBtns);
    }

    @PostMapping(value={"/fetchAdditionalItems"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchAdditionalItems(@RequestBody Map<String, Object> body) {
        String itemId = (String)body.get("itemId");
        POSItem item = POSPersister.findByID(POSItem.class, itemId);
        if (item == null) {
            return new MobilePOSResult().fromNormalResultToJson(new POSResult(), null);
        }
        PosItemAdditionalItems additionalItems = POSResourcesUtil.fetchAdditionalItemsForItem(item);
        if (additionalItems == null) {
            return new MobilePOSResult().fromNormalResultToJson(new POSResult(), null);
        }
        List<PosAdditionalItemsGroupPane> groups = PosAdditionalItemsDialog.createGroups(additionalItems, item);
        if (groups == null) {
            return new MobilePOSResult().fromNormalResultToJson(new POSResult(), null);
        }
        List groupsObj = groups.stream().filter(g -> ObjectChecker.isNotEmptyOrNull(g.getButtons())).map(PosAdditionalItemsGroupPane::toNormalGroup).collect(Collectors.toList());
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), groupsObj);
    }

    @PostMapping(value={"/fetchNextLevelFavourites"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String fetchNextLevelFavourites(@RequestBody Map<String, Object> body) {
        ArrayList mobilePOSFavouriteBtns = new ArrayList();
        try {
            HashMap btnData = (HashMap)body.get("buttonData");
            MobileCompositePOSFavouriteBtn mobCompositeFavouriteBtn = NamaJSON.read(NamaJSON.toString(btnData), MobileCompositePOSFavouriteBtn.class);
            POSCompositeFavouriteBtn compositeParentFavouriteBtn = null;
            if (mobCompositeFavouriteBtn.getParentBtn() != null) {
                MobileCompositePOSFavouriteBtn mobParentBtn = mobCompositeFavouriteBtn.getParentBtn();
                compositeParentFavouriteBtn = new POSCompositeFavouriteBtn(mobParentBtn.getFavouriteItem(), null, mobParentBtn.getLevel(), new POSLiteMasterFile(mobParentBtn.getCurrentRecord()), null);
            }
            POSCompositeFavouriteBtn compositeFavouriteBtn = new POSCompositeFavouriteBtn(mobCompositeFavouriteBtn.getFavouriteItem(), null, mobCompositeFavouriteBtn.getLevel(), new POSLiteMasterFile(mobCompositeFavouriteBtn.getCurrentRecord()), compositeParentFavouriteBtn);
            List<POSFavouriteBtn> favouriteButtons = compositeFavouriteBtn.btnNextLevelAction(null);
            favouriteButtons.stream().forEach(posFavouriteBtn -> {
                if (posFavouriteBtn instanceof POSNormalFavouriteBtn) {
                    mobilePOSFavouriteBtns.add(new MobilePOSNormalFavouriteBtn((POSNormalFavouriteBtn)posFavouriteBtn));
                } else {
                    mobilePOSFavouriteBtns.add(new MobileCompositePOSFavouriteBtn((POSCompositeFavouriteBtn)posFavouriteBtn));
                }
            });
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), mobilePOSFavouriteBtns);
    }

    @PostMapping(value={"/backToBreadCrumbLevel"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String backToBreadCrumbLevel(@RequestBody Map<String, Object> body) {
        ArrayList mobilePOSFavouriteBtns = new ArrayList();
        try {
            HashMap file_ = (HashMap)body.get("file");
            HashMap btn = (HashMap)file_.get("btn");
            MobilePOSLiteMasterFile file = NamaJSON.read(NamaJSON.toString(file_), MobilePOSLiteMasterFile.class);
            if (btn.get("posCompositeFavouriteBtn") != null) {
                file.setBtn(NamaJSON.read(NamaJSON.toString(btn.get("posCompositeFavouriteBtn")), MobileCompositePOSFavouriteBtn.class));
            }
            int currentLevel = (Integer)body.get("currentLevel");
            int level = (Integer)body.get("level");
            List<POSFavouriteBtn> favouriteButtons = FavouritesContainerBuilder.backBreadCrumbsLevel(new POSLiteMasterFile(file), null, currentLevel, null, null, null, null, level);
            favouriteButtons.stream().forEach(posFavouriteBtn -> {
                if (posFavouriteBtn instanceof POSNormalFavouriteBtn) {
                    mobilePOSFavouriteBtns.add(new MobilePOSNormalFavouriteBtn((POSNormalFavouriteBtn)posFavouriteBtn));
                } else {
                    mobilePOSFavouriteBtns.add(new MobileCompositePOSFavouriteBtn((POSCompositeFavouriteBtn)posFavouriteBtn));
                }
            });
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), mobilePOSFavouriteBtns);
    }

    @PostMapping(value={"registers/{id}/createOrUpdatePOSCustomerFromMobile"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String createOrUpdatePOSCustomerFromMobile(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) throws IOException {
        String customerBody = (String)body.get("customer");
        Map map = NamaJSON.read(customerBody, Map.class);
        POSCustomer posCustomer = POSPersister.findByID(POSCustomer.class, ObjectChecker.toStringOrEmpty(map.get("id")));
        if (posCustomer == null) {
            posCustomer = new POSCustomer();
        }
        posCustomer.setCode(ObjectChecker.toStringOrEmpty(map.get("code")));
        posCustomer.setName1(ObjectChecker.toStringOrEmpty(map.get("name1")));
        posCustomer.setName2(ObjectChecker.toStringOrEmpty(map.get("name2")));
        posCustomer.setPhoneNumber(ObjectChecker.toStringOrEmpty(map.get("mobile")));
        posCustomer.setAddress(ObjectChecker.toStringOrEmpty(map.get("address")));
        posCustomer.setArea(ObjectChecker.toStringOrEmpty(map.get("area")));
        posCustomer.setResidency(ObjectChecker.toStringOrEmpty(map.get("residency")));
        posCustomer.setDescription1(ObjectChecker.toStringOrEmpty(map.get("description1")));
        POSCustomerClass customerClass = (POSCustomerClass)POSPersister.findByCode(POSCustomerClass.class, ObjectChecker.toStringOrEmpty(map.get("class")));
        posCustomer.setCustomerClass(customerClass);
        POSCustomerClass customerCategory = (POSCustomerClass)POSPersister.findByCode(POSCustomerCategory.class, ObjectChecker.toStringOrEmpty(map.get("category")));
        posCustomer.setCustomerClass(customerCategory);
        posCustomer.setCreationDate(new Date());
        posCustomer.setSent(false);
        List<String> errors = PosSalesUtil.validateAndCreateIfNeeded(POSResourcesUtil.fetchRegister(registerId), posCustomer);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("success", ObjectChecker.isEmptyOrNull(errors));
        responseMap.put("errors", errors);
        return NamaJSON.toString(responseMap);
    }

    @PostMapping(value={"registers/{id}/listTopReferences"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    @ResponseBody
    public String listReferences(@PathVariable(name="id") String registerId, @RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        String refClass = (String)body.get("refClass");
        String itemCode = (String)body.get("itemCode");
        String itemId = (String)body.get("itemId");
        String fieldId = (String)body.get("fieldId");
        int page = 0;
        String value = "";
        if (body.get("page") != null) {
            page = (Integer)body.get("page");
        } else {
            value = (String)body.get("value");
        }
        int recordsPerPage = (Integer)body.get("recordsPerPage");
        MobileDTOSearchResult searchResult = new MobileDTOSearchResult();
        try {
            List<Object> refList;
            Class<?> klass = Class.forName("com.namasoft.pos.domain.entities." + refClass);
            if (ObjectChecker.areEqual(klass, POSUnit.class) && ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{itemId, itemCode})) {
                List<POSUnit> units;
                POSItem item = POSPersister.findByID(POSItem.class, itemId);
                if (item == null) {
                    POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, itemCode);
                    item = POSPersister.findByID(POSItem.class, posItemCode.getItemId());
                }
                refList = ObjectChecker.isNotEmptyOrNull(units = POSItem.calcItemUoms(item, itemCode)) ? units.stream().map(POSMasterFile::toEntityReferenceData).collect(Collectors.toList()) : new ArrayList();
                searchResult.setTotalRecordsCount(units.size());
            } else {
                DTOPageData dtoPageData = new DTOPageData(page, recordsPerPage);
                if (page == -1) {
                    dtoPageData = DTOPageData.lastRecord();
                }
                String whereCodeNameLikeValue = " and code LIKE :val or name1 LIKE :val  or name2 LIKE :val ";
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (ObjectChecker.isEmptyOrNull((Object)value)) {
                    whereCodeNameLikeValue = "";
                } else {
                    parameters.put("val", "%" + value + "%");
                }
                POSNewSalesScreen screen = new POSNewSalesScreen();
                screen.updateDocType(POSDocumentType.Invoice);
                NamaPOSSearchDialog.POSSearchRequest searchRequest = new NamaPOSSearchDialog.POSSearchRequest();
                searchRequest.klass = klass;
                searchRequest.fieldId = fieldId;
                searchRequest.screen = screen;
                searchRequest.customeType = null;
                searchRequest.parameters = parameters;
                searchRequest.fromOpenDocAction = false;
                searchRequest.searchInAllRegisters = false;
                searchRequest.register = POSResourcesUtil.fetchRegister(registerId);
                String whereClause = NamaPOSSearchDialog.calcCondition(searchRequest) + whereCodeNameLikeValue;
                List list = POSPersister.searchFor(" from " + refClass + whereClause, parameters, dtoPageData, null);
                Number count = POSPersister.count(klass, whereClause, parameters, true);
                refList = list.stream().map(POSMasterFile::toEntityReferenceData).collect(Collectors.toList());
                searchResult.setTotalRecordsCount(count);
            }
            searchResult.setRefList(refList);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            result.setFailed(true);
            result.setEnMessage(e.getMessage());
        }
        return new MobilePOSResult().fromNormalResultToJson(result, searchResult);
    }

    @PostMapping(value={"registers/{id}/fetchPaymentScreenDetails"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchPaymentScreenDetails(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) {
        POSSalesInvoice salesDoc = this.posInvoiceFromJson((String)body.get("sales"));
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        salesDoc.updateRegisterFields(register, null);
        ValidateDocRequest validateRequest = MobileInvoicesController.createValidationRequest(register, salesDoc);
        POSResult result = POSEntityUtil.validateInvoice(validateRequest);
        if (result.isFailed().booleanValue()) {
            return new MobilePOSResult().fromNormalResultToJson(result, null);
        }
        List<POSPaymentMethod> methods = POSResourcesUtil.methods;
        ArrayList<MobileDTOPaymentMethod> paymentMethodsDtos = new ArrayList<MobileDTOPaymentMethod>();
        for (POSPaymentMethod method : methods) {
            paymentMethodsDtos.add(new MobileDTOPaymentMethod(method));
        }
        MobileDTOPaymentScreen response = new MobileDTOPaymentScreen();
        response.setPaymentMethods(paymentMethodsDtos);
        response.setInvoiceNet(salesDoc.calcDocumentNet());
        return new MobilePOSResult().fromNormalResultToJson(result, response);
    }

    @PostMapping(value={"registers/{id}/payAction"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String payAction(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body) throws IOException {
        POSSalesInvoice salesDoc = this.posInvoiceFromJson((String)body.get("sales"));
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        salesDoc.updateRegisterFields(register, null);
        ValidateDocRequest validateRequest = MobileInvoicesController.createValidationRequest(register, salesDoc);
        POSResult result = POSEntityUtil.validateInvoice(validateRequest);
        if (result.isSucceeded().booleanValue()) {
            PayRequest payRequest = MobileInvoicesController.createPayRequest(register, body, salesDoc, result);
            result.accumulate(MultiplePaymentDialog.process(payRequest, null));
        }
        return new MobilePOSResult().fromNormalResultToJson(result, new MobileDTOInvoice().fromNormalInvoice(salesDoc));
    }

    private static ValidateDocRequest createValidationRequest(POSRegistery register, POSSalesInvoice salesDoc) {
        ValidateDocRequest validateRequest = new ValidateDocRequest();
        validateRequest.setWarehouseCode(MobileInvoicesController.codeOf(salesDoc.getWarehouse()));
        validateRequest.setTableCode(MobileInvoicesController.codeOf(salesDoc.getTable()));
        validateRequest.setToWarehouseCode(null);
        validateRequest.setToTime(null);
        validateRequest.setSubsidiaryCode(salesDoc.getSubsidiaryCode());
        validateRequest.setItems(salesDoc.fetchDetails());
        validateRequest.setToLocationCode(null);
        validateRequest.setLocationCode(MobileInvoicesController.codeOf(salesDoc.getLocation()));
        validateRequest.setSalesmanCode(MobileInvoicesController.codeOf(salesDoc.getSalesMan()));
        validateRequest.setReservationDate(null);
        validateRequest.setItemCode(null);
        validateRequest.setFromTime(null);
        validateRequest.setSalesDoc(salesDoc);
        validateRequest.setInvoiceClassificationCode(MobileInvoicesController.codeOf(salesDoc.getPosInvoiceClassification()));
        validateRequest.setDiscVal(salesDoc.getDiscountValue());
        validateRequest.setDiscPercent(salesDoc.getDiscountPercent());
        validateRequest.setInvCode(salesDoc.getCode());
        validateRequest.setCustomerCode(MobileInvoicesController.codeOf(salesDoc.getCustomer()));
        validateRequest.setDocType(salesDoc.docType());
        validateRequest.setDisc2Val(salesDoc.getDiscount2Value());
        validateRequest.setCurrencyCode(MobileInvoicesController.codeOf(salesDoc.getCurrency()));
        validateRequest.setDocCategoryCode(MobileInvoicesController.codeOf(salesDoc.getDocCategory()));
        validateRequest.setFromWarehouseCode(null);
        validateRequest.setRegister(register);
        return validateRequest;
    }

    private static String codeOf(POSMasterFile file) {
        if (file == null) {
            return null;
        }
        return file.getCode();
    }

    private static PayRequest createPayRequest(POSRegistery register, Map<String, Object> body, POSSalesInvoice salesDoc, POSResult result) throws IOException {
        PayRequest payRequest = new PayRequest();
        payRequest.setSalesDoc(salesDoc);
        payRequest.setDocType(salesDoc.docType());
        payRequest.setValue(MultiplePaymentDialog.toZeroIfNullOrEmpty(body.get("value").toString()));
        payRequest.setRemainingAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(body.get("remaining").toString()));
        payRequest.setDebitAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(body.get("debitAmount").toString()));
        payRequest.setDefaultCashAmount(MultiplePaymentDialog.toZeroIfNullOrEmpty(body.get("defaultCashAmount").toString()));
        payRequest.setDelayPayment(Boolean.valueOf(body.get("delayPayment").toString()));
        payRequest.setCashValue(MultiplePaymentDialog.toZeroIfNullOrEmpty(body.get("cashValue").toString()));
        payRequest.setPayments(MobileInvoicesController.convertToPaymentsInfoMap((List)body.get("payments")));
        List pgwPaymentsInfo = (List)body.get("pgwPaymentsInfo");
        for (String element : pgwPaymentsInfo) {
            PGWPaymentInfo pgwPaymentInfo = NamaJSON.read(element, PGWPaymentInfo.class);
            NearPay.addPaymentInfoToPayRequest(payRequest, ObjectChecker.toBigDecimalIfNumber((Object)pgwPaymentInfo.amount), pgwPaymentInfo.pgwResponse, result);
        }
        payRequest.setCouponsInfo((List)CollectionsUtility.getFirst(new ArrayList<List<PaymentInfo>>(MobileInvoicesController.convertToPaymentsInfoMap((List)body.get("couponsInfo")).values())));
        payRequest.setCreditNotesInfo((List)CollectionsUtility.getFirst(new ArrayList<List<PaymentInfo>>(MobileInvoicesController.convertToPaymentsInfoMap((List)body.get("creditNotesInfo")).values())));
        payRequest.setRegister(register);
        payRequest.setShouldPrintAfterPayment(true);
        return payRequest;
    }

    private static Map<POSPaymentMethod, List<PaymentInfo>> convertToPaymentsInfoMap(List<String> dtoPayments) throws IOException {
        HashMap<POSPaymentMethod, List<PaymentInfo>> payments = new HashMap<POSPaymentMethod, List<PaymentInfo>>();
        for (String payment : dtoPayments) {
            MobileDTOPaymentInfo paymentInfo = NamaJSON.read(payment, MobileDTOPaymentInfo.class);
            ArrayList<PaymentInfo> paymentsInfo = new ArrayList<PaymentInfo>();
            paymentsInfo.add(new PaymentInfo(paymentInfo.getValue(), paymentInfo.getProcessNumber()));
            payments.put(paymentInfo.getPaymentMethod(), paymentsInfo);
        }
        return payments;
    }

    @PostMapping(value={"registers/{id}/payUsingPGW"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String payUsingPGW(@PathVariable(name="id") String registerId, @RequestBody Map<String, Object> body) throws IOException {
        POSSalesInvoice salesDoc = this.posInvoiceFromJson((String)body.get("sales"));
        String pgwResponse = (String)body.get("pgwResponse");
        NaMaLogger.info((Object)pgwResponse);
        BigDecimal amount = ObjectChecker.toBigDecimalIfNumber((Object)body.get("amount"));
        POSResult result = NearPay.pay(POSResourcesUtil.fetchRegister(registerId), salesDoc, amount, pgwResponse);
        return new MobilePOSResult().fromNormalResultToJson(result, null);
    }

    @PostMapping(value={"/couponAction"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String couponAction(@RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        String couponCode = (String)body.get("couponCode");
        String amount = String.valueOf(body.get("amount"));
        BigDecimal totalPaid = BigDecimal.valueOf((Double)body.get("totalPaid"));
        String salesDoc = (String)body.get("salesDoc");
        String val = MultiplePaymentDialog.couponAction(couponCode, amount, totalPaid, this.posInvoiceFromJson(salesDoc), result);
        return new MobilePOSResult().fromNormalResultToJson(result, val);
    }

    @GetMapping(value={"/fetchInvById/{invId}"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String fetchInvById(@PathVariable(name="invId") String invId) {
        POSSalesInvoice invoice = POSPersister.findByID(POSSalesInvoice.class, invId);
        if (invoice == null) {
            return new MobilePOSResult().fromNormalResultToJson(new POSResult(), null);
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), new MobileDTOInvoice().fromNormalInvoice(invoice));
    }

    @PostMapping(value={"registers/{id}/printDocumentAsListOfImages/{fileType}"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String printDocumentAsListOfImages(@PathVariable(value="id") String registerId, @RequestBody Map<String, Object> body, @PathVariable(name="fileType") String fileType) {
        boolean fromPrintAction = ObjectChecker.isTrue((Boolean)((Boolean)body.get("fromPrintAction")));
        POSResult result = new POSResult();
        if (POSResourcesUtil.disablePrinting.booleanValue() && !fromPrintAction) {
            result.setFailed(true);
        } else if (fromPrintAction && POSResourcesUtil.disablePrinting.booleanValue()) {
            result.failure("Printing is disabled", new Object[0]);
        }
        if (result.isFailed().booleanValue()) {
            return new MobilePOSResult().fromNormalResultToJson(result, null);
        }
        String invId = body.get("invoiceId").toString();
        POSSalesInvoice invoice = POSPersister.findByID(POSSalesInvoice.class, invId);
        List<String> images = POSReportDefinition.exportReportTo(POSResourcesUtil.fetchRegister(registerId), fileType, true, invoice);
        if (ObjectChecker.isEmptyOrNull(images) && fromPrintAction) {
            result.failure("Can not find report definition", new Object[0]);
        } else if (ObjectChecker.isEmptyOrNull(images)) {
            result.setFailed(true);
        }
        if (result.isFailed().booleanValue()) {
            return new MobilePOSResult().fromNormalResultToJson(result, null);
        }
        return new MobilePOSResult().fromNormalResultToJson(result, MobileInvoicesController.createPrintDocAsListOfImagesResponseParams(images));
    }

    private static Map<String, Object> createPrintDocAsListOfImagesResponseParams(List<String> images) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("images", images);
        params.put("viewPrintDialog", true);
        return params;
    }

    @GetMapping(value={"/rewardPointsForCustomer/{customerId}"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String rewardPointsForCustomer(@PathVariable(name="customerId") String customerId) {
        POSResult result = new POSResult();
        POSCustomer customer = POSPersister.findByID(POSCustomer.class, customerId);
        DTONamaRewardInfo rewardInfo = POSRewardPointsUtil.calculateRemainingRewardInfo(customer, result);
        return new MobilePOSResult().fromNormalResultToJson(result, rewardInfo);
    }

    @PostMapping(value={"/requestOTP"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String requestOTP(@RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        POSSalesInvoice salesInvoice = this.posInvoiceFromJson(ObjectChecker.toStringOrEmpty((Object)body.get("salesInvoice")));
        BigDecimal amount = BigDecimal.valueOf((Double)body.get("amount"));
        POSRewardPointsUtil.requestOTP(salesInvoice, amount, result);
        return new MobilePOSResult().fromNormalResultToJson(result, null);
    }

    @PostMapping(value={"/redeemAmount"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String redeemAmount(@RequestBody Map<String, Object> body) {
        POSResult result = new POSResult();
        POSSalesInvoice salesInvoice = this.posInvoiceFromJson(ObjectChecker.toStringOrEmpty((Object)body.get("salesInvoice")));
        BigDecimal amount = BigDecimal.valueOf((Double)body.get("amount"));
        String otp = ObjectChecker.toStringOrEmpty((Object)body.get("otp"));
        String couponCode = POSRewardPointsUtil.redeem(salesInvoice, amount, otp, false, result);
        return new MobilePOSResult().fromNormalResultToJson(result, couponCode);
    }

    @GetMapping(value={"registers/{id}/shift"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public String createNewShift(@PathVariable(value="id") String registerId) {
        POSRegistery register = POSResourcesUtil.fetchRegister(registerId);
        AbsPOSShiftInventory shiftDoc = POSShiftInventoryService.createShiftDoc(register, true, POSCodeGenerator.generateShiftCode(register), null);
        MobileDTOPOSShift shiftDto = new MobileDTOPOSShift(shiftDoc);
        List<AbsPOSInventoryLine> shiftLines = POSPaymentMethodsUtil.calcShiftTotals(POSResourcesUtil.fetchRegister(registerId), POSShiftOpenLine.class, totalCash -> {});
        for (AbsPOSInventoryLine shiftLine : shiftLines) {
            shiftDto.getShiftLines().add(new MobileDTOAbsPOSShiftLine(shiftLine));
        }
        return new MobilePOSResult().fromNormalResultToJson(new POSResult(), shiftDto);
    }

    @PostMapping(value={"registers/{id}/shift"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public MobilePOSResult saveShift(@PathVariable(value="id") String registerId, @RequestBody MobileDTOPOSShift shiftDTO) {
        POSShiftInventoryService.POSCreateShiftRequest request = new POSShiftInventoryService.POSCreateShiftRequest(shiftDTO);
        POSResult result = new POSResult();
        POSShiftInventoryService.saveShift(request, result);
        return new MobilePOSResult().fromNormalResult(result, null);
    }

    @GetMapping(value={"items/{barcode}/price"}, consumes={"application/json; charset=utf-8"}, produces={"application/json; charset=utf-8"})
    public MobilePOSResult checkPrice(@PathVariable(name="barcode") String barcode) {
        POSItemCode posItemCode = (POSItemCode)POSPersister.findByCode(POSItemCode.class, barcode);
        POSResult result = new POSResult();
        if (ObjectChecker.isEmptyOrNull((Object)posItemCode)) {
            return new MobilePOSResult().fromNormalResult(result.failure(POSResourcesUtil.id("Not Found", new Object[0]), new Object[0]), null);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        POSItem item = posItemCode.fetchItem();
        if (item.isHasImage().booleanValue()) {
            String base64Image = this.fetchItemImageAsBase64(item.getId().toString(), barcode);
            response.put("productImage", base64Image);
        }
        response.put("productName", item.nameByLanguage());
        response.put("productCode", barcode);
        response.put("productPrice", ObjectChecker.toStringOrEmpty((Object)posItemCode.getCurrentPrice()) + " - " + POSResourcesUtil.fetchMainRegister().fetchCurrency().nameByLanguage());
        return new MobilePOSResult().fromNormalResult(result, response);
    }

    @GetMapping(value={"promotionalImages"}, produces={"application/json; charset=utf-8"})
    public MobilePOSResult promotionalImages() {
        ArrayList<String> base64Images = new ArrayList<String>();
        try {
            String folderPath = POSGeneralSettings.getPromotionalImagesFolderPath();
            File folder = new File(folderPath);
            if (ObjectChecker.isAnyFalseOrNull((Boolean[])new Boolean[]{folder.exists(), folder.isDirectory()})) {
                return new MobilePOSResult().fromNormalResult(new POSResult(), base64Images);
            }
            File[] files = folder.listFiles();
            if (files == null) {
                files = new File[1];
            }
            for (File file : files) {
                if (ObjectChecker.isAnyFalseOrNull((Boolean[])new Boolean[]{file.isFile() && this.isImageFile(file)})) continue;
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)ImageIO.read(file), "png", outputStream);
                    byte[] imagesBytes = outputStream.toByteArray();
                    base64Images.add(Base64.getEncoder().encodeToString(imagesBytes));
                }
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        return new MobilePOSResult().fromNormalResult(new POSResult(), base64Images);
    }

    private boolean isImageFile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif");
    }

    private class POSMobileActionRequest {
        private Map<String, Object> body;
        private POSSalesInvoice salesInvoice;
        private POSRegistery register;

        public POSMobileActionRequest(MobileInvoicesController mobileInvoicesController, Map<String, Object> body, POSSalesInvoice invoice, POSRegistery register) {
            this.body = body;
            this.salesInvoice = invoice;
            this.register = register;
        }
    }

    private static class PGWPaymentInfo {
        private String pgwResponse = "";
        private Double amount = 0.0;

        private PGWPaymentInfo() {
        }

        public String getPgwResponse() {
            return this.pgwResponse;
        }

        public void setPgwResponse(String pgwResponse) {
            this.pgwResponse = pgwResponse;
        }

        public Double getAmount() {
            return this.amount;
        }

        public void setAmount(Double amount) {
            this.amount = amount;
        }
    }
}

