/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.controllers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class NamaJSON
extends ObjectMapper {
    private static NamaJSON mapper;

    public static NamaJSON instance() {
        if (mapper == null) {
            mapper = new NamaJSON();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mapper.setDateFormat(df);
            SimpleModule customSerializers = new SimpleModule();
            customSerializers.addSerializer(DateWrapper.class, (JsonSerializer)new DateWrapperSerializer());
            customSerializers.addDeserializer(Date.class, (JsonDeserializer)new FlexibleDateDeserializer());
            mapper.registerModule((Module)customSerializers);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new NamaCustomCaseStrategy());
        }
        return mapper;
    }

    public static <T> T read(String json, Class<T> klass) throws IOException {
        if (json == null) {
            return null;
        }
        return (T)NamaJSON.instance().readValue(json, klass);
    }

    public static <T> T read(File file, Class<T> klass) throws IOException {
        if (file == null) {
            return null;
        }
        return (T)NamaJSON.instance().readValue(file, klass);
    }

    public static <T> List<T> readList(String json, Class<T> klass) throws IOException {
        if (json == null) {
            return null;
        }
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, klass);
        return (List)NamaJSON.instance().readValue(json, (JavaType)type);
    }

    public static String toString(Object o) {
        try {
            return NamaJSON.instance().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new NaMaServiceExcepption((Throwable)e);
        }
    }

    private static class DateWrapperSerializer
    extends StdSerializer<DateWrapper> {
        protected DateWrapperSerializer() {
            super(DateWrapper.class);
        }

        public void serialize(DateWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Date date = null;
            if (value != null) {
                date = value.toDate();
            }
            provider.defaultSerializeDateValue(date, gen);
        }
    }

    private static class FlexibleDateDeserializer
    extends StdDeserializer<Date> {
        private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "dd/MM/yyyy", "MM/dd/yyyy"};

        public FlexibleDateDeserializer() {
            this(null);
        }

        public FlexibleDateDeserializer(Class<?> vc) {
            super(vc);
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String dateString = jsonParser.getText();
            if (dateString == null || dateString.trim().isEmpty()) {
                return null;
            }
            dateString = dateString.trim();
            for (String formatString : DATE_FORMATS) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(formatString);
                    format.setLenient(false);
                    return format.parse(dateString);
                }
                catch (ParseException parseException) {
                }
            }
            throw new IOException("Unable to parse date: " + dateString + ". Supported formats: " + Arrays.toString(DATE_FORMATS));
        }
    }

    private static class NamaCustomCaseStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private NamaCustomCaseStrategy() {
        }

        public String translate(String input) {
            if (input == null) {
                return input;
            }
            return input;
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                return StringUtils.firstLetterLower((String)methodName.substring(3));
            }
            return super.nameForSetterMethod(config, method, defaultName);
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                return StringUtils.firstLetterLower((String)methodName.substring(3));
            }
            if (methodName.startsWith("is")) {
                return StringUtils.firstLetterLower((String)methodName.substring(2));
            }
            return super.nameForGetterMethod(config, method, defaultName);
        }
    }
}

