/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.displayPole;

import com.namasoft.common.OSValidator;
import com.namasoft.common.utilities.CommonFilesUtil;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.entities.PosPoleDisplaySpecs;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Modality;

public class DisplayPoleConnector {
    private boolean requiredFilesLoaded = false;
    private Enumeration portList;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private OutputStream outputStream;
    private PosPoleDisplaySpecs posPoleDisplaySpecs;
    private String mustBeRestartMsg = "System Library were configured and you need to restart to use Pole Display  ... Please restart now";
    private String mustRunAsAdminMsg = "You need to run as admin to copy Pole Display required files --------- ";
    private static final byte[] B0x0C = new byte[]{12};

    public void init() {
        try {
            boolean requiredFilesExist;
            String javaHome = System.getProperty("java.home");
            NaMaLogger.info((Object)("java home is --------- " + javaHome));
            File jarFile = new File(javaHome + "/lib/ext/RXTXcomm.jar");
            File serialFile = new File(javaHome + "/bin/rxtxSerial.dll");
            File parallelFile = new File(javaHome + "/bin/rxtxParallel.dll");
            boolean bl = requiredFilesExist = jarFile.exists() && serialFile.exists() && parallelFile.exists();
            if (requiredFilesExist) {
                NaMaLogger.info((Object)"Pole Display libraries already exist");
                this.requiredFilesLoaded = true;
                return;
            }
            if (!OSValidator.isAdmin()) {
                DisplayPoleConnector.showAlertWithMsg(this.mustRunAsAdminMsg);
                return;
            }
            ClassLoader classLoader = DisplayPoleConnector.class.getClassLoader();
            String prefix = OSValidator.OS_NameAbbr + OSValidator.OS_Arch;
            CommonFilesUtil.copyFileUsingStream((InputStream)classLoader.getResourceAsStream(prefix + "/RXTXcomm.jar"), (File)jarFile);
            CommonFilesUtil.copyFileUsingStream((InputStream)classLoader.getResourceAsStream(prefix + "/rxtxSerial.dll"), (File)serialFile);
            CommonFilesUtil.copyFileUsingStream((InputStream)classLoader.getResourceAsStream(prefix + "/rxtxParallel.dll"), (File)parallelFile);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public void open(String portName) {
        try {
            if (!this.requiredFilesLoaded) {
                DisplayPoleConnector.showAlertWithMsg(this.mustBeRestartMsg);
                return;
            }
            this.portList = CommPortIdentifier.getPortIdentifiers();
            while (this.portList.hasMoreElements()) {
                CommPortIdentifier currentPortId = (CommPortIdentifier)this.portList.nextElement();
                if (currentPortId.getPortType() != 1) continue;
                DisplayPoleConnectorUtil.poleLogInfo("Found COMM Port {0}", currentPortId.getName());
                if (!currentPortId.getName().equals(portName)) continue;
                DisplayPoleConnectorUtil.poleLogInfo("Current Active COMM Port is {0}", currentPortId.getName());
                this.portId = currentPortId;
                this.serialPort = (SerialPort)this.portId.open("SimpleWriteApp", 2000);
                this.serialPort.setSerialPortParams(9600, 8, 1, 0);
                return;
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private static void showAlertWithMsg(String msg) {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setHeaderText("Error");
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setContentText(msg);
            alert.showAndWait();
        });
    }

    public void write(String msgString) {
        if (!this.requiredFilesLoaded) {
            DisplayPoleConnector.showAlertWithMsg(this.mustBeRestartMsg);
            return;
        }
        if (this.portId == null) {
            return;
        }
        NaMaLogger.info((String)"Writing {0} to {1} ", (Object[])new Object[]{msgString, this.portId.getName()});
        this.write_(msgString.getBytes());
    }

    public void write_(byte[] messageAsBytes) {
        try {
            if (this.portId == null) {
                return;
            }
            if (this.serialPort == null) {
                return;
            }
            this.outputStream = this.serialPort.getOutputStream();
            this.outputStream.write(messageAsBytes);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public void clearDisplay() {
        this.write_(B0x0C);
    }

    public void close() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public void setPosPoleDisplaySpecs(PosPoleDisplaySpecs posPoleDisplaySpecs) {
        this.posPoleDisplaySpecs = posPoleDisplaySpecs;
    }

    public PosPoleDisplaySpecs getPosPoleDisplaySpecs() {
        return this.posPoleDisplaySpecs;
    }
}

