/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IHasPOSFinancialEffect;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.IPOSHasDateAndTime;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.IPOSDocFile;
import com.namasoft.pos.domain.IPOSWritableFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSShiftTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSTakenElementsPerShiftLine;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSFinancialUtil;
import com.namasoft.pos.util.TableCellCreatorUtil;
import jakarta.persistence.FetchType;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;

@MappedSuperclass
public abstract class AbsPOSShiftInventory<DTOType extends NaMaDTO>
extends POSMasterFile
implements IPOSDocFile,
IHasPOSFinancialEffect,
IPOSHasDateAndTime,
IPOSWritableFile<DTOType> {
    @Temporal(value=TemporalType.DATE)
    private Date shiftDate;
    private String shiftTime;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRegistery registery;
    @Transient
    private IHasToolBar view;
    private Boolean sent = false;
    @Lob
    private String remarks;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSUser posUser;
    private String attach1FilePath;
    private String attach2FilePath;

    public AbsPOSShiftInventory(String code) {
        this.setCode(code);
    }

    public AbsPOSShiftInventory() {
    }

    public String getAttach1FilePath() {
        return this.attach1FilePath;
    }

    public void setAttach1FilePath(String attach1FilePath) {
        this.attach1FilePath = attach1FilePath;
    }

    public String getAttach2FilePath() {
        return this.attach2FilePath;
    }

    public void setAttach2FilePath(String attach2FilePath) {
        this.attach2FilePath = attach2FilePath;
    }

    public POSUser getPosUser() {
        this.posUser = POSPersister.materialize(POSUser.class, this.posUser);
        return this.posUser;
    }

    public void setPosUser(POSUser posUser) {
        this.posUser = posUser;
    }

    public String getTime() {
        return this.shiftTime;
    }

    public void setTime(String time) {
        this.shiftTime = time;
    }

    public POSRegistery getRegistery() {
        this.registery = POSPersister.materialize(POSRegistery.class, this.registery);
        return this.registery;
    }

    public void setRegistery(POSRegistery registery) {
        this.registery = registery;
    }

    public void updateCode(String shiftCode) {
        this.setCode(shiftCode);
    }

    public void updateRegistery(String registeryCode) {
        if (ObjectChecker.isNotEmptyOrNull((Object)registeryCode)) {
            this.setRegistery((POSRegistery)POSPersister.findByCode(POSRegistery.class, registeryCode));
        }
    }

    public Date getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(Date shiftDate) {
        this.shiftDate = shiftDate;
    }

    public String getShiftTime() {
        return this.shiftTime;
    }

    public void setShiftTime(String shiftTime) {
        this.shiftTime = shiftTime;
    }

    public IHasToolBar getView() {
        return this.view;
    }

    public void setView(IHasToolBar view) {
        this.view = view;
    }

    public abstract List<? extends AbsPOSInventoryLine> fetchDetails();

    public List<? extends AbsPOSShiftTakenElementsPerShiftLine> fetchTakenElements() {
        return new ArrayList();
    }

    @Override
    public void initializeLists() {
        this.fetchDetails().size();
        this.fetchTakenElements().size();
    }

    @Override
    public void assignIds() {
        this.getId();
        for (AbsPOSInventoryLine l : this.fetchDetails()) {
            l.getId();
            this.updateShiftOrInventory(l);
        }
    }

    protected abstract void updateShiftOrInventory(AbsPOSInventoryLine var1);

    public abstract void updateDetails(List<? extends AbsPOSInventoryLine> var1);

    public Boolean getSent() {
        return this.sent;
    }

    @Override
    public void setSent(Boolean sent) {
        this.sent = sent;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public abstract AbsPOSInventoryLine createLine();

    @Override
    public void postCommitAction(Session session) {
        POSFinancialUtil.applyEffects(this, session);
    }

    @Override
    public List<? extends IPOSFinancialEffect> effects() {
        return this.fetchDetails();
    }

    @Override
    public Date fetchValueDate() {
        return this.getShiftDate();
    }

    @Override
    public Date fetchValueTime() {
        return this.fetchTime();
    }

    @Override
    public List<POSTableColumn> createColumnList(TableCellCreatorUtil creatorUtil) {
        return creatorUtil.createColumns(Arrays.asList("code", "shiftDate", "shiftTime"));
    }

    @Override
    public String orderByCol() {
        return "shiftDate";
    }

    @Override
    public List<String> filterByFields() {
        List<String> list = super.filterByFields();
        list.add("shiftDate");
        return list;
    }

    @Override
    public Date fetchDate() {
        return this.getShiftDate();
    }

    @Override
    public Date fetchTime() {
        Date vTime = new Date();
        try {
            vTime = new SimpleDateFormat("HH:mm:ss").parse(this.getShiftTime());
        }
        catch (ParseException e) {
            NaMaLogger.error((Throwable)e);
            vTime.setTime(Date.parse(this.getShiftTime()));
        }
        return vTime;
    }

    @Override
    public void updateDate(Date date) {
        this.setShiftDate(date);
    }

    @Override
    public void updateTime(Date time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        this.setShiftTime(df.format(time));
    }

    @Override
    public boolean searchOnAllFields() {
        return true;
    }

    @Override
    public List<String> fetchReferenceFieldsIDs() {
        return Arrays.asList("registery");
    }

    public List<POSTakenElementsPerShiftLine> fetchTakenElementsFor(String entityType) {
        List takenItems = POSResourcesUtil.fetchMainRegister().getTakenElementsPerShiftLines();
        if (ObjectChecker.isEmptyOrNull(takenItems)) {
            takenItems = CollectionsUtility.convert((Collection)POSResourcesUtil.fetchPOSConfig().getTakenElementsPerShift(), POSTakenElementsPerShiftLine::new);
        }
        if (ObjectChecker.isEmptyOrNull(takenItems)) {
            return new ArrayList<POSTakenElementsPerShiftLine>();
        }
        return takenItems.stream().filter(l -> ObjectChecker.isEmptyOrNull((Object)l.getEntityType()) || ObjectChecker.areEqual((Object)l.getEntityType(), (Object)entityType)).toList();
    }

    @Override
    public POSRegistery register() {
        return this.getRegistery();
    }
}

