/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;

public interface IPOSWritableFile<DTOType extends NaMaDTO> {
    public DTOType toDTO();

    default public DTOLargeData createLargeData(String filePath) {
        DTOLargeData attachment = new DTOLargeData();
        File file = new File(filePath);
        DataHandler data = new DataHandler((DataSource)new FileDataSource(file));
        attachment.setData(data);
        DTOFileAttachmentInfo attachmentInfo = new DTOFileAttachmentInfo();
        attachmentInfo.setUpdated(true);
        String fileName = StringUtils.substringAfterLast((String)filePath, (String)"_#_");
        attachmentInfo.setFileName(fileName);
        attachmentInfo.setFileId(UUID.randomUUID().toString());
        attachment.setAttachmentInfo(attachmentInfo);
        attachment.setDataLength(file.length());
        return attachment;
    }

    default public String convertDateToDateTimeString(Date valueDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(valueDate);
    }

    default public Date adjustTimeForTimeZoneDiff(Date date) {
        if (date == null) {
            return date;
        }
        LocalTime localTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalTime();
        return new Date((long)(localTime.getHour() * 60 * 60) * 1000L + (long)(localTime.getMinute() * 60 * 1000) + (long)(localTime.getSecond() * 1000) + (long)(localTime.getNano() / 1000000));
    }

    default public long calcMilliSecFromString(String deliveryDate) {
        String[] deliveryTime = ObjectChecker.toStringOrEmpty((Object)deliveryDate).trim().toLowerCase().replace('.', ':').split(":");
        long ms = 0L;
        for (int i = 0; i < deliveryTime.length; ++i) {
            Integer val = ObjectChecker.tryParseInt((String)deliveryTime[i]);
            if (ObjectChecker.isEmptyOrZero((Integer)val)) continue;
            if (i == 0) {
                ms += (long)(val * 60 * 60 * 1000);
                continue;
            }
            if (i == 1) {
                ms += (long)(val * 60 * 1000);
                continue;
            }
            if (i == 2) {
                ms += (long)(val * 1000);
                continue;
            }
            if (i != 3) break;
            ms += (long)val.intValue();
        }
        return ms;
    }
}

