/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.constants.Language;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.MobilePOSLiteMasterFile;
import com.namasoft.pos.domain.POSLiteCompositeFavouriteBtn;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSHasImage;
import java.util.UUID;

public class POSLiteMasterFile<T extends POSMasterFile> {
    private String code;
    private String name1;
    private String name2;
    private UUID id;
    private String colorCode;
    private String namaEntityType;
    private Boolean hasImage;
    private Class klass;
    private POSLiteCompositeFavouriteBtn btn;

    public POSLiteMasterFile() {
    }

    public POSLiteMasterFile(UUID id, String name1, String name2) {
        this.setId(id);
        this.setName1(name1);
        this.setName2(name2);
    }

    public POSLiteMasterFile(T masterFile) {
        this.setId(((POSMasterFile)masterFile).id);
        this.setCode(((POSMasterFile)masterFile).getCode());
        this.setName1(((POSMasterFile)masterFile).getName1());
        this.setName2(((POSMasterFile)masterFile).getName2());
        this.setColorCode(((POSMasterFile)masterFile).getColorCode());
        this.setHasImage(((POSHasImage)masterFile).isHasImage());
        this.setNamaEntityType(masterFile.calcNamaEntityType());
        this.setKlass(masterFile.getClass());
    }

    public POSLiteMasterFile(MobilePOSLiteMasterFile masterFile) {
        if (masterFile == null) {
            return;
        }
        this.setId(masterFile.getId());
        this.setCode(masterFile.getCode());
        this.setName1(masterFile.getName1());
        this.setName2(masterFile.getName2());
        this.setColorCode(masterFile.getColorCode());
        this.setHasImage(masterFile.getHasImage());
        this.setNamaEntityType(masterFile.getNamaEntityType());
        this.setKlass(masterFile.getKlass());
        if (masterFile.getBtn().getLevel() != null) {
            this.setBtn(new POSLiteCompositeFavouriteBtn(masterFile));
        }
    }

    public Class getKlass() {
        return this.klass;
    }

    public void setKlass(Class klass) {
        this.klass = klass;
    }

    public String nameByLanguage() {
        if (POSResourcesUtil.getCurrentLang().equals((Object)Language.Arabic)) {
            return this.getName1();
        }
        return this.getName2();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public Boolean getHasImage() {
        if (this.hasImage == null) {
            return false;
        }
        return this.hasImage;
    }

    public void setHasImage(Boolean hasImage) {
        this.hasImage = hasImage;
    }

    public String getNamaEntityType() {
        return this.namaEntityType;
    }

    public void setNamaEntityType(String namaEntityType) {
        this.namaEntityType = namaEntityType;
    }

    public POSLiteCompositeFavouriteBtn getBtn() {
        return this.btn;
    }

    public void setBtn(POSLiteCompositeFavouriteBtn btn) {
        this.btn = btn;
    }
}

