/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSPaymentRecipt;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSPaymentToRegister;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSDataWriterUtil;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.Arrays;
import org.hibernate.Session;

@Entity
public class POSPaymentToRegistery
extends AbsPOSPayReceipt {
    @ManyToOne(fetch=FetchType.LAZY)
    private PosCancelReservation cancelReservation;

    public POSPaymentToRegistery() {
    }

    public POSPaymentToRegistery(POSPaymentReciptScreen view) {
        this.setCode(POSCodeGenerator.generateInvoiceCode(POSDocumentType.Payment));
        this.setView(view);
        this.setGenericDims(POSResourcesUtil.fetchRegisterDims());
    }

    public PosCancelReservation getCancelReservation() {
        this.cancelReservation = POSPersister.materialize(PosCancelReservation.class, this.cancelReservation);
        return this.cancelReservation;
    }

    public void setCancelReservation(PosCancelReservation cancelReservation) {
        this.cancelReservation = cancelReservation;
    }

    @Override
    public String calcNamaEntityType() {
        return "POSPaymentToRegister";
    }

    @Override
    public POSMasterFile origin() {
        return this;
    }

    @Override
    public BigDecimal getAmount() {
        if (ObjectChecker.areNotEqual((Object)this.getType(), (Object)"FromRegister")) {
            return BigDecimal.ZERO;
        }
        return this.getValue().negate();
    }

    @Override
    public void writeToServer(POSRegistery register, boolean forceSend, Callback callback) {
        block3: {
            block2: {
                if (forceSend) break block2;
                if (!POSSettingsInfo.mustTransferWithSave(this.calcNamaEntityType()).booleanValue()) break block3;
            }
            POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> POSDataWriterUtil.writePayments(register, Arrays.asList(this), callback)));
        }
    }

    @Override
    public void postCommitAction(Session session) {
        super.postCommitAction(session);
        PosCancelReservation cancelReservation = this.getCancelReservation();
        if (ObjectChecker.isNotEmptyOrNull((Object)cancelReservation)) {
            cancelReservation.setPaid(true);
            POSPersister.saveOrUpdate(cancelReservation, session);
        }
    }

    @Override
    public NaMaDTO toDTO() {
        DTOPOSPaymentToRegister dtoPayment = new DTOPOSPaymentToRegister();
        POSActualDTOConverter.convertToDTO(this, (DTOAbsPOSPaymentRecipt)dtoPayment);
        dtoPayment.setCancelReservation(POSMasterFile.toRef(this.getCancelReservation()));
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getType())) {
            dtoPayment.setType(this.getType());
        }
        return dtoPayment;
    }
}

