/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPosUISettings;
import com.namasoft.modules.namapos.contracts.valueobjects.DTONamaPosUISettingsInfo;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.PosUISettingsOptions;
import com.namasoft.pos.domain.details.AbsPOSFieldLine;
import com.namasoft.pos.domain.details.POSCancelReservationGridLine;
import com.namasoft.pos.domain.details.POSCancelReservationMainLine;
import com.namasoft.pos.domain.details.POSCancelReservationOtherLine;
import com.namasoft.pos.domain.details.POSCustomerDisplayWindowFooterField;
import com.namasoft.pos.domain.details.POSCustomerDisplayWindowHeaderField;
import com.namasoft.pos.domain.details.POSCustomerDisplayWindowTableColumn;
import com.namasoft.pos.domain.details.POSCustomerFieldLine;
import com.namasoft.pos.domain.details.POSFavProcedureLine;
import com.namasoft.pos.domain.details.POSOrderReservationGridLine;
import com.namasoft.pos.domain.details.POSOrderReservationMainLine;
import com.namasoft.pos.domain.details.POSOrderReservationOtherLine;
import com.namasoft.pos.domain.details.POSRegisterGridLine;
import com.namasoft.pos.domain.details.POSRegisterMainLine;
import com.namasoft.pos.domain.details.POSRegisterOtherLine;
import com.namasoft.pos.domain.details.POSReplacementGridLine;
import com.namasoft.pos.domain.details.POSReplacementMainLine;
import com.namasoft.pos.domain.details.POSReplacementOtherLine;
import com.namasoft.pos.domain.details.POSReturnGridLine;
import com.namasoft.pos.domain.details.POSReturnMainLine;
import com.namasoft.pos.domain.details.POSReturnOtherLine;
import com.namasoft.pos.domain.details.POSScrapDocGridLine;
import com.namasoft.pos.domain.details.POSScrapDocMainLine;
import com.namasoft.pos.domain.details.POSScrapDocOtherLine;
import com.namasoft.pos.domain.details.POSShortfallsDocGridLine;
import com.namasoft.pos.domain.details.POSShortfallsDocMainLine;
import com.namasoft.pos.domain.details.POSShortfallsDocOtherLine;
import com.namasoft.pos.domain.details.POSStockReceiptGridLine;
import com.namasoft.pos.domain.details.POSStockReceiptMainLine;
import com.namasoft.pos.domain.details.POSStockReceiptOtherLine;
import com.namasoft.pos.domain.details.POSTakingGridLine;
import com.namasoft.pos.domain.details.POSTakingMainLine;
import com.namasoft.pos.domain.details.POSTakingOtherLine;
import com.namasoft.pos.domain.details.POSTransferGridLine;
import com.namasoft.pos.domain.details.POSTransferMainLine;
import com.namasoft.pos.domain.details.POSTransferOtherLine;
import com.namasoft.pos.domain.details.POSUISettingsSearchDialogueColumn;
import com.namasoft.pos.domain.details.POSUISettingsSearchDialogueConfigLine;
import com.namasoft.pos.domain.details.POSUISettingsSearchDialogueFilterLine;
import com.namasoft.pos.domain.valueobjects.PosUiBasicInfo;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Session;

@Entity
public class PosUISettings
extends POSMasterFile<DTONamaPosUISettings> {
    @Embedded
    private PosUISettingsOptions uiSettingsOptions;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="colsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="doNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="favouritePaneWidthPercent"))})
    private PosUiBasicInfo invoiceBasicInfo;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSRegisterMainLine> mainPageFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSRegisterOtherLine> otherPageFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSRegisterGridLine> salesGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReturnMainLine> returnMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReplacementMainLine> replacementMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTransferMainLine> transferMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTakingMainLine> takingMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSOrderReservationMainLine> orderReservationMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSCancelReservationMainLine> cancelReservationMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSStockReceiptMainLine> stockReceiptMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSShortfallsDocMainLine> shortfallsDocMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSScrapDocMainLine> scrapDocMainFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReturnOtherLine> returnOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReplacementOtherLine> replacementOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTransferOtherLine> transferOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTakingOtherLine> takingOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSOrderReservationOtherLine> orderReservationOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSCancelReservationOtherLine> cancelReservationOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSStockReceiptOtherLine> stockReceiptOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSShortfallsDocOtherLine> shortfallsDocOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSScrapDocOtherLine> scrapDocOtherFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReturnGridLine> returnGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSReplacementGridLine> replacementGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTransferGridLine> transferGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSTakingGridLine> takingGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSOrderReservationGridLine> orderReservationGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSCancelReservationGridLine> cancelReservationGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSStockReceiptGridLine> stockReceiptGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSShortfallsDocGridLine> shortfallsDocGridFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="posSettings")
    @OrderColumn(name="lineNumber")
    List<POSScrapDocGridLine> scrapDocGridFields;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="retColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="retDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="retFavouritePaneWidthPercent"))})
    private PosUiBasicInfo returnBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="repColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="repDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="repFavouritePaneWidthPercent"))})
    private PosUiBasicInfo replacementBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="trColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="trDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="trFavouritePaneWidthPercent"))})
    private PosUiBasicInfo transferBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="depColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="depDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="depFavouritePaneWidthPercent"))})
    private PosUiBasicInfo scrapDocBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="sfColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="sfDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="sfFavouritePaneWidthPercent"))})
    private PosUiBasicInfo shortfallsDocBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="takColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="takDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="takFavouritePaneWidthPercent"))})
    private PosUiBasicInfo takingBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="ordColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="ordDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="ordFavouritePaneWidthPercent"))})
    private PosUiBasicInfo orderReservationBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="cancelColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="cancelDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="cancelFavouritePaneWidthPercent"))})
    private PosUiBasicInfo canelReservationBasicInfo;
    @AttributeOverrides(value={@AttributeOverride(name="colsCountPerRow", column=@Column(name="rcptColsCountPerRow")), @AttributeOverride(name="doNotAddFavouritesPart", column=@Column(name="rcptDoNotAddFavouritesPart")), @AttributeOverride(name="favouritePaneWidthPercent", column=@Column(name="rcptFavouritePaneWidthPercent"))})
    private PosUiBasicInfo stockReceiptBasicInfo;
    private Boolean doNotAddSalesLineDuplBtn;
    private Boolean doNotAddSalesLineRemovelBtn;
    private Boolean doNotAddSalesLineIncQtyBtn;
    private Boolean doNotAddSalesLineDecQtyBtn;
    private Boolean doNotAddSalesLineDepreciateBtn;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSUISettingsSearchDialogueColumn> searchDialogueFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    private List<POSFavProcedureLine> procedures;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSUISettingsSearchDialogueConfigLine> searchDialogueConfigLines;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSUISettingsSearchDialogueFilterLine> searchDialogueFilters;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSCustomerDisplayWindowHeaderField> customerDisplayWindowHeaderFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSCustomerDisplayWindowTableColumn> customerDisplayWindowTableColumns;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSCustomerDisplayWindowFooterField> customerDisplayWindowFooterFields;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="lineNumber")
    @JoinColumn(name="posUISettings_id")
    private List<POSCustomerFieldLine> customerFields;
    private String totalsPaneColor;
    private String totalsPaneFontColor;

    public PosUISettingsOptions getUiSettingsOptions() {
        if (this.uiSettingsOptions == null) {
            this.uiSettingsOptions = new PosUISettingsOptions();
            return this.uiSettingsOptions;
        }
        return this.uiSettingsOptions;
    }

    public void setUiSettingsOptions(PosUISettingsOptions uiSettingsOptions) {
        this.uiSettingsOptions = uiSettingsOptions;
    }

    public Boolean getDoNotAddSalesLineDuplBtn() {
        if (this.doNotAddSalesLineDuplBtn == null) {
            this.doNotAddSalesLineDuplBtn = false;
        }
        return this.doNotAddSalesLineDuplBtn;
    }

    public void setDoNotAddSalesLineDuplBtn(Boolean doNotAddSalesLineDuplBtn) {
        this.doNotAddSalesLineDuplBtn = doNotAddSalesLineDuplBtn;
    }

    public Boolean getDoNotAddSalesLineRemovelBtn() {
        if (this.doNotAddSalesLineRemovelBtn == null) {
            this.doNotAddSalesLineRemovelBtn = false;
        }
        return this.doNotAddSalesLineRemovelBtn;
    }

    public void setDoNotAddSalesLineRemovelBtn(Boolean doNotAddSalesLineRemovelBtn) {
        this.doNotAddSalesLineRemovelBtn = doNotAddSalesLineRemovelBtn;
    }

    public Boolean getDoNotAddSalesLineIncQtyBtn() {
        if (this.doNotAddSalesLineIncQtyBtn == null) {
            this.doNotAddSalesLineIncQtyBtn = false;
        }
        return this.doNotAddSalesLineIncQtyBtn;
    }

    public void setDoNotAddSalesLineIncQtyBtn(Boolean doNotAddSalesLineIncQtyBtn) {
        this.doNotAddSalesLineIncQtyBtn = doNotAddSalesLineIncQtyBtn;
    }

    public Boolean getDoNotAddSalesLineDecQtyBtn() {
        if (this.doNotAddSalesLineDecQtyBtn == null) {
            this.doNotAddSalesLineDecQtyBtn = false;
        }
        return this.doNotAddSalesLineDecQtyBtn;
    }

    public void setDoNotAddSalesLineDecQtyBtn(Boolean doNotAddSalesLineDecQtyBtn) {
        this.doNotAddSalesLineDecQtyBtn = doNotAddSalesLineDecQtyBtn;
    }

    public Boolean getDoNotAddSalesLineDepreciateBtn() {
        if (this.doNotAddSalesLineDepreciateBtn == null) {
            this.doNotAddSalesLineDepreciateBtn = false;
        }
        return this.doNotAddSalesLineDepreciateBtn;
    }

    public void setDoNotAddSalesLineDepreciateBtn(Boolean doNotAddSalesLineDepreciateBtn) {
        this.doNotAddSalesLineDepreciateBtn = doNotAddSalesLineDepreciateBtn;
    }

    public List<POSUISettingsSearchDialogueColumn> getSearchDialogueFields() {
        if (this.searchDialogueFields == null) {
            return new ArrayList<POSUISettingsSearchDialogueColumn>();
        }
        return this.searchDialogueFields;
    }

    public void setSearchDialogueFields(List<POSUISettingsSearchDialogueColumn> searchDialogueFields) {
        this.searchDialogueFields = searchDialogueFields;
    }

    public List<POSFavProcedureLine> getProcedures() {
        if (this.procedures == null) {
            return new ArrayList<POSFavProcedureLine>();
        }
        return this.procedures;
    }

    public void setProcedures(List<POSFavProcedureLine> procedures) {
        this.procedures = procedures;
    }

    public List<POSUISettingsSearchDialogueConfigLine> getSearchDialogueConfigLines() {
        if (this.searchDialogueConfigLines == null) {
            this.searchDialogueConfigLines = new ArrayList<POSUISettingsSearchDialogueConfigLine>();
        }
        return this.searchDialogueConfigLines;
    }

    public void setSearchDialogueConfigLines(List<POSUISettingsSearchDialogueConfigLine> searchDialogueConfigLines) {
        this.searchDialogueConfigLines = searchDialogueConfigLines;
    }

    public List<POSUISettingsSearchDialogueFilterLine> getSearchDialogueFilters() {
        if (this.searchDialogueFilters == null) {
            this.searchDialogueFilters = new ArrayList<POSUISettingsSearchDialogueFilterLine>();
        }
        return this.searchDialogueFilters;
    }

    public void setSearchDialogueFilters(List<POSUISettingsSearchDialogueFilterLine> searchDialogueFilters) {
        this.searchDialogueFilters = searchDialogueFilters;
    }

    public List<POSCustomerDisplayWindowHeaderField> getCustomerDisplayWindowHeaderFields() {
        if (this.customerDisplayWindowHeaderFields == null) {
            this.customerDisplayWindowHeaderFields = new ArrayList<POSCustomerDisplayWindowHeaderField>();
        }
        return this.customerDisplayWindowHeaderFields;
    }

    public void setCustomerDisplayWindowHeaderFields(List<POSCustomerDisplayWindowHeaderField> customerDisplayWindowHeaderFields) {
        this.customerDisplayWindowHeaderFields = customerDisplayWindowHeaderFields;
    }

    public List<POSCustomerDisplayWindowTableColumn> getCustomerDisplayWindowTableColumns() {
        if (this.customerDisplayWindowTableColumns == null) {
            this.customerDisplayWindowTableColumns = new ArrayList<POSCustomerDisplayWindowTableColumn>();
        }
        return this.customerDisplayWindowTableColumns;
    }

    public void setCustomerDisplayWindowTableColumns(List<POSCustomerDisplayWindowTableColumn> customerDisplayWindowTableColumns) {
        this.customerDisplayWindowTableColumns = customerDisplayWindowTableColumns;
    }

    public List<POSCustomerDisplayWindowFooterField> getCustomerDisplayWindowFooterFields() {
        if (this.customerDisplayWindowFooterFields == null) {
            this.customerDisplayWindowFooterFields = new ArrayList<POSCustomerDisplayWindowFooterField>();
        }
        return this.customerDisplayWindowFooterFields;
    }

    public void setCustomerDisplayWindowFooterFields(List<POSCustomerDisplayWindowFooterField> customerDisplayWindowFooterFields) {
        this.customerDisplayWindowFooterFields = customerDisplayWindowFooterFields;
    }

    public List<POSCustomerFieldLine> getCustomerFields() {
        if (this.customerFields == null) {
            this.customerFields = new ArrayList<POSCustomerFieldLine>();
        }
        return this.customerFields;
    }

    public void setCustomerFields(List<POSCustomerFieldLine> customerFields) {
        this.customerFields = customerFields;
    }

    public String getTotalsPaneColor() {
        return this.totalsPaneColor;
    }

    public void setTotalsPaneColor(String totalsPaneColor) {
        this.totalsPaneColor = totalsPaneColor;
    }

    public String getTotalsPaneFontColor() {
        return this.totalsPaneFontColor;
    }

    public void setTotalsPaneFontColor(String totalsPaneFontColor) {
        this.totalsPaneFontColor = totalsPaneFontColor;
    }

    @Override
    public void updateData(DTONamaPosUISettings object) {
        super.updateData(object);
        this.getUiSettingsOptions().updateData(object);
        this.setDoNotAddSalesLineDecQtyBtn(object.getDoNotAddSalesLineDecQtyBtn());
        this.setDoNotAddSalesLineDuplBtn(object.getDoNotAddSalesLineDuplBtn());
        this.setDoNotAddSalesLineIncQtyBtn(object.getDoNotAddSalesLineIncQtyBtn());
        this.setDoNotAddSalesLineRemovelBtn(object.getDoNotAddSalesLineRemovelBtn());
        this.setDoNotAddSalesLineDepreciateBtn(object.getDoNotAddSalesLineDepreciateBtn());
        List mainLines = CollectionsUtility.convert((Collection)object.getMainPageFields(), POSRegisterMainLine::new);
        List otherLines = CollectionsUtility.convert((Collection)object.getOtherPageFields(), POSRegisterOtherLine::new);
        List gridLines = CollectionsUtility.convert((Collection)object.getSalesGridFields(), POSRegisterGridLine::new);
        this.fillUiSettingPart(this.getInvoiceBasicInfo(), object.getInvoiceUiInfo(), mainLines, otherLines, gridLines, this::setInvoiceBasicInfo, PosUISettings::getMainPageFields, PosUISettings::getOtherPageFields, PosUISettings::getSalesGridFields);
        List retMainLines = CollectionsUtility.convert((Collection)object.getReturnMainFields(), POSReturnMainLine::new);
        List retOtherLines = CollectionsUtility.convert((Collection)object.getReturnOtherFields(), POSReturnOtherLine::new);
        List retGridLines = CollectionsUtility.convert((Collection)object.getReturnGridFields(), POSReturnGridLine::new);
        this.fillUiSettingPart(this.getReturnBasicInfo(), object.getReturnUiInfo(), retMainLines, retOtherLines, retGridLines, this::setReturnBasicInfo, PosUISettings::getReturnMainFields, PosUISettings::getReturnOtherFields, PosUISettings::getReturnGridFields);
        List repMainLines = CollectionsUtility.convert((Collection)object.getReplacementMainFields(), POSReplacementMainLine::new);
        List repOtherLines = CollectionsUtility.convert((Collection)object.getReplacementOtherFields(), POSReplacementOtherLine::new);
        List repGridLines = CollectionsUtility.convert((Collection)object.getReplacementGridFields(), POSReplacementGridLine::new);
        this.fillUiSettingPart(this.getReplacementBasicInfo(), object.getReplacementUiInfo(), repMainLines, repOtherLines, repGridLines, this::setReplacementBasicInfo, PosUISettings::getReplacementMainFields, PosUISettings::getReplacementOtherFields, PosUISettings::getReplacementGridFields);
        List transferMainLines = CollectionsUtility.convert((Collection)object.getTransferMainFields(), POSTransferMainLine::new);
        List transferOtherLines = CollectionsUtility.convert((Collection)object.getTransferOtherFields(), POSTransferOtherLine::new);
        List transferGridLines = CollectionsUtility.convert((Collection)object.getTransferGridFields(), POSTransferGridLine::new);
        this.fillUiSettingPart(this.getTransferBasicInfo(), object.getTransferUiInfo(), transferMainLines, transferOtherLines, transferGridLines, this::setTransferBasicInfo, PosUISettings::getTransferMainFields, PosUISettings::getTransferOtherFields, PosUISettings::getTransferGridFields);
        List takingMainLines = CollectionsUtility.convert((Collection)object.getTakingMainFields(), POSTakingMainLine::new);
        List takingOtherLines = CollectionsUtility.convert((Collection)object.getTakingOtherFields(), POSTakingOtherLine::new);
        List takingGridLines = CollectionsUtility.convert((Collection)object.getTakingGridFields(), POSTakingGridLine::new);
        this.fillUiSettingPart(this.getTakingBasicInfo(), object.getTakingUiInfo(), takingMainLines, takingOtherLines, takingGridLines, this::setTakingBasicInfo, PosUISettings::getTakingMainFields, PosUISettings::getTakingOtherFields, PosUISettings::getTakingGridFields);
        List orderReservationMainLines = CollectionsUtility.convert((Collection)object.getOrderReservationMainFields(), POSOrderReservationMainLine::new);
        List orderReservationOtherLines = CollectionsUtility.convert((Collection)object.getOrderReservationOtherFields(), POSOrderReservationOtherLine::new);
        List orderReservationGridLines = CollectionsUtility.convert((Collection)object.getOrderReservationGridFields(), POSOrderReservationGridLine::new);
        this.fillUiSettingPart(this.getOrderReservationBasicInfo(), object.getOrderReservationUiInfo(), orderReservationMainLines, orderReservationOtherLines, orderReservationGridLines, this::setOrderReservationBasicInfo, PosUISettings::getOrderReservationMainFields, PosUISettings::getOrderReservationOtherFields, PosUISettings::getOrderReservationGridFields);
        List cancelReservationMainLines = CollectionsUtility.convert((Collection)object.getCancelReservationMainFields(), POSCancelReservationMainLine::new);
        List cancelReservationOtherLines = CollectionsUtility.convert((Collection)object.getCancelReservationOtherFields(), POSCancelReservationOtherLine::new);
        List cancelReservationGridLines = CollectionsUtility.convert((Collection)object.getCancelReservationGridFields(), POSCancelReservationGridLine::new);
        this.fillUiSettingPart(this.getCanelReservationBasicInfo(), object.getCancelReservationUiInfo(), cancelReservationMainLines, cancelReservationOtherLines, cancelReservationGridLines, this::setCanelReservationBasicInfo, PosUISettings::getCancelReservationMainFields, PosUISettings::getCancelReservationOtherFields, PosUISettings::getCancelReservationGridFields);
        List receiptMainLines = CollectionsUtility.convert((Collection)object.getReceiptMainFields(), POSStockReceiptMainLine::new);
        List receiptOtherLines = CollectionsUtility.convert((Collection)object.getReceiptOtherFields(), POSStockReceiptOtherLine::new);
        List receiptGridLines = CollectionsUtility.convert((Collection)object.getReceiptGridFields(), POSStockReceiptGridLine::new);
        this.fillUiSettingPart(this.getStockReceiptBasicInfo(), object.getReceiptUiInfo(), receiptMainLines, receiptOtherLines, receiptGridLines, this::setStockReceiptBasicInfo, PosUISettings::getStockReceiptMainFields, PosUISettings::getStockReceiptOtherFields, PosUISettings::getStockReceiptGridFields);
        List shortfallsDocMainLines = CollectionsUtility.convert((Collection)object.getShortfallsDocMainFields(), POSShortfallsDocMainLine::new);
        List shortfallsDocOtherLines = CollectionsUtility.convert((Collection)object.getShortfallsDocOtherFields(), POSShortfallsDocOtherLine::new);
        List shortfallsDocGridLines = CollectionsUtility.convert((Collection)object.getShortfallsDocGridFields(), POSShortfallsDocGridLine::new);
        this.fillUiSettingPart(this.getShortfallsDocBasicInfo(), object.getShortfallsDocUiInfo(), shortfallsDocMainLines, shortfallsDocOtherLines, shortfallsDocGridLines, this::setShortfallsDocBasicInfo, PosUISettings::getShortfallsDocMainFields, PosUISettings::getShortfallsDocOtherFields, PosUISettings::getShortfallsDocGridFields);
        List scrapDocMainLines = CollectionsUtility.convert((Collection)object.getScrapDocMainFields(), POSScrapDocMainLine::new);
        List scrapDocOtherLines = CollectionsUtility.convert((Collection)object.getScrapDocOtherFields(), POSScrapDocOtherLine::new);
        List scrapDocGridLines = CollectionsUtility.convert((Collection)object.getScrapDocGridFields(), POSScrapDocGridLine::new);
        this.fillUiSettingPart(this.getScrapDocBasicInfo(), object.getScrapDocUiInfo(), scrapDocMainLines, scrapDocOtherLines, scrapDocGridLines, this::setScrapDocBasicInfo, PosUISettings::getScrapDocMainFields, PosUISettings::getScrapDocOtherFields, PosUISettings::getScrapDocGridFields);
        this.getSearchDialogueFields().clear();
        this.getSearchDialogueFields().addAll(CollectionsUtility.convert((Collection)object.getSearchDialogueColumns(), POSUISettingsSearchDialogueColumn::new));
        this.getProcedures().clear();
        this.getProcedures().addAll(CollectionsUtility.convert((Collection)object.getPosFavProcedures(), POSFavProcedureLine::new));
        this.getSearchDialogueConfigLines().clear();
        this.getSearchDialogueConfigLines().addAll(CollectionsUtility.convert((Collection)object.getSearchDialogueConfigLines(), POSUISettingsSearchDialogueConfigLine::new));
        this.getSearchDialogueFilters().clear();
        this.getSearchDialogueFilters().addAll(CollectionsUtility.convert((Collection)object.getSearchDialogueFilters(), POSUISettingsSearchDialogueFilterLine::new));
        this.getCustomerDisplayWindowHeaderFields().clear();
        this.getCustomerDisplayWindowHeaderFields().addAll(CollectionsUtility.convert((Collection)object.getCustomerDisplayWindowHeaderFields(), POSCustomerDisplayWindowHeaderField::new));
        this.getCustomerDisplayWindowTableColumns().clear();
        this.getCustomerDisplayWindowTableColumns().addAll(CollectionsUtility.convert((Collection)object.getCustomerDisplayWindowTableColumns(), POSCustomerDisplayWindowTableColumn::new));
        this.getCustomerDisplayWindowFooterFields().clear();
        this.getCustomerDisplayWindowFooterFields().addAll(CollectionsUtility.convert((Collection)object.getCustomerDisplayWindowFooterFields(), POSCustomerDisplayWindowFooterField::new));
        this.getCustomerFields().clear();
        this.getCustomerFields().addAll(CollectionsUtility.convert((Collection)object.getCustomerFields(), POSCustomerFieldLine::new));
        this.setTotalsPaneColor(object.getTotalsPaneColor());
        this.setTotalsPaneFontColor(object.getTotalsPaneFontColor());
    }

    private void fillUiSettingPart(PosUiBasicInfo basicInfo, DTONamaPosUISettingsInfo invoiceUiInfo, List<? extends AbsPOSFieldLine> mainLines, List<? extends AbsPOSFieldLine> otherLines, List<? extends AbsPOSFieldLine> gridLines, Consumer<PosUiBasicInfo> setter, Function<PosUISettings, List<? extends AbsPOSFieldLine>> mainFieldsFetcher, Function<PosUISettings, List<? extends AbsPOSFieldLine>> otherFieldsFetcher, Function<PosUISettings, List<? extends AbsPOSFieldLine>> gridFieldsFetcher) {
        if (ObjectChecker.isEmptyOrNull((Object)basicInfo)) {
            basicInfo = new PosUiBasicInfo();
        }
        if (invoiceUiInfo != null) {
            basicInfo.setColsCountPerRow(invoiceUiInfo.getColsCountPerRow());
            basicInfo.setDoNotAddFavouritesPart(invoiceUiInfo.getDoNotAddFavouritesPart());
            basicInfo.setFavouritePaneWidthPercent(invoiceUiInfo.getFavouritePaneWidthPercent());
        }
        setter.accept(basicInfo);
        mainFieldsFetcher.apply(this).clear();
        mainFieldsFetcher.apply(this).addAll(mainLines);
        otherFieldsFetcher.apply(this).clear();
        otherFieldsFetcher.apply(this).addAll(otherLines);
        gridFieldsFetcher.apply(this).clear();
        gridFieldsFetcher.apply(this).addAll(gridLines);
    }

    @Override
    public void postCommitAction(Session session) {
        POSResourcesUtil.cacheRegisterConfigFields();
        PosScreenCacheUtil.clear();
    }

    public List<POSStockReceiptMainLine> getStockReceiptMainFields() {
        if (this.stockReceiptMainFields == null) {
            this.stockReceiptMainFields = new ArrayList<POSStockReceiptMainLine>();
            return this.stockReceiptMainFields;
        }
        return this.stockReceiptMainFields;
    }

    public void setStockReceiptMainFields(List<POSStockReceiptMainLine> stockReceiptMainFields) {
        this.stockReceiptMainFields = stockReceiptMainFields;
    }

    public List<POSStockReceiptOtherLine> getStockReceiptOtherFields() {
        if (this.stockReceiptOtherFields == null) {
            this.stockReceiptOtherFields = new ArrayList<POSStockReceiptOtherLine>();
            return this.stockReceiptOtherFields;
        }
        return this.stockReceiptOtherFields;
    }

    public void setStockReceiptOtherFields(List<POSStockReceiptOtherLine> stockReceiptOtherFields) {
        this.stockReceiptOtherFields = stockReceiptOtherFields;
    }

    public List<POSStockReceiptGridLine> getStockReceiptGridFields() {
        if (this.stockReceiptGridFields == null) {
            this.stockReceiptGridFields = new ArrayList<POSStockReceiptGridLine>();
            return this.stockReceiptGridFields;
        }
        return this.stockReceiptGridFields;
    }

    public void setStockReceiptGridFields(List<POSStockReceiptGridLine> stockReceiptGridFields) {
        this.stockReceiptGridFields = stockReceiptGridFields;
    }

    public PosUiBasicInfo getStockReceiptBasicInfo() {
        return this.stockReceiptBasicInfo;
    }

    public void setStockReceiptBasicInfo(PosUiBasicInfo stockReceiptBasicInfo) {
        this.stockReceiptBasicInfo = stockReceiptBasicInfo;
    }

    public List<POSCancelReservationMainLine> getCancelReservationMainFields() {
        if (this.cancelReservationMainFields == null) {
            this.cancelReservationMainFields = new ArrayList<POSCancelReservationMainLine>();
            return this.cancelReservationMainFields;
        }
        return this.cancelReservationMainFields;
    }

    public void setCancelReservationMainFields(List<POSCancelReservationMainLine> cancelReservationMainFields) {
        this.cancelReservationMainFields = cancelReservationMainFields;
    }

    public List<POSCancelReservationOtherLine> getCancelReservationOtherFields() {
        if (this.cancelReservationOtherFields == null) {
            this.cancelReservationOtherFields = new ArrayList<POSCancelReservationOtherLine>();
            return this.cancelReservationOtherFields;
        }
        return this.cancelReservationOtherFields;
    }

    public void setCancelReservationOtherFields(List<POSCancelReservationOtherLine> cancelReservationOtherFields) {
        this.cancelReservationOtherFields = cancelReservationOtherFields;
    }

    public List<POSCancelReservationGridLine> getCancelReservationGridFields() {
        if (this.cancelReservationGridFields == null) {
            this.cancelReservationGridFields = new ArrayList<POSCancelReservationGridLine>();
            return this.cancelReservationGridFields;
        }
        return this.cancelReservationGridFields;
    }

    public void setCancelReservationGridFields(List<POSCancelReservationGridLine> cancelReservationGridFields) {
        this.cancelReservationGridFields = cancelReservationGridFields;
    }

    public List<POSReturnMainLine> getReturnMainFields() {
        if (this.returnMainFields == null) {
            this.returnMainFields = new ArrayList<POSReturnMainLine>();
            return this.returnMainFields;
        }
        return this.returnMainFields;
    }

    public void setReturnMainFields(List<POSReturnMainLine> returnMainFields) {
        this.returnMainFields = returnMainFields;
    }

    public List<POSReplacementMainLine> getReplacementMainFields() {
        if (this.replacementMainFields == null) {
            this.replacementMainFields = new ArrayList<POSReplacementMainLine>();
            return this.replacementMainFields;
        }
        return this.replacementMainFields;
    }

    public void setReplacementMainFields(List<POSReplacementMainLine> replacementMainFields) {
        this.replacementMainFields = replacementMainFields;
    }

    public List<POSTransferMainLine> getTransferMainFields() {
        if (this.transferMainFields == null) {
            this.transferMainFields = new ArrayList<POSTransferMainLine>();
            return this.transferMainFields;
        }
        return this.transferMainFields;
    }

    public void setTransferMainFields(List<POSTransferMainLine> transferMainFields) {
        this.transferMainFields = transferMainFields;
    }

    public List<POSTakingMainLine> getTakingMainFields() {
        if (this.takingMainFields == null) {
            this.takingMainFields = new ArrayList<POSTakingMainLine>();
            return this.takingMainFields;
        }
        return this.takingMainFields;
    }

    public void setTakingMainFields(List<POSTakingMainLine> takingMainFields) {
        this.takingMainFields = takingMainFields;
    }

    public List<POSReturnOtherLine> getReturnOtherFields() {
        if (this.returnOtherFields == null) {
            this.returnOtherFields = new ArrayList<POSReturnOtherLine>();
            return this.returnOtherFields;
        }
        return this.returnOtherFields;
    }

    public void setReturnOtherFields(List<POSReturnOtherLine> returnOtherFields) {
        this.returnOtherFields = returnOtherFields;
    }

    public List<POSReplacementOtherLine> getReplacementOtherFields() {
        if (this.replacementOtherFields == null) {
            this.replacementOtherFields = new ArrayList<POSReplacementOtherLine>();
            return this.replacementOtherFields;
        }
        return this.replacementOtherFields;
    }

    public void setReplacementOtherFields(List<POSReplacementOtherLine> replacementOtherFields) {
        this.replacementOtherFields = replacementOtherFields;
    }

    public List<POSTransferOtherLine> getTransferOtherFields() {
        if (this.transferOtherFields == null) {
            this.transferOtherFields = new ArrayList<POSTransferOtherLine>();
            return this.transferOtherFields;
        }
        return this.transferOtherFields;
    }

    public void setTransferOtherFields(List<POSTransferOtherLine> transferOtherFields) {
        this.transferOtherFields = transferOtherFields;
    }

    public List<POSTakingOtherLine> getTakingOtherFields() {
        if (this.takingOtherFields == null) {
            this.takingOtherFields = new ArrayList<POSTakingOtherLine>();
            return this.takingOtherFields;
        }
        return this.takingOtherFields;
    }

    public void setTakingOtherFields(List<POSTakingOtherLine> takingOtherFields) {
        this.takingOtherFields = takingOtherFields;
    }

    public List<POSReturnGridLine> getReturnGridFields() {
        if (this.returnGridFields == null) {
            this.returnGridFields = new ArrayList<POSReturnGridLine>();
            return this.returnGridFields;
        }
        return this.returnGridFields;
    }

    public void setReturnGridFields(List<POSReturnGridLine> returnGridFields) {
        this.returnGridFields = returnGridFields;
    }

    public List<POSReplacementGridLine> getReplacementGridFields() {
        if (this.replacementGridFields == null) {
            this.replacementGridFields = new ArrayList<POSReplacementGridLine>();
            return this.replacementGridFields;
        }
        return this.replacementGridFields;
    }

    public void setReplacementGridFields(List<POSReplacementGridLine> replacementGridFields) {
        this.replacementGridFields = replacementGridFields;
    }

    public List<POSTransferGridLine> getTransferGridFields() {
        if (this.transferGridFields == null) {
            this.transferGridFields = new ArrayList<POSTransferGridLine>();
            return this.transferGridFields;
        }
        return this.transferGridFields;
    }

    public void setTransferGridFields(List<POSTransferGridLine> transferGridFields) {
        this.transferGridFields = transferGridFields;
    }

    public List<POSTakingGridLine> getTakingGridFields() {
        if (this.takingGridFields == null) {
            this.takingGridFields = new ArrayList<POSTakingGridLine>();
            return this.takingGridFields;
        }
        return this.takingGridFields;
    }

    public void setTakingGridFields(List<POSTakingGridLine> takingGridFields) {
        this.takingGridFields = takingGridFields;
    }

    public PosUiBasicInfo getReturnBasicInfo() {
        return this.returnBasicInfo;
    }

    public void setReturnBasicInfo(PosUiBasicInfo returnBasicInfo) {
        this.returnBasicInfo = returnBasicInfo;
    }

    public PosUiBasicInfo getReplacementBasicInfo() {
        return this.replacementBasicInfo;
    }

    public void setReplacementBasicInfo(PosUiBasicInfo replacementBasicInfo) {
        this.replacementBasicInfo = replacementBasicInfo;
    }

    public PosUiBasicInfo getTransferBasicInfo() {
        return this.transferBasicInfo;
    }

    public PosUiBasicInfo getScrapDocBasicInfo() {
        return this.scrapDocBasicInfo;
    }

    public PosUiBasicInfo getShortfallsDocBasicInfo() {
        return this.shortfallsDocBasicInfo;
    }

    public void setTransferBasicInfo(PosUiBasicInfo transferBasicInfo) {
        this.transferBasicInfo = transferBasicInfo;
    }

    public void setShortfallsDocBasicInfo(PosUiBasicInfo shortfallsBasicInfo) {
        this.shortfallsDocBasicInfo = shortfallsBasicInfo;
    }

    public void setScrapDocBasicInfo(PosUiBasicInfo scrapDocBasicInfo) {
        this.scrapDocBasicInfo = scrapDocBasicInfo;
    }

    public PosUiBasicInfo getTakingBasicInfo() {
        return this.takingBasicInfo;
    }

    public void setTakingBasicInfo(PosUiBasicInfo takingBasicInfo) {
        this.takingBasicInfo = takingBasicInfo;
    }

    public List<POSRegisterMainLine> getMainPageFields() {
        if (this.mainPageFields == null) {
            this.mainPageFields = new ArrayList<POSRegisterMainLine>();
            return this.mainPageFields;
        }
        return this.mainPageFields;
    }

    public void setMainPageFields(List<POSRegisterMainLine> mainPageFields) {
        this.mainPageFields = mainPageFields;
    }

    public List<POSRegisterOtherLine> getOtherPageFields() {
        if (this.otherPageFields == null) {
            this.otherPageFields = new ArrayList<POSRegisterOtherLine>();
            return this.otherPageFields;
        }
        return this.otherPageFields;
    }

    public List<POSShortfallsDocMainLine> getShortfallsDocMainFields() {
        if (this.shortfallsDocMainFields == null) {
            this.shortfallsDocMainFields = new ArrayList<POSShortfallsDocMainLine>();
            return this.shortfallsDocMainFields;
        }
        return this.shortfallsDocMainFields;
    }

    public void setShortfallsDocMainFields(List<POSShortfallsDocMainLine> shortfallsMainFields) {
        this.shortfallsDocMainFields = shortfallsMainFields;
    }

    public List<POSScrapDocMainLine> getScrapDocMainFields() {
        if (this.scrapDocMainFields == null) {
            this.scrapDocMainFields = new ArrayList<POSScrapDocMainLine>();
            return this.scrapDocMainFields;
        }
        return this.scrapDocMainFields;
    }

    public void setScrapDocMainFields(List<POSScrapDocMainLine> scrapDocMainFields) {
        this.scrapDocMainFields = scrapDocMainFields;
    }

    public List<POSShortfallsDocOtherLine> getShortfallsDocOtherFields() {
        if (this.shortfallsDocOtherFields == null) {
            this.shortfallsDocOtherFields = new ArrayList<POSShortfallsDocOtherLine>();
            return this.shortfallsDocOtherFields;
        }
        return this.shortfallsDocOtherFields;
    }

    public void setShortfallsDocOtherFields(List<POSShortfallsDocOtherLine> shortfallsOtherFields) {
        this.shortfallsDocOtherFields = shortfallsOtherFields;
    }

    public List<POSScrapDocOtherLine> getScrapDocOtherFields() {
        if (this.scrapDocOtherFields == null) {
            this.scrapDocOtherFields = new ArrayList<POSScrapDocOtherLine>();
            return this.scrapDocOtherFields;
        }
        return this.scrapDocOtherFields;
    }

    public void setScrapDocOtherFields(List<POSScrapDocOtherLine> scrapDocOtherFields) {
        this.scrapDocOtherFields = scrapDocOtherFields;
    }

    public List<POSShortfallsDocGridLine> getShortfallsDocGridFields() {
        if (this.shortfallsDocGridFields == null) {
            this.shortfallsDocGridFields = new ArrayList<POSShortfallsDocGridLine>();
            return this.shortfallsDocGridFields;
        }
        return this.shortfallsDocGridFields;
    }

    public void setShortfallsDocGridFields(List<POSShortfallsDocGridLine> shortfallsGridFields) {
        this.shortfallsDocGridFields = shortfallsGridFields;
    }

    public List<POSScrapDocGridLine> getScrapDocGridFields() {
        if (this.scrapDocGridFields == null) {
            this.scrapDocGridFields = new ArrayList<POSScrapDocGridLine>();
            return this.scrapDocGridFields;
        }
        return this.scrapDocGridFields;
    }

    public void setScrapDocGridFields(List<POSScrapDocGridLine> scrapDocGridFields) {
        this.scrapDocGridFields = scrapDocGridFields;
    }

    public void setOtherPageFields(List<POSRegisterOtherLine> otherPageFields) {
        this.otherPageFields = otherPageFields;
    }

    public List<POSRegisterGridLine> getSalesGridFields() {
        if (this.salesGridFields == null) {
            this.salesGridFields = new ArrayList<POSRegisterGridLine>();
            return this.salesGridFields;
        }
        return this.salesGridFields;
    }

    public void setSalesGridFields(List<POSRegisterGridLine> salesGridFields) {
        this.salesGridFields = salesGridFields;
    }

    public PosUiBasicInfo getInvoiceBasicInfo() {
        return this.invoiceBasicInfo;
    }

    public void setInvoiceBasicInfo(PosUiBasicInfo invoiceBasicInfo) {
        this.invoiceBasicInfo = invoiceBasicInfo;
    }

    public List<POSOrderReservationMainLine> getOrderReservationMainFields() {
        if (this.orderReservationMainFields == null) {
            this.orderReservationMainFields = new ArrayList<POSOrderReservationMainLine>();
            return this.orderReservationMainFields;
        }
        return this.orderReservationMainFields;
    }

    public void setOrderReservationMainFields(List<POSOrderReservationMainLine> orderReservationMainFields) {
        this.orderReservationMainFields = orderReservationMainFields;
    }

    public List<POSOrderReservationOtherLine> getOrderReservationOtherFields() {
        if (this.orderReservationOtherFields == null) {
            this.orderReservationOtherFields = new ArrayList<POSOrderReservationOtherLine>();
            return this.orderReservationOtherFields;
        }
        return this.orderReservationOtherFields;
    }

    public void setOrderReservationOtherFields(List<POSOrderReservationOtherLine> orderReservationOtherFields) {
        this.orderReservationOtherFields = orderReservationOtherFields;
    }

    public List<POSOrderReservationGridLine> getOrderReservationGridFields() {
        if (this.orderReservationGridFields == null) {
            this.orderReservationGridFields = new ArrayList<POSOrderReservationGridLine>();
            return this.orderReservationGridFields;
        }
        return this.orderReservationGridFields;
    }

    public void setOrderReservationGridFields(List<POSOrderReservationGridLine> orderReservationGridFields) {
        this.orderReservationGridFields = orderReservationGridFields;
    }

    public PosUiBasicInfo getOrderReservationBasicInfo() {
        return this.orderReservationBasicInfo;
    }

    public void setOrderReservationBasicInfo(PosUiBasicInfo orderReservationBasicInfo) {
        this.orderReservationBasicInfo = orderReservationBasicInfo;
    }

    public PosUiBasicInfo getCanelReservationBasicInfo() {
        return this.canelReservationBasicInfo;
    }

    public void setCanelReservationBasicInfo(PosUiBasicInfo canelReservationBasicInfo) {
        this.canelReservationBasicInfo = canelReservationBasicInfo;
    }

    @Override
    public String calcNamaEntityType() {
        return "NamaPosUISettings";
    }

    @Override
    public void initializeLists() {
        this.getMainPageFields().size();
        this.getOtherPageFields().size();
        this.getSalesGridFields().size();
        this.getReturnMainFields().size();
        this.getReturnOtherFields().size();
        this.getReturnGridFields().size();
        this.getReplacementMainFields().size();
        this.getReplacementOtherFields().size();
        this.getReplacementGridFields().size();
        this.getTransferMainFields().size();
        this.getTransferOtherFields().size();
        this.getTransferGridFields().size();
        this.getTakingMainFields().size();
        this.getTakingOtherFields().size();
        this.getTakingGridFields().size();
        this.getOrderReservationMainFields().size();
        this.getOrderReservationOtherFields().size();
        this.getOrderReservationGridFields().size();
        this.getCancelReservationMainFields().size();
        this.getCancelReservationOtherFields().size();
        this.getCancelReservationGridFields().size();
        this.getStockReceiptMainFields().size();
        this.getStockReceiptGridFields().size();
        this.getStockReceiptOtherFields().size();
        this.getSearchDialogueFields().size();
        this.getProcedures().size();
        this.getSearchDialogueConfigLines().size();
        this.getSearchDialogueFilters().size();
        this.getScrapDocMainFields().size();
        this.getScrapDocGridFields().size();
        this.getScrapDocOtherFields().size();
        this.getShortfallsDocMainFields().size();
        this.getShortfallsDocGridFields().size();
        this.getShortfallsDocOtherFields().size();
        this.getCustomerDisplayWindowHeaderFields().size();
        this.getCustomerDisplayWindowTableColumns().size();
        this.getCustomerDisplayWindowFooterFields().size();
        this.getCustomerFields().size();
    }

    @Override
    public void assignIds() {
        super.assignIds();
        Consumer<AbsPOSFieldLine> lineConsumer = l -> {
            l.getId();
            l.setPosSettings(this);
        };
        this.getMainPageFields().forEach(lineConsumer);
        this.getOtherPageFields().forEach(lineConsumer);
        this.getSalesGridFields().forEach(lineConsumer);
        this.getReturnMainFields().forEach(lineConsumer);
        this.getReturnOtherFields().forEach(lineConsumer);
        this.getReturnGridFields().forEach(lineConsumer);
        this.getReplacementMainFields().forEach(lineConsumer);
        this.getReplacementOtherFields().forEach(lineConsumer);
        this.getReplacementGridFields().forEach(lineConsumer);
        this.getTransferMainFields().forEach(lineConsumer);
        this.getTransferOtherFields().forEach(lineConsumer);
        this.getTransferGridFields().forEach(lineConsumer);
        this.getTakingMainFields().forEach(lineConsumer);
        this.getTakingOtherFields().forEach(lineConsumer);
        this.getTakingGridFields().forEach(lineConsumer);
        this.getOrderReservationMainFields().forEach(lineConsumer);
        this.getOrderReservationOtherFields().forEach(lineConsumer);
        this.getOrderReservationGridFields().forEach(lineConsumer);
        this.getCancelReservationMainFields().forEach(lineConsumer);
        this.getCancelReservationOtherFields().forEach(lineConsumer);
        this.getCancelReservationGridFields().forEach(lineConsumer);
        this.getStockReceiptMainFields().forEach(lineConsumer);
        this.getStockReceiptGridFields().forEach(lineConsumer);
        this.getStockReceiptOtherFields().forEach(lineConsumer);
        this.getSearchDialogueFields().forEach(l -> l.getId());
        this.getProcedures().forEach(l -> l.getId());
        this.getSearchDialogueConfigLines().forEach(l -> l.getId());
        this.getSearchDialogueFilters().forEach(l -> l.getId());
        this.getScrapDocMainFields().forEach(lineConsumer);
        this.getScrapDocGridFields().forEach(lineConsumer);
        this.getScrapDocOtherFields().forEach(lineConsumer);
        this.getShortfallsDocMainFields().forEach(lineConsumer);
        this.getShortfallsDocGridFields().forEach(lineConsumer);
        this.getShortfallsDocOtherFields().forEach(lineConsumer);
        this.getCustomerDisplayWindowHeaderFields().forEach(lineConsumer);
        this.getCustomerDisplayWindowTableColumns().forEach(lineConsumer);
        this.getCustomerDisplayWindowFooterFields().forEach(lineConsumer);
        this.getCustomerFields().forEach(lineConsumer);
    }
}

