/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSPricingRange;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSEntityRefData;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceReq;
import com.namasoft.pos.util.PosSalesUtil;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPOSPricingRangeInvoiceLine {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="posPricingRange")
    private POSPricingRange pricingRange;
    @Embedded
    private POSGenericDims dimensions;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier1 priceClassifier1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier2 priceClassifier2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier3 priceClassifier3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier4 priceClassifier4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSSalesPriceClassifier5 priceClassifier5;
    @Embedded
    private POSEntityRefData customer;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSInvoiceClassification invoiceClassification;

    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public POSPricingRange getPricingRange() {
        this.pricingRange = POSPersister.materialize(POSPricingRange.class, this.pricingRange);
        return this.pricingRange;
    }

    public void setPricingRange(POSPricingRange pricingRange) {
        this.pricingRange = pricingRange;
    }

    public POSGenericDims getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(POSGenericDims dimensions) {
        this.dimensions = dimensions;
    }

    public POSSalesPriceClassifier1 getPriceClassifier1() {
        this.priceClassifier1 = POSPersister.materialize(POSSalesPriceClassifier1.class, this.priceClassifier1);
        return this.priceClassifier1;
    }

    public void setPriceClassifier1(POSSalesPriceClassifier1 priceClassifier1) {
        this.priceClassifier1 = priceClassifier1;
    }

    public POSSalesPriceClassifier2 getPriceClassifier2() {
        this.priceClassifier2 = POSPersister.materialize(POSSalesPriceClassifier2.class, this.priceClassifier2);
        return this.priceClassifier2;
    }

    public void setPriceClassifier2(POSSalesPriceClassifier2 priceClassifier2) {
        this.priceClassifier2 = priceClassifier2;
    }

    public POSSalesPriceClassifier3 getPriceClassifier3() {
        this.priceClassifier3 = POSPersister.materialize(POSSalesPriceClassifier3.class, this.priceClassifier3);
        return this.priceClassifier3;
    }

    public void setPriceClassifier3(POSSalesPriceClassifier3 priceClassifier3) {
        this.priceClassifier3 = priceClassifier3;
    }

    public POSSalesPriceClassifier4 getPriceClassifier4() {
        this.priceClassifier4 = POSPersister.materialize(POSSalesPriceClassifier4.class, this.priceClassifier4);
        return this.priceClassifier4;
    }

    public void setPriceClassifier4(POSSalesPriceClassifier4 priceClassifier4) {
        this.priceClassifier4 = priceClassifier4;
    }

    public POSSalesPriceClassifier5 getPriceClassifier5() {
        this.priceClassifier5 = POSPersister.materialize(POSSalesPriceClassifier5.class, this.priceClassifier5);
        return this.priceClassifier5;
    }

    public void setPriceClassifier5(POSSalesPriceClassifier5 priceClassifier5) {
        this.priceClassifier5 = priceClassifier5;
    }

    public POSEntityRefData getCustomer() {
        return this.customer;
    }

    public void setCustomer(POSEntityRefData customer) {
        this.customer = customer;
    }

    public POSInvoiceClassification getInvoiceClassification() {
        this.invoiceClassification = POSPersister.materialize(POSInvoiceClassification.class, this.invoiceClassification);
        return this.invoiceClassification;
    }

    public void setInvoiceClassification(POSInvoiceClassification invoiceClassification) {
        this.invoiceClassification = invoiceClassification;
    }

    public boolean applicableLine(POSItemSalesPriceReq req) {
        POSGenericDims dimensions;
        if (this.customerNotMatched(req.getCustomer())) {
            return false;
        }
        POSGenericDims pOSGenericDims = dimensions = req.getGenericDims() == null ? new POSGenericDims() : req.getGenericDims();
        if (ObjectChecker.isEmptyOrNull((Object)this.getDimensions())) {
            this.setDimensions(new POSGenericDims());
        }
        if (this.dimensionNotMatched(this.getDimensions().getLegalEntity(), dimensions.getLegalEntity())) {
            return false;
        }
        if (this.dimensionNotMatched(this.getDimensions().getAnalysisSet(), dimensions.getAnalysisSet())) {
            return false;
        }
        if (this.dimensionNotMatched(this.getDimensions().getBranch(), dimensions.getBranch())) {
            return false;
        }
        if (this.dimensionNotMatched(this.getDimensions().getDepartment(), dimensions.getDepartment())) {
            return false;
        }
        if (this.dimensionNotMatched(this.getDimensions().getSector(), dimensions.getSector())) {
            return false;
        }
        if (this.notMatched(this.getInvoiceClassification(), req.getInvoiceClassification())) {
            return false;
        }
        if (this.notMatched(this.getPriceClassifier1(), req.getPriceClassifier1())) {
            return false;
        }
        if (this.notMatched(this.getPriceClassifier2(), req.getPriceClassifier2())) {
            return false;
        }
        if (this.notMatched(this.getPriceClassifier3(), req.getPriceClassifier3())) {
            return false;
        }
        if (this.notMatched(this.getPriceClassifier4(), req.getPriceClassifier4())) {
            return false;
        }
        return !this.notMatched(this.getPriceClassifier5(), req.getPriceClassifier5());
    }

    private <T extends POSMasterFile<?>> boolean notMatched(T myField, T reqField) {
        if (myField == null) {
            return false;
        }
        return ObjectChecker.areNotEqual(myField, reqField);
    }

    private boolean dimensionNotMatched(POSDimInfo myDim, POSDimInfo reqDim) {
        if (myDim == null) {
            return false;
        }
        if (ObjectChecker.areEqual((Object)myDim, (Object)reqDim)) {
            return false;
        }
        return reqDim != null;
    }

    private boolean customerNotMatched(POSCustomer customer) {
        if (ObjectChecker.isEmptyOrNull((Object)this.getCustomer())) {
            return false;
        }
        if (customer == null) {
            return true;
        }
        return PosSalesUtil.customerToIds(customer).contains(this.getCustomer().getNamaGenRefId());
    }
}

