/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSPricingRange;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSSalesPriceReqDetail;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPOSPricingRangeItemLine {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="posPricingRange")
    private POSPricingRange pricingRange;
    private String itemCode;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem item;
    @AttributeOverrides(value={@AttributeOverride(name="color", column=@Column(name="itemColor")), @AttributeOverride(name="lotId", column=@Column(name="itemLotId")), @AttributeOverride(name="revisionId", column=@Column(name="itemRevisionId")), @AttributeOverride(name="serialNumber", column=@Column(name="itemSerialNumber")), @AttributeOverride(name="size", column=@Column(name="itemSize")), @AttributeOverride(name="secondSerial", column=@Column(name="itemSecondSerial")), @AttributeOverride(name="box", column=@Column(name="itemBox"))})
    @Embedded
    private POSItemSpecificDimensions specificDimensions;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemCategory category5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass1 itemClass1;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass2 itemClass2;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass3 itemClass3;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass4 itemClass4;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass5 itemClass5;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass6 itemClass6;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass7 itemClass7;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass8 itemClass8;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass9 itemClass9;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemClass10 itemClass10;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemBrand brand;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItemSection itemSection;

    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public POSPricingRange getPricingRange() {
        this.pricingRange = POSPersister.materialize(POSPricingRange.class, this.pricingRange);
        return this.pricingRange;
    }

    public void setPricingRange(POSPricingRange pricingRange) {
        this.pricingRange = pricingRange;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    public POSItemSpecificDimensions getSpecificDimensions() {
        return this.specificDimensions;
    }

    public void setSpecificDimensions(POSItemSpecificDimensions specificDimensions) {
        this.specificDimensions = specificDimensions;
    }

    public POSItemCategory getCategory1() {
        this.category1 = POSPersister.materialize(POSItemCategory.class, this.category1);
        return this.category1;
    }

    public void setCategory1(POSItemCategory category1) {
        this.category1 = category1;
    }

    public POSItemCategory getCategory2() {
        this.category2 = POSPersister.materialize(POSItemCategory.class, this.category2);
        return this.category2;
    }

    public void setCategory2(POSItemCategory category2) {
        this.category2 = category2;
    }

    public POSItemCategory getCategory3() {
        this.category3 = POSPersister.materialize(POSItemCategory.class, this.category3);
        return this.category3;
    }

    public void setCategory3(POSItemCategory category3) {
        this.category3 = category3;
    }

    public POSItemCategory getCategory4() {
        this.category4 = POSPersister.materialize(POSItemCategory.class, this.category4);
        return this.category4;
    }

    public void setCategory4(POSItemCategory category4) {
        this.category4 = category4;
    }

    public POSItemCategory getCategory5() {
        this.category5 = POSPersister.materialize(POSItemCategory.class, this.category5);
        return this.category5;
    }

    public void setCategory5(POSItemCategory category5) {
        this.category5 = category5;
    }

    public POSItemClass1 getItemClass1() {
        this.itemClass1 = POSPersister.materialize(POSItemClass1.class, this.itemClass1);
        return this.itemClass1;
    }

    public void setItemClass1(POSItemClass1 itemClass1) {
        this.itemClass1 = itemClass1;
    }

    public POSItemClass2 getItemClass2() {
        this.itemClass2 = POSPersister.materialize(POSItemClass2.class, this.itemClass2);
        return this.itemClass2;
    }

    public void setItemClass2(POSItemClass2 itemClass2) {
        this.itemClass2 = itemClass2;
    }

    public POSItemClass3 getItemClass3() {
        this.itemClass3 = POSPersister.materialize(POSItemClass3.class, this.itemClass3);
        return this.itemClass3;
    }

    public void setItemClass3(POSItemClass3 itemClass3) {
        this.itemClass3 = itemClass3;
    }

    public POSItemClass4 getItemClass4() {
        this.itemClass4 = POSPersister.materialize(POSItemClass4.class, this.itemClass4);
        return this.itemClass4;
    }

    public void setItemClass4(POSItemClass4 itemClass4) {
        this.itemClass4 = itemClass4;
    }

    public POSItemClass5 getItemClass5() {
        this.itemClass5 = POSPersister.materialize(POSItemClass5.class, this.itemClass5);
        return this.itemClass5;
    }

    public void setItemClass5(POSItemClass5 itemClass5) {
        this.itemClass5 = itemClass5;
    }

    public POSItemClass6 getItemClass6() {
        this.itemClass6 = POSPersister.materialize(POSItemClass6.class, this.itemClass6);
        return this.itemClass6;
    }

    public void setItemClass6(POSItemClass6 itemClass6) {
        this.itemClass6 = itemClass6;
    }

    public POSItemClass7 getItemClass7() {
        this.itemClass7 = POSPersister.materialize(POSItemClass7.class, this.itemClass7);
        return this.itemClass7;
    }

    public void setItemClass7(POSItemClass7 itemClass7) {
        this.itemClass7 = itemClass7;
    }

    public POSItemClass8 getItemClass8() {
        this.itemClass8 = POSPersister.materialize(POSItemClass8.class, this.itemClass8);
        return this.itemClass8;
    }

    public void setItemClass8(POSItemClass8 itemClass8) {
        this.itemClass8 = itemClass8;
    }

    public POSItemClass9 getItemClass9() {
        this.itemClass9 = POSPersister.materialize(POSItemClass9.class, this.itemClass9);
        return this.itemClass9;
    }

    public void setItemClass9(POSItemClass9 itemClass9) {
        this.itemClass9 = itemClass9;
    }

    public POSItemClass10 getItemClass10() {
        this.itemClass10 = POSPersister.materialize(POSItemClass10.class, this.itemClass10);
        return this.itemClass10;
    }

    public void setItemClass10(POSItemClass10 itemClass10) {
        this.itemClass10 = itemClass10;
    }

    public POSItemBrand getBrand() {
        this.brand = POSPersister.materialize(POSItemBrand.class, this.brand);
        return this.brand;
    }

    public void setBrand(POSItemBrand brand) {
        this.brand = brand;
    }

    public POSItemSection getItemSection() {
        this.itemSection = POSPersister.materialize(POSItemSection.class, this.itemSection);
        return this.itemSection;
    }

    public void setItemSection(POSItemSection itemSection) {
        this.itemSection = itemSection;
    }

    public boolean applicableLine(POSSalesPriceReqDetail requestLine) {
        if (this.notMatched(this.getItem(), requestLine.getItem())) {
            return false;
        }
        if (this.notMatched(this.getBrand(), requestLine.getItem().getBrand())) {
            return false;
        }
        if (this.notMatched(this.getItemSection(), requestLine.getItem().getSection())) {
            return false;
        }
        if (this.getSpecificDimensions() == null) {
            this.setSpecificDimensions(new POSItemSpecificDimensions());
        }
        if (this.notMatched(this.getSpecificDimensions().getColor(), requestLine.getSpecificDimensions().getColor())) {
            return false;
        }
        if (this.notMatched(this.getSpecificDimensions().getSize(), requestLine.getSpecificDimensions().getSize())) {
            return false;
        }
        if (this.notMatched(this.getSpecificDimensions().getRevisionId(), requestLine.getSpecificDimensions().getRevisionId())) {
            return false;
        }
        if (this.notMatched(this.getItemClass1(), requestLine.getItem().getItemClass1())) {
            return false;
        }
        if (this.notMatched(this.getItemClass2(), requestLine.getItem().getItemClass2())) {
            return false;
        }
        if (this.notMatched(this.getItemClass3(), requestLine.getItem().getItemClass3())) {
            return false;
        }
        if (this.notMatched(this.getItemClass4(), requestLine.getItem().getItemClass4())) {
            return false;
        }
        if (this.notMatched(this.getItemClass5(), requestLine.getItem().getItemClass5())) {
            return false;
        }
        if (this.notMatched(this.getItemClass6(), requestLine.getItem().getItemClass6())) {
            return false;
        }
        if (this.notMatched(this.getItemClass7(), requestLine.getItem().getItemClass7())) {
            return false;
        }
        if (this.notMatched(this.getItemClass8(), requestLine.getItem().getItemClass8())) {
            return false;
        }
        if (this.notMatched(this.getItemClass9(), requestLine.getItem().getItemClass9())) {
            return false;
        }
        if (this.notMatched(this.getItemClass10(), requestLine.getItem().getItemClass10())) {
            return false;
        }
        if (this.notMatched(this.getCategory1(), requestLine.getItem().getCategory1())) {
            return false;
        }
        if (this.notMatched(this.getCategory2(), requestLine.getItem().getCategory2())) {
            return false;
        }
        if (this.notMatched(this.getCategory3(), requestLine.getItem().getCategory3())) {
            return false;
        }
        if (this.notMatched(this.getCategory4(), requestLine.getItem().getCategory4())) {
            return false;
        }
        return !this.notMatched(this.getCategory5(), requestLine.getItem().getCategory5());
    }

    private <T> boolean notMatched(T myDim, T reqDim) {
        if (ObjectChecker.isEmptyOrNull(myDim)) {
            return false;
        }
        return ObjectChecker.areNotEqual(myDim, reqDim);
    }

    private <T extends POSMasterFile<?>> boolean notMatched(T myField, T reqField) {
        if (myField == null) {
            return false;
        }
        return ObjectChecker.areNotEqual(myField, reqField);
    }
}

