/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.MoneyEffectType;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.entities.DTOTaxPlan;
import com.namasoft.modules.commonbasic.contracts.invoicing.IDTOInvoiceLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGlobalConfigInfo;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceLineMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.namapos.enums.WarehouseIssueMethod;
import com.namasoft.namacontrols.PosTempDocumentUtil;
import com.namasoft.namacontrols.tablecells.POSSalesTableFields;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.HasCheckBox;
import com.namasoft.pos.domain.details.POSItemDimsDetail;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSDepreciationReason;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.valueobjects.POSDiscountTax;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSSecurityUtil;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@MappedSuperclass
public abstract class AbsPOSSalesLine
implements POSSavable,
HasCheckBox,
IDTOInvoiceLine {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem item;
    private String warehouseIssueMethod;
    @Column(length=16)
    private UUID ref1Id;
    private String ref1Type;
    private String ref1Code;
    private String ref1NamaType;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSWarehouse warehouse;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSLocation location;
    @Embedded
    private POSQuantity qty;
    private String itemActualCode;
    @AttributeOverrides(value={@AttributeOverride(name="color", column=@Column(name="itemColor")), @AttributeOverride(name="lotId", column=@Column(name="itemLotId")), @AttributeOverride(name="revisionId", column=@Column(name="itemRevisionId")), @AttributeOverride(name="serialNumber", column=@Column(name="itemSerialNumber")), @AttributeOverride(name="size", column=@Column(name="itemSize")), @AttributeOverride(name="secondSerial", column=@Column(name="itemSecondSerial")), @AttributeOverride(name="box", column=@Column(name="itemBox"))})
    @Embedded
    private POSItemSpecificDimensions itemDimensions;
    private String itemCode;
    @Column(precision=20, scale=10)
    private BigDecimal unitPrice;
    @Column(precision=20, scale=10)
    private BigDecimal totalPrice;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d1Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d1Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount1;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc1;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d2Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d2Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount2;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc2;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="t1Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="t1Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax tax1;
    @Column(precision=20, scale=10)
    private BigDecimal afterTax1;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="t2Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="t2Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax tax2;
    @Column(precision=20, scale=10)
    private BigDecimal afterTax2;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="hdPercent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="hdVal", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax headerDicount;
    @Column(precision=20, scale=10)
    private BigDecimal netPrice;
    private String itemName;
    private Boolean freeLine;
    private Boolean editableFreeLine;
    private UUID freeItemId;
    private UUID freeGroupId;
    private UUID masterRowId;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSCurrency currency;
    private Boolean selected;
    private UUID invoiceOfferId;
    private Boolean deactivateEmpDiscountsValidations;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSFreeItemGroup freeItemGroup;
    private UUID priceListLineId;
    private Boolean fromFreeItemsOnInvoiceOffer;
    private Date productionDate;
    private Date expiryDate;
    private Boolean freeFromItemsCountOffer;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d3Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d3Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount3;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc3;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d4Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d4Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount4;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc4;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d5Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d5Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount5;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc5;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d6Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d6Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount6;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc6;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d7Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d7Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount7;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc7;
    @AttributeOverrides(value={@AttributeOverride(name="percentage", column=@Column(name="d8Percent", precision=20, scale=10)), @AttributeOverride(name="value", column=@Column(name="d8Val", precision=20, scale=10))})
    @Embedded
    private POSDiscountTax discount8;
    @Column(precision=20, scale=10)
    private BigDecimal afterDisc8;
    @Transient
    private String itemsCountOfferSrcIds;
    @Lob
    private String remarks;
    @Column(precision=20, scale=10)
    private BigDecimal custom;
    private Date prepFormPrintDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSDepreciationReason depreciationReason;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSEmployee salesman;
    @Transient
    private Boolean discountConsidersOtherItemsInInvoice;
    private String box;
    @Transient
    private DTOInvoiceLineMoney price;
    @Transient
    private String itemImageAsBase64;

    public Date getPrepFormPrintDate() {
        return this.prepFormPrintDate;
    }

    public void setPrepFormPrintDate(Date prepFormPrintDate) {
        this.prepFormPrintDate = prepFormPrintDate;
    }

    public BigDecimal getCustom() {
        return this.custom;
    }

    public void setCustom(BigDecimal custom) {
        this.custom = custom;
    }

    public String fetchItemsCountOfferSrcIds() {
        if (ObjectChecker.isEmptyOrNull((Object)this.itemsCountOfferSrcIds)) {
            this.itemsCountOfferSrcIds = "";
        }
        return this.itemsCountOfferSrcIds;
    }

    public String getWarehouseIssueMethod() {
        return this.warehouseIssueMethod;
    }

    public void setWarehouseIssueMethod(String warehouseIssueMethod) {
        this.warehouseIssueMethod = warehouseIssueMethod;
    }

    public void updateWarehouseIssueMethod(POSRegistery register, String warehouseIssueMethod, AbsPosSalesScreen view) {
        this.warehouseIssueMethod = warehouseIssueMethod;
        if (ObjectChecker.areEqual((Object)this.getWarehouseIssueMethod(), (Object)WarehouseIssueMethod.ToBeIssued.name())) {
            this.setUnitPrice(BigDecimal.ZERO);
            this.fetchSalesDoc().updateLineValues(this);
        } else {
            this.fetchSalesDoc().calcUnitPriceAndFreeLines(register, this, false, view);
        }
    }

    public void updateItemsCountOfferSrcIds(String itemsCountOfferSrcIds) {
        this.itemsCountOfferSrcIds = itemsCountOfferSrcIds;
    }

    public POSDiscountTax getDiscount3() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount3)) {
            this.discount3 = new POSDiscountTax();
        }
        return this.discount3;
    }

    public void setDiscount3(POSDiscountTax discount3) {
        this.discount3 = discount3;
    }

    public BigDecimal getAfterDisc3() {
        return this.afterDisc3;
    }

    public void setAfterDisc3(BigDecimal afterDisc3) {
        this.afterDisc3 = afterDisc3;
    }

    public POSDiscountTax getDiscount4() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount4)) {
            this.discount4 = new POSDiscountTax();
        }
        return this.discount4;
    }

    public void setDiscount4(POSDiscountTax discount4) {
        this.discount4 = discount4;
    }

    public BigDecimal getAfterDisc4() {
        return this.afterDisc4;
    }

    public void setAfterDisc4(BigDecimal afterDisc4) {
        this.afterDisc4 = afterDisc4;
    }

    public POSDiscountTax getDiscount5() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount5)) {
            this.discount5 = new POSDiscountTax();
        }
        return this.discount5;
    }

    public void setDiscount5(POSDiscountTax discount5) {
        this.discount5 = discount5;
    }

    public BigDecimal getAfterDisc5() {
        return this.afterDisc5;
    }

    public void setAfterDisc5(BigDecimal afterDisc5) {
        this.afterDisc5 = afterDisc5;
    }

    public POSDiscountTax getDiscount6() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount6)) {
            this.discount6 = new POSDiscountTax();
        }
        return this.discount6;
    }

    public void setDiscount6(POSDiscountTax discount6) {
        this.discount6 = discount6;
    }

    public BigDecimal getAfterDisc6() {
        return this.afterDisc6;
    }

    public void setAfterDisc6(BigDecimal afterDisc6) {
        this.afterDisc6 = afterDisc6;
    }

    public POSDiscountTax getDiscount7() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount7)) {
            this.discount7 = new POSDiscountTax();
        }
        return this.discount7;
    }

    public void setDiscount7(POSDiscountTax discount7) {
        this.discount7 = discount7;
    }

    public BigDecimal getAfterDisc7() {
        return this.afterDisc7;
    }

    public void setAfterDisc7(BigDecimal afterDisc7) {
        this.afterDisc7 = afterDisc7;
    }

    public POSDiscountTax getDiscount8() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount8)) {
            this.discount8 = new POSDiscountTax();
        }
        return this.discount8;
    }

    public void setDiscount8(POSDiscountTax discount8) {
        this.discount8 = discount8;
    }

    public BigDecimal getAfterDisc8() {
        return this.afterDisc8;
    }

    public void setAfterDisc8(BigDecimal afterDisc8) {
        this.afterDisc8 = afterDisc8;
    }

    public Boolean getFreeFromItemsCountOffer() {
        return this.freeFromItemsCountOffer;
    }

    public void setFreeFromItemsCountOffer(Boolean freeFromItemsCountOffer) {
        this.freeFromItemsCountOffer = freeFromItemsCountOffer;
    }

    public Date getProductionDate() {
        return this.productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Boolean getFromFreeItemsOnInvoiceOffer() {
        return this.fromFreeItemsOnInvoiceOffer;
    }

    public void setFromFreeItemsOnInvoiceOffer(Boolean fromFreeItemsOnInvoiceOffer) {
        this.fromFreeItemsOnInvoiceOffer = fromFreeItemsOnInvoiceOffer;
    }

    public UUID getPriceListLineId() {
        return this.priceListLineId;
    }

    public void setPriceListLineId(UUID priceListLineId) {
        this.priceListLineId = priceListLineId;
    }

    public POSCurrency getCurrency() {
        this.currency = POSPersister.materialize(POSCurrency.class, this.currency);
        return this.currency;
    }

    public void setCurrency(POSCurrency currency) {
        this.currency = currency;
    }

    public UUID getFreeItemId() {
        return this.freeItemId;
    }

    public void setFreeItemId(UUID freeItemId) {
        this.freeItemId = freeItemId;
    }

    public BigDecimal getAfterDisc1() {
        return this.afterDisc1;
    }

    public void setAfterDisc1(BigDecimal afterDisc1) {
        this.afterDisc1 = afterDisc1;
    }

    public BigDecimal getAfterDisc2() {
        return this.afterDisc2;
    }

    public void setAfterDisc2(BigDecimal afterDisc2) {
        this.afterDisc2 = afterDisc2;
    }

    public BigDecimal getAfterTax1() {
        return this.afterTax1;
    }

    public void setAfterTax1(BigDecimal afterTax1) {
        this.afterTax1 = afterTax1;
    }

    public BigDecimal getAfterTax2() {
        return this.afterTax2;
    }

    public void setAfterTax2(BigDecimal afterTax2) {
        this.afterTax2 = afterTax2;
    }

    public UUID getFreeGroupId() {
        return this.freeGroupId;
    }

    public void setFreeGroupId(UUID freeGroupId) {
        this.freeGroupId = freeGroupId;
    }

    public POSWarehouse getWarehouse() {
        this.warehouse = POSPersister.materialize(POSWarehouse.class, this.warehouse);
        return this.warehouse;
    }

    public void setWarehouse(POSWarehouse warehouse) {
        this.warehouse = warehouse;
    }

    public POSLocation getLocation() {
        this.location = POSPersister.materialize(POSLocation.class, this.location);
        return this.location;
    }

    public void setLocation(POSLocation location) {
        this.location = location;
    }

    public String getBox() {
        return this.box;
    }

    public void setBox(String box) {
        this.box = box;
    }

    public POSDiscountTax getDiscount1() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount1)) {
            return new POSDiscountTax();
        }
        return this.discount1;
    }

    public void setDiscount1(POSDiscountTax discount1) {
        this.discount1 = discount1;
    }

    public POSDiscountTax getDiscount2() {
        if (ObjectChecker.isEmptyOrNull((Object)this.discount2)) {
            return new POSDiscountTax();
        }
        return this.discount2;
    }

    public void setDiscount2(POSDiscountTax discount2) {
        this.discount2 = discount2;
    }

    public POSDiscountTax getTax1() {
        if (ObjectChecker.isEmptyOrNull((Object)this.tax1)) {
            return new POSDiscountTax();
        }
        return this.tax1;
    }

    public void setTax1(POSDiscountTax tax1) {
        this.tax1 = tax1;
    }

    public POSDiscountTax getTax2() {
        if (ObjectChecker.isEmptyOrNull((Object)this.tax2)) {
            return new POSDiscountTax();
        }
        return this.tax2;
    }

    public void setTax2(POSDiscountTax tax2) {
        this.tax2 = tax2;
    }

    public BigDecimal getNetPrice() {
        return this.netPrice;
    }

    public void setNetPrice(BigDecimal netPrice) {
        this.netPrice = netPrice;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    public POSQuantity getQty() {
        if (this.qty == null) {
            this.setQty(new POSQuantity());
        }
        this.roundQty();
        return this.qty;
    }

    public void setQty(POSQuantity qty) {
        this.qty = qty;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public String getItemActualCode() {
        return this.itemActualCode;
    }

    public void setItemActualCode(String itemScannedCode) {
        this.itemActualCode = itemScannedCode;
    }

    public void updateTotal() {
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)this.getQty().getValue())) {
            BigDecimal total = this.getUnitPrice().multiply(this.getQty().getValue());
            if (ObjectChecker.isEmptyOrZero((BigDecimal)total)) {
                total = BigDecimal.ZERO;
            }
            this.setTotalPrice(total);
            this.setAfterDisc1(total);
            this.setAfterDisc2(total);
            this.setAfterDisc3(total);
            this.setAfterDisc4(total);
            this.setAfterDisc5(total);
            this.setAfterDisc6(total);
            this.setAfterDisc7(total);
            this.setAfterDisc8(total);
            this.setAfterTax1(total);
            this.setAfterTax2(total);
            this.setNetPrice(total);
        }
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public abstract void updateInvoice(AbsPOSSales var1);

    public abstract AbsPOSSales fetchSalesDoc();

    public POSItemSpecificDimensions getItemDimensions() {
        if (this.itemDimensions == null) {
            this.setItemDimensions(new POSItemSpecificDimensions());
        }
        return this.itemDimensions;
    }

    public void setItemDimensions(POSItemSpecificDimensions itemDimensions) {
        this.itemDimensions = itemDimensions;
    }

    public Boolean getFreeLine() {
        return ObjectChecker.isTrue((Boolean)this.freeLine);
    }

    public void setFreeLine(Boolean freeLine) {
        this.freeLine = freeLine;
    }

    public Boolean getEditableFreeLine() {
        return ObjectChecker.isTrue((Boolean)this.editableFreeLine);
    }

    public void setEditableFreeLine(Boolean editableFreeLine) {
        this.editableFreeLine = editableFreeLine;
    }

    public UUID getMasterRowId() {
        return this.masterRowId;
    }

    public void setMasterRowId(UUID masterRowId) {
        this.masterRowId = masterRowId;
    }

    public POSDiscountTax getHeaderDicount() {
        if (ObjectChecker.isEmptyOrNull((Object)this.headerDicount)) {
            return new POSDiscountTax();
        }
        return this.headerDicount;
    }

    public void setHeaderDicount(POSDiscountTax headerDicount) {
        this.headerDicount = headerDicount;
    }

    public Boolean getSelected() {
        if (ObjectChecker.isEmptyOrNull((Object)this.selected)) {
            return false;
        }
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public UUID getInvoiceOfferId() {
        return this.invoiceOfferId;
    }

    public void setInvoiceOfferId(UUID invoiceOfferId) {
        this.invoiceOfferId = invoiceOfferId;
    }

    public POSDepreciationReason getDepreciationReason() {
        this.depreciationReason = POSPersister.materialize(POSDepreciationReason.class, this.depreciationReason);
        return this.depreciationReason;
    }

    public void setDepreciationReason(POSDepreciationReason depreciationReason) {
        this.depreciationReason = depreciationReason;
    }

    public String getDepreciationReasonName() {
        if (this.depreciationReason == null) {
            return "";
        }
        this.depreciationReason = POSPersister.materializeProxy(POSDepreciationReason.class, this.depreciationReason);
        return this.depreciationReason.nameByLanguage();
    }

    public POSEmployee getSalesman() {
        this.salesman = POSPersister.materialize(POSEmployee.class, this.salesman);
        return this.salesman;
    }

    public void setSalesman(POSEmployee salesMan) {
        this.salesman = salesMan;
    }

    public Boolean getDeactivateEmpDiscountsValidations() {
        if (this.deactivateEmpDiscountsValidations == null) {
            return false;
        }
        return this.deactivateEmpDiscountsValidations;
    }

    public void setDeactivateEmpDiscountsValidations(Boolean deactivateEmpDiscountsValidations) {
        this.deactivateEmpDiscountsValidations = deactivateEmpDiscountsValidations;
    }

    public Boolean getDiscountConsidersOtherItemsInInvoice() {
        return this.discountConsidersOtherItemsInInvoice;
    }

    public void setDiscountConsidersOtherItemsInInvoice(Boolean discountConsidersOtherItemsInInvoice) {
        this.discountConsidersOtherItemsInInvoice = discountConsidersOtherItemsInInvoice;
    }

    @Override
    public void updateSelectionProperty(Boolean selected) {
        this.setSelected(selected);
    }

    @Override
    public Boolean fetchSelectionProperty() {
        return this.getSelected();
    }

    @Override
    public void updateFreeLineProperty(Boolean isFreeLine) {
        this.setFreeLine(isFreeLine);
        if (isFreeLine.booleanValue()) {
            this.fetchSalesDoc().updateLineValues(this);
        }
    }

    @Override
    public Boolean fetchFreeLineProperty() {
        return this.getFreeLine();
    }

    public void setCommonValues(POSQuantity qty, BigDecimal unitPrice, BigDecimal totalPrice, POSItem item, String itemCode, POSDiscountTax discount1, POSDiscountTax discount2, POSDiscountTax tax1, POSDiscountTax tax2, BigDecimal netPrice, POSDiscountTax discount3, POSDiscountTax discount4, POSDiscountTax discount5, POSDiscountTax discount6, POSDiscountTax discount7, POSDiscountTax discount8) {
        this.assignIds();
        if (item == null) {
            item = (POSItem)POSPersister.findByCode(POSItem.class, itemCode);
        }
        this.setItem(item);
        if (ObjectChecker.isNotEmptyOrNull((Object)item)) {
            this.setItemName(item.nameByLanguage());
            this.setItemCode(item.getCode());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)itemCode)) {
            this.setItemCode(itemCode);
        }
        this.setQty(qty);
        this.setUnitPrice(unitPrice);
        this.setTotalPrice(totalPrice);
        this.setDiscount1(discount1);
        this.setDiscount2(discount2);
        this.setDiscount3(discount3);
        this.setDiscount4(discount4);
        this.setDiscount5(discount5);
        this.setDiscount6(discount6);
        this.setDiscount7(discount7);
        this.setDiscount8(discount8);
        this.setTax1(tax1);
        this.setTax2(tax2);
        this.setNetPrice(netPrice);
    }

    public DTOInvoiceLineMoney getPrice() {
        if (this.price == null) {
            this.price = new DTOInvoiceLineMoney();
            this.price.updateNulls();
        }
        this.price.setUnitPrice(this.getUnitPrice());
        this.price.setPrice(this.getTotalPrice());
        POSDiscountTax hDisc = new POSDiscountTax();
        hDisc.setValue(this.fetchSalesDoc().getDiscountValue());
        hDisc.setPercentage(this.fetchSalesDoc().getDiscountPercent());
        this.copyEffect(this.price.getHeaderDicount(), hDisc, "HeaderDiscount");
        this.copyEffect(this.price.getDiscount1(), this.getDiscount1(), "discount1");
        this.copyEffect(this.price.getDiscount2(), this.getDiscount2(), "discount2");
        this.copyEffect(this.price.getDiscount3(), this.getDiscount3(), "discount3");
        this.copyEffect(this.price.getDiscount4(), this.getDiscount4(), "discount4");
        this.copyEffect(this.price.getDiscount5(), this.getDiscount5(), "discount5");
        this.copyEffect(this.price.getDiscount6(), this.getDiscount6(), "discount6");
        this.copyEffect(this.price.getDiscount7(), this.getDiscount7(), "discount7");
        this.copyEffect(this.price.getDiscount8(), this.getDiscount8(), "discount8");
        this.copyEffect(this.price.getTax1(), this.getTax1(), "tax1");
        this.copyEffect(this.price.getTax2(), this.getTax2(), "tax2");
        this.price.setCustom(this.getCustom());
        return this.price;
    }

    public DTOInvoiceLineMoney fetchPrice() {
        return this.price;
    }

    public BigDecimal fetchLineTotalPrice() {
        return this.price.getPrice();
    }

    private void copyEffect(DTOMoneyEffectDetails effect, POSDiscountTax discountOrTax, String effectId) {
        DTOTaxConfiguration taxConfiguration = DTOTaxPlan.fetchTaxConfiguration((DTOTaxPlan)POSResourcesUtil.fetchPosConfigDtoTaxPlan(), null, (EntityReferenceData)POSResourcesUtil.fetchMainRegister().fetchLegalEntityRef(), null, (DTOGlobalConfigInfo)POSResourcesUtil.fetchGlobalConfig().getInfo(), (String)this.fetchSalesDoc().calcNamaEntityType());
        if (ObjectChecker.isNotEmptyOrNull((Object)discountOrTax)) {
            BigDecimal percent = BigDecimal.ZERO;
            if (ObjectChecker.isNotEmptyOrZero((BigDecimal)discountOrTax.getPercentage())) {
                percent = discountOrTax.getPercentage();
            } else {
                BigDecimal discountValue = discountOrTax.getValue();
                BigDecimal previousTotal = POSMoneyUtils.getPreviousTotal(effectId, this, taxConfiguration);
                if (effectId.equalsIgnoreCase("HeaderDiscount") && ObjectChecker.isNotEmptyOrZero((BigDecimal)discountValue)) {
                    previousTotal = POSMoneyUtils.calculateTotalFor(MoneyEffectType.HeaderDiscount, this.fetchSalesDoc().fetchDetails(), this.fetchSalesDoc());
                }
                percent = NaMaMath.calcPercentage((BigDecimal)previousTotal, (BigDecimal)discountValue, (Integer)POSMoneyUtils.getPercentageScale());
            }
            effect.setPercentage(percent);
            effect.setMaxNormalPercent(percent);
            effect.setValue(ObjectChecker.toZeroIfNull((BigDecimal)discountOrTax.getValue()));
            if (ObjectChecker.areNotEqual((Object)effectId, (Object)"HeaderDiscount")) {
                effect.setAfterValue(ObjectChecker.toZeroIfNull((BigDecimal)this.calcAfterDiscValueByEffectId(effectId)));
            }
        }
    }

    private BigDecimal calcAfterDiscValueByEffectId(String effectId) {
        switch (effectId.toLowerCase()) {
            case "discount1": {
                return this.getAfterDisc1();
            }
            case "discount2": {
                return this.getAfterDisc2();
            }
            case "discount3": {
                return this.getAfterDisc3();
            }
            case "discount4": {
                return this.getAfterDisc4();
            }
            case "discount5": {
                return this.getAfterDisc5();
            }
            case "discount6": {
                return this.getAfterDisc6();
            }
            case "discount7": {
                return this.getAfterDisc7();
            }
            case "discount8": {
                return this.getAfterDisc8();
            }
            case "tax1": {
                return this.getAfterTax1();
            }
            case "tax2": {
                return this.getAfterTax2();
            }
        }
        return BigDecimal.ZERO;
    }

    public void setPrice(DTOInvoiceLineMoney price) {
        if (price == null) {
            this.price = null;
            return;
        }
        this.price = price;
        this.setHeaderDicount(POSDiscountTax.fromDiscountEffect(price.getHeaderDicount()));
        this.setDiscount1(POSDiscountTax.fromDiscountEffect(price.getDiscount1()));
        this.setDiscount2(POSDiscountTax.fromDiscountEffect(price.getDiscount2()));
        this.setDiscount3(POSDiscountTax.fromDiscountEffect(price.getDiscount3()));
        this.setDiscount4(POSDiscountTax.fromDiscountEffect(price.getDiscount4()));
        this.setDiscount5(POSDiscountTax.fromDiscountEffect(price.getDiscount5()));
        this.setDiscount6(POSDiscountTax.fromDiscountEffect(price.getDiscount6()));
        this.setDiscount7(POSDiscountTax.fromDiscountEffect(price.getDiscount7()));
        this.setDiscount8(POSDiscountTax.fromDiscountEffect(price.getDiscount8()));
        this.setTax1(POSDiscountTax.fromDiscountEffect(price.getTax1()));
        this.setTax2(POSDiscountTax.fromDiscountEffect(price.getTax2()));
        price.setPrice(ObjectChecker.toZeroIfNull((BigDecimal)price.getPrice()));
        this.setTotalPrice(price.getPrice());
        this.setNetPrice(price.getNetValue());
        this.setAfterDisc1(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount1().getAfterValue()));
        this.setAfterDisc2(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount2().getAfterValue()));
        this.setAfterDisc3(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount3().getAfterValue()));
        this.setAfterDisc4(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount4().getAfterValue()));
        this.setAfterDisc5(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount5().getAfterValue()));
        this.setAfterDisc6(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount6().getAfterValue()));
        this.setAfterDisc7(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount7().getAfterValue()));
        this.setAfterDisc8(ObjectChecker.toZeroIfNull((BigDecimal)price.getDiscount8().getAfterValue()));
        this.setAfterTax1(ObjectChecker.toZeroIfNull((BigDecimal)price.getTax1().getAfterValue()));
        this.setAfterTax2(ObjectChecker.toZeroIfNull((BigDecimal)price.getTax2().getAfterValue()));
        this.setUnitPrice(ObjectChecker.toZeroIfNull((BigDecimal)price.getUnitPrice()));
        this.setCustom(ObjectChecker.toZeroIfNull((BigDecimal)price.getCustom()));
    }

    public BigDecimal unitQuantity() {
        return this.getQty().getValue();
    }

    public Boolean isFreeLine() {
        return this.getFreeLine();
    }

    public void updateQtyVal(BigDecimal qty) {
    }

    public void setPrimQtyUom(EntityReferenceData uom) {
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public Boolean mustBeDisable(String fieldId) {
        if (this.isFreeLine().booleanValue() && ObjectChecker.isEmptyOrNull((Object)this.getFreeItemGroup())) {
            return true;
        }
        if (this.isFreeLine().booleanValue() && ObjectChecker.isNotEmptyOrNull((Object)this.getFreeItemGroup())) {
            if (ObjectChecker.areEqual((Object)fieldId, (Object)POSSalesTableFields.Qty_Col)) {
                return false;
            }
            return true;
        }
        if (ObjectChecker.areEqual((Object)fieldId, (Object)POSSalesTableFields.Unit_Price_Col)) {
            if (ObjectChecker.isEmptyOrNull((Object)this.getItem())) {
                return false;
            }
            String itemType = this.getItem().getItemType();
            if (ObjectChecker.areEqual((Object)itemType, (Object)"Stock") && POSSecurityUtil.userCan(POSSecurityCapability.CanEditPrice).isFailed().booleanValue()) {
                return true;
            }
            if (ObjectChecker.areEqual((Object)itemType, (Object)"Service") && POSSecurityUtil.userCan(POSSecurityCapability.CanEditServiceItemPrice).isFailed().booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public POSFreeItemGroup getFreeItemGroup() {
        this.freeItemGroup = POSPersister.materialize(POSFreeItemGroup.class, this.freeItemGroup);
        return this.freeItemGroup;
    }

    public void setFreeItemGroup(POSFreeItemGroup freeItemGroup) {
        this.freeItemGroup = freeItemGroup;
    }

    @Override
    public POSMasterFile originDoc() {
        return this.fetchSalesDoc();
    }

    @Override
    public Boolean disabledInSavedDocLines() {
        if (this.fetchSalesDoc().getHold()) {
            return false;
        }
        return true;
    }

    public POSLocation calcLocation(POSLocation headerLocation) {
        if (ObjectChecker.isNotEmptyOrNull((Object)headerLocation)) {
            return headerLocation;
        }
        POSWarehouse warehouse = POSResourcesUtil.fetchRegisterWarehouse();
        if (warehouse == null) {
            return null;
        }
        POSItem item = POSPersister.findByID(POSItem.class, this.getItem().getId());
        Optional<POSItemDimsDetail> firstWare = item.getDetails().stream().filter(l -> ObjectChecker.areEqual((Object)l.getWarehouse(), (Object)warehouse) && ObjectChecker.isTrue((Boolean)l.getDefaultLocator())).findFirst();
        if (firstWare.isPresent()) {
            return firstWare.get().getLocation();
        }
        return warehouse.getDefaultLocator();
    }

    public void updateDiscountByLocation(DiscountLocation discLocation, BigDecimal newDiscountPercentage) {
        DTOInvoiceLineMoney price = this.getPrice();
        DTOMoneyEffectDetails effectByLocation = price.fetchDiscountEffect(discLocation);
        if (effectByLocation == null) {
            return;
        }
        BigDecimal currentDiscountPercent = ObjectChecker.toZeroIfNull((BigDecimal)effectByLocation.getPercentage());
        effectByLocation.setPercentage(currentDiscountPercent.add(newDiscountPercentage));
        this.setPrice(price);
    }

    public String calcMasterRowId() {
        return ObjectChecker.toStringOrEmpty((Object)this.getMasterRowId());
    }

    public void roundQty() {
        if (ObjectChecker.isNotEmptyOrNull((Object)this.qty) && ObjectChecker.isNotEmptyOrNull((Object)this.qty.getUom()) && ObjectChecker.isNotEmptyOrNull((Object)this.qty.getValue())) {
            this.qty.setValue(NaMaMath.round((BigDecimal)this.qty.getValue(), (Integer)this.qty.getUom().getFractionDecimalPlaces()));
        }
    }

    public void increaseQty(AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        if (ObjectChecker.isEmptyOrNull((Object)this.qty)) {
            return;
        }
        this.updateLineQty(salesDoc, this.qty.getValue().add(BigDecimal.ONE), view);
    }

    public void decreaseQty(AbsPOSSales salesDoc, AbsPosSalesScreen view) {
        if (ObjectChecker.isEmptyOrNull((Object)this.qty) || this.qty.getValue().compareTo(BigDecimal.ONE) == 0) {
            return;
        }
        this.updateLineQty(salesDoc, this.qty.getValue().subtract(BigDecimal.ONE), view);
    }

    public void updateLineQty(AbsPOSSales salesDoc, BigDecimal qty, AbsPosSalesScreen view) {
        this.getQty().setValue(qty);
        this.roundQty();
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        if (!this.isFreeLine().booleanValue()) {
            salesDoc.calcUnitPriceAndFreeLines(register, this, false, view);
        }
        salesDoc.calcDiscountsFromOffersConditionally(register, view);
        PosTempDocumentUtil.saveOrUpdateTempDocIfNeeded(salesDoc);
    }

    public UUID getRef1Id() {
        return this.ref1Id;
    }

    public void setRef1Id(UUID ref1Id) {
        this.ref1Id = ref1Id;
    }

    public String getRef1Type() {
        return this.ref1Type;
    }

    public void setRef1Type(String ref1Type) {
        this.ref1Type = ref1Type;
    }

    public String getRef1Code() {
        return this.ref1Code;
    }

    public void setRef1Code(String ref1Code) {
        this.ref1Code = ref1Code;
    }

    public String getRef1NamaType() {
        return this.ref1NamaType;
    }

    public void setRef1NamaType(String ref1NamaType) {
        this.ref1NamaType = ref1NamaType;
    }

    @Override
    public List<Object> filterFieldsInTableView() {
        ArrayList<Object> fieldsValues = new ArrayList<Object>();
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getItem())) {
            fieldsValues.add(this.getItem().getCode());
            fieldsValues.add(this.getItem().getAltCode());
            fieldsValues.add(this.getItem().getName1());
            fieldsValues.add(this.getItem().getName2());
        }
        fieldsValues.add(this.getItemCode());
        fieldsValues.add(this.getItemDimensions().getColorName());
        fieldsValues.add(this.getItemDimensions().getSizeName());
        fieldsValues.add(this.getItemDimensions().getRevisionId());
        fieldsValues.add(this.getItemDimensions().getSerialNumber());
        fieldsValues.add(this.getItemDimensions().getSecondSerial());
        fieldsValues.add(this.getItemDimensions().getBox());
        fieldsValues.add(this.getItemDimensions().getSize());
        fieldsValues.add(this.getItemDimensions().getColor());
        fieldsValues.add(this.getItemDimensions().getLotId());
        fieldsValues.removeIf(ObjectChecker::isEmptyOrNull);
        return fieldsValues;
    }

    public POSItem fetchItem() {
        try {
            this.item.getDetails().isEmpty();
        }
        catch (Exception e) {
            this.item = POSPersister.findByID(POSItem.class, this.item.getId().toString());
        }
        return this.item;
    }

    public void updateSourceLineId(UUID sourceLineId) {
    }

    public void setItemImageAsBase64(String base64Image) {
        this.itemImageAsBase64 = base64Image;
    }

    public String getItemImageAsBase64() {
        return this.itemImageAsBase64;
    }
}

