/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

@Entity
@XmlRootElement
public class POSCancelReservationPayLine
extends AbsPOSPaymentLine {
    @JoinColumn(name="cancelReservation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private PosCancelReservation cancelReservation;

    public POSCancelReservationPayLine() {
    }

    public POSCancelReservationPayLine(String methodName, UUID method_id, BigDecimal value, String authorizationNumber, Boolean cash) {
        super(methodName, value);
        this.setAuthorizationNumber(authorizationNumber);
        this.setMethod_id(method_id);
        this.setCash(cash);
    }

    public PosCancelReservation getCancelReservation() {
        this.cancelReservation = POSPersister.materialize(PosCancelReservation.class, this.cancelReservation);
        return this.cancelReservation;
    }

    public void setCancelReservation(PosCancelReservation cancelReservation) {
        this.cancelReservation = cancelReservation;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public void updateInvoice(AbsPOSSales invoice) {
        this.setCancelReservation((PosCancelReservation)invoice);
    }

    @Override
    public POSMasterFile origin() {
        return this.cancelReservation;
    }

    @Override
    public BigDecimal getAmount() {
        return this.getValue().negate();
    }

    @Override
    public Date fetchValueDate() {
        return this.cancelReservation.getValueDate();
    }
}

