/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.basic.contracts.details.DTOExtraCode;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSGenericReferenceOverrider;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSExtraCodeLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @JoinColumn(name="genRefOverrider_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSGenericReferenceOverrider genRefOverrider;
    private String fieldID;
    private String forType;

    public POSExtraCodeLine() {
    }

    public POSExtraCodeLine(DTOExtraCode extraCode) {
        this.getId();
        this.setForType(ObjectChecker.isEmptyOrNull((Object)extraCode.getForType()) ? "Customer" : extraCode.getForType());
        this.setFieldID(extraCode.getFieldID());
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
            return this.id;
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSGenericReferenceOverrider getGenRefOverrider() {
        this.genRefOverrider = POSPersister.materialize(POSGenericReferenceOverrider.class, this.genRefOverrider);
        return this.genRefOverrider;
    }

    public void setGenRefOverrider(POSGenericReferenceOverrider genRefOverrider) {
        this.genRefOverrider = genRefOverrider;
    }

    public String getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String fieldID) {
        this.fieldID = fieldID;
    }

    public String getForType() {
        return this.forType;
    }

    public void setForType(String forType) {
        this.forType = forType;
    }
}

