/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.supplychain.contracts.details.DTOFreeGroupLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.math.BigDecimal;
import java.util.UUID;

@Entity
public class POSFreeGroupLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSItem item;
    @JoinColumn(name="itemGroup")
    @ManyToOne(fetch=FetchType.LAZY)
    POSFreeItemGroup itemGroup;
    private POSItemSpecificDimensions dimensions;
    private POSQuantity qty;
    @Column(precision=20, scale=10)
    private BigDecimal statndardPrice;
    @Column(precision=20, scale=10)
    private BigDecimal statndardCost;

    public POSFreeItemGroup getItemGroup() {
        this.itemGroup = POSPersister.materialize(POSFreeItemGroup.class, this.itemGroup);
        return this.itemGroup;
    }

    public void setItemGroup(POSFreeItemGroup itemGroup) {
        this.itemGroup = itemGroup;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSItem getItem() {
        this.item = POSPersister.materialize(POSItem.class, this.item);
        return this.item;
    }

    public void setItem(POSItem item) {
        this.item = item;
    }

    public POSItemSpecificDimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(POSItemSpecificDimensions dimensions) {
        this.dimensions = dimensions;
    }

    public POSQuantity getQty() {
        return this.qty;
    }

    public void setQty(POSQuantity qty) {
        this.qty = qty;
    }

    public BigDecimal getStatndardPrice() {
        return this.statndardPrice;
    }

    public void setStatndardPrice(BigDecimal statndardPrice) {
        this.statndardPrice = statndardPrice;
    }

    public BigDecimal getStatndardCost() {
        return this.statndardCost;
    }

    public void setStatndardCost(BigDecimal statndardCost) {
        this.statndardCost = statndardCost;
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    public void updateData(DTOFreeGroupLine dtoFreeGroupLine) {
        this.setId(ServerStringUtils.strToUUID((String)dtoFreeGroupLine.getId()));
        this.setDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(dtoFreeGroupLine.getDimensions()));
        this.setItem((POSItem)this.fromReference(dtoFreeGroupLine.getItem()));
        this.setQty(POSQuantity.fromDTORawQuantity(dtoFreeGroupLine.getQty(), this));
        this.setStatndardCost(dtoFreeGroupLine.getStatndardCost());
        this.setStatndardPrice(dtoFreeGroupLine.getStatndardPrice());
    }
}

