/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.domain.details;

import com.namasoft.modules.namapos.contracts.details.DTONamaPOSTableLine;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSTable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.UUID;

@Entity
public class POSHallTableLine
implements POSSavable {
    @Id
    @Column(name="id", length=16)
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSTable posTable;
    @ManyToOne(fetch=FetchType.LAZY)
    private POSHall posHall;
    @JoinColumn(name="register_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private POSRegistery register;

    public POSHallTableLine() {
    }

    public POSRegistery getRegister() {
        this.register = POSPersister.materialize(POSRegistery.class, this.register);
        return this.register;
    }

    public void setRegister(POSRegistery register) {
        this.register = register;
    }

    public POSHallTableLine(DTONamaPOSTableLine dtoNamaPOSTableLine) {
        this.setPosHall((POSHall)this.fromReference(dtoNamaPOSTableLine.getHall()));
        this.setPosTable((POSTable)this.fromReference(dtoNamaPOSTableLine.getTable()));
    }

    @Override
    public void assignIds() {
        this.getId();
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = POSUUIDUtil.genUUID();
        }
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public POSTable getPosTable() {
        this.posTable = POSPersister.materialize(POSTable.class, this.posTable);
        return this.posTable;
    }

    public void setPosTable(POSTable posTable) {
        this.posTable = posTable;
    }

    public POSHall getPosHall() {
        this.posHall = POSPersister.materialize(POSHall.class, this.posHall);
        return this.posHall;
    }

    public void setPosHall(POSHall posHall) {
        this.posHall = posHall;
    }
}

